

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCleanUncommitedCont.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCleanUncommitedCont.sp,v $ $Id: AppCleanUncommitedCont.sp,v 1.5 2006/01/13 05:03:02 xsui Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppCleanUncommitedCont   - Clean the uncommitted content from the APP_ScFilterFile and APP_SubClientProp
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppCleanUncommitedCont <<<'

IF EXISTS (select * from sysobjects where name='AppCleanUncommitedCont')
	drop procedure AppCleanUncommitedCont
IF EXISTS (select * from GxQscripts where name='AppCleanUncommitedCont')
	delete from GxQscripts where name = 'AppCleanUncommitedCont'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCleanUncommitedCont')
	delete from GXDBVersions where aliasname = 'AppCleanUncommitedCont'
GO
print '... Creating Procedure: AppCleanUncommitedCont'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCleanUncommitedCont
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
AS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
declare @bsId				int
declare @attrType				int
declare @errorCode				int
declare @errorSTring				nvarchar(1024)
declare @timestamp int
set @errorCode = 0
BEGIN
DECLARE DelDirtyContent CURSOR FOR
select created, componentnameId from APP_BackupSetProp where attrName = N'Subclient Dirty' and modified = 0
OPEN DelDirtyContent
FETCH DelDirtyContent INTO @timeStamp, @bsId
WHILE @@FETCH_STATUS = 0
BEGIN
	delete APP_SubClientProp where created = @timeStamp and componentnameid in (select id from APP_Application where backupset = @bsId)
	delete APP_ScFilterFile where created = @timeStamp and componentnameid in (select id from APP_Application where backupset = @bsId)
	update APP_ScFilterFile set modified  = 0  where modified = @timeStamp and componentnameid in (select id from APP_Application where backupset = @bsId)
	update APP_SubClientProp set modified = 0  where modified = @timeStamp and componentnameid in (select id from APP_Application where backupset = @bsId)
	delete APP_BackupSetProp where componentnameid = @bsId and attrName = N'Subclient Dirty' and modified = 0
	FETCH DelDirtyContent INTO @timeStamp, @bsId
END
CLOSE DelDirtyContent
DEALLOCATE DelDirtyContent
--Check Error
	set @errorCode = @@error
	IF(@errorCode <> 0)
		GOTO ERROR_EXIT
--Error Check
END
ERROR_EXIT:
--------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
SELECT	1			         as TAG,
		NULL		         as Parent,
	@errorCode			     as [CVGui_GenericResp!1!errorCode],
	@errorString	         as [CVGui_GenericResp!1!errorMessage]
FOR XML EXPLICIT
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'AppCleanUncommitedCont')
	delete from GxQscripts where name = 'AppCleanUncommitedCont'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCleanUncommitedCont')
	delete from GXDBVersions where aliasname = 'AppCleanUncommitedCont'
GO

insert into GXDBVersions values(2, 'AppCleanUncommitedCont',  '00010005000000000000', 'AppCleanUncommitedCont', '00010005000000000000')
GO

