

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCleanCDRJobByPairID.sp] ---------- 

--  +========================================================================+
--  | Stored Procedure: Given a pairID delete the job from JM tables (JMCdrJobs, JMJobStats)
--	| Author : Gokul
--  +========================================================================+
-- $Id: AppCleanCDRJobByPairID.sp,v 1.2.276.2 2018/03/22 01:38:24 jiechen Exp $
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppCleanCDRJobByPairID <<<'

IF EXISTS (select * from sysobjects where name='AppCleanCDRJobByPairID')
	drop procedure AppCleanCDRJobByPairID
IF EXISTS (select * from GxQscripts where name='AppCleanCDRJobByPairID')
	delete from GxQscripts where name = 'AppCleanCDRJobByPairID'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCleanCDRJobByPairID')
	delete from GXDBVersions where aliasname = 'AppCleanCDRJobByPairID'
GO
print '... Creating Procedure: AppCleanCDRJobByPairID'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure AppCleanCDRJobByPairID
  @pairId integer,
  @commcellId integer
AS
  DECLARE @retCode integer
  DECLARE @infoString varchar(255)
SET NOCOUNT ON
DECLARE @jobID INTEGER
SET @jobID = 0
DECLARE @error INTEGER
SET @error = 0
IF @CommCellID = 0
SET @CommCellID = 2 -- Use Default if zero
BEGIN TRANSACTION CleanCDRJob
	SET @jobID = ISNULL((SELECT jobId FROM JMCdrJobs WHERE [pairId] = @pairID), 0)
	DELETE FROM JMCdrJobs
	WHERE [pairId] = @pairID
	SET @error = @@ERROR
	IF @error <> 0
		GOTO CX_ERROR_EXIT;
	IF @jobID <> 0
	BEGIN
		DELETE FROM JMJobStats
		WHERE jobId = @jobID
		AND [commCellId] = @CommCellID
		SET @error = @@ERROR
		IF @error <> 0
			GOTO CX_ERROR_EXIT;
	END
	COMMIT	TRANSACTION CleanCDRJob
	select @error, @infoString					-- This is just a placeholder for now.  -SKatz
	RETURN
CX_ERROR_EXIT:
	ROLLBACK TRANSACTION CleanCDRJob
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'AppCleanCDRJobByPairID')
	delete from GxQscripts where name = 'AppCleanCDRJobByPairID'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCleanCDRJobByPairID')
	delete from GXDBVersions where aliasname = 'AppCleanCDRJobByPairID'
GO

insert into GXDBVersions values(2, 'AppCleanCDRJobByPairID',  '00010002027600020000', 'AppCleanCDRJobByPairID', '00010002027600020000')
GO

