

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCheckReplicationGroupExistence.sp] ---------- 

--  +=============================================================================================+
--  |                       Name: AppCheckReplicationGroupExistence()
--  | Description: Checks if replication group of same name exists in db for that particular user
--  |
--  |       Input: replicationGroupName, userId, localeId
--  |      Output: GenericResponse XML
--  |      Author: sravanan
--  +=============================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppCheckReplicationGroupExistence')
BEGIN
	print '>>> Drop Stored Procedure: AppCheckReplicationGroupExistence <<<'
	drop procedure AppCheckReplicationGroupExistence
END
IF EXISTS (select * from GxQscripts where name='AppCheckReplicationGroupExistence')
	delete from GxQscripts where name = 'AppCheckReplicationGroupExistence'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCheckReplicationGroupExistence')
	delete from GXDBVersions where aliasname = 'AppCheckReplicationGroupExistence'
GO
print '... Creating Procedure: AppCheckReplicationGroupExistence'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCheckReplicationGroupExistence
  @replicationGroupName NVARCHAR(MAX),
  @userId INT,
  @localeId INT
AS
  DECLARE @o_xml XML
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	DECLARE @o_errorCode INT = 0
	DECLARE @o_errorString NVARCHAR(MAX) = ''
	IF EXISTS(SELECT 1 FROM App_ReplicationGroup REP WITH(NOLOCK) JOIN App_ReplicationGroupAssociation REPASSOC WITH(NOLOCK) ON REP.id = REPASSOC.componentNameId
				LEFT JOIN TM_AssocEntity TMASSOC WITH(NOLOCK) ON TMASSOC.taskId = REPASSOC.taskId AND REPASSOC.taskId IS NOT NULL
				LEFT JOIN BlrPair BLR WITH(NOLOCK) ON BLR.id = REPASSOC.blrpairId AND REPASSOC.blrpairId IS NOT NULL
				JOIN App_SubclientProp SUB WITH(NOLOCK) ON SUB.componentNameId = BLR.subclientId OR SUB.componentNameId = TMASSOC.subclientId
				JOIN App_Plan PLANS WITH(NOLOCK) ON CONVERT(NVARCHAR,PLANS.id) = SUB.attrVal AND PLANS.ownerId = @userId
WHERE REP.name = @replicationGroupName AND SUB.attrName = 'Associated Plan' AND SUB.cs_attrName = CHECKSUM(N'Associated Plan') AND SUB.modified = 0 )
	BEGIN
SET @o_errorCode = (4602 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @o_errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (4602 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
		SET @o_errorString = REPLACE(@o_errorString, '^1%s',(SELECT @replicationGroupName))
	END
	SET @o_xml = (SELECT @o_errorCode AS '@errorCode',
						 @o_errorString AS '@errorMessage' FOR XML PATH('Api_GenericResp'))
	SELECT @o_xml AS o_xml
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppCheckReplicationGroupExistence')
	delete from GxQscripts where name = 'AppCheckReplicationGroupExistence'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCheckReplicationGroupExistence')
	delete from GXDBVersions where aliasname = 'AppCheckReplicationGroupExistence'
GO

insert into GXDBVersions values(2, 'AppCheckReplicationGroupExistence',  '00000000000000000000', 'AppCheckReplicationGroupExistence', '00000000000000000000')
GO

