

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCheckIsValidLicense.sp] ---------- 

-- ----------------------------------------------------------------------
-- Copyright (c) 2015  CommVault Systems, Inc.
-- All rights reserved.
--
-- This is unpublished proprietary source code of CommVault
-- Systems, Inc. The copyright notice above does not evidence
-- any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCheckIsValidLicense.sp,v $ $Id: AppCheckIsValidLicense.sp,v 1.1.2.4 2017/02/10 20:59:45 sjohnson Exp $";
-- =========================================================
-- Author: Ganesh Kumar Subramanian
-- Description: Check if Valid License present for given clientid and licType
-- =========================================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppCheckIsValidLicense <<<'

IF EXISTS (select * from sysobjects where name='AppCheckIsValidLicense')
	drop procedure AppCheckIsValidLicense
IF EXISTS (select * from GxQscripts where name='AppCheckIsValidLicense')
	delete from GxQscripts where name = 'AppCheckIsValidLicense'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCheckIsValidLicense')
	delete from GXDBVersions where aliasname = 'AppCheckIsValidLicense'
GO
print '... Creating Procedure: AppCheckIsValidLicense'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCheckIsValidLicense
  @xmlText XML
AS
  DECLARE @response XML
--
SET NOCOUNT ON;
--
BEGIN TRY
	--
	DECLARE @i_clientId int = (SELECT TOP(1) @xmlText.value('(/App_LicenseCheckReq/@clientId)[1]', 'int'));
	DECLARE @i_licType int = (SELECT TOP(1) @xmlText.value('(/App_LicenseCheckReq/@licType)[1]', 'int'));
	DECLARE @i_appType int = (SELECT TOP(1) @xmlText.value('(/App_LicenseCheckReq/@licAppType)[1]', 'int'));
	--
	IF @i_clientId IS NULL
		RAISERROR('Error fetching the client information.', 16, 1);
	IF OBJECT_ID('tempdb.dbo.#tempResSet') IS NOT NULL DROP TABLE #tempResSet
	CREATE TABLE #tempResSet (retId int, expTime int, retStr varchar(MAX))
	EXEC simValidLicenseCheck @i_clientId, @i_appType, @i_licType
	-- return the xml response
	SET @xmlText = (SELECT retId as '@isValid' FROM #tempResSet
		FOR XML PATH ('LicenseCheckResp'),TYPE);
	--
	SELECT @xmlText;
--
END TRY
BEGIN CATCH
	IF (ERROR_SEVERITY() <> 16 OR ERROR_STATE() <> 1)
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR);
	--
	-- return error response
	SET @xmlText = (SELECT ERROR_STATE() AS '@errorCode', ERROR_MESSAGE() AS '@errorString' FOR XML PATH('App_GenericEntityResponse'), TYPE);
	SELECT @xmlText;
END CATCH
--
SET NOCOUNT OFF;
--
GO

IF EXISTS (select * from GxQscripts where name = 'AppCheckIsValidLicense')
	delete from GxQscripts where name = 'AppCheckIsValidLicense'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCheckIsValidLicense')
	delete from GXDBVersions where aliasname = 'AppCheckIsValidLicense'
GO

insert into GXDBVersions values(2, 'AppCheckIsValidLicense',  '00010001000200040000', 'AppCheckIsValidLicense', '00010001000200040000')
GO

