

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCheckIsPseudoClient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCheckIsPseudoClient.sp,v $ $Id: AppCheckIsPseudoClient.sp,v 1.1.2.4 2018/06/16 12:40:42 vdevassy Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppCheckIsPseudoClient <<<'

IF EXISTS (select * from sysobjects where name='AppCheckIsPseudoClient')
	drop procedure AppCheckIsPseudoClient
IF EXISTS (select * from GxQscripts where name='AppCheckIsPseudoClient')
	delete from GxQscripts where name = 'AppCheckIsPseudoClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCheckIsPseudoClient')
	delete from GXDBVersions where aliasname = 'AppCheckIsPseudoClient'
GO
print '... Creating Procedure: AppCheckIsPseudoClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCheckIsPseudoClient
  @clientId INT
AS
-- added to prevent extra result sets from
-- interfering with SELECT statements.
SET NOCOUNT ON
-------------------------------------------------------------------------------------------------------------------------------------------
--#include "SPBodies/AppPlanConstants.spb"
-------------------------------------------------------------------------------------------------------------------------------------------
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
        DECLARE @status INT = 0
        DECLARE @specialClientFlags INT = 0
        DECLARE @errorCode int=0
        DECLARE @errorString nvarchar(610)=''
        DECLARE @Result INT = 0
        -- PROCCED ONLY IF NO PACKAGES EXIST, ELSE ITS NOT A PSEUDO CLIENT
        IF EXISTS (SELECT 1 FROM SIMINSTALLEDPACKAGES WHERE clientId = @clientId)
        BEGIN
            SET @errorCode = 0
            SET @errorString='ClientID has a Sim Package Associated , not a Psuedo Client'
            GOTO FINISH
        END
        SELECT @status = C.status , @specialClientFlags = specialClientFlags  FROM APP_CLIENT C WHERE C.id = @clientId
        -- DEPENDENT on status flags (DAG/RAC/DB2DBF/NAS/REFERENCE COPY)
        SET @result = (SELECT CASE
WHEN (@status & 0x0040   ) > 0 THEN 1			 --0x0040
WHEN (@status & 0x0080   ) > 0 THEN 1			-- 0x0080
WHEN (@status & 0x0200   ) > 0 THEN 1			-- 0x0200
WHEN (@status & 0x200000 ) > 0 THEN 1			 --0x200000
WHEN (@status & 0x400000 ) > 0 THEN 1			--0x400000
WHEN (@status & 0x4000000) > 0 THEN 1			--0x4000000
WHEN (@status & 0x2000000 ) > 0 THEN 1		    --0x2000000
WHEN (@status & 0x20000000) > 0 THEN 1		    -- 0x20000000
			ELSE 0
            END)
        IF @result = 1
        BEGIN
            SET @errorCode = 1
            SET @errorString='ClientID has Flags set, is a Psuedo Client'
            GOTO FINISH
        END
        -- DISCOVERED CLIENTS
        IF EXISTS(SELECT 1 FROM APP_ClientProp ACP WHERE ACP.componentNameId = @clientId AND ( ACP.attrName in ('Virtual Server Discovered Clients','SharePoint Farm Client','Mini SRM Agent' ) ) AND attrval = '1')
        BEGIN
            SET @errorCode = 1
            SET @errorString='ClientID is a Discovered/SP Farm/Mini SRM client, is a Psuedo Client'
            GOTO FINISH
        END
        -- VS PSEUDO CLIENTS
        IF EXISTS(SELECT 1 FROM app_idaprop IdaProp,APP_IDAName Ida where Ida.clientId = @clientId and IdaProp.componentNameId = Ida.id and attrName = 'Pseudo Apptype' and attrVal = '1')
        BEGIN
            SET @errorCode = 1
            SET @errorString='ClientID has Psuedo Apptype set, is a Psuedo Client'
            GOTO FINISH
        END
        -- OPENVMS CLIENTS  N_CV_OS_ID_OPENVMS = 38
        IF EXISTS(SELECT 1 FROM APP_Client WHERE id = @clientId AND simOperatingSystemId = 38)
        BEGIN
            SET @errorCode = 1
            SET @errorString='ClientID is N_CV_OS_ID_OPENVMS, is a Psuedo Client'
            GOTO FINISH
        END
        --EDC CLIENTS
        IF EXISTS(SELECT  1 FROM app_clientgroup CG INNER JOIN app_clientGroupAssoc CGA  ON CG.id = CGA.clientGroupId and CGA.clientId = @clientId
            WHERE ((CG.flag & 0x100 = 0x100) OR (CG.flag & 0x200 = 0x200)))
        BEGIN
            SET @errorCode = 1
            SET @errorString='ClientID is EDC Client, is a Psuedo Client'
            GOTO FINISH
        END
        -- WINDOWS/LINUX DUMMY CLIENTS -- SAME_COMMCELL_GALAXY_PACKAGES_ABSENT. THIS FLAG WOULD BE SET FOR PACKAGES WHICH IS UINSTALLED. SO ADD ADDITIONAL CHECKS
        IF(@specialClientFlags & 0x02) <> 0
        BEGIN
            IF EXISTS(SELECT 1 FROM APP_APPLICATION WHERE clientId = @clientId)
                    OR EXISTS(SELECT 1 FROM LICUSAGE WHERE Cid = @clientId)
                    BEGIN
                        SET @errorCode = 0
                        SET @errorString='ClientID not a Dummy Client, is not a Psuedo Client'
                        GOTO FINISH
                    END
            ELSE
            BEGIN
                        SET @errorCode = 0
                        SET @errorString='ClientID IS a Dummy Client, is a Psuedo Client'
                        GOTO FINISH
            END
        END
 FINISH:
            SELECT @errorCode as '@errorCode' ,@errorString as '@errorString' for xml path('App_GenericEntityResponse') ,Type
GO

IF EXISTS (select * from GxQscripts where name = 'AppCheckIsPseudoClient')
	delete from GxQscripts where name = 'AppCheckIsPseudoClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCheckIsPseudoClient')
	delete from GXDBVersions where aliasname = 'AppCheckIsPseudoClient'
GO

insert into GXDBVersions values(2, 'AppCheckIsPseudoClient',  '00010001000200040000', 'AppCheckIsPseudoClient', '00010001000200040000')
GO

