

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCheckIsDuplicateBlockLevelContent.sp] ---------- 

SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppCheckIsDuplicateBlockLevelContent <<<'

IF EXISTS (select * from sysobjects where name='AppCheckIsDuplicateBlockLevelContent')
	drop procedure AppCheckIsDuplicateBlockLevelContent
IF EXISTS (select * from GxQscripts where name='AppCheckIsDuplicateBlockLevelContent')
	delete from GxQscripts where name = 'AppCheckIsDuplicateBlockLevelContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCheckIsDuplicateBlockLevelContent')
	delete from GXDBVersions where aliasname = 'AppCheckIsDuplicateBlockLevelContent'
GO
print '... Creating Procedure: AppCheckIsDuplicateBlockLevelContent'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCheckIsDuplicateBlockLevelContent
  @i_xmlText XML	
AS
  DECLARE @o_ErrorCode integer=0
  DECLARE @o_ErrorString NVARCHAR(1024)
  DECLARE @o_xmlText XML
SET NOCOUNT OFF
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	DECLARE @i_clientId int
	DECLARE @i_scId int
	DECLARE @assocScId int
	DECLARE @Names VARCHAR(8000)
	DECLARE @duplicacyCheckTable TABLE ( scId int , scName NVARCHAR(1024) , fileName NVARCHAR(1024));
	DECLARE @scIds TABLE ( scId int , assocScID int );
	DECLARE @scContents TABLE (scContent NVARCHAR(1024));
	SET     @o_ErrorCode  = 0
	SET     @o_xmlText    = '<Api_CheckIsDuplicateBlockLevelContentResp/>'
	SET     @i_clientId   = ISNULL((SELECT ref.value('@clientId','int')
									FROM @i_xmlText.nodes('Api_CheckIsDuplicateBlockLevelContentReq/subclientEntity') R ( ref )), 0)
	SET     @i_scId   = ISNULL((SELECT ref.value('@subclientId','int')
									FROM @i_xmlText.nodes('Api_CheckIsDuplicateBlockLevelContentReq/subclientEntity') R ( ref )), 0)
	IF @i_clientId = 0
	BEGIN
		SET @o_ErrorCode   = 1
		SET @o_ErrorString = 'Client ID not found'
		GOTO EXIT_PROC
	END
	IF @i_scId = 0 or @i_scId = -1
	BEGIN
		SET @o_ErrorCode   = 1
		SET @o_ErrorString = 'Subclient ID not found'
		GOTO EXIT_PROC
	END
	INSERT INTO @scIds
	SELECT S1.componentNameId ScId, S2.attrVal AssociatedPolicy
			from APP_SubClientProp S1
			LEFT JOIN APP_SubClientProp S2
			on S1.componentNameId = S2.componentNameId and S2.attrName = 'Associated subclient Policy' and S2.modified = 0
			JOIN APP_Application A
			ON S1.componentNameId = A.id and A.clientId = @i_clientId
			where  S1.attrName = 'Use block level backup' and S1.attrVal = 1
and ( A.subclientStatus &  0x00002 = 0 OR A.subclientStatus &  0x00004 = 0 OR A.subclientStatus & 0x00010 = 0 OR A.subclientStatus & 0x00020  = 0 )
			and  S1.modified = 0
	SET @assocScId = ISNULL(( SELECT assocScID FROM @scIds ID WHERE ID.scId = @i_scId ) , 0 )
	INSERT @scContents ( scContent )
		SELECT fileName
		FROM APP_ScFilterFile C
		WHERE C.componentNameId = @i_scId OR C.componentNameId = @assocScId AND modified = 0
	INSERT INTO @duplicacyCheckTable
		SELECT  A.id , A.subclientName , C.scContent
		FROM @scIds ID
		JOIN APP_ScFilterFile F
		ON F.componentNameId = ID.scId OR F.componentNameId = ID.assocScID
		JOIN @scContents C
		ON F.fileName = C.scContent
		JOIN APP_Application A
		ON A.id = ID.scId OR A.id = ID.assocScID and A.clientId = @i_clientId
		WHERE F.type = 1 AND F.modified = 0
		AND ( A.id !=  @i_scId AND A.id != @assocScId )
		GROUP BY A.id, A.subclientName,  C.scContent
	SELECT @Names = COALESCE(@Names + ', ', '') +
    ISNULL(scName, 'N/A') + ':' + ISNULL( fileName , 'N/A')
	FROM @duplicacyCheckTable
	IF EXISTS ( SELECT * FROM @duplicacyCheckTable )
	BEGIN
		SET @o_ErrorCode   = 1
		SET @o_ErrorString = 'Cannot add content. Duplicate(s) found in other block level subclient(s) on this client [' +
						( SELECT @Names  ) + ']'
	END
	ELSE
	BEGIN
		SET @o_ErrorCode   = 0
	END
	EXIT_PROC:
    IF @o_ErrorCode > 0
    BEGIN
        SET @o_xmlText =
        (
            SELECT @o_ErrorCode '@errorCode',
                    @o_ErrorString '@errorMessage'
            FOR XML PATH ('error'), ROOT('Api_CheckIsDuplicateBlockLevelContentResp')
        )
    END
	SELECT @o_xmlText
END
SET NOCOUNT ON
GO

IF EXISTS (select * from GxQscripts where name = 'AppCheckIsDuplicateBlockLevelContent')
	delete from GxQscripts where name = 'AppCheckIsDuplicateBlockLevelContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCheckIsDuplicateBlockLevelContent')
	delete from GXDBVersions where aliasname = 'AppCheckIsDuplicateBlockLevelContent'
GO

insert into GXDBVersions values(2, 'AppCheckIsDuplicateBlockLevelContent',  '00000000000000000000', 'AppCheckIsDuplicateBlockLevelContent', '00000000000000000000')
GO

