

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCheckIfHadoopUpgradeRequired.sp] ---------- 

-- Additional header files can be included for constants used in this stored procedure.
-- Stored procedure has to be rebuilt if any constant value changed in those header file.
-- This will generate the revision for the stored procedure. Don't remove this line!!!
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCheckIfHadoopUpgradeRequired.sp,v $ $Id: AppCheckIfHadoopUpgradeRequired.sp,v 1.1.2.4 2019/03/15 14:17:58 stelagamsetti Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppCheckIfHadoopUpgradeRequired')
BEGIN
	print '>>> Drop Stored Procedure: AppCheckIfHadoopUpgradeRequired <<<'
	drop procedure AppCheckIfHadoopUpgradeRequired
END
IF EXISTS (select * from GxQscripts where name='AppCheckIfHadoopUpgradeRequired')
	delete from GxQscripts where name = 'AppCheckIfHadoopUpgradeRequired'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCheckIfHadoopUpgradeRequired')
	delete from GXDBVersions where aliasname = 'AppCheckIfHadoopUpgradeRequired'
GO
print '... Creating Procedure: AppCheckIfHadoopUpgradeRequired'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCheckIfHadoopUpgradeRequired
-- Input variables of the stored procedure
  @i_clientId integer,
  @o_isHadoopUpgradeRequired integer OUTPUT
-- Tell the AWK processor that body of query starts here
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	IF OBJECT_ID('tempdb.dbo.#hadoopNodes') IS NOT NULL
		DROP TABLE #hadoopNodes
	--Intialize
	CREATE TABLE #hadoopNodes (attrVal NVARCHAR(MAX), xmlQ XML)
	SET @o_isHadoopUpgradeRequired = 0
	-- Check coordinator nodes
	INSERT INTO #hadoopNodes (attrVal)
	SELECT	attrVal
	FROM	APP_InstanceProp
	WHERE	attrName = 'Hadoop Config' AND modified = 0
	UPDATE #hadoopNodes SET xmlQ = CAST(attrVal AS XML)
	SELECT	@o_isHadoopUpgradeRequired = 1
	FROM	#hadoopNodes xmlSt
	WHERE	xmlSt.xmlQ.value('(/App_HadoopConfig/coordinatorNode/@clientId)[1]', 'integer') = @i_clientId
	-- check data access nodes
	IF @o_isHadoopUpgradeRequired = 0
	BEGIN
		--Delete existing rows
		DELETE #hadoopNodes
		INSERT	INTO #hadoopNodes (attrVal)
		SELECT	scp.attrVal
		FROM	APP_InstanceProp inst
		INNER JOIN APP_Application app on  app.instance = inst.componentNameId
		INNER JOIN APP_SubClientProp scp on scp.componentNameId = app.id
		WHERE	inst.attrName = 'Distributed Cluster Type' AND  inst.attrVal = '2' --Hadoop
			AND	inst.modified = 0
			AND	scp.attrName = 'Data Access Nodes' AND scp.modified = 0
		UPDATE #hadoopNodes SET xmlQ = CAST(attrVal AS XML)
		SELECT	@o_isHadoopUpgradeRequired = 1
		FROM	#hadoopNodes as xmlSt
			CROSS APPLY xmlSt.xmlQ.nodes('App_DataAccessNodes/dataAccessNodes') as daNodes(node)
		WHERE daNodes.node.value('@clientId', 'integer') = @i_clientId
	END
	DROP TABLE #hadoopNodes
GO

IF EXISTS (select * from GxQscripts where name = 'AppCheckIfHadoopUpgradeRequired')
	delete from GxQscripts where name = 'AppCheckIfHadoopUpgradeRequired'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCheckIfHadoopUpgradeRequired')
	delete from GXDBVersions where aliasname = 'AppCheckIfHadoopUpgradeRequired'
GO

insert into GXDBVersions values(2, 'AppCheckIfHadoopUpgradeRequired',  '00010001000200040000', 'AppCheckIfHadoopUpgradeRequired', '00010001000200040000')
GO

