

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCheckIfDDBSubClientExist.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppCheckIfDDBSubClientExist <<<'

IF EXISTS (select * from sysobjects where name='AppCheckIfDDBSubClientExist')
	drop procedure AppCheckIfDDBSubClientExist
IF EXISTS (select * from GxQscripts where name='AppCheckIfDDBSubClientExist')
	delete from GxQscripts where name = 'AppCheckIfDDBSubClientExist'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCheckIfDDBSubClientExist')
	delete from GXDBVersions where aliasname = 'AppCheckIfDDBSubClientExist'
GO
print '... Creating Procedure: AppCheckIfDDBSubClientExist'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCheckIfDDBSubClientExist
  @i_clientId INT,
  @i_backupSetId INT
AS
  DECLARE @errCode integer = 0
  DECLARE @errString varchar(MAX) = ''
BEGIN TRY
	DECLARE @ddbSubclientID		INT = 0
	DECLARE @ddbSubclientName	VARCHAR(MAX) = ''
	DECLARE @backupSetName		VARCHAR(MAX) = ''
	IF NOT EXISTS (SELECT status FROM APP_BackupSetName WHERE id = @i_backupSetId)
	BEGIN
		SET @errCode = 1
		SET @errString = 'BackupSet ID [' + CAST(@i_backupSetId as NVARCHAR(MAX)) + '] is invalid. Please give correct backup set id.'
		GOTO SKIP
	END
IF ((SELECT status FROM APP_BackupSetName WHERE id = @i_backupSetId) & 0x00008) != 0x00008
	BEGIN
		SET @backupSetName = (SELECT name FROM APP_BackupSetName WHERE id = @i_backupSetId)
		SET @errCode = 1
		SET @errString = 'BackupSet [' + @backupSetName + '] is not default backupset. Please give default backup set for creating DDB subclient.'
		GOTO SKIP
	END
	-- Only check for the default DDB subclient using the DDB Backup Subclient Type
	SET @ddbSubclientID = ISNULL( (SELECT TOP(1) ASCP.componentNameId FROM APP_SubClientProp ASCP WITH(NOLOCK)
																	LEFT OUTER JOIN APP_SubClientProp ASCP1 WITH(NOLOCK)
																	ON ASCP.componentNameId = ASCP1.componentNameId AND ASCP1.attrName = 'DDB Backup SubClient Type'
																WHERE (ASCP.attrName = 'DDB Backup'
																	AND ASCP.attrVal = '1')
																AND (ASCP1.attrVal = '0' OR ASCP1.id IS NULL)
																AND ASCP.componentNameId IN (SELECT id FROM APP_Application
																						WHERE clientId = @i_clientId
AND (subclientStatus & 0x00004) != 0x00004)), 0)
	IF @ddbSubclientID != 0
	BEGIN
		SET @ddbSubclientName = (SELECT subclientName FROM APP_Application WHERE id = @ddbSubclientID )
		SET @errCode = 1
		SET @errString = 'DDB subclient [' + @ddbSubclientName + '] is available for this client. Unable to create another DDB subclient. Please delete existing DDB subclient to create a new one.'
	END
SKIP:
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
   set @errCode = ERROR_NUMBER()
   set @errString = 'Problems executing [' +ERROR_PROCEDURE() +'], Line['
					+ CONVERT(nvarchar(10),ERROR_LINE()) + '] :' +ERROR_MESSAGE()
END	  CATCH
SELECT @errCode, @errString
GO

IF EXISTS (select * from GxQscripts where name = 'AppCheckIfDDBSubClientExist')
	delete from GxQscripts where name = 'AppCheckIfDDBSubClientExist'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCheckIfDDBSubClientExist')
	delete from GXDBVersions where aliasname = 'AppCheckIfDDBSubClientExist'
GO

insert into GXDBVersions values(2, 'AppCheckIfDDBSubClientExist',  '00000000000000000000', 'AppCheckIfDDBSubClientExist', '00000000000000000000')
GO

