

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCheckIfContentExists.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCheckIfContentExists.sp,v $ $Id: AppCheckIfContentExists.sp,v 1.8.66.3 2020/03/12 01:28:28 shussain Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppCheckIfContentExists')
BEGIN
	print '>>> Drop Stored Procedure: AppCheckIfContentExists <<<'
	drop procedure AppCheckIfContentExists
END
IF EXISTS (select * from GxQscripts where name='AppCheckIfContentExists')
	delete from GxQscripts where name = 'AppCheckIfContentExists'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCheckIfContentExists')
	delete from GXDBVersions where aliasname = 'AppCheckIfContentExists'
GO
print '... Creating Procedure: AppCheckIfContentExists'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCheckIfContentExists
  @subClientId INT,
  @propertyType INT,
  @AttrName VARCHAR(MAX),
  @errCode INT OUTPUT,
  @errString VARCHAR(MAX) OUTPUT
AS
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	SET @errCode = 0
	SET @errString = ''
	DECLARE @dupSubClientName VARCHAR(128) = N''
	DECLARE @dupSubClientId INT = 0
	DECLARE @RowCount INT = 0
	IF OBJECT_ID('#tmpContents') IS NOT NULL DROP TABLE #tmpContents
	CREATE TABLE #tmpContents (subclientId INT, subclientName NVARCHAR(128), instanceId INT,
		clientId INT, content NVARCHAR(MAX), appTypeId INT, primary key(subclientId,instanceId,clientId))
	IF @propertyType = 118 --PROPERTY_MSSQL_DB
		OR @propertyType = 119 --PROPERTY_MSSQL_FFG
		OR @propertyType = 116 --PROPERTY_SYBASE
		OR @propertyType = 102 --PROPERTY_LNOTES_DB
	BEGIN
		IF @propertyType = 118
			OR @propertyType = 119 --PROPERTY_MSSQL_FFG
		BEGIN
			INSERT INTO #tmpContents
			SELECT
				AP.id,
				AP.subclientName,
				AP.instance,
				AP.clientId,
				SP.attrName,
				AP.appTypeId
			FROM APP_SubClientProp SP
				JOIN APP_Application AP
					ON SP.componentNameId = AP.id
						AND SP.attrName = @AttrName
						AND SP.attrType = @propertyType
						AND SP.modified = 0
						AND AP.subclientStatus <> 4
				JOIN APP_Application AX
					ON AX.id = @subClientId
						AND AX.clientId = AP.clientId
						AND AX.instance = AP.instance
				JOIN APP_SubClientProp SY
					ON SY.componentNameId = AP.id
						AND SY.attrName = N'mssql subclient type'
						AND SY.attrVal = CASE @propertyType WHEN 118 THEN '1' WHEN 119 THEN '2' END
						AND SY.modified = 0
			SET @RowCount = @@ROWCOUNT
		END
		ELSE
		BEGIN
			INSERT INTO #tmpContents
			SELECT
				AP.id,
				AP.subclientName,
				AP.instance,
				AP.clientId,
				SP.attrName,
				AP.appTypeId
			FROM APP_SubClientProp SP
				JOIN APP_Application AP
					ON SP.componentNameId = AP.id
						AND SP.attrName = @AttrName
						AND SP.attrType = @propertyType
						AND SP.modified = 0
						AND AP.subclientStatus <> 4
				JOIN APP_Application AX
					ON AX.id = @subClientId
						AND AX.clientId = AP.clientId
						AND AX.instance = AP.instance
			SET @RowCount = @@ROWCOUNT
		END
		IF @RowCount > 0
		BEGIN
			SELECT TOP 1
				@dupSubClientId = TC.subclientId,
				@dupSubClientName = TC.subclientName
			FROM #tmpContents TC
				WHERE TC.content = @AttrName
SET @errCode = (1775 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errString = 'Same content[' + @AttrName + '] is available in another subclient[' + CAST(@dupSubClientId as NVARCHAR(MAX)) + '][' + @dupSubClientName + ']. Please delete the content[' + @AttrName + '] from subclient[' + @dupSubClientName + ']'
			RETURN
		END
	END
	ELSE IF @propertyType = 112 --PROPERTY_EXCHANGE_DB
			OR @propertyType = 122 --PROPERTY_POSTGRESQL
			OR @propertyType = 124 --PROPERTY_UNIX_SYMBOLIC_LINK
	BEGIN
		INSERT INTO #tmpContents
			SELECT
				AP.id,
				AP.subclientName,
				AP.instance,
				AP.clientId,
				SP.attrName,
				AP.appTypeId
			FROM APP_SubClientProp SP
				JOIN APP_Application AP
					ON SP.componentNameId = AP.id
						AND SP.attrName = @AttrName
						AND SP.attrType = @propertyType
						AND SP.modified = 0
						AND AP.subclientStatus <> 4
				JOIN APP_Application AX
					ON AX.id = @subClientId
						AND AX.clientId = AP.clientId
						AND AX.instance = AP.instance
		SET @RowCount = @@ROWCOUNT
		IF @RowCount > 0
		BEGIN
			SELECT TOP 1
				@dupSubClientName = TC.subclientName,
				@dupSubClientId = TC.subClientId
			FROM #tmpContents TC
				WHERE TC.content = @AttrName
SET @errCode = (1775 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @errString = 'Same content[' + @AttrName + '] is available in another subclient[' + CAST(@dupSubClientId as NVARCHAR(MAX)) + '][' + @dupSubClientName + ']. Please delete the content[' + @AttrName + '] from subclient[' + @dupSubClientName + ']'
			RETURN
		END
	END
	ELSE
	BEGIN
		SET @errCode = 2
		SET @errString = 'AppCheckIfContentExists: Unknown property type[' + CAST(@propertyType as NVARCHAR(MAX)) + '], ask developer to implement duplicate content check for this property.'
	END
GO

IF EXISTS (select * from GxQscripts where name = 'AppCheckIfContentExists')
	delete from GxQscripts where name = 'AppCheckIfContentExists'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCheckIfContentExists')
	delete from GXDBVersions where aliasname = 'AppCheckIfContentExists'
GO

insert into GXDBVersions values(2, 'AppCheckIfContentExists',  '00010008006600030000', 'AppCheckIfContentExists', '00010008006600030000')
GO

