

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCheckIfClientOrArrayExists.sp] ---------- 

-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "AppCheckIfClientOrArrayExists"
--	|	This Procedure is used to get NAS VServer Clients
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppCheckIfClientOrArrayExists')
BEGIN
	print '>>> Drop Stored Procedure: AppCheckIfClientOrArrayExists <<<'
	drop procedure AppCheckIfClientOrArrayExists
END
IF EXISTS (select * from GxQscripts where name='AppCheckIfClientOrArrayExists')
	delete from GxQscripts where name = 'AppCheckIfClientOrArrayExists'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCheckIfClientOrArrayExists')
	delete from GXDBVersions where aliasname = 'AppCheckIfClientOrArrayExists'
GO
print '... Creating Procedure: AppCheckIfClientOrArrayExists'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppCheckIfClientOrArrayExists
  @xmlText XML
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
  DECLARE @o_id INTEGER
  DECLARE @o_ControlHostId INTEGER
  DECLARE @o_ClientId INTEGER
  DECLARE @o_actionPending INTEGER
  DECLARE @o_errorCode INTEGER
  DECLARE @o_errorStr NVARCHAR(1024)
  DECLARE @o_duplicateHostId NVARCHAR(1024)
SET NOCOUNT ON
DECLARE @tblInput TABLE ( Id INT, -- dummy id for each array info object
						  ClientId INT,
						  CtrlHostId INT,
						  origClientId	INT,
						  origCtrlHostId INT,
						  arrayId NVARCHAR(1024),
						  controlHost NVARCHAR(1024),
						  vendor NVARCHAR(1024),
						  uniqueIdentifier NVARCHAR(1024),
						  actionPending	INTEGER,
						  duplicateHostId NVARCHAR(1024),
						  arrayType	INT,
						  arrayAdd INT)
DECLARE @tblAliases TABLE (Id INT,
					 Alias NVARCHAR(1024))
DECLARE @errCode INT = 0
DECLARE @errStr NVARCHAR(1024) = N''
-- MM Config Parameter to skip duplicate array alias check.
DECLARE @skipDuplicateAliasCheck INT = 0
SET @skipDuplicateAliasCheck = ISNULL((select Value from MMConfigs where name = 'MMS2_CONFIG_SKIP_DUPLICATE_ALIAS_CHECK'), 0)
DECLARE @isMultiTenantSite INT = 0
SET @isMultiTenantSite = ISNULL((select Value from MMConfigs where name = 'MMS2_CONFIG_SNAP_MULTI_TENANT_SITE'), 0)
	-- XML Structure for [AppCheckIfNASClientOrArrayExists]
	/*
	<AppCheckIfNASClientOrArrayExists>
		<ArrayClientDetails>
			<Id>122</Id>
			<ClientId>122</ClientId>
			<CtrlHostId>170</CtrlHostId>
			<ArrayId>arrayname</ArrayId>
			<ControlHost>%s</ControlHost>
			<Vendor>%s</Vendor>
			<AliasList>
				<Alias>%s</Alias>
				<Alias>%s</Alias>
				<Alias>%s</Alias>
			</AliasList>
			<UniqueIdentifier>
		</ArrayClientDetails>
	</AppCheckIfNASClientOrArrayExists>
	*/
	INSERT	INTO @tblAliases
	SELECT	R.ref.value('../../Id[1]', 'integer') AS Id,
			R.ref.value('.', 'nvarchar(1024)') AS Alias
	FROM	@xmlText.nodes('/AppCheckIfNASClientOrArrayExists/ArrayClientDetails/AliasList/Alias') R(ref)
	INSERT	INTO @tblInput
	SELECT	R.ref.value('Id[1]', 'integer') AS Id,
			R.ref.value('ClientId[1]', 'integer') AS ClientId,
			R.ref.value('CtrlHostId[1]', 'integer') AS CtrlHostId,
			R.ref.value('ClientId[1]', 'integer') AS origClientId,
			R.ref.value('CtrlHostId[1]', 'integer') AS origCtrlHostId,
			R.ref.value('ArrayId[1]', 'NVARCHAR(1024)') AS arrayId,
			R.ref.value('ControlHost[1]', 'NVARCHAR(1024)') AS controlHost,
			R.ref.value('Vendor[1]', 'NVARCHAR(1024)') AS vendor,
			ISNULL( R.ref.value('UniqueIdentifier[1]', 'NVARCHAR(1024)'), '') AS uniqueIdentifier,
			0,
			N'',
			R.ref.value('ArrayType[1]', 'integer') AS arrayType,
			R.ref.value('ArrayAdd[1]', 'integer') AS arrayAdd
	FROM	@xmlText.nodes('/AppCheckIfNASClientOrArrayExists/ArrayClientDetails') R(ref)
	--Do not consider MultiSite behavior when adding an array for 7mode arrays/non-NetApp arrays
	IF  EXISTS (SELECT 1
			   FROM @tblInput
			   WHERE arrayAdd = 1 AND
vendor = 'NetApp' AND
(((arrayType & 32) = 32) OR ((arrayType & 16) = 16))) --32 = CVSM_CTRLHOST_7MODE_VFILER_DB 16 = CVSM_CTRLHOST_7MODE_FILER
		OR
EXISTS (SELECT 1 FROM @tblInput INPUT WHERE INPUT.vendor <> 'NetApp')
	BEGIN
		SET @isMultiTenantSite = 0
	END
	IF(@skipDuplicateAliasCheck > 0 AND @isMultiTenantSite = 0)
	BEGIN
		DELETE @tblAliases
		FROM @tblAliases I_ALIAS, SMHostAlias H_ALIAS
		WHERE I_ALIAS.Alias = H_ALIAS.AliasName
	END
	IF @isMultiTenantSite = 0
	BEGIN
	-- Find ctrlHostID by looking up HostAlias
	UPDATE	@tblInput
	SET 	ctrlHostId = H_ALIAS.RefId
	FROM	@tblInput INPUT JOIN @tblAliases I_ALIAS ON INPUT.Id = I_ALIAS.Id
			JOIN SMHostAlias H_ALIAS ON I_ALIAS.Alias = H_ALIAS.AliasName
			INNER JOIN SMControlHost HOST ON HOST.ControlHostId = H_ALIAS.RefId AND HOST.SnapVendorName = INPUT.vendor
	WHERE	INPUT.ctrlHostId = 0
	SET @errCode = @@ERROR
	IF(@errCode <> 0)
	BEGIN
		SET @errStr = N'Error in checking array aliases against existing aliases.'
		GOTO ERR_EXIT
	END
	-- Find ctrlHostID by checking aliases against ArrayId
	UPDATE	@tblInput
	SET		ctrlHostId = HOST.ControlHostId
	FROM	@tblInput INPUT JOIN @tblAliases I_ALIAS ON INPUT.Id = I_ALIAS.Id
			JOIN SMControlHost HOST ON (I_ALIAS.Alias = HOST.SMArrayId OR I_ALIAS.Alias = HOST.SMHostName)
			AND HOST.SnapVendorName = INPUT.vendor
	WHERE	INPUT.ctrlHostId = 0
	SET @errCode = @@ERROR
	IF(@errCode <> 0)
	BEGIN
		SET @errStr = N'Error in checking array aliases against existing array names.'
		GOTO ERR_EXIT
	END
	-- Find ctrlHostID by looking up ArrayId
	UPDATE	@tblInput
	SET 	ctrlHostId = HOST.ControlHostId
	FROM 	@tblInput INPUT JOIN SMControlHost HOST ON (INPUT.arrayId = HOST.SMArrayId)
				AND HOST.SnapVendorName = INPUT.vendor
WHERE	INPUT.ctrlHostId = 0 AND INPUT.vendor = 'NetApp'
	SET @errCode = @@ERROR
	IF(@errCode <> 0)
	BEGIN
		SET @errStr = N'Error in checking array name against existing arrays.'
		GOTO ERR_EXIT
	END
	-- Find ctrlHostID by looking up ArrayId
	UPDATE	@tblInput
	SET 	ctrlHostId = HOST.ControlHostId
	FROM 	@tblInput INPUT JOIN SMControlHost HOST ON (INPUT.arrayId = HOST.SMArrayId OR INPUT.controlHost = HOST.SMHostName)
				AND HOST.SnapVendorName = INPUT.vendor
WHERE	INPUT.ctrlHostId = 0 AND INPUT.vendor in ('Dell EMC Isilon', 'Huawei')
	SET @errCode = @@ERROR
	IF(@errCode <> 0)
	BEGIN
		SET @errStr = N'Error in checking array name against existing arrays.'
		GOTO ERR_EXIT
	END
	-- Find ctrlHostID by looking up both ArrayId and ControlHost
	UPDATE	@tblInput
	SET 	ctrlHostId = HOST.ControlHostId
	FROM 	@tblInput INPUT JOIN SMControlHost HOST ON (INPUT.arrayId = HOST.SMArrayId AND INPUT.controlHost = HOST.SMHostName)
				AND HOST.SnapVendorName = INPUT.vendor
WHERE	INPUT.ctrlHostId = 0 AND INPUT.vendor in ('Dell EMC Unity', 'Hitachi NAS', 'Dell EMC VNX / Celerra', 'Huawei')
	SET @errCode = @@ERROR
	IF(@errCode <> 0)
	BEGIN
		SET @errStr = N'Error in checking array name against existing arrays.'
		GOTO ERR_EXIT
	END
	-- Validate input client against array alias list - Case when adding the array for a client using the "Manage Array option"
	DECLARE @rowCount INT
	SELECT @rowCount = COUNT(*) FROM @tblInput
	-- MR:294708 - For EQL and 3PAR, there is a failure in re-add with "client already exists" as it fails to find the client
	IF @rowCount = 1 AND EXISTS (SELECT 1 FROM @tblInput WHERE CtrlHostId = 0 AND ClientId > 0) --If the array is already added, then do not add it again.
	BEGIN
		IF NOT EXISTS(SELECT CLIENT.id
		FROM	@tblInput INPUT
		JOIN @tblAliases I_ALIAS ON INPUT.Id = I_ALIAS.Id
		JOIN APP_Client CLIENT ON I_ALIAS.Alias = CLIENT.net_hostname
		WHERE CLIENT.id = INPUT.ClientId)
		BEGIN
			SET @errStr = N'Error validating input client against array alias list. Client hostname does not match array alias list.'
UPDATE @tblInput SET actionPending = 6
			--Return here so the actionPending can be propagated back to the caller, instead of changing EXIT code to minimize regression
			SELECT	Id, CtrlHostId, ClientId, actionPending, 0, @errStr, N'' FROM @tblInput
			RETURN
		END
	END
	-- Find clientId by controlHostId
	UPDATE	@tblInput
	SET		clientId = HOST.ClientId
	FROM	@tblInput INPUT JOIN SMControlHost HOST ON INPUT.ctrlHostId = HOST.ControlHostId
	WHERE	INPUT.clientId = 0 AND HOST.ControlHostId > 0
	SET @errCode = @@ERROR
	IF(@errCode <> 0)
	BEGIN
		SET @errStr = N'Error in checking if clients exist for the given arrays.'
		GOTO ERR_EXIT
	END
	-- Find ClientID by checking client name against arrayid
	UPDATE	@tblInput
	SET		clientId = CLIENT.Id
	FROM	@tblInput INPUT JOIN APP_Client CLIENT
			ON (INPUT.arrayId = CLIENT.name OR INPUT.arrayId = CLIENT.net_hostname
				OR INPUT.controlHost = CLIENT.name OR INPUT.controlHost = CLIENT.net_hostname)
	WHERE	INPUT.clientId = 0
	SET @errCode = @@ERROR
	IF(@errCode <> 0)
	BEGIN
		SET @errStr = N'Error in checking array name against existing clients.'
		GOTO ERR_EXIT
	END
	-- Find client by checking aliases against client net_hostname
	UPDATE	@tblInput
	SET		clientId = CLIENT.Id
	FROM	@tblInput INPUT JOIN @tblAliases I_ALIAS ON INPUT.Id = I_ALIAS.Id
			JOIN APP_Client CLIENT
				ON (I_ALIAS.Alias = CLIENT.net_hostname OR I_ALIAS.Alias = CLIENT.name)
	WHERE	INPUT.clientId = 0
	SET @errCode = @@ERROR
	IF(@errCode <> 0)
	BEGIN
		SET @errStr = N'Error in checking array aliases against existing clients.'
		GOTO ERR_EXIT
	END
	-- Find clientId by looking up EndPoint
	UPDATE	@tblInput
	SET 	clientId = ENDPOINT.ClientId
	FROM	@tblInput INPUT JOIN @tblAliases I_ALIAS ON INPUT.Id = I_ALIAS.Id
			JOIN SMEndPoint ENDPOINT ON I_ALIAS.Alias = ENDPOINT.Address
	WHERE	INPUT.clientId = 0
	SET @errCode = @@ERROR
	IF(@errCode <> 0)
	BEGIN
		SET @errStr = N'Error in checking aliases against existing client aliases.'
		GOTO ERR_EXIT
	END
	-- Unique identifier based checks are only for NetApp
IF EXISTS (  SELECT 1 FROM @tblInput WHERE vendor = 'NetApp' )
	BEGIN
	-- Fail the request if the unique id is present in the CS DB for other array
		-- Find ctrlHostID by looking up UniqueIdentifier
		UPDATE	@tblInput
		SET 	CtrlHostId = HOST.ControlHostId,
				clientId = HOST.ClientId,
actionPending = 1 /*SM_UNIQUE_ID_EXISTS*/
		FROM	@tblInput INPUT INNER JOIN SMControlHost HOST ON HOST.UniqueIdentifier = INPUT.uniqueIdentifier
		WHERE	(HOST.UniqueIdentifier <> '' OR INPUT.uniqueIdentifier <> '')
				AND INPUT.origCtrlHostId <> HOST.ControlHostId
	END
	END
	-- Unique identifier based checks are only for NetApp
ELSE IF (@isMultiTenantSite = 1)
	BEGIN
IF EXISTS (  SELECT 1 FROM @tblInput WHERE vendor = 'NetApp' )
		--Check if there are any entries in the SMControlHost table that matches with the UUID passed as input.
		BEGIN
			UPDATE	@tblInput
			SET		CtrlHostId = HOST.ControlHostId,
					clientId = HOST.ClientId,
actionPending = 1 /*SM_UNIQUE_ID_EXISTS*/
			FROM	@tblInput INPUT INNER JOIN SMControlHost HOST
			ON		HOST.UniqueIdentifier = INPUT.uniqueIdentifier
			WHERE	(HOST.UniqueIdentifier <> '' OR INPUT.uniqueIdentifier <> '')
AND		INPUT.CtrlHostId <> HOST.ControlHostId AND INPUT.vendor = 'NetApp'
		END
		--Check if there are any matches found to the SMControlHost based on the hostAlias and the actionPending is not set + UUID is missing. In such cases, we have to update the UUID of the duplicate entries.
		--Return immediately as we will not be able to match based on the uniqueIdentifier
		BEGIN
			--Isolate the duplicate controlhosts whose unique identifier is missing - based on the following: HostAlias, HostAlias and ArrayId, ArrayId
			DECLARE @tblDuplicateHostNoUUID TABLE (duplicatehost NVARCHAR(1024), Id INT)
			INSERT INTO @tblDuplicateHostNoUUID  (duplicatehost,Id)
			SELECT distinct(H_ALIAS.RefId) as duplicateHost, INPUT.Id
			FROM @tblInput INPUT INNER JOIN @tblAliases I_ALIAS ON INPUT.Id = I_ALIAS.Id
			INNER JOIN	SMHostAlias H_ALIAS ON I_ALIAS.Alias = H_ALIAS.AliasName
			INNER JOIN SMControlHost HOST ON HOST.ControlHostId = H_ALIAS.RefId AND HOST.SnapVendorName = INPUT.vendor
WHERE HOST.UniqueIdentifier = '' AND INPUT.uniqueIdentifier <> '' AND INPUT.vendor = 'NetApp' AND INPUT.actionPending = 0
			UNION
			SELECT distinct(HOST.ControlHostId) as duplicateHost, INPUT.Id
			FROM @tblInput INPUT INNER JOIN @tblAliases I_ALIAS ON INPUT.Id = I_ALIAS.Id
			INNER JOIN SMControlHost HOST ON (I_ALIAS.Alias = HOST.SMArrayId OR I_ALIAS.Alias = HOST.SMHostName) AND HOST.SnapVendorName = INPUT.vendor
WHERE HOST.UniqueIdentifier = '' AND INPUT.uniqueIdentifier <> '' AND INPUT.vendor = 'NetApp'  AND INPUT.actionPending = 0
			UNION
			SELECT distinct(HOST.ControlHostId) as duplicateHost, INPUT.Id
			FROM @tblInput INPUT INNER JOIN SMControlHost HOST ON (INPUT.arrayId = HOST.SMArrayId) AND HOST.SnapVendorName = INPUT.vendor
WHERE HOST.UniqueIdentifier = '' AND INPUT.uniqueIdentifier <> '' AND INPUT.vendor = 'NetApp' AND INPUT.actionPending = 0
			IF EXISTS (SELECT 1 FROM @tblDuplicateHostNoUUID)
			BEGIN
UPDATE @tblInput SET duplicateHostId = TMP1.host, actionPending = 2
				FROM
				(SELECT
				STUFF((SELECT distinct ',' + CAST (duplicatehost as NVARCHAR(10))
				FROM @tblDuplicateHostNoUUID T2 WHERE T2.Id = T1.Id
				FOR XML PATH ('')),1,1,'') as host,
				Id FROM @tblDuplicateHostNoUUID T1 GROUP BY Id) TMP1
				INNER JOIN @tblInput TMP2 ON TMP2.id = TMP1.id
				SELECT	Id, CtrlHostId, ClientId, actionPending, 0, N'',duplicateHostId FROM @tblInput
				RETURN
			END
		END
		--If we are looking at array edit operation, and if the UUID already exists, we should return the corresponding
		UPDATE	@tblInput
		SET		CtrlHostId = HOST.ControlHostId,
				clientId = HOST.ClientId
		FROM	@tblInput INPUT INNER JOIN SMControlHost HOST ON INPUT.CtrlHostId = HOST.ControlHostId
		WHERE	INPUT.CtrlHostId > 0 AND HOST.UniqueIdentifier = INPUT.uniqueIdentifier AND  HOST.UniqueIdentifier <> '' AND INPUT.uniqueIdentifier <> '' AND INPUT.actionPending = 0
AND  	INPUT.vendor = 'NetApp'
		--This is the section to associate the NAS clients and the controlHost entries
		--If ClientID = 0 - indicates that we still haven't found the client that should be associated to the array
		--This section mainly concentrates on finding the correct NAS clients for cases where ClientId = 0
		DECLARE @clientMatch TABLE (ClientId INT, Id INT)
		IF EXISTS (SELECT 1 FROM @tblInput WHERE ClientId = 0 )
		BEGIN
			DECLARE @tblArrayCtrl TABLE (Id INT, ControllerId INT, ClientId INT, precedence INT)
			DECLARE @tblProxyClientResult TABLE (clientID INT, proxyId INT, precedence INT)
			INSERT	INTO @tblArrayCtrl
			SELECT	R.ref.value('../../Id[1]', 'integer') AS Id,
			R.ref.value('.', 'integer') AS ControllerId,
			0,
			0
			FROM	@xmlText.nodes('/AppCheckIfNASClientOrArrayExists/ArrayClientDetails/SelectedArrayControllers/controllerId') R(ref)
			DECLARE @tblNASClient TABLE (ClientId INT, Id INT)
			--This query will give us the list of NAS clients that match the array either based on the alias+nethostname or alias+clientname or arrayID+clientname or EndPoint Address
			INSERT INTO @tblNASClient
			SELECT distinct(CLIENT.id), INPUT.Id
			FROM @tblInput INPUT INNER JOIN @tblAliases I_ALIAS ON INPUT.Id = I_ALIAS.Id
			INNER JOIN APP_Client CLIENT ON (I_ALIAS.Alias = CLIENT.net_hostname OR I_ALIAS.Alias = CLIENT.name OR INPUT.arrayId = CLIENT.name OR INPUT.arrayId = CLIENT.net_hostname OR INPUT.controlHost = CLIENT.name OR INPUT.controlHost = CLIENT.net_hostname)
			WHERE INPUT.ClientId = 0 AND INPUT.actionPending = 0 AND CLIENT.id NOT IN (SELECT ClientId FROM SMControlHost)
			UNION
			SELECT distinct(ENDPOINT.ClientId), INPUT.Id
			FROM @tblInput INPUT INNER JOIN @tblAliases I_ALIAS ON INPUT.Id = I_ALIAS.Id
			INNER JOIN  SMEndPoint ENDPOINT ON I_ALIAS.Alias = ENDPOINT.Address
			WHERE INPUT.ClientId = 0 AND INPUT.actionPending = 0 AND ENDPOINT.ClientId NOT IN (SELECT ClientId FROM SMControlHost)
			--From this list, filter out the NAS clients for which the array controller is the detectMA or the proxyMA -
			--Based on the IDA level for cluster config and IDA+subclient for the svm config
			DECLARE @tblClientProxyXML TABLE (Id INT IDENTITY, InputId INT, ClientId INT, AppTypeId INT, proxyXML XML)
			INSERT INTO @tblClientProxyXML
			SELECT T1.Id, T1.ClientId, IDAName.appTypeId, NULL
			FROM @tblNASClient T1 INNER JOIN APP_IDAName IDAName ON T1.ClientId = IDANAme.clientId
			INNER JOIN APP_IDAProp IDAProp ON IDAProp.componentNameId = IDAName.id
			WHERE IDAProp.attrName  = 'Backup Configuration Nodes' AND IDAProp.modified = 0 AND (CHARINDEX('clientId',attrVal) > 0 OR  CHARINDEX('clientGroupId',attrVal) > 0)
			DECLARE @RowId INT = 0
			DECLARE @ClientID INT
			DECLARE @AppTypeId INT
			DECLARE @tblClientProxyXMLTemp TABLE (Id INT IDENTITY,proxyXML XML)
			-- Iterate over all rows and get the proxyMA
			WHILE (1 = 1)
			BEGIN
				SELECT TOP 1 @RowId = Id,  @ClientID = ClientId, @AppTypeId = AppTypeId
				FROM @tblClientProxyXML
				WHERE Id > @RowId
				ORDER BY Id
				-- Exit if no more data
				IF @@ROWCOUNT = 0 BREAK;
				INSERT INTO @tblClientProxyXMLTemp
				EXEC AppGetBackupConfigNodes @ClientID,@AppTypeId,0,0,0,0,0,0
			END
			--Update the original table with the XML fetched from the SP
			UPDATE @tblClientProxyXML
			SET proxyXML = T1.proxyXML
			FROM @tblClientProxyXMLTemp T1 INNER JOIN @tblClientProxyXML T2 ON T1.Id = T2.Id
			--Strip the clientID from the XML data
			INSERT INTO @tblProxyClientResult
			SELECT * FROM
			(SELECT DISTINCT
				Q1.clientId,
				R.ref.value('@clientId', 'int') AS proxyId,
				1 AS precedence
				FROM
				(SELECT	ClientId, proxyXML FROM @tblClientProxyXML) Q1
				CROSS APPLY Q1.proxyXML.nodes('/App_BackupConfigurationNodes/backupDataAccessNodes') AS R(ref)) T1
			WHERE T1.proxyId IS NOT NULL
			--Get the DetectMA
			MERGE @tblProxyClientResult as T1
			USING
			(
				SELECT		CLIENT.id AS clientID,
							PROP.attrVal AS proxyId
				FROM		APP_Client CLIENT
				INNER JOIN	APP_ClientProp PROP  ON CLIENT.id = PROP.componentNameId AND PROP.attrName like 'Detect Media Agent for NDMP Server'
				INNER JOIN	@tblNASClient TMP ON TMP.ClientId = Client.id
			) AS T2
			ON (T1.ClientId = T2.ClientId AND T1.proxyID = T2.proxyId)
			WHEN NOT MATCHED BY TARGET THEN
			INSERT (clientID,proxyID,precedence) VALUES (T2.clientId, T2.proxyId,1);
			--If the array is of type vserver, then we need to look at subclients for the proxy details
IF EXISTS (SELECT 1 FROM @tblInput WHERE (arrayType & 8 = 8))
			BEGIN
				DECLARE @tblSubClientProxyXML TABLE (Id INT IDENTITY, InputId INT, SubClientId INT, ClientId INT, AppTypeId INT, proxyXML XML)
				DECLARE @tblSCProxyXMLTemp TABLE (Id INT IDENTITY,proxyXML XML)
				INSERT INTO @tblSubClientProxyXML
				SELECT T1.Id, APP.Id, T1.ClientId, APP.appTypeId, NULL
FROM @tblNASClient T1 INNER JOIN APP_Application APP ON T1.ClientId = APP.clientId AND  (APP.subclientStatus = 0 OR (APP.subclientStatus & 0x00008 = 0x00008))/*CV_STATUS_DEFAULT*/
				INNER JOIN APP_SubClientProp SCPROP ON APP.ID = SCPROP.componentNameId
				WHERE SCPROP.attrName  = 'Backup Configuration Nodes' AND SCPROP.modified = 0 AND (CHARINDEX('clientId',SCPROP.attrVal) > 0 OR  CHARINDEX('clientGroupId',SCPROP.attrVal) > 0)
				DECLARE @SubClientId INT
				SET @RowId = 0
				WHILE (1 = 1)
				BEGIN
					SELECT TOP 1 @RowId = Id,  @ClientID = ClientId, @AppTypeId = AppTypeId , @SubClientId = SubClientId
					FROM @tblSubClientProxyXML
					WHERE Id > @RowId
					ORDER BY Id
					-- Exit if no more data
					IF @@ROWCOUNT = 0 BREAK;
					 -- call the SP to get the backup nodes
					INSERT INTO @tblSCProxyXMLTemp
					EXEC AppGetBackupConfigNodes @ClientID,@AppTypeId,@SubClientId,0,0,0,0,0
				END
				UPDATE @tblSubClientProxyXML
				SET proxyXML = T1.proxyXML
				FROM @tblSCProxyXMLTemp T1 INNER JOIN @tblSubClientProxyXML T2 ON T1.Id = T2.Id
				MERGE @tblProxyClientResult as T1
				USING
				(
					SELECT * FROM
					(SELECT DISTINCT
					Q1.clientId,
					R.ref.value('@clientId', 'int') as proxyId
					FROM
					(SELECT	ClientId, proxyXML FROM @tblSubClientProxyXML) Q1
					CROSS APPLY Q1.proxyXML.nodes('/App_BackupConfigurationNodes/backupDataAccessNodes') AS R(ref)) Q1
					WHERE Q1.proxyId IS NOT NULL
				) AS T2
				ON (T1.ClientId = T2.ClientId AND T1.proxyID = T2.proxyId)
				WHEN NOT MATCHED BY TARGET THEN
				INSERT (clientID,proxyID,precedence) VALUES (T2.clientId, T2.proxyId,2);
			END
			--Match the clients with the selectedarraycontrollers
			UPDATE @tblArrayCtrl
			SET ClientId = TMP1.clientID , precedence = TMP1.precedence
			FROM
			(SELECT clientID, proxyId, precedence, ROW_NUMBER() OVER(PARTITION BY proxyId ORDER BY precedence desc) as PART1 from @tblProxyClientResult) as TMP1
			INNER JOIN @tblArrayCtrl TMP2 ON TMP1.proxyId = TMP2.ControllerId
			WHERE PART1 = 1
			--Update the input based on the precedence - the subclient proxyMA has the highest priority over the client
			UPDATE	@tblInput
			SET		ClientId = TMP1.clientID
			FROM
			(SELECT Id, clientID, ControllerId, precedence, ROW_NUMBER() OVER(PARTITION BY Id ORDER BY precedence desc) as PART1 from @tblArrayCtrl) as TMP1
			INNER JOIN @tblInput TMP2 ON TMP1.Id = TMP2.Id
			WHERE	PART1 = 1 AND TMP1.ClientId > 0 --this is required because if multiple array controllers are mentioned, and if not all of them are mentioned as DetecMA/proxyMA then the ClientID will remain 0
			IF EXISTS(SELECT 1 FROM @tblInput WHERE ClientId = 0)
			BEGIN
				--MR:294737 - if the client has the name appended with UUID, then use that
				UPDATE	@tblInput
				SET		clientId = CLIENT.Id
				FROM	@tblInput INPUT INNER JOIN App_Client CLIENT ON INPUT.uniqueIdentifier = SUBSTRING(CLIENT.name, (LEN(CLIENT.name) - CHARINDEX('_',REVERSE(CLIENT.name)))+2, LEN(CLIENT.name))
				WHERE	CLIENT.Id NOT IN (SELECT ClientId FROM SMControlHost) AND INPUT.ClientId = 0 AND INPUT.uniqueIdentifier <> ''
			END
		END --End of updating clientID
	END
	SELECT	Id, CtrlHostId,
			case when ClientId = 1 then origClientId else ClientId end,
			actionPending, 0, N'',N'' FROM @tblInput
	RETURN
ERR_EXIT:
	SELECT 0, 0, 0, 0, @errCode, @errStr,N''
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'AppCheckIfClientOrArrayExists')
	delete from GxQscripts where name = 'AppCheckIfClientOrArrayExists'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCheckIfClientOrArrayExists')
	delete from GXDBVersions where aliasname = 'AppCheckIfClientOrArrayExists'
GO

insert into GXDBVersions values(2, 'AppCheckIfClientOrArrayExists',  '00000000000000000000', 'AppCheckIfClientOrArrayExists', '00000000000000000000')
GO

