

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCheckIfClientMultiSiteEnabled.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--	+=======================================================================+
--	|  							AppCheckIfClientMultiSiteEnabled						|
--	|  Procedure to check if a given client (array controller/data access node) is eligibile to run Multisite related operations		|
--	+=======================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppCheckIfClientMultiSiteEnabled')
BEGIN
	print '>>> Drop Stored Procedure: AppCheckIfClientMultiSiteEnabled <<<'
	drop procedure AppCheckIfClientMultiSiteEnabled
END
IF EXISTS (select * from GxQscripts where name='AppCheckIfClientMultiSiteEnabled')
	delete from GxQscripts where name = 'AppCheckIfClientMultiSiteEnabled'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCheckIfClientMultiSiteEnabled')
	delete from GXDBVersions where aliasname = 'AppCheckIfClientMultiSiteEnabled'
GO
print '... Creating Procedure: AppCheckIfClientMultiSiteEnabled'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppCheckIfClientMultiSiteEnabled
  @iClientId INTEGER
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
  DECLARE @oISMSEnabled INTEGER
SET NOCOUNT ON
BEGIN
	--Eligibility criteria is that the client (array controller/data access node) should have SP >=23 and Release =11
	DECLARE @MSSPVersion	INT	= 23
	DECLARE @MSReleaseId	INT	= 11
	DECLARE @CurrSPVersion	INT	= 0
	DECLARE @CurrReleaseId	INT	= 0
	SET @oISMSEnabled = 0
	SELECT @CurrSPVersion = F1.spLevel , @CurrReleaseId = F1.releaseId
    from GetSpVersionInfo(@iClientId) F1
	IF (@CurrReleaseId > @MSReleaseId) OR  (@CurrReleaseId = @MSReleaseId AND @CurrSPVersion >= @MSSPVersion)
	BEGIN
		SET @oIsMSEnabled = 1
	END
	IF OBJECT_ID('tempdb..#AppCheckIfClientMultiSiteEnabledResultTable') IS NOT NULL
	BEGIN
		INSERT INTO #AppCheckIfClientMultiSiteEnabledResultTable
		SELECT @oIsMSEnabled
	END
	ELSE
	BEGIN
		SELECT @oIsMSEnabled
	END
	SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppCheckIfClientMultiSiteEnabled')
	delete from GxQscripts where name = 'AppCheckIfClientMultiSiteEnabled'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCheckIfClientMultiSiteEnabled')
	delete from GXDBVersions where aliasname = 'AppCheckIfClientMultiSiteEnabled'
GO

insert into GXDBVersions values(2, 'AppCheckIfClientMultiSiteEnabled',  '00000000000000000000', 'AppCheckIfClientMultiSiteEnabled', '00000000000000000000')
GO

