

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCheckEntityIncluded.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCheckEntityIncluded.sp,v $ $Id: AppCheckEntityIncluded.sp,v 1.6.14.2 2018/03/27 08:13:34 jiechen Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppCheckEntityIncluded   - This procedure takes three arguments @entity, @entityList and @alertId.
--                              @entity will be of the type GenericEntity message xml and @entityList will be of association message type
--                              Which is a list of generic entity , This procedure will check whether @entity is included or not in the entity list and if the entity belongs to the appTypeFilter of the alert specified
--
--
--  +========================================================================+
--  | Stored Precedure: AppCheckEntityIncluded
--  |
--  | Description:
--  |   This procedure takes two argument @entity and @entityList .
--  |   @entity will be of the type GenericEntity message xml and @entityList will be of association message type
--	|   Which is a list of generic entity , This procedure will check whether @entity is included or not in the entity list
--  |
--  |   Revisions  Author              Description
--  |   ---------  -----------        -------------------------------
--  |   1.0        Nikhil Chorappan    Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppCheckEntityIncluded <<<'

IF EXISTS (select * from sysobjects where name='AppCheckEntityIncluded')
	drop procedure AppCheckEntityIncluded
IF EXISTS (select * from GxQscripts where name='AppCheckEntityIncluded')
	delete from GxQscripts where name = 'AppCheckEntityIncluded'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCheckEntityIncluded')
	delete from GXDBVersions where aliasname = 'AppCheckEntityIncluded'
GO
print '... Creating Procedure: AppCheckEntityIncluded'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCheckEntityIncluded
  @entity xml,
  @entityList XML,
  @alertId INT
AS
  DECLARE @retVal INT 
-------------------
---    BEGIN    ---
-------------------
BEGIN
  SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
  SELECT @retval = dbo.IsEntityInAssocList( @entity,@entityList,@alertId)
  SELECT @retval
END

IF EXISTS (select * from GxQscripts where name = 'AppCheckEntityIncluded')
	delete from GxQscripts where name = 'AppCheckEntityIncluded'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCheckEntityIncluded')
	delete from GXDBVersions where aliasname = 'AppCheckEntityIncluded'
GO

insert into GXDBVersions values(2, 'AppCheckEntityIncluded',  '00010006001400020000', 'AppCheckEntityIncluded', '00010006001400020000')
GO

