

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCheckDeviceActivationPrerequisite.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +================================================================================================+
--  |   Procedure:  AppCheckDeviceActivationPrerequisite()
--  |
--  | Description:  Executes some checks for activation of plan and return the response accordingly
--  |
--  |       Input:  user id , locale id , physicalClientId
--  |      Output:  ProfileId,ErrorCode, ErrorString to determine status of the operation
--  |				errorCode- 0 if successfull, non zero if any of the Prerequisite failed.
--  |
--  |
--  +================================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppCheckDeviceActivationPrerequisite')
BEGIN
	print '>>> Drop Stored Procedure: AppCheckDeviceActivationPrerequisite <<<'
	drop procedure AppCheckDeviceActivationPrerequisite
END
IF EXISTS (select * from GxQscripts where name='AppCheckDeviceActivationPrerequisite')
	delete from GxQscripts where name = 'AppCheckDeviceActivationPrerequisite'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCheckDeviceActivationPrerequisite')
	delete from GXDBVersions where aliasname = 'AppCheckDeviceActivationPrerequisite'
GO
print '... Creating Procedure: AppCheckDeviceActivationPrerequisite'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppCheckDeviceActivationPrerequisite
  @userId INTEGER,
  @localeId INTEGER,
  @physicalClientId INTEGER,
  @ignoreBlacklistedUser INTEGER,
  @iPlanId INTEGER
AS
  DECLARE @planId INTEGER
  DECLARE @userCentric INTEGER
  DECLARE @flag INTEGER
  DECLARE @errorCode INTEGER
  DECLARE @errorString NVARCHAR(MAX)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @planId = @iPlanId
SET @errorCode = 0
SET @errorString = N''
SET @userCentric = 0
-- Flag used to check if Activation is deferred(Flag = 3) or Device is already activated(Flag = 1)
SET @flag = 0
BEGIN TRY
--NOT_ACTIVATED 0
--ACTIVATED_MODE_DEVICE_CENTRIC 1
--ACTIVATED_MODE_USER_CENTRIC 2
DECLARE @activatedMode INT = ISNULL((SELECT attrval FROM APP_CLIENTPROP
WHERE attrname = 'Activated Mode' and modified = 0 AND componentNameId=@physicalClientId),0)
-- Check if Laptop is already activated (Device centric)
IF @activatedMode = 1
BEGIN
SET @flag = 1
	SET @errorCode = 0
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3684 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
	GOTO GENERATE_OUTPUT
END
DECLARE @authCode nvarchar(64)
DECLARE @authCompanyId INT
DECLARE @isBlackListedUser INT = 0
IF @userId <> 0
BEGIN
	DECLARE @login nvarchar(max)
	DECLARE @providerId INT
	SELECT @login = login,@providerId = umdsproviderId FROM UMUsers
		WHERE id = @userId
	--If its not an AD user (or) company user
	IF @providerId = 0 AND CHARINDEX('\',@login,1) <> 0
    BEGIN
		IF NOT EXISTS(SELECT TOP 1 attrVal FROM UMUsersProp WHERE componentNameId=@userId AND attrName ='Company Name' AND modified = 0)
		BEGIN
			-- Local user not allowed for activation
SET @errorCode = (2172 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3671 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
			GOTO GENERATE_OUTPUT
		END
    END
	-- If user belongs to a deactivated company, activation should not be allowed.
	IF @providerId <> 0
	BEGIN
IF EXISTS(SELECT 1 FROM UMDSProviders WITH (NOLOCK) WHERE ((flags & 0x0010) = 0x0010) AND
			id = (
					CASE WHEN (id = @providerId) THEN id
						 ELSE (SELECT DISTINCT ownerCompany FROM UMDSProviders WITH(NOLOCK) WHERE id = @providerId)
					END)
			)
		BEGIN
SET @errorCode = (3908 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3908 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
			GOTO GENERATE_OUTPUT
		END
	END
	IF @planId > 0
	BEGIN
		DECLARE @capabilityList VARCHAR(MAX)
		DECLARE @hasCapabilityOnEntity INTEGER = 0
SET		@capabilityList = CAST(157 AS VARCHAR(20)) + ', ' + CAST(159 AS VARCHAR(20))
		--Check whether user has capabilities on all libraries
EXEC sec_checkPermissionOnEntity @userId, @capabilityList, @hasCapabilityOnEntity OUTPUT, 158, @planId
		IF  (@hasCapabilityOnEntity = 0)
		BEGIN
			-- We got the plan id but user doesn't have required rights to use the plan.
			-- Then we can't honor the passed plan id.
			SET @planId = 0
		END
		ELSE
		BEGIN
			-- Mark UserId as 0.
			-- We have plan from the request. No need to honor userid anymore in this request
			SET @userId = 0
		END
	END
	IF (@planId IS NULL) OR (@planId=0)
	BEGIN
		EXECUTE sec_isBlackListedUser @userId, @isBlackListedUser OUTPUT
		IF @isBlackListedUser = 1
		BEGIN
			-- Let's keep setting flag. This will help us in cpp layer
SET @flag = 3
			SET @errorCode = 0
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3677 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
			GOTO GENERATE_OUTPUT
		END
	END
END
ELSE
BEGIN
	-- Check if client is associated to a deactivated company
IF EXISTS(SELECT 1 FROM UMDSProviders WITH(NOLOCK) WHERE ((flags & 0x0010) = 0x0010)
AND id = (SELECT CAST(attrVal AS INT) FROM APP_ClientProp WITH(NOLOCK) WHERE attrName = 'Installation Company ID' AND modified=0 AND componentNameId = @physicalClientId)
				)
	BEGIN
SET @errorCode = (3908 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3908 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
		GOTO GENERATE_OUTPUT
	END
	IF @planId > 0
	BEGIN
		DECLARE @companyId INT
SELECT @companyId=attrVal FROM APP_ClientProp WHERE attrname='Installation Company ID' AND componentNameId=@physicalClientId AND modified=0
		-- Check if plan is provided and if company has sufficient rights on to that plan
		-- First check Invalid auth code wasn't used for this company
IF EXISTS (SELECT 1 FROM APP_ClientProp WITH(NOLOCK) WHERE attrName = 'Is Invalid Authorization Code' AND attrval='1' AND componentNameId = @physicalClientId AND modified=0)
		BEGIN
SET @errorCode = (3673 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString =  (SELECT message FROM EvLocaleMsgs WHERE messageId = (3673 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
			GOTO GENERATE_OUTPUT
		END
		ELSE IF @companyId > 0
		BEGIN
			-- We have to check only in case company id is greater than 0
			-- In all other case, we are good
			IF OBJECT_ID('tempdb.dbo.#getPlans') IS NOT NULL DROP TABLE #getPlans
			CREATE TABLE #getPlans (planId INT)
EXEC AppGetCompanyPlanList @companyId,159,'#getPlans'
			DECLARE @hasCapabilityOnPlan INTEGER = 0
			IF EXISTS (SELECT 1 FROM #getPlans WHERE planId=@planId)
			BEGIN
				SET @hasCapabilityOnPlan = 1
			END
			IF (@hasCapabilityOnPlan = 0)
			BEGIN
SET @errorCode = (4639 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString =  (SELECT message FROM EvLocaleMsgs WHERE messageId = (4639 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
				SET @errorString = REPLACE(@errorString, '^1%s', (SELECT hostName FROM UMDSProviders WITH (NOLOCK) WHERE id = @companyId))
			    SET @errorString = REPLACE(@errorString, '^2%s', (SELECT name FROM App_Plan WITH (NOLOCK) WHERE id = @planId))
				GOTO GENERATE_OUTPUT
			END
		END
	END
END
-- Default false
DECLARE @needActivation INT = ISNULL((SELECT attrval FROM APP_CLIENTPROP
WHERE attrname = 'Need Activation' and modified = 0 AND componentNameId=@physicalClientId),0)
-- Check if activation is allowed, value set during registration
-- Change to locale messages later
IF  @needActivation = 0
BEGIN
SET @errorCode = (2172 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3675 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
	GOTO GENERATE_OUTPUT
END
-- Find the plan for the activation, if you have plan we can proceed.
IF @planId = 0
BEGIN
	IF @userId = 0
	BEGIN
			-- If user Id is 0, check if there is valid auth code then use the default plan in the company.
			DECLARE @clientId INT = @physicalClientId
			-------------------------------------------------------------------------------------------------------------------------------------------
--- CODE BELOW HERE IS FROM AppGetPlanForAuthCode.spb  ----------
IF @clientId <> 0
BEGIN
SELECT @authCode=attrval FROM APP_ClientProp WITH (NOLOCK) WHERE attrname='Authorization Code'
		AND componentNameId=@clientId AND modified=0
END
IF (@authCode IS NOT NULL)
BEGIN
SELECT @authCompanyID=componentNameId FROM APP_CompanyProp WITH (NOLOCK) WHERE attrname='Authorization Code'
AND attrVal=@authCode AND cs_attrName=checksum('Authorization Code')
	-- At the time of install the auth code might have been valid, we can still use that company id
	IF @authCompanyID IS NULL
	BEGIN
		SELECT @authCompanyID=CAST(attrval as INT) FROM
APP_ClientProp WHERE attrname='Installation Company ID' and modified = 0
	END
	SELECT @planId = AP.id FROM APP_CompanyProp ACP WITH(NOLOCK)
		INNER JOIN App_Plan AP WITH(NOLOCK)
ON ACP.attrValInt=AP.id AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)
		INNER JOIN APP_CompanyProp ACP1 WITH(NOLOCK)
ON ACP1.componentNameId=ACP.componentNameId AND ACP1.attrName='Always activate with default plan' AND ACP1.modified=0 AND ACP1.attrVal='1'
WHERE ACP.componentNameId=@authCompanyID AND ACP.attrName='Default Laptop Plan' AND ACP.modified=0 AND ACP.cs_attrName=checksum('Default Laptop Plan')
	IF ((@planId IS NULL) OR (@planId = 0))
	BEGIN
		-- Get Tenant Admin Id
		DECLARE @tenantAdminId_spb INT
		DECLARE @errorCode_spb INT
		DECLARE @errorMsg_spb NVARCHAR(1024)
		EXEC dbo.AppGetTenantAdminForCompany @authCompanyID, 0, @tenantAdminId_spb OUTPUT, @errorCode_spb OUTPUT, @errorMsg_spb OUTPUT
		IF (@errorCode_spb=0) AND (@tenantAdminId_spb > 0)
		BEGIN
			-- Get all plan for company
			IF OBJECT_ID('tempdb.dbo.#sec_tempGetPlans') IS NOT NULL
				DROP TABLE #sec_tempGetPlans
			CREATE TABLE #sec_tempGetPlans
			(
				planId INT
			)
EXEC sec_getNonIdaObjectsForThisUser @tenantAdminId_spb, 158,159,'#sec_tempGetPlans'
			DECLARE @laptopPlanId INT, @countLaptopPlan INT = 0
			SELECT @laptopPlanId=AP.id, @countLaptopPlan=COUNT(*) OVER ()  FROM #sec_tempGetPlans GP
			INNER JOIN APP_Plan AP WITH(NOLOCK)
ON AP.id=GP.planId AND AP.subType=33554439 AND (AP.flag & 0x00004 = 0) AND (AP.flag & 0x40000000 = 0)
			GROUP BY AP.id
			IF ((@countLaptopPlan = 1) AND (@laptopPlanId > 0))
			BEGIN
				DECLARE @rcnt_spb INT = 0
				DECLARE @nowTime_spb INT = dbo.getUnixTime(GETUTCDATE())
				--	-- Below is the summary of logic
				--	-- If there is only one laptop plan then use that plan to activate the laptops when the laptop is registered with tenant authcode.
				--	--	--Set the key for CVD to be able to auto add the first logged in user as owner or when the user logs in from edge monitor, the user can be added as owner of the laptop.
				--	--	--	-- If GxGlobalParam is set (for auto setup of default plan for client with authcode and it is pure Plan Mode)
				--	--		--	--	Do we set this one plan as default? - Yes
				--	--		--	--	Do we set the "Always activate with default plan" as ON? - Yes
				IF EXISTS (SELECT 1 FROM GxGlobalParam  WITH(NOLOCK) WHERE name='IsOnlyPlanModeEnforced' AND value='1')
				BEGIN
					-- Set Plan as default Plan
					-- Set Always activate with default plan for company
					UPDATE APP_CompanyProp SET attrval =  CAST(@laptopPlanId AS NVARCHAR(16))
WHERE attrname = 'Default Laptop Plan'
						AND componentNameId = @authCompanyID AND modified=0
AND cs_attrName=CHECKSUM('Default Laptop Plan')
					SET @rcnt_spb = @@ROWCOUNT
					IF (@rcnt_spb = 0)
					BEGIN
						INSERT into App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@authCompanyID, 'Default Laptop Plan', 7,  @laptopPlanId, @nowTime_spb, 0)
					END
					SET @rcnt_spb = 0
					UPDATE APP_CompanyProp SET attrval =  '1'
WHERE attrname = 'Always activate with default plan'
						AND componentNameId = @authCompanyID AND modified=0
AND cs_attrName=CHECKSUM('Always activate with default plan')
					SET @rcnt_spb = @@ROWCOUNT
					IF (@rcnt_spb = 0)
					BEGIN
						INSERT into App_CompanyProp(componentNameId, attrName, attrType, attrVal, created, modified)
VALUES(@authCompanyID, 'Always activate with default plan', 7,  '1', @nowTime_spb, 0)
					END
				END
				-- All done
				-- SET Laptop Plan Id
				SET @planId = @laptopPlanId
			END
		END
	END
	IF OBJECT_ID('tempdb.dbo.#getPlans') IS NOT NULL DROP TABLE #getPlans
END
--- CODE ABOVE HERE IS FROM AppGetPlanForAuthCode.spb  ----------
			-------------------------------------------------------------------------------------------------------------------------------------------
			-- Valid auth code is provided, but no property set to activate with default plan. Hence require user information to activate.
			IF @planId IS NULL OR @planId = 0
			BEGIN
					-- GENERATE ERROR
					SET @errorCode = 1
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3683 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
					GOTO GENERATE_OUTPUT
			END
	END
	ELSE
	BEGIN
		-------------------------------------------------------------------------------------------------------------------------------------------
--- CODE BELOW HERE IS FROM AppGetPlanForUser.spb  ----------
-- in order to use variables to be declared are : INPUT : @userId INT, OUTPUT @plandId INT, userCentric INT
-- also "SPBodies\AppPlanConstants.spb" should be included before using this snippet
-- Check If user preference for activation of laptop as user centric client is disabled
-- As per discussion with Bhavyan - We will refer only those user groups which are assigned to a plan to determine user activation type
-- Sequence - User->Global Level->Company Level(for Sp11 at advance settings)->User Group Level
-- Item higher in priority order is checked for for User Centric preference only.
-- If someone has "Device Centric" set at higher level in priority but still has user centric down the line, then we will use user centric
DECLARE @userOrgId INT = dbo.AppGetOrganizationForUser(@userId)
DECLARE @priTable AS TABLE (fIsUserCentric INT, PriorityLevel INT)
INSERT INTO @priTable
    SELECT UUP.attrVal, 1 from UMUsers UU WITH(NOLOCK) INNER JOIN UMUsersProp UUP WITH(NOLOCK) ON UU.id=UUP.componentNameId
WHERE UU.id = @userId AND (UUP.attrName = 'Prefer Machine Centric Client' AND UUP.attrType = 7)
	UNION ALL
SELECT value, 2 from GXGlobalParam WITH(NOLOCK) where name='Prefer Machine Centric Client' AND value=N'0'
	UNION ALL
SELECT CAST(attrval AS INT), 3 FROM App_CompanyProp WITH(NOLOCK) WHERE attrname='Prefer Machine Centric Client' AND componentNameId=@userOrgId AND attrval=N'0' AND  cs_attrName = checksum('Prefer Machine Centric Client')
	UNION ALL
    SELECT UGP.attrVal, 4  from UMUserGroup UUG WITH(NOLOCK)
		INNER JOIN UMGroupsProp UGP WITH(NOLOCK) ON UGP.componentNameId=UUG.groupId
INNER JOIN App_PlanProp APP WITH(NOLOCK) ON APP.attrVal=CAST(UUG.groupId AS NVARCHAR(64)) AND APP.attrName IN ('Assigned user group', 'Associated internal user group', 'Associated external user group')
WHERE UUG.userId = @userId AND (UGP.attrName = 'Prefer Machine Centric Client' AND UGP.attrType = 7 and UGP.attrVal='0')
DECLARE @fIsPreferenceMachineCentric INT = ISNULL((select TOP 1 fIsUserCentric  from @priTable order by PriorityLevel),1)
IF (@fIsPreferenceMachineCentric IS NOT NULL AND @fIsPreferenceMachineCentric = 1) OR (@fIsPreferenceMachineCentric IS NULL)
BEGIN
    SET @userCentric = 0
END ELSE BEGIN
    SET @userCentric = 1
END
-- check for direct plan association
SELECT @planId = CAST(attrVal AS INT) FROM UMUsersProp UUP WITH(NOLOCK)
	INNER JOIN App_Plan AP
ON UUP.attrVal=CAST(AP.id AS NVARCHAR(64)) AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)
WHERE UUP.componentNameId = @userId AND UUP.attrName = 'Associated Plan' AND UUP.modified=0
-- if there was no direct association try to get plan associated with the group to which user belongs
IF @planId IS NULL OR @planId = 0
BEGIN
	-- For device centric user, all type of group are OK as default preference is - Device Centric
    SET @planId = (SELECT  TOP 1 AP.id
                    FROM App_Plan AP WITH(NOLOCK)
						INNER JOIN UMUserGroup UUG WITH(NOLOCK)
							ON UUG.userId=@userId
						INNER JOIN UMGroupsProp UGP WITH(NOLOCK)
ON UGP.componentNameId=UUG.groupId AND UGP.attrName = 'Associated Plan' AND UGP.modified=0 AND CAST(AP.id AS NVARCHAR(64))=UGP.attrVal
						INNER JOIN App_PlanProp APP WITH(NOLOCK)
ON APP.componentNameId=AP.id AND APP.attrName IN ('Associated internal user group', 'Associated external user group') AND APP.modified=0
WHERE ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0) AND APP.attrVal=CAST(UGP.componentNameId AS NVARCHAR(64)))
END
-- if user does not belong to any group and there was no direct plan association try to find organization to which user belongs
IF @planId IS NULL  OR @planId = 0 BEGIN
	-- To ensure we refer to the latest setting as per index in table (in case of multiple enteries)
    SELECT @planId =AP.id FROM APP_CompanyProp ACP WITH(NOLOCK)
		INNER JOIN App_Plan AP WITH(NOLOCK)
ON ACP.attrValInt=AP.id AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)
WHERE ACP.componentNameId=@userOrgId AND ACP.attrName='Default Laptop Plan' AND ACP.cs_attrName=checksum('Default Laptop Plan') AND ACP.modified=0
    IF (@planId IS NOT NULL)  AND (@planId <> 0)
    BEGIN
        DECLARE @planUserGroupId INT = 0
SELECT @planUserGroupId = attrval from App_PlanProp WITH(NOLOCK) WHERE componentNameId=@planId AND attrName = 'Assigned user group' AND modified=0
        Merge UMUsersProp As UUP
        USING (SELECT @userId) as SRC(userId)
ON SRC.userId = UUP.componentNameId AND UUP.attrName = 'Associated Plan' AND UUP.modified=0
            WHEN MATCHED THEN
                UPDATE SET attrVal = @planId
            WHEN NOT MATCHED THEN
INSERT(componentNameId, attrName, attrVal, attrType, created, modified ) VALUES(@userId, 'Associated Plan', @planId, 7, dbo.GetUnixTime(GetDate()), 0);
		IF NOT EXISTS (SELECT 1 FROM UMUserGroup WHERE userId=@userId AND groupId=@planUserGroupId)
		BEGIN
			INSERT INTO UMUserGroup
				VALUES (@userId, @planUserGroupId, 0)
		END
    END
END
--- CODE ABOVE HERE IS FROM AppGetPlanForUser.spb  ----------
		-------------------------------------------------------------------------------------------------------------------------------------------
		--Install rights
		DECLARE @o_userHasInstallCapability INT
		EXECUTE sec_userHasCapability @userId, 0, @o_userHasInstallCapability OUTPUT, 0, 1, '65' -- Install client permission
		-- Ideally , if there is plan, then that should give user rights for install
		-- so, error message should be correct one which give useful information
		IF (@o_userHasInstallCapability = 0)
		BEGIN
		    IF (@planId IS NULL) OR (@planId <=0)
		    BEGIN
				    SET @errorCode = 1
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2843 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
					GOTO GENERATE_OUTPUT
		    END
		    ELSE
		    BEGIN
SET @errorCode=(2493 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString=(select message from EvLocaleMsgs Where messageId=(2493 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and [localeId] = @localeId)
			    SET @errorString = REPLACE(@errorString, '^1%s', (SELECT login FROM UMUsers WITH (NOLOCK) where id = @userId))
SET @errorString = REPLACE(@errorString, '^2%s', (select message from EvLocaleMsgs Where messageId=(2491 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and [localeId] = @localeId))
			    GOTO GENERATE_OUTPUT
		    END
		END
	END
END
-- We dont have a plan ID then dont proceed with Activation
IF @planId IS NULL  OR @planId = 0
BEGIN
		SET @errorCode = 1
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2843 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
		GOTO GENERATE_OUTPUT
END
-- First check if there is pending activation reqeust for this client.
-- If yes, then just return error stating there is pending activation request.
DECLARE @isElasticPlan INT  = 0
DECLARE @storageRules XML = dbo.AppPlanGetEntityValueV2(@planId, 'Storage Rules', default)
IF @storageRules.exist('//./rule') = 1
BEGIN
	SET @isElasticPlan = 1
END
-- With MR# 270326, it has been decided to allow re-association though the plan association is pending.
/*
IF EXISTS (SELECT 1 FROM App_PlanDeferredEntityAssoc WHERE entityId = @physicalClientId AND entityType = 3) AND (@isElasticPlan = 0)
BEGIN
SET @errorCode = (3865 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3865 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
	GOTO GENERATE_OUTPUT
END
*/
-- Check to see if planid that is calculated is elastic plan and client does have geo tagging
DECLARE @storagePolicyId INT
EXEC dbo.PlanRuleEvaluateStoragePolicyForEntityV2 @planId, @physicalClientId, 3, @userId, @localeId, 0, @storagePolicyId OUTPUT, @errorCode OUTPUT, @errorString OUTPUT
IF (@errorCode <> 0) OR (@storagePolicyId = 0)
BEGIN
	GOTO GENERATE_OUTPUT
END
--NOT_ACTIVATED 0
--ACTIVATED_MODE_DEVICE_CENTRIC 1
--ACTIVATED_MODE_USER_CENTRIC 2
IF @activatedMode = 1
BEGIN
	DECLARE @oldPlanId INT = ISNULL((SELECT attrval FROM APP_CLIENTPROP
WHERE attrname = 'Associated Plan' and modified = 0 AND componentNameId=@physicalClientId),0)
	-- If activatedMode is device.
	-- This condition is needed as it will cause a data loss if we allow device to be shared by multiple users with different plans in device centric mode
	IF @planId <> @oldPlanId
	BEGIN
SET @errorCode = (2172 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (3676 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
		GOTO GENERATE_OUTPUT
	END
END
-- If modes are different, activation should not be proceed.
IF @activatedMode = 2 -- User Centric
	AND @userCentric = 0 -- Request is device centric
BEGIN
SET @errorCode = (2172 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	SET @errorString = 'Device is already activated as user centric mode. Cannot allow device centric activation.'
	GOTO GENERATE_OUTPUT
END
IF (@userCentric=1) AND (@planId IS NULL  OR @planId = 0)
BEGIN
SET @errorCode = (2843 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @errorString = (SELECT message FROM EvLocaleMsgs WHERE messageId = (2843 | (CAST(POWER(2, 24) AS BIGINT) * 35)) and localeid = @localeId)
	GOTO GENERATE_OUTPUT
END
DECLARE @nowTime                      int
Set     @nowTime                      =  datediff(second, '01/01/1970', GetUTCdate())
-- Insert a property in DB to determine how we would activate the client - device or user centric
IF @activatedMode = 0
BEGIN
	IF (@userCentric=1)
	BEGIN
			MERGE App_ClientProp
				USING (SELECT @physicalClientId) AS SRC(id)
ON componentNameId=SRC.id AND attrName='Activated Mode'
				WHEN MATCHED THEN
UPDATE SET attrval=2
				WHEN NOT MATCHED THEN
						INSERT (componentNameId, attrName, attrType, attrVal, created, modified , ccpId)
VALUES (@physicalClientId, 'Activated Mode', 10, 2, @nowTime, 0, 0);
		END ELSE BEGIN
					MERGE App_ClientProp
				USING (SELECT @physicalClientId) AS SRC(id)
ON componentNameId=SRC.id AND attrName='Activated Mode'
				WHEN MATCHED THEN
UPDATE SET attrval=1
				WHEN NOT MATCHED THEN
						INSERT (componentNameId, attrName, attrType, attrVal, created, modified , ccpId)
VALUES (@physicalClientId, 'Activated Mode', 10, 1, @nowTime, 0, 0);
		END
END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
            SET @errorCode = ERROR_NUMBER()
			SET @errorString = 'Error During SP Execution. Error Message :' + ERROR_MESSAGE()
			-- Rethrow Deadlock exception
			IF (@errorCode = 1205)
			BEGIN
			  ;THROW;
			END
END  CATCH
GENERATE_OUTPUT:
IF @planId IS NULL
BEGIN
	SET @planId = 0
END
	SELECT @planId,@userCentric,@flag,@errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'AppCheckDeviceActivationPrerequisite')
	delete from GxQscripts where name = 'AppCheckDeviceActivationPrerequisite'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCheckDeviceActivationPrerequisite')
	delete from GXDBVersions where aliasname = 'AppCheckDeviceActivationPrerequisite'
GO

insert into GXDBVersions values(2, 'AppCheckDeviceActivationPrerequisite',  '00000000000000000000', 'AppCheckDeviceActivationPrerequisite', '00000000000000000000')
GO

