

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCheckDeletedCompanyStoragePoliciesHasData.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCheckDeletedCompanyStoragePoliciesHasData.sp,v $ $Id: AppCheckDeletedCompanyStoragePoliciesHasData.sp,v 1.1.2.3 2020/12/21 06:57:17 jswaminathan Exp $";
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE	:	"AppCheckDeletedCompanyStoragePoliciesHasData"          |
--  |       Author	    :	sghatbale                            			|
--  | Execute the System stored procedure to check deleted   				|
--  | company's storage policies which still has data. Mark all such			|
--  | policies not ready for delete. That means this proc will prevent the deletion of 	|
--  | all the identified company storage policies which has data even after completion  |
--  | of retire client on company clients.						|
--  +-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppCheckDeletedCompanyStoragePoliciesHasData')
BEGIN
	print '>>> Drop Stored Procedure: AppCheckDeletedCompanyStoragePoliciesHasData <<<'
	drop procedure AppCheckDeletedCompanyStoragePoliciesHasData
END
IF EXISTS (select * from GxQscripts where name='AppCheckDeletedCompanyStoragePoliciesHasData')
	delete from GxQscripts where name = 'AppCheckDeletedCompanyStoragePoliciesHasData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCheckDeletedCompanyStoragePoliciesHasData')
	delete from GXDBVersions where aliasname = 'AppCheckDeletedCompanyStoragePoliciesHasData'
GO
print '... Creating Procedure: AppCheckDeletedCompanyStoragePoliciesHasData'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppCheckDeletedCompanyStoragePoliciesHasData
  @companyId INTEGER
AS
  DECLARE @errorCode INT
set @errorCode = 0
BEGIN TRY
	DECLARE @c_flags INT = 0
    SELECT @c_flags = flags FROM UMDSProviders WHERE id = @companyId AND enabled=0
IF  @c_flags & 0x0002 = 0x0002
    BEGIN
		IF OBJECT_ID('tempdb..#DDBIndexSubClientList') IS NOT NULL DROP TABLE #DDBIndexSubClientList
			CREATE TABLE #DDBIndexSubClientList(appId Integer)
		INSERT INTO #DDBIndexSubClientList
		SELECT DISTINCT componentNameId
		FROM APP_SubClientProp WITH (NOLOCK)
		where attrName in (N'DDB Backup', N'Index Subclient')
			AND (cs_attrname = CHECKSUM(N'DDB Backup') OR cs_attrname = CHECKSUM(N'Index Subclient'))
			AND modified = 0
			AND CONVERT(INTEGER,attrVal) = 1
		IF object_id('tempdb.dbo.#nonDeletableStoragePoliciesTbl') is not null
				DROP TABLE #nonDeletableStoragePoliciesTbl
		create table #nonDeletableStoragePoliciesTbl (
				    				id INT NOT NULL
								PRIMARY KEY(id))
		-- Need to revert the "scheduled for deletion.." appended at data bearing entities names for entities which are
		-- not going to be deleted.
		IF object_id('tempdb.dbo.#nonDeletableDataBearingEntities') is not null
				DROP TABLE #nonDeletableDataBearingEntities
		create table #nonDeletableDataBearingEntities (
				    				entityType INT NOT NULL,
									entityId INT NOT NULL
								PRIMARY KEY(entityType, entityId))
		INSERT INTO #nonDeletableStoragePoliciesTbl
		SELECT DISTINCT ACE.entityId
		FROM App_CompanyEntities ACE WITH (NOLOCK)
		INNER JOIN ArchFile AF WITH (NOLOCK)
ON AF.archGroupId = ACE.entityId AND ACE.entityType = 17
		LEFT OUTER JOIN #DDBIndexSubClientList TMP
			ON AF.appId = TMP.appId
		WHERE  TMP.appId IS NULL
			AND ACE.companyId = @companyId
		IF (SELECT count(0)
			FROM #nonDeletableStoragePoliciesTbl) > 0
		BEGIN
			-- This will prevent deletion of company storage policies which has data
			-- even after completion of retire clients of company. If it has data
			-- that means it is holding data from another company client/ MSP client.
			UPDATE ACE
SET ACE.flags = ACE.flags | 0x4
			FROM App_CompanyEntities ACE
			INNER JOIN #nonDeletableStoragePoliciesTbl NDSP
ON NDSP.id = ACE.entityId AND ACE.entityType = 17
			INSERT INTO #nonDeletableDataBearingEntities
SELECT 17, id
			FROM #nonDeletableStoragePoliciesTbl
			-- Based on policies which has data, we cannot delete corresponding storage pool as well
			IF object_id('tempdb.dbo.#nonDeletableStoragePoolsTbl') is not null
				DROP TABLE #nonDeletableStoragePoolsTbl
			create table #nonDeletableStoragePoolsTbl (
				    				id INT NOT NULL
								PRIMARY KEY(id))
			INSERT INTO #nonDeletableStoragePoolsTbl
			SELECT DISTINCT A.globalPolicyId
			FROM archCopyToGlobalPolicy A WITH (NOLOCK)
			INNER JOIN archGroupCopy AGC WITH (NOLOCK)
				ON AGC.id = A.copyId
			INNER JOIN #nonDeletableStoragePoliciesTbl NDSP
				ON NDSP.id = AGC.archGroupId
			UPDATE ACE
SET ACE.flags = ACE.flags | 0x4
			FROM App_CompanyEntities ACE
			INNER JOIN #nonDeletableStoragePoolsTbl ND
				ON ND.id = ACE.entityId
AND ACE.entityType = 17
					AND ACE.companyId = @companyId
			INSERT INTO #nonDeletableDataBearingEntities
SELECT 17, id
			FROM #nonDeletableStoragePoolsTbl
			-- Based on policies which has data, we cannot delete corresponding MA as well
			IF object_id('tempdb.dbo.#nonDeletableMediaAgentsTbl') is not null
        			DROP TABLE #nonDeletableMediaAgentsTbl
			create table #nonDeletableMediaAgentsTbl (id INT NOT NULL
								   PRIMARY KEY(id))
			INSERT INTO #nonDeletableMediaAgentsTbl
			SELECT DISTINCT MMP.ClientId
			FROM MMDrivepool MMP WITH (NOLOCK)
			INNER JOIN MMDataPath MMD  WITH (NOLOCK)
				ON MMP.DrivepoolId = MMD.DrivePoolId
			INNER JOIN App_CompanyEntities ACE WITH (NOLOCK)
				ON ACE.entityId = MMP.ClientId
AND ACE.entityType = 11
					AND ACE.companyId = @companyId
			INNER JOIN archGroupCopy AGC WITH (NOLOCK)
				ON AGC.id = MMD.CopyId
			INNER JOIN #nonDeletableStoragePoliciesTbl NDSP
				ON NDSP.id = AGC.archGroupId
			-- cannot delete client entity (and it's instance/backupset/subclient entities as well) if not going to delete media agent of MA client entity
			UPDATE ACE
SET ACE.flags = ACE.flags | 0x4
			FROM App_CompanyEntities ACE
			INNER JOIN #nonDeletableMediaAgentsTbl NDMA
ON NDMA.id = ACE.entityId AND ACE.entityType = 11
			UPDATE ACE
SET ACE.flags = ACE.flags | 0x4
			FROM App_CompanyEntities ACE
			INNER JOIN #nonDeletableMediaAgentsTbl NDMA
ON NDMA.id = ACE.entityId AND ACE.entityType = 3
			INSERT INTO #nonDeletableDataBearingEntities
SELECT 3, id
			FROM #nonDeletableMediaAgentsTbl
			-- a. subclients
			IF object_id('tempdb.dbo.#nonDeletableSubclientsTbl') is not null
        			DROP TABLE #nonDeletableSubclientsTbl
			create table #nonDeletableSubclientsTbl (id INT NOT NULL
								   PRIMARY KEY(id))
			INSERT INTO #nonDeletableSubclientsTbl
			SELECT DISTINCT App.entityId
			FROM App_CompanyEntities App
			INNER JOIN App_Application Appl WITH(NOLOCK)
				ON Appl.id = App.entityId
AND App.entityType = 7
					AND App.companyId = @companyId
			INNER JOIN #nonDeletableMediaAgentsTbl NDMA
				ON Appl.clientId = NDMA.id
			UPDATE App_CompanyEntities
SET flags = App.flags | 0x4
			FROM App_CompanyEntities App
			INNER JOIN #nonDeletableSubclientsTbl ST
				ON ST.id = App.entityId
AND App.entityType = 7
			INSERT INTO #nonDeletableDataBearingEntities
SELECT 7, id
			FROM #nonDeletableSubclientsTbl
			-- B. backupsets
			IF object_id('tempdb.dbo.#nonDeletableBackupsetsTbl') is not null
        			DROP TABLE #nonDeletableBackupsetsTbl
			create table #nonDeletableBackupsetsTbl (id INT NOT NULL
								   PRIMARY KEY(id))
			INSERT INTO #nonDeletableBackupsetsTbl
			SELECT DISTINCT App.entityId
			FROM App_CompanyEntities App
			INNER JOIN App_Application Appl WITH(NOLOCK)
				ON Appl.backupSet = App.entityId
AND App.entityType = 6
					AND App.companyId = @companyId
			INNER JOIN #nonDeletableMediaAgentsTbl NDMA
				ON Appl.clientId = NDMA.id
			UPDATE App_CompanyEntities
SET flags = App.flags | 0x4
			FROM App_CompanyEntities App
			INNER JOIN #nonDeletableBackupsetsTbl BT
				ON BT.id = App.entityId
AND App.entityType = 6
			INSERT INTO #nonDeletableDataBearingEntities
SELECT 6, id
			FROM #nonDeletableBackupsetsTbl
			-- C. instance
			IF object_id('tempdb.dbo.#nonDeletableInstancesTbl') is not null
        			DROP TABLE #nonDeletableInstancesTbl
			create table #nonDeletableInstancesTbl (id INT NOT NULL
								   PRIMARY KEY(id))
			INSERT INTO #nonDeletableInstancesTbl
			SELECT DISTINCT App.entityId
			FROM App_CompanyEntities App
			INNER JOIN App_Application Appl WITH(NOLOCK)
				ON Appl.instance  = App.entityId
AND App.entityType = 5
					AND App.companyId = @companyId
			INNER JOIN #nonDeletableMediaAgentsTbl NDMA
				ON Appl.clientId = NDMA.id
			WHERE Appl.instance <> 1
				AND Appl.instance NOT IN (SELECT componentNameId
					FROM APP_InstanceProp WITH(NOLOCK) INNER JOIN App_InstanceName WITH(NOLOCK)
ON App_instancename.id=componentNameId and attrName = 'Discovered VM Instance' and APP_InstanceProp.modified=0 and status=0x200000 AND attrVal = '1')
			UPDATE App_CompanyEntities
SET flags = App.flags | 0x4
			FROM App_CompanyEntities App
			INNER JOIN #nonDeletableInstancesTbl IT
				ON IT.id = App.entityId
AND App.entityType = 5
			INSERT INTO #nonDeletableDataBearingEntities
SELECT 5, id
			FROM #nonDeletableInstancesTbl
			----- Mark dependent policy copy & library of SP as not deleteble  -----
			IF object_id('tempdb.dbo.#nonDeletablePolicyCopiesTbl') is not null
        			DROP TABLE #nonDeletablePolicyCopiesTbl
			create table #nonDeletablePolicyCopiesTbl (id INT NOT NULL
								   PRIMARY KEY(id))
			INSERT INTO #nonDeletablePolicyCopiesTbl
			SELECT DISTINCT AGC.id
			FROM archGroupCopy AGC WITH(NOLOCK)
			INNER JOIN #nonDeletableStoragePoliciesTbl Pol
				On  AGC.archGroupId = Pol.id
			UNION
			SELECT DISTINCT AGC.id
			FROM archGroupCopy AGC WITH(NOLOCK)
			INNER JOIN #nonDeletableStoragePoolsTbl Pool
				On  AGC.archGroupId = Pool.id
			-- Policy copy
			UPDATE App_CompanyEntities
SET flags = App.flags | 0x4
			FROM App_CompanyEntities App
			INNER JOIN #nonDeletablePolicyCopiesTbl AGC
ON AGC.id = App.entityId AND App.entityType = 18
			-- Library
			IF object_id('tempdb.dbo.#nonDeletableLibraryTbl') is not null
        			DROP TABLE #nonDeletableLibraryTbl
			create table #nonDeletableLibraryTbl (id INT NOT NULL
								   PRIMARY KEY(id))
			INSERT INTO #nonDeletableLibraryTbl
			SELECT DISTINCT App.entityId
			FROM App_CompanyEntities App
			INNER JOIN MMLibrary ML WITH(NOLOCK)
ON ML.libraryId = App.entityId AND App.entityType = 9
			INNER JOIN MMMasterPool MMP WITH(NOLOCK)
				ON MMP.LibraryId = ML.LibraryId
			INNER JOIN MMDrivePool MD WITH(NOLOCK)
				ON MMP.MasterPoolId = MD.MasterPoolId
			INNER JOIN MMDataPath MDP WITH(NOLOCK)
				ON MD.DrivePoolId = MDP.DrivePoolId
			INNER JOIN #nonDeletablePolicyCopiesTbl  AGC
				ON AGC.id = MDP.CopyId
			UPDATE App_CompanyEntities
SET flags = App.flags | 0x4
			FROM App_CompanyEntities App
			INNER JOIN #nonDeletableLibraryTbl LT
ON LT.id = App.entityId AND App.entityType = 9
			INSERT INTO #nonDeletableDataBearingEntities
SELECT 9, id
			FROM #nonDeletableLibraryTbl
			-- Now revert the "scheduled for deletion.." appended at data bearing entities names for entities which are
			-- not going to be deleted.
			DECLARE @entityType INT = 0
			DECLARE entityTypes CURSOR FOR
			SELECT DISTINCT entityType FROM #nonDeletableDataBearingEntities
			OPEN entityTypes
			FETCH NEXT FROM entityTypes INTO @entityType
			WHILE @@FETCH_STATUS = 0
			BEGIN
				DECLARE @dynamicSQLStr NVARCHAR(MAX) = ''
				DECLARE @idColName VARCHAR(128) = ''
					,@tableName VARCHAR(128) = ''
					,@entityNameColName VARCHAR(128) = ''
					,@whereClause VARCHAR(512) = ''
				SELECT @idColName = idColName, @tableName = tableName, @whereClause = whereClause,  @entityNameColName = entityNameColName
				FROM APP_Entity
				WHERE
					entityType = @entityType
				IF @whereClause = ''
					SET @whereClause = '1=1'
				IF PATINDEX('%flags%', @whereClause) <> 0 AND PATINDEX('%.flags%', @whereClause) = 0
				BEGIN
					-- Sometimes whereclause has columns such flags which may be ambiguous with the table it is joining to, so better add table table in clause.
					SET @whereClause = REPLACE(@whereClause, 'flags', @tableName + '.' + 'flags')
				END
				SET @dynamicSQLStr =  'UPDATE ' + @tableName +
										' SET ' + @entityNameColName + ' = SUBSTRING( '
											+ @tableName + '.' + @entityNameColName +' , 1, CHARINDEX(' + '''' +
': scheduled for deletion' + '''' + ', ' +
											 @tableName + '.' + @entityNameColName + ' )-1) ' +
										' FROM ' + @tableName +
										' INNER JOIN #nonDeletableDataBearingEntities DBE
										ON DBE.entityId = '  + @tableName + '.' + @idColName +
										' AND DBE.entityType = ' + CAST (@entityType AS VARCHAR(10)) +
										' WHERE ' + @whereClause +
											' AND CHARINDEX(' + '''' +
': scheduled for deletion' + '''' + ', ' +
											 @tableName + '.' + @entityNameColName + ') > 0 '
				EXEC (@dynamicSQLStr)
				FETCH NEXT FROM entityTypes INTO @entityType
			END
			CLOSE entityTypes
			DEALLOCATE entityTypes
		END
	END
	ELSE
    BEGIN
        set @errorCode = 1
    END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @errorCode = 1
END CATCH
SELECT @errorCode AS 'errorCode'
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppCheckDeletedCompanyStoragePoliciesHasData')
	delete from GxQscripts where name = 'AppCheckDeletedCompanyStoragePoliciesHasData'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCheckDeletedCompanyStoragePoliciesHasData')
	delete from GXDBVersions where aliasname = 'AppCheckDeletedCompanyStoragePoliciesHasData'
GO

insert into GXDBVersions values(2, 'AppCheckDeletedCompanyStoragePoliciesHasData',  '00010001000200030000', 'AppCheckDeletedCompanyStoragePoliciesHasData', '00010001000200030000')
GO

