

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCheckClientsBelongToRelatedCompanies.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCheckClientsBelongToRelatedCompanies.sp,v $ $Id: AppCheckClientsBelongToRelatedCompanies.sp,v 1.1.2.1 2020/11/05 09:57:25 jswaminathan Exp $";
--  +-----------------------------------------------------------------------+
--  |       PROCEDURE	:	"AppCheckClientsBelongToRelatedCompanies"         |
--  |       Author	    :	sghatbale                            			|
--  | Execute the System stored procedure to know whether given two clients |
--  | belong to related companies .                    						|
--  +-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppCheckClientsBelongToRelatedCompanies')
BEGIN
	print '>>> Drop Stored Procedure: AppCheckClientsBelongToRelatedCompanies <<<'
	drop procedure AppCheckClientsBelongToRelatedCompanies
END
IF EXISTS (select * from GxQscripts where name='AppCheckClientsBelongToRelatedCompanies')
	delete from GxQscripts where name = 'AppCheckClientsBelongToRelatedCompanies'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCheckClientsBelongToRelatedCompanies')
	delete from GXDBVersions where aliasname = 'AppCheckClientsBelongToRelatedCompanies'
GO
print '... Creating Procedure: AppCheckClientsBelongToRelatedCompanies'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppCheckClientsBelongToRelatedCompanies
  @requestingClientId bigint,  	
  @targetClientId bigint		
AS
  DECLARE @o_relatedCompany INTEGER
  DECLARE @errorCode INTEGER
  DECLARE @errorMsg NVARCHAR(MAX)
DECLARE @requestingClientCompany Integer
DECLARE @targetClientCompany Integer
DECLARE @belongToRelatedCompany Integer = 0
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @errorCode = 0
SET @errorMsg = ''
IF NOT EXISTS (SELECT 1 FROM App_Client WITH(NOLOCK) WHERE id = @requestingClientId)
			OR NOT EXISTS (SELECT 1 FROM App_Client WITH(NOLOCK) WHERE id = @targetClientId)
BEGIN
	SET @belongToRelatedCompany = 0
SET @errorCode = 100
	IF NOT EXISTS (SELECT 1 FROM App_Client WITH(NOLOCK) WHERE id = @requestingClientId)
		SET @errorMsg = 'Client does not exists: ' + CAST (@requestingClientId AS NVARCHAR(32))
	ELSE
		SET @errorMsg = 'Client does not exists: ' + CAST (@targetClientId AS NVARCHAR(32))
	GOTO PROC_EXIT
END
SET @requestingClientCompany = ISNULL((SELECT companyId FROM App_CompanyEntities WITH(NOLOCK) WHERE entityType = 3 AND entityId = @requestingClientId), 0)
SET @targetClientCompany = ISNULL((SELECT companyId FROM App_CompanyEntities WITH(NOLOCK) WHERE entityType = 3 AND entityId = @targetClientId), 0)
IF @requestingClientCompany = 0 AND @targetClientCompany = 0
BEGIN
	-- Both the clients are MSP clients
	SET  @belongToRelatedCompany =	1
END
ELSE IF @requestingClientCompany <> 0 AND @targetClientCompany <> 0
BEGIN
	IF @requestingClientCompany = @targetClientCompany
		-- Both the clients belong to same company
		SET  @belongToRelatedCompany = 1
	ELSE
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#childCompaniesOfRequestingClientCompany') IS NOT NULL
			DROP TABLE #childCompaniesOfRequestingClientCompany
		CREATE TABLE #childCompaniesOfRequestingClientCompany
			(
				companyId INT NOT NULL
				primary key (companyId)
			)
		declare @parentCompanyId int = @requestingClientCompany
        	;with parentCompany as
        	(
select id as childCompanyId from UMDSproviders WITH(NOLOCK) where ownerCompany = @parentCompanyId and serviceType = 5
            		union all
select P.id as childCompanyId from UMDSProviders P WITH(NOLOCK) inner join parentCompany P1 on P.ownerCompany = P1.childCompanyId and P.serviceType = 5
        	)
        	INSERT INTO #childCompaniesOfRequestingClientCompany(companyId)
        	select childCompanyId
        	from parentCompany
		IF EXISTS (SELECT 1 FROM #childCompaniesOfRequestingClientCompany WHERE companyId = @targetClientCompany)
			SET  @belongToRelatedCompany = 1
		ELSE
			SET  @belongToRelatedCompany = 0
	END
END
ELSE IF @requestingClientCompany = 0 AND @targetClientCompany <> 0
BEGIN
	/*MSP client trying to access properties of company client */
	SET  @belongToRelatedCompany = 1
END
ELSE
BEGIN
	/*Company client trying to access properties of MSP client */
	SET  @belongToRelatedCompany = 0
END
PROC_EXIT:
SELECT @belongToRelatedCompany as 'o_relatedCompany', @errorCode as 'errorCode', @errorMsg as 'errorMsg'
GO

IF EXISTS (select * from GxQscripts where name = 'AppCheckClientsBelongToRelatedCompanies')
	delete from GxQscripts where name = 'AppCheckClientsBelongToRelatedCompanies'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCheckClientsBelongToRelatedCompanies')
	delete from GXDBVersions where aliasname = 'AppCheckClientsBelongToRelatedCompanies'
GO

insert into GXDBVersions values(2, 'AppCheckClientsBelongToRelatedCompanies',  '00010001000200010000', 'AppCheckClientsBelongToRelatedCompanies', '00010001000200010000')
GO

