

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCheckClientUpgradeAssociationsXML.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCheckClientUpgradeAssociationsXML.sp,v $ $Id: AppCheckClientUpgradeAssociationsXML.sp,v 1.1.2.4 2018/03/27 08:07:28 jiechen Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppCheckClientUpgradeAssociationsXML <<<'

IF EXISTS (select * from sysobjects where name='AppCheckClientUpgradeAssociationsXML')
	drop procedure AppCheckClientUpgradeAssociationsXML
IF EXISTS (select * from GxQscripts where name='AppCheckClientUpgradeAssociationsXML')
	delete from GxQscripts where name = 'AppCheckClientUpgradeAssociationsXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCheckClientUpgradeAssociationsXML')
	delete from GXDBVersions where aliasname = 'AppCheckClientUpgradeAssociationsXML'
GO
print '... Creating Procedure: AppCheckClientUpgradeAssociationsXML'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCheckClientUpgradeAssociationsXML
-- Input arguments
  @xmlInput XML
AS
  DECLARE @o_XMLOutput XML
BEGIN
	SET NOCOUNT ON
	DECLARE @clientId	INT = 0
	SELECT
		@clientId = a.value('@clientId', 'int')
	FROM
		@xmlInput.nodes('API_GetClientUpgradeAssociationsReq') doc(a)
	IF (@clientId IS NULL OR @clientId <= 0)
	BEGIN
		SELECT
			@clientId '@clientId',
			(SELECT
				1 '@errorCode',
				'Invalid clientId inputted' '@errorMessage'
			FOR XML PATH('error'), TYPE)
		FOR XML PATH('API_GetClientUpgradeAssociationsResp'), TYPE
		GOTO END_OF_PROC
	END
	IF OBJECT_ID('tempdb.dbo.#ClientsToUpgrade') IS NOT NULL
		DROP TABLE #ClientsToUpgrade
	CREATE TABLE #ClientsToUpgrade (
		clientId		INT,
		clientName		NVARCHAR(255),
		hostName		NVARCHAR(255),
		softwareVersion	NVARCHAR(255),
		osName			NVARCHAR(255),
		reasonType		INT--,
		--reason			NVARCHAR(255)
		PRIMARY KEY (clientId, reasonType)
	)
	INSERT INTO #ClientsToUpgrade
		EXEC AppCheckClientUpgradeAssociations @clientId
	-- return result set
	SELECT
		@clientId '@clientId',
		(SELECT
			c.clientId '@clientId',
			c.clientName '@clientName',
			c.hostName '@hostName',
			c.softwareVersion '@softwareVersion',
			c.osName '@osName',
			c.reasonType '@reasonType'--,
			--c.reason '@reason'
		FROM #ClientsToUpgrade c
		FOR XML PATH('upgradeAssociations'), TYPE),
		(SELECT
			0 '@errorCode',
			'Success' '@errorMessage'
		FOR XML PATH('error'), TYPE)
	FOR XML PATH('API_GetClientUpgradeAssociationsResp'), TYPE
END_OF_PROC:
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppCheckClientUpgradeAssociationsXML')
	delete from GxQscripts where name = 'AppCheckClientUpgradeAssociationsXML'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCheckClientUpgradeAssociationsXML')
	delete from GXDBVersions where aliasname = 'AppCheckClientUpgradeAssociationsXML'
GO

insert into GXDBVersions values(2, 'AppCheckClientUpgradeAssociationsXML',  '00010001000200040000', 'AppCheckClientUpgradeAssociationsXML', '00010001000200040000')
GO

