

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCheckAndInsertSubclientContent.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCheckAndInsertSubclientContent.sp,v $ $Id: AppCheckAndInsertSubclientContent.sp,v 1.6.56.3 2018/03/27 08:05:40 jiechen Exp $";
--	+===================================================================================+
--	|  					  AppCheckAndInsertSubclientContent								|
--	|          Procedure that checks if content needs to be added in subclient			|
--	+===================================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppCheckAndInsertSubclientContent <<<'

IF EXISTS (select * from sysobjects where name='AppCheckAndInsertSubclientContent')
	drop procedure AppCheckAndInsertSubclientContent
IF EXISTS (select * from GxQscripts where name='AppCheckAndInsertSubclientContent')
	delete from GxQscripts where name = 'AppCheckAndInsertSubclientContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCheckAndInsertSubclientContent')
	delete from GXDBVersions where aliasname = 'AppCheckAndInsertSubclientContent'
GO
print '... Creating Procedure: AppCheckAndInsertSubclientContent'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCheckAndInsertSubclientContent
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @inSubclientId INT, 
  @inContent NVARCHAR(MAX),
  @inUserId INT = 0,
  @inLocaleId INT = 0,
  @outSCFilterFileId INT OUTPUT,
  @outIsContentChanged INT OUTPUT,
  @outErrorCode INT = 0 OUTPUT,
  @outErrorString NVARCHAR(MAX) = '' OUTPUT
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE @nowTime		INT = dbo.GetUnixTime (GetUTCdate())
	DECLARE @scpId			INT = 0
	DECLARE @origCCId		INT = 2
	DECLARE @clientId		INT = 0
	DECLARE @appTypeId		INT = 0
	DECLARE @instanceId		INT = 0
	DECLARE @backupSetId	INT = 0
	DECLARE @canManage		INT = 0
	DECLARE @t_userCaps   	TABLE(userId INT, nodeCap bigint, childCap bigint)
	DECLARE	@oldContent		NVARCHAR(MAX) = ''
	DECLARE	@newContent		NVARCHAR(MAX) = ''
	SET @outIsContentChanged = 0
	SET @outSCFilterFileId = 0
	SELECT @scpId = ISNULL(cast(attrVal as int), 0) FROM APP_SubClientProp(NOLOCK) WHERE componentNameId = @inSubclientId AND attrName = 'Associated subclient Policy' AND modified = 0
---------------------------------------------------
--- FOR GUI AUDIT TRAIL						-------
---------------------------------------------------
	DECLARE @opMsgId INTEGER
--
	DECLARE @opEvMsgId			INTEGER
	DECLARE @opId 				INTEGER
	DECLARE @paramMsgId			INTEGER
	DECLARE @paramData 			NVARCHAR(MAX)
	DECLARE @dataIsEvent		INTEGER
DECLARE @cap				BIGINT = CAST(POWER(2.0, 2 - 1) AS bigint)
	IF object_id('tempdb.dbo.#entitiesWithManagementCapability') is not null
	DROP TABLE #entitiesWithManagementCapability
--
create table  #entitiesWithManagementCapability ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	SET @oldContent = (							-- FOR GUI AUDIT TRAIL (MIMIC C++ Audit Message)
	SELECT STUFF((
		SELECT ' '+ filename+ ';'
		FROM dbo.APP_ScFilterFile
		where componentNameId = @inSubclientId and modified = 0 order by fileName
		FOR XML PATH('')
		), 1, 1, ''
	  ) As concatenated_string)
	SET @oldContent=SUBSTRING(@oldContent, 0, LEN(@oldContent))        -- Lob off the trailing ';'
	SELECT @clientId=clientId, @appTypeId=appTypeId, @instanceId=instance, @backupSetId=backupSet FROM APP_Application WITH (NOLOCK) WHERE id = @inSubclientId
	IF @inUserId > 0
	BEGIN
		EXEC sec_getUserObjects @inUserId, 0, 0, '#entitiesWithManagementCapability'
		DELETE #entitiesWithManagementCapability WHERE capabilities&@cap=0
		IF EXISTS (SELECT 1 FROM #entitiesWithManagementCapability sec
			WHERE
			( --CHECK USER HAVING ASSOCIATION FOR THE ENTITY
				(
					@clientId = sec.clientId
					AND (@appTypeId     = sec.appTypeId   OR sec.appTypeId = 0 )
					AND (@instanceId    = sec.instanceId  OR sec.instanceId = 0 )
					AND (@backupSetId   = sec.backupSetId OR sec.backupSetId = 0 )
					AND (@inSubclientId   = sec.subClientId OR sec.subClientId = 0 )
				)
				OR --CHECK FOR USER HAVING ASSOCIATION AT CC LEVEL
				(
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
				)
			)
		)
			SET @canManage = 1
		ELSE
			SET @canManage = 0
	END
	ELSE
		SET @canManage = 1
	IF @scpId >0 AND EXISTS (SELECT 1 FROM APP_ScFilterFile WITH (NOLOCK)
			   WHERE componentNameId = @scpId AND modified = 0
			   AND (fileName = '\' OR fileName = @inContent OR @inContent LIKE (fileName + '\%') OR @inContent LIKE (fileName + '/%')))
	BEGIN
		SET @outSCFilterFileId = (SELECT TOP 1 id FROM APP_ScFilterFile WITH (NOLOCK)
								  WHERE componentNameId = @scpId AND modified = 0
								  AND (fileName = '\' OR fileName = @inContent OR @inContent LIKE (fileName + '%')))
		GOTO ALLDONE
	END
	ELSE IF EXISTS (SELECT 1 FROM APP_ScFilterFile WITH (NOLOCK)
			   WHERE componentNameId = @inSubclientId AND modified = 0
			   AND (fileName = '\' OR fileName = @inContent OR @inContent LIKE (fileName + '\%') OR @inContent LIKE (fileName + '/%')))
	BEGIN
		SET @outSCFilterFileId = (SELECT TOP 1 id FROM APP_ScFilterFile WITH (NOLOCK)
								  WHERE componentNameId = @inSubclientId AND modified = 0
								  AND (fileName = '\' OR fileName = @inContent OR @inContent LIKE (fileName + '%')))
		GOTO ALLDONE
	END
	ELSE IF EXISTS (SELECT 1 FROM APP_ScFilterFile WITH (NOLOCK)
					WHERE componentNameId = @inSubclientId AND modified = 0
					AND (fileName LIKE (@inContent + '\%') OR  fileName LIKE (@inContent + '/%')) )
	BEGIN
		IF @canManage = 0
			GOTO DONE
		DELETE FROM APP_ScFilterFile
		WHERE componentNameId = @inSubclientId AND modified = 0
		AND fileName LIKE (@inContent + '%')
		INSERT INTO APP_ScFilterFile
		VALUES(@inSubclientId, 1, @inContent, @nowTime, 0, 0)
		SELECT @outSCFilterFileId = SCOPE_IDENTITY() --@@IDENTITY -> returns the inserted identity id from trigger insert operations
		SET @outIsContentChanged = 1
	END
	ELSE
	BEGIN
		IF @canManage = 0
			GOTO DONE
		INSERT INTO APP_ScFilterFile
		VALUES(@inSubclientId, 1, @inContent, @nowTime, 0, 0)
		SELECT @outSCFilterFileId = SCOPE_IDENTITY() --@@IDENTITY -> returns the inserted identity id from trigger insert operations
		SET @outIsContentChanged = 1
	END
	IF @outIsContentChanged = 1
	BEGIN
		SET @newContent = (							-- FOR GUI AUDIT TRAIL (MIMIC C++ Audit Message)
		SELECT STUFF((
			SELECT ' '+ filename+ ';'
			FROM dbo.APP_ScFilterFile
			where componentNameId = @inSubclientId and modified = 0 order by fileName
			FOR XML PATH('')
			), 1, 1, ''
		  ) As concatenated_string)
		  SET @newContent=SUBSTRING(@newContent, 0, LEN(@newContent))        -- Lob off the trailing ';'
		IF @oldContent <> @newContent
		BEGIN
		--
		--	---------------------------------------------------
		--	DO GUI AUDIT TRAIL FOR SUBCLIENT CONTENT CHANGE  --
		--	---------------------------------------------------
SET @opMsgId = (277 | (CAST(POWER(2, 24) AS BIGINT) * 84))
EXEC EvGuiAuditSetOpWithEntity @opMsgId, @inUserId, 7, @inSubclientId, @opEvMsgId OUTPUT, @opId OUTPUT
			SET @dataIsEvent = 0
		--
SET @paramMsgId  = (202 | (CAST(POWER(2, 24) AS BIGINT) * 85))
					SET @paramData   = ISNULL((Select name from app_client where id = @clientId), 'No Client Name')
					EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
					EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @inUserId
		--
SET @paramMsgId  = (206 | (CAST(POWER(2, 24) AS BIGINT) * 85))
					SET @paramData   = ISNULL((Select name from app_idaType where type = @appTypeId), 'No Ida Name')
					EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
					EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @inUserId
		--
SET @paramMsgId  = (208 | (CAST(POWER(2, 24) AS BIGINT) * 85))
					SET @paramData   = ISNULL((Select name from app_backupsetName where id = @backupsetId), 'No Backupset Name')
					EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
					EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @inUserId
		--
SET @paramMsgId  = (211 | (CAST(POWER(2, 24) AS BIGINT) * 85))
					SET @paramData   = ISNULL((Select subClientName from app_application where id = @inSubclientId), 'No Subclient Name')
					EXEC EvGuiAuditSetParamData @opId, @paramData, @dataIsEvent
					EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @inUserId
SET @paramMsgId  = (776 | (CAST(POWER(2, 24) AS BIGINT) * 83))
				EXEC EvGuiAuditSetParamData @opId, @oldContent, @dataIsEvent
				EXEC EvGuiAuditSetParamData @opId, @newContent, @dataIsEvent
				EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @inUserId
		END
	END
DONE:
	--SELECT  @outSCFilterFileId, @outIsContentChanged
	IF @canManage = 0
	BEGIN
		DECLARE @clientName NVARCHAR(MAX)
		DECLARE @objectName NVARCHAR(MAX)
		SET @clientName = ISNULL((SELECT name FROM App_Client WHERE id = @clientId), '')
SET @outErrorCode = (462 | (CAST(POWER(2, 24) AS BIGINT) * 35))
SET @objectName = (SELECT message FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = (1007 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @inLocaleId)
		SET @objectName = @objectName + '[' + @clientName + ']'
		SET @outErrorString = (SELECT message FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = @outErrorCode AND [localeId] = @inLocaleId)
		SET @outErrorString = REPLACE(@outErrorString, '^1%s', (SELECT login FROM UMUsers WITH (NOLOCK) WHERE id = @inUserId))
		SET @outErrorString = REPLACE(@outErrorString, '^2%s', dbo.fn_EvFormatEventMsgText(0, @inLocaleId, (SELECT tokenId FROM UMCapability WITH (NOLOCK) WHERE id = @cap), 0, 2))
		SET @outErrorString = REPLACE(@outErrorString, '^3%s', @objectName)
	END
ALLDONE:
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppCheckAndInsertSubclientContent')
	delete from GxQscripts where name = 'AppCheckAndInsertSubclientContent'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCheckAndInsertSubclientContent')
	delete from GXDBVersions where aliasname = 'AppCheckAndInsertSubclientContent'
GO

insert into GXDBVersions values(2, 'AppCheckAndInsertSubclientContent',  '00010006005600030000', 'AppCheckAndInsertSubclientContent', '00010006005600030000')
GO

