

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppChangeDomainName.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppChangeDomainName.sp,v $ $Id: AppChangeDomainName.sp,v 1.11.192.4 2019/05/16 20:37:10 bzhu Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						SP: "AppChangeDomainName"							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppChangeDomainName')
BEGIN
	print '>>> Drop Stored Procedure: AppChangeDomainName <<<'
	drop procedure AppChangeDomainName
END
IF EXISTS (select * from GxQscripts where name='AppChangeDomainName')
	delete from GxQscripts where name = 'AppChangeDomainName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppChangeDomainName')
	delete from GXDBVersions where aliasname = 'AppChangeDomainName'
GO
print '... Creating Procedure: AppChangeDomainName'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppChangeDomainName
-- ---------------------------------------------------------------
-- Function is used to lookup the client list using specified condition
-- ---------------------------------------------------------------
  @i_commcellId integer,
  @i_oldDomainName varchar(255),
  @i_newDomainName varchar(255)
AS
  DECLARE @rows integer
	SET NOCOUNT ON
	DECLARE	@commCellId			integer
DECLARE	@oldDomainName		varchar(255)
DECLARE	@newDomainName		varchar(255)
	DECLARE	@return			integer
	DECLARE @tempClients TABLE (
        Id                  integer,
        ClientName  varchar(255),
        NetHostName varchar(255),
        CsHostName  varchar(255),
        isDup               integer,
        newNetHostName  varchar(255),
        newCsHostName   varchar(255),
        isNasClient integer,
        csHostClientId  integer
    )
	insert into @tempClients
	exec AppGetClientListForDomainChange  @i_commcellId,@i_oldDomainName,@i_newDomainName
	--select * from @tempClients
	DECLARE @tempCCount INTEGER
	SET @tempCCount = (select COUNT(*) from @tempClients)
	IF @tempCCount = 0
		GOTO ENDSP
	-- update Nas client
	UPDATE	MMLibraryHostInfo
	SET		NetHostName = cl.newNetHostName
	FROM	@tempClients cl, MMLibraryHostInfo lib
	WHERE	lib.NetHostName = cl.NetHostName
	--UPdate DAG Client
	update APP_ClientProp SET  attrName = cl.newNetHostName
	FROM	@tempClients cl, APP_ClientProp CP
	where CP.attrName = cl.NetHostName  and CP.modified =0
	-- Update ArchPipeLine
	UPDATE	ArchPipeLine
	SET		srcInterface = cl.newNetHostName,
			srcIP = ''
	FROM		@tempClients cl, ArchPipeLine pl
	WHERE		pl.srcInterface = cl.NetHostName
	UPDATE	ArchPipeLine
	SET		destInterface = cl.newNetHostName,
			destIP = ''
	FROM		@tempClients cl, ArchPipeLine pl
	WHERE		pl.destInterface = cl.NetHostName
	-- Update App_ClientProp
	UPDATE	App_ClientProp
	SET		attrVal = cl.newNetHostName
	FROM	@tempClients cl, App_ClientProp prop
	WHERE		attrName = 'DataPipeInterface' AND
				prop.attrVal = cl.NetHostName
	-- update Net_HostName
	UPDATE	App_Client
	SET		Net_HostName = tempC.newNetHostName
	FROM	@tempClients tempC,App_Client C
	WHERE	tempC.Id = C.id
	-- update LicUsage table
	UPDATE	LicUsage
	SET	Name = tempC.newNetHostName
	FROM	@tempClients tempC,LicUsage L
	WHERE	tempC.Id = L.CId
	SET	@return = @@rowcount
ENDSP:
	SELECT @return
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppChangeDomainName')
	delete from GxQscripts where name = 'AppChangeDomainName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppChangeDomainName')
	delete from GXDBVersions where aliasname = 'AppChangeDomainName'
GO

insert into GXDBVersions values(2, 'AppChangeDomainName',  '00010011019200040000', 'AppChangeDomainName', '00010011019200040000')
GO

