

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppChangeCSHostName.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppChangeCSHostName.sp,v $ $Id: AppChangeCSHostName.sp,v 1.10.294.4 2019/05/16 20:37:13 bzhu Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						SP: "AppChangeCSHostName"							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppChangeCSHostName')
BEGIN
	print '>>> Drop Stored Procedure: AppChangeCSHostName <<<'
	drop procedure AppChangeCSHostName
END
IF EXISTS (select * from GxQscripts where name='AppChangeCSHostName')
	delete from GxQscripts where name = 'AppChangeCSHostName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppChangeCSHostName')
	delete from GXDBVersions where aliasname = 'AppChangeCSHostName'
GO
print '... Creating Procedure: AppChangeCSHostName'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppChangeCSHostName
-- ---------------------------------------------------------------
-- Function is used to lookup the client list using specified condition
-- ---------------------------------------------------------------
  @i_commcellId integer,
  @i_oldCSHostName varchar(255),
  @i_newCSHostName varchar(255)
AS
  DECLARE @rows integer
	SET NOCOUNT ON
	DECLARE	@commCellId			integer
DECLARE	@oldCSHostName		varchar(255)
DECLARE	@newCSHostName		varchar(255)
	DECLARE	@return			integer
	SET		@commCellId 	= @i_commcellId
	SET		@oldCSHostName 	= @i_oldCSHostName
	SET		@newCSHostName 	= @i_newCSHostName
DECLARE @short_oldHostName	varchar(255)
DECLARE @short_newHostName	varchar(255)
	DECLARE @short_name			varchar(255)
	SET @short_name = (SELECT Name FROM App_Client WHERE Net_HostName = @oldCSHostName)
	SET	@short_oldHostName = (
				SELECT SUBSTRING(Net_HostName, 0, CHARINDEX('.', Net_HostName))
				FROM App_Client WHERE Net_HostName = @oldCSHostName)
	SET @short_newHostName = SUBSTRING(@newCSHostName, 0, CHARINDEX('.', @newCSHostName))
	-- Passing the new short name inside
	IF @short_newHostName = ''
	BEGIN
		SET @short_newHostName = @i_newCSHostName
		SET @newCSHostName = @short_newHostName + SUBSTRING(@oldCSHostName, CHARINDEX('.', @oldCSHostName), LEN(@oldCSHostName))
	END
	-- update Net_HostName
	UPDATE	App_Client
	SET			Net_HostName = @newCSHostName,
				Name = @short_newHostName
	WHERE		Net_HostName = @oldCSHostName
	-- update CsHostName
	UPDATE	App_Client
	SET			CsHostName = @newCSHostName
	WHERE		CsHostName = @oldCSHostName OR CsHostName = @short_oldHostName OR CsHostName = @short_name
	SET	@return = @@rowcount
	-- update Nas client
	UPDATE	MMLibraryHostInfo
	SET			NetHostName = @newCSHostName
	WHERE		NetHostName = @oldCSHostName OR NetHostName = @short_oldHostName OR NetHostName = @short_name
	-- Update ArchPipeLine
	UPDATE	ArchPipeLine
	SET			srcInterface = @newCSHostName, srcIP = ''
	WHERE		srcInterface = @oldCSHostName OR srcInterface = @short_oldHostName OR srcInterface = @short_name
	UPDATE	ArchPipeLine
	SET			destInterface = @newCSHostName, destIP = ''
	WHERE		destInterface = @oldCSHostName OR destInterface = @short_oldHostName OR destInterface = @short_name
	-- Update App_ClientProp
	UPDATE	App_ClientProp
	SET			attrVal = @newCSHostName
	WHERE		attrName = 'DataPipeInterface' AND
					(attrVal  = @oldCSHostName OR attrVal = @short_oldHostName OR attrVal = @short_name)
	-- update LicUsage table
	UPDATE	LicUsage
	SET	Name = @newCSHostName
	WHERE	Name  = @oldCSHostName OR Name = @short_oldHostName OR Name = @short_name
	SELECT @return
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppChangeCSHostName')
	delete from GxQscripts where name = 'AppChangeCSHostName'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppChangeCSHostName')
	delete from GXDBVersions where aliasname = 'AppChangeCSHostName'
GO

insert into GXDBVersions values(2, 'AppChangeCSHostName',  '00010010029400040000', 'AppChangeCSHostName', '00010010029400040000')
GO

