

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCSNameChange.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCSNameChange.sp,v $ $Id: AppCSNameChange.sp,v 1.9.208.13 2020/07/23 21:59:05 bzhu Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						SP: "AppCSNameChange"							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppCSNameChange')
BEGIN
	print '>>> Drop Stored Procedure: AppCSNameChange <<<'
	drop procedure AppCSNameChange
END
IF EXISTS (select * from GxQscripts where name='AppCSNameChange')
	delete from GxQscripts where name = 'AppCSNameChange'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCSNameChange')
	delete from GXDBVersions where aliasname = 'AppCSNameChange'
GO
print '... Creating Procedure: AppCSNameChange'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCSNameChange
-- ---------------------------------------------------------------
-- Function is used to lookup the client list using specified condition
-- ---------------------------------------------------------------
-- change displayName to clientName to avoid confusion
  @i_oldClientName varchar(255),
  @i_newClientName varchar(255),
  @i_oldHostName varchar(255),
  @i_newHostName varchar(255),
  @i_updateCSHostName integer=1,
  @i_newDisplayName varchar(255)
AS
  DECLARE @o_id integer
  DECLARE @o_name varchar(255)
  DECLARE @o_hostname varchar(255)
	SET NOCOUNT ON
CREATE TABLE	#retClientList	 (	t_id		int PRIMARY KEY,
t_name		varchar(255),
t_netHostName	varchar(255)	)
IF @i_oldClientName <> '' AND @i_newClientName <> ''
BEGIN
	UPDATE	App_Client
	SET	name = @i_newClientName, displayName = CASE WHEN @i_newDisplayName = '' THEN displayName ELSE @i_newDisplayName END
	WHERE	name = @i_oldClientName AND name <> @i_newClientName AND id = 2
	UPDATE	App_CommCell
	SET	aliasName = @i_newClientName
	WHERE	aliasName = @i_oldClientName AND aliasName <> @i_newClientName AND clientId = 2
	-- Code cleanup
	--INSERT INTO #retClientList
	--SELECT 0, '', ''
END
IF @i_oldHostName <> '' AND @i_newHostName <> ''
BEGIN
	UPDATE	App_CommCell
	SET	aliasName = @i_newHostName
	WHERE	aliasName = @i_oldHostName AND aliasName <> @i_newHostName AND clientId = 2
	-- update Net_HostName
	UPDATE	App_Client
	SET	Net_HostName = @i_newHostName
	WHERE	Net_HostName = @i_oldHostName AND Net_HostName <> @i_newHostName AND id = 2
	-- update Nas client
	UPDATE	MMLibraryHostInfo
	SET	NetHostName = @i_newHostName
	WHERE	NetHostName = @i_oldHostName AND NetHostName <> @i_newHostName AND NDMPHostId = 2
	-- update clientProp
	UPDATE	APP_clientProp
	SET	attrVal = @i_newHostName
	WHERE	attrName = 'DataPipeInterface' AND attrVal = @i_oldHostName AND attrVal <> @i_newHostName AND componentNameId = 2
	and modified = 0
	-- Update ArchPipeLine
	UPDATE	ArchPipeLine
	SET	srcInterface = @i_newHostName, srcIP = ''
	WHERE	srcInterface = @i_oldHostName AND srcInterface <> @i_newHostName AND srcClientId = 2
	UPDATE	ArchPipeLine
	SET	destInterface = @i_newHostName, destIP = ''
	WHERE	destInterface = @i_oldHostName AND destInterface <> @i_newHostName AND destClientId = 2
	-- Update CCRClientToClient
	UPDATE	CCRClientToClient
	SET	FromClientInterfaceName = @i_newHostName
	WHERE	FromClientInterfaceName = @i_oldHostName AND FromClientInterfaceName <> @i_newHostName AND FromClientId = 2
	UPDATE	CCRClientToClient
	SET	ToClientInterfaceName = @i_newHostName
	WHERE	ToClientInterfaceName = @i_oldHostName AND ToClientInterfaceName <> @i_newHostName AND ToClientId = 2
	-- update CsHostName
	INSERT INTO #retClientList
	SELECT	id, name, net_hostName
	FROM	App_Client
	WHERE	CsHostName = @i_oldHostName
	-- update CommServer
	UPDATE	App_Client
	SET	CsHostName = @i_newHostName
	WHERE   id = 2 AND CsHostName = @i_oldHostName
	IF @i_updateCSHostName > 0
	BEGIN
		UPDATE	App_Client
		SET	CsHostName = @i_newHostName
		WHERE	id in (select t_id from #retClientList)
	END
	ELSE
	BEGIN
		-- SP5a breakage - Pseudoclients are not updated with the new cs host name.
		-- Pseudoclients or clients with no packages are not updated with the new cs host name.
		-- Update all clients with no packages installed and worktoken will take care of clients with packages installed.
		-- 2. 0X2   SAME_COMMCELL_GALAXY_PACKAGES_ABSENT
		UPDATE	App_Client
		SET	CsHostName = @i_newHostName
		WHERE	id in (select T.t_id from #retClientList T INNER JOIN
						APP_CLIENT C ON T.t_id = C.id and (C.specialClientFlags & 2 = 2))
	END
	UPDATE GXGlobalParam
		SET value = dbo.ReplaceHostNameInURL (value, @i_OldHostName, @i_NewHostName)
		WHERE name in ('CommcellConsoleUrl','CommcellReportsUrl','CommcellRSSUrl','RSS Base URL', 'WebConsoleURL')
	UPDATE CP
		SET attrVal = n.url
		FROM APP_ClientProp CP
		CROSS APPLY (SELECT dbo.ReplaceHostNameInURL (CP.attrVal, @i_OldHostName, @i_NewHostName) url ) n
		WHERE componentNameId = 2
			AND CP.attrName in ('WebURL', 'WebConsoleURL')
			AND CP.modified = 0
			AND CP.attrVal <> n.url
	UPDATE	App_CommCellInfo
	SET	CCHostName = @i_newHostName
	WHERE	CCHostName = @i_oldHostName AND CCHostName <> @i_newHostName AND commcellId = 2
END
-- DONT RETURN CLUSTER CS PHYSICAL NODES, CLIENTS WITH NO PACKAGES INSTALLED
SELECT DISTINCT clientList.t_id, clientList.t_name, clientList.t_netHostName
FROM #retClientList AS clientList
	INNER JOIN simInstalledPackages AS simPkgs
		ON clientList.t_id = simPkgs.ClientId
WHERE clientList.t_id NOT IN (SELECT PMClientId FROM APP_VMToPMMap WHERE VMClientId = 2)
	SET NOCOUNT OFF
DROP TABLE #retClientList
GO

IF EXISTS (select * from GxQscripts where name = 'AppCSNameChange')
	delete from GxQscripts where name = 'AppCSNameChange'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCSNameChange')
	delete from GXDBVersions where aliasname = 'AppCSNameChange'
GO

insert into GXDBVersions values(2, 'AppCSNameChange',  '00010009020800130000', 'AppCSNameChange', '00010009020800130000')
GO

