

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCSFailoverPropageConfig.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppCSFailoverPropageConfig')
BEGIN
	print '>>> Drop Stored Procedure: AppCSFailoverPropageConfig <<<'
	drop procedure AppCSFailoverPropageConfig
END
IF EXISTS (select * from GxQscripts where name='AppCSFailoverPropageConfig')
	delete from GxQscripts where name = 'AppCSFailoverPropageConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCSFailoverPropageConfig')
	delete from GXDBVersions where aliasname = 'AppCSFailoverPropageConfig'
GO
print '... Creating Procedure: AppCSFailoverPropageConfig'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppCSFailoverPropageConfig
  @i_xmlString XML
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
BEGIN
begin try
	-- Output xml string.
	DECLARE @workTokenId int = 43 -- WORK_TOKEN_REFRESH_FAILOVER_CONFIG
	DECLARE @nowTime INT = dbo.GetUnixTime(GETUTCDATE())
	-- Reading from xml.
	-- First get whether we need to send miscSettings from Gxglobalparam
	DECLARE	@errorCode		INT = 0
	DECLARE	@errorString	NVARCHAR(1024) = N''
	DECLARE @sourceClient	INT = 0
	SET @sourceClient = ISNULL (( SELECT ref.value('@clientId', 'INT')
              FROM @i_xmlString.nodes('App_CSFailoverUpdateConfigOnNodes/sourceClient') R(ref)), 0)
	DECLARE @csFailoverConfigInfo NVARCHAR(MAX) = ''
	SELECT @csFailoverConfigInfo = IsNull(CONVERT(NVARCHAR(MAX),@i_xmlString.query('App_CSFailoverUpdateConfigOnNodes/operationStatus')),'')
	SET @csFailoverConfigInfo = REPLACE(@csFailoverConfigInfo, '<operationStatus','<csFailoverConfigInfo')
	SET @csFailoverConfigInfo = REPLACE(@csFailoverConfigInfo, '</operationStatus>','</csFailoverConfigInfo>')
	-- Convert this to GetMonitoredNodesFailoverResp. Since original WQ request does the same for work token WORK_TOKEN_REFRESH_FAILOVER_CONFIG
	SET @csFailoverConfigInfo = '<App_GetMonitoredNodesFailoverResp>'+@csFailoverConfigInfo+'</App_GetMonitoredNodesFailoverResp>'
	DECLARE @o_xmlString XML
	declare @destinationClientIds table
	(
		clientId int
	)
	INSERT INTO @destinationClientIds
	SELECT DISTINCT ref.value('@clientId', 'int') AS Agent
		FROM    @i_xmlString.nodes('App_CSFailoverUpdateConfigOnNodes/destinationClients') R ( ref )
	IF NOT EXISTS(SELECT 1 FROM @destinationClientIds)
	BEGIN
		INSERT INTO @destinationClientIds
		SELECT DISTINCT C.Id
		from SimInstalledPackages
        inner join App_client C on SimInstalledPackages.clientId = C.Id
and (C.status&2)=0 and simPackageID IN (24, 1024)
	END
	-- First update the CS failover config as a client property for the source client. So that client can retrieve it using appMgr apis. Sending complete failover config in workqueue request might slow down workqueue processing.
	IF NOT EXISTS(SELECT 1 FROM SimInstalledPackages
        inner join App_client C on SimInstalledPackages.clientId = C.Id
and (C.status&2)=0 and simPackageID IN (24, 1024)
		AND C.Id = @sourceClient )
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'Source Client provided does not have failover package configured. So ignoring request'
		GOTO ERROR_EXIT
	END
	IF len(@csFailoverConfigInfo)=0
	BEGIN
		SET @errorCode = 2
		SET @errorString = 'Commserv failover configuration details not provided. So ignoring request'
		GOTO ERROR_EXIT
	END
	-- Update the client properties
	UPDATE GxGlobalParam
	SET value = @csFailoverConfigInfo,
		created = @nowTime
	WHERE name = 'Failover Details' -- CV_PROP_FAILOVER_DETAILS
	AND modified = 0
	IF @@ROWCOUNT=0
	BEGIN
		INSERT INTO GxGlobalParam VALUES
		--(name , value,created,modified)
		('Failover Details', @csFailoverConfigInfo, @nowTime, 0) -- CV_PROP_FAILOVER_DETAILS
	END
	DECLARE @workTokenParams NVARCHAR(MAX) = '<CvEntities_ClientEntity clientId="'+CONVERT(nvarchar(10),@sourceClient)+'" />'
	-- Submit workqueue request to all failover nodes to refresh config.
	INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
	SELECT clientId, @workTokenId,@workTokenParams,
		dbo.GetUnixTime(GetUTCDate()), 0, 0, 0, -1
	FROM @destinationClientIds
	WHERE clientID <> @sourceClient
END TRY
 BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
     SET @errorCode = ERROR_NUMBER()
     SET @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
 END CATCH
ERROR_EXIT:
	SET @o_xmlString = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
							FOR XML PATH('App_GenericResp'), Type)
	SELECT @o_xmlString
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppCSFailoverPropageConfig')
	delete from GxQscripts where name = 'AppCSFailoverPropageConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCSFailoverPropageConfig')
	delete from GXDBVersions where aliasname = 'AppCSFailoverPropageConfig'
GO

insert into GXDBVersions values(2, 'AppCSFailoverPropageConfig',  '00000000000000000000', 'AppCSFailoverPropageConfig', '00000000000000000000')
GO

