

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCINameChange.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCINameChange.sp,v $ $Id: AppCINameChange.sp,v 1.3.2.9 2019/05/16 20:37:07 bzhu Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 						SP: "AppCINameChange"							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppCINameChange')
BEGIN
	print '>>> Drop Stored Procedure: AppCINameChange <<<'
	drop procedure AppCINameChange
END
IF EXISTS (select * from GxQscripts where name='AppCINameChange')
	delete from GxQscripts where name = 'AppCINameChange'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCINameChange')
	delete from GXDBVersions where aliasname = 'AppCINameChange'
GO
print '... Creating Procedure: AppCINameChange'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCINameChange
-- ---------------------------------------------------------------
-- Function is used to lookup the client list using specified condition
-- ---------------------------------------------------------------
  @i_ClientId int,
  @i_OldHostName varchar(255),
  @i_NewHostName varchar(255),
  @i_oldClientName varchar(255)='',
  @i_NewClientName varchar(255)=''
AS
  DECLARE @o_errorCode INTEGER;
SET NOCOUNT ON
-- In all the case, update if the property exists. Sometimes the packages are reinstalled or deleted. The urls point to old entries
-- When the property is resused, it points to old link.
IF @i_OldHostName <> @i_NewHostName
begin
		DECLARE @CloudId INT = (SELECT CloudId FROM DM2SearchServerCoreInfo WHERE ClientId = @i_ClientId  AND cloudType = 3)  --searchEngine
		UPDATE DM2SearchServerCoreInfo
		SET ServiceLink = dbo.ReplaceHostNameInURL (ServiceLink, @i_OldHostName, @i_NewHostName)
		WHERE CloudId = @CloudId AND cloudType = 3
		UPDATE APP_ComponentProp
		SET stringVal = dbo.ReplaceHostNameInURL (stringVal, @i_OldHostName, @i_NewHostName)
		WHERE componentId = @CloudId
AND propertyTypeId IN (1005, 1011)
							AND modified = 0
AND componentType = 2
		UPDATE APP_ClientProp
		SET attrVal = dbo.ReplaceHostNameInURL (attrVal, @i_OldHostName, @i_NewHostName)
		WHERE componentNameId = @i_ClientId AND attrName in ('URL for Compliance Search',
															 'URL for Administrator',
															 'URL for End-User Search',
															 'WebURL',
															 'WebConsoleURL',
															'FAST_hostName',
															'FAST_QPS_URL',
															'vWebConsoleURL')
		UPDATE APP_ClientProp
		SET attrVal = @i_NewHostName
		where attrName = 'Mongo DB Instance'
		and attrval = @i_OldHostName
		and componentNameId = @i_ClientId
		UPDATE APP_SubClientProp
		SET attrVal = dbo.ReplaceHostNameInURL (attrVal, @i_OldHostName, @i_NewHostName)
		WHERE componentNameId IN (SELECT id FROM App_application where clientId = @i_ClientId)
		AND
		attrName in ('Edge Web Server URL')
		and modified = 0
		-- update LicUsage table
		UPDATE	LicUsage
		SET	Name = @i_NewHostName
		WHERE	CId = @i_ClientId AND Name = @i_OldHostName
		UPDATE GXGlobalParam
		SET value = dbo.ReplaceHostNameInURL (value, @i_OldHostName, @i_NewHostName)
		WHERE name in ('WebConsoleURL','CommcellReportsURL')
	--Analytics engine
	IF EXISTS (SELECT TOP 1 1 FROM DM2SearchServerCoreInfo (NOLOCK) WHERE ClientId = @i_ClientId AND  cloudType IN (1,4,5))
	BEGIN
		UPDATE DM2SearchServerCoreInfo
		SET ServiceLink = ''
		WHERE ClientId = @i_ClientId AND cloudType IN (1,4,5) --AnalyticsEngine,SolrEmbeddedCloud,SolrClusterCloud
		DELETE FROM APP_ClientProp
		WHERE componentNameId = @i_ClientId AND attrName in ('Analytics_hostname','Analytics_QPS_URL')
	END
end
IF LEN(@i_NewClientName) >0 AND LEN(@i_oldClientName)> 0 AND @i_oldClientName <> @i_NewClientName
begin
		UPDATE APP_AdvanceSettings
		SET relativePath = dbo.ReplaceHostNameInURL (relativePath, @i_oldClientName, @i_NewClientName)
		WHERE entityId = @i_ClientId and Keyname LIKE 'solr%'
		and entityType = 3 AND sourceid = 0 AND sourceEntityType = 0 AND deleted = 0
end
select @@ERROR
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppCINameChange')
	delete from GxQscripts where name = 'AppCINameChange'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCINameChange')
	delete from GXDBVersions where aliasname = 'AppCINameChange'
GO

insert into GXDBVersions values(2, 'AppCINameChange',  '00010003000200090000', 'AppCINameChange', '00010003000200090000')
GO

