

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCCSUpdateXMLTableRow.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCCSUpdateXMLTableRow.sp,v $ $Id: AppCCSUpdateXMLTableRow.sp,v 1.2.40.2 2018/03/22 01:47:22 jiechen Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppCCSUpdateXMLTableRow <<<'

IF EXISTS (select * from sysobjects where name='AppCCSUpdateXMLTableRow')
	drop procedure AppCCSUpdateXMLTableRow
IF EXISTS (select * from GxQscripts where name='AppCCSUpdateXMLTableRow')
	delete from GxQscripts where name = 'AppCCSUpdateXMLTableRow'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCCSUpdateXMLTableRow')
	delete from GXDBVersions where aliasname = 'AppCCSUpdateXMLTableRow'
GO
print '... Creating Procedure: AppCCSUpdateXMLTableRow'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCCSUpdateXMLTableRow
-- Input arguments
  @inXMLText XML
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @xmlText XML = NULL;
	SET NOCOUNT ON
-- Example XML Input
-- NOTE status row modified should be set with other fields indicating the operation type this is just simple test data
--	DECLARE @xmlText XML = '
--<TBL_CCSTableRowUpdates fromClientId="3" timeStamp="1412788711">
--	<UpdateRowList>
--		<ClientPropRow attrName="GX Compliance" attrType="2" attrVal="1" ccpId="0" componentNameId="2" created="1412788611" id="3" modified="0"/>
--		<RowStatus deleted="0" id="5" inserted="0" modified="0" tableType="2" updated="0" updated65="0"/>
--	</UpdateRowList>
--	<UpdateRowList>
--		<ClientPropRow attrName="Byte Order" attrType="1" attrVal="Little-endian" ccpId="0" componentNameId="3" created="1412792419" id="45" modified="0"/>
--		<RowStatus deleted="0" id="8" inserted="0" modified="0" tableType="2" updated="0" updated65="0"/>
--	</UpdateRowList>
--	<UpdateRowList>
--		<ClientPropRow attrName="Binary Set ID" attrType="7" attrVal="3" ccpId="0" componentNameId="3" created="1412792419" id="46" modified="0"/>
--		<RowStatus deleted="0" id="9" inserted="0" modified="0" tableType="2" updated="0" updated65="0"/></UpdateRowList>
--	<UpdateRowList>
--		<ClientPropRow attrName="DataPipeInterface" attrType="1" attrVal="WFS-Aaron-1" ccpId="0" componentNameId="3" created="1412792419" id="47" modified="0"/>
--		<RowStatus deleted="0" id="10" inserted="0" modified="0" tableType="2" updated="0" updated65="0"/>
--	</UpdateRowList>
--	<UpdateRowList>
--		<ClientPropRow attrName="Sim OS Info" attrType="1" attrVal="Windows 8.1 Enterprise:-6.2:-9200:-WinX64" ccpId="0" componentNameId="3" created="1412792419" id="48" modified="0"/>
--		<RowStatus deleted="0" id="11" inserted="0" modified="0" tableType="2" updated="0" updated65="0"/>
--	</UpdateRowList>
--</TBL_CCSTableRowUpdates>'
	DECLARE @rowCnt INT;
	-- count the number of rows to insert from XML Document
	SELECT
		@rowCnt = COUNT(r.query('.'))
	FROM
		@inXMLText.nodes('TBL_CCSTableRowUpdates/UpdateRowList') rows(r)
	IF (@rowCnt = 0)
	BEGIN
		-- nothing to do!
		GOTO END_OF_PROC
	END
	IF OBJECT_ID('tempdb.dbo.#CCSTableRows') IS NOT NULL
		DROP TABLE #CCSTableRows
	CREATE TABLE #CCSTableRows (
		timeStamp		INT,
		clientId		INT,
		statusRowId		INT,
		tableType		INT,
		modified		INT,
		deleted			INT,
		inserted		INT,
		updated			BIGINT,
		updated65		BIGINT,
		xmlRow			NVARCHAR(MAX),
		ccsId			INT,
		rowId1			INT,
		rowId2			INT
	)
	CREATE UNIQUE CLUSTERED INDEX CCSTableRows_tableType_modified_clientId_statusRowId_Idx on #CCSTableRows (tableType, modified, clientId, statusRowId)
	--=========================================================================
	-- From here on actual database updates take place to APP_CCSUpdateXMLRows
	--=========================================================================
	BEGIN TRY
		-- not allowed in insert-exec operations - rollback
		--BEGIN TRANSACTION Insert_CCSUpdateXMLRows
		-- parse XML Document and insert into temp table
		INSERT INTO #CCSTableRows (
				timeStamp,
				clientId,
				statusRowId,
				tableType,
				modified,
				deleted,
				inserted,
				updated,
				updated65,
				xmlRow,
				ccsId,
				rowId1,
				rowId2
			)
			SELECT
				r.value('../../@timeStamp', 'INT') timeStamp,
				r.value('../../@fromClientId', 'INT') clientId,
				r.value('@id', 'INT') statusRowId,
				r.value('@tableType', 'INT') tableType,
				r.value('@modified', 'INT') modified,
				r.value('@deleted', 'INT') deleted,
				r.value('@inserted', 'INT') inserted,
				r.value('@updated', 'BIGINT') updated,
				r.value('@updated65', 'BIGINT') updated65,
				CAST(r.query('../ClientPropRow') AS NVARCHAR(MAX)) xmlRow,
				r.value('@ccsId', 'INT') ccsId,
				r.value('@rowId1', 'INT') rowId1,
				r.value('@rowId2', 'INT') rowId2
			FROM
				@inXMLText.nodes('TBL_CCSTableRowUpdates/UpdateRowList/RowStatus') rows(r)
		-- only insert rows that do not exist
		INSERT INTO APP_CCSUpdateXMLRows (
				timeStamp,
				clientId,
				statusRowId,
				tableType,
				modified,
				deleted,
				inserted,
				updated,
				updated65,
				xmlRow,
				flags,
				ccsId,
				rowId1,
				rowId2
			)
			SELECT
				t.timeStamp,
				t.clientId,
				t.statusRowId,
				t.tableType,
				t.modified,
				t.deleted,
				t.inserted,
				t.updated,
				t.updated65,
				t.xmlRow,
				0 flags,
				t.ccsId,
				t.rowId1,
				t.rowId2
			FROM #CCSTableRows  t
				LEFT OUTER JOIN APP_CCSUpdateXMLRows r ON	-- left outer join to only insert row updates that do not exist in the table
					r.tableType = t.tableType
					AND r.modified = t.modified
					AND r.clientId = t.clientId
					AND r.statusRowId = t.statusRowId
			WHERE
				r.timeStamp IS NULL
		-- not allowed in insert-exec operations - rollback
		--COMMIT TRANSACTION Insert_CCSUpdateXMLRows
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		-- format error to be returned to sender
		SET @xmlText = (SELECT
							ERROR_NUMBER() AS '@errorCode',
							ERROR_MESSAGE() AS '@errorMessage'
						FOR XML PATH('TMMsg_GenericResp'), TYPE)
		-- not allowed in insert-exec operations - rollback
		--ROLLBACK TRANSACTION Insert_CCSUpdateXMLRows
	END CATCH
	IF OBJECT_ID('tempdb.dbo.#CCSTableRows') IS NOT NULL
		DROP TABLE #CCSTableRows
END_OF_PROC:
	IF (@xmlText IS NULL)
	BEGIN
		-- Success
		SET @xmlText = (SELECT
							0 AS '@errorCode',
							'Success.' AS '@errorMessage'
						FOR XML PATH('TMMsg_GenericResp'), TYPE)
	END
	SELECT @xmlText AS xmlText
GO

IF EXISTS (select * from GxQscripts where name = 'AppCCSUpdateXMLTableRow')
	delete from GxQscripts where name = 'AppCCSUpdateXMLTableRow'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCCSUpdateXMLTableRow')
	delete from GXDBVersions where aliasname = 'AppCCSUpdateXMLTableRow'
GO

insert into GXDBVersions values(2, 'AppCCSUpdateXMLTableRow',  '00010002004000020000', 'AppCCSUpdateXMLTableRow', '00010002004000020000')
GO

