

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCCSTriggerToWorkQueue.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCCSTriggerToWorkQueue.sp,v $ $Id: AppCCSTriggerToWorkQueue.sp,v 1.13.2.20 2019/11/18 15:22:18 abilbrey Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppCCSTriggerToWorkQueue')
BEGIN
	print '>>> Drop Stored Procedure: AppCCSTriggerToWorkQueue <<<'
	drop procedure AppCCSTriggerToWorkQueue
END
IF EXISTS (select * from GxQscripts where name='AppCCSTriggerToWorkQueue')
	delete from GxQscripts where name = 'AppCCSTriggerToWorkQueue'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCCSTriggerToWorkQueue')
	delete from GXDBVersions where aliasname = 'AppCCSTriggerToWorkQueue'
GO
print '... Creating Procedure: AppCCSTriggerToWorkQueue'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCCSTriggerToWorkQueue
-- Input arguments
  @startTime INT
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @o_errorCode int = 0
  DECLARE @o_errorCodeStr nvarchar(1024) = ''
	SET NOCOUNT ON
	-- Debug and execution time messages
	DECLARE @timers		TINYINT = 0
	DECLARE @logLevel	INT = 0
	DECLARE @sdt DATETIME2
	DECLARE @edt DATETIME2
	IF (@timers > 0)
	BEGIN
		SET @sdt = SYSDATETIME()
		PRINT 'AppCCSTriggerToWorkQueue Start: ' + CAST(@sdt AS VARCHAR(128))
	END
	DECLARE @rowCnt INT = 0
	DECLARE @WorkToken INT = 19		-- WORK_TOKEN_CCS_DB_UPDATE
	DECLARE @AllClients INT = -1
	DECLARE @delRowCnt INT = 0
	DECLARE @delBatchCnt INT = 100	-- static batch count
	-- Lookup APP_CCSWorkQueueAudit Pruning Time Frame
	DECLARE @pruneDays INT = 1	-- default 1 day / 24 hours
	SELECT
		@pruneDays = CAST(value AS INTEGER)
	FROM GXGlobalParam WITH(NOLOCK)
	WHERE name = 'CCSWorkQueueAuditPruneDays'
	IF (@pruneDays < 1 OR @pruneDays > 14)
	BEGIN
		SET @pruneDays = 1
		PRINT 'AppCCSTriggerToWorkQueue: Warning invalid GXGlobalParam::CCSWorkQueueAuditPruneDays value.'
	END
	DECLARE @pruneDate DATETIME = DATEADD(day, -@pruneDays, GETUTCDATE())
	DECLARE	@pruneTime INT = DATEDIFF(second, '01/01/1970', @pruneDate)
	IF (@startTime = 0)
	BEGIN
		-- set to current time
		SET @startTime = dbo.GetUnixTime(GETUTCDATE()) - 2		-- move back 2 second so that transaction activity does not allow mid-second updates to slip thru filtering
	END
	-- test code - temporary stop processing of trigger rows
	IF EXISTS (SELECT 1 FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'CCSTriggerRowProccessingStop' AND value = '1')
	BEGIN
		GOTO END_OF_PROC
	END
	-- Is CCS Functionality enabled on the CommServer?
	DECLARE @ccsEnabled	INT = 0
	SELECT @ccsEnabled = CAST(value AS INT) FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'CommServCCSEnabled'
	-- Are the CCS Triggers enabled?  Check the APP_Client CCS Trigger for overall CCS Trigger Status
	DECLARE @SumTriggersDisabled	INT = 0
	DECLARE @CntTriggersDisabled	INT = 0
	SELECT
		@CntTriggersDisabled = COUNT(is_disabled),				-- total count of all CCS Triggers
		@SumTriggersDisabled = SUM(CAST(is_disabled AS INT))	-- is_disabled 0|1 sum all values should equal total count if all disabled properly
	FROM sys.triggers WITH(NOLOCK)
	WHERE name LIKE 'APP_CCS%TableChange'
	IF (@ccsEnabled = 1)
	BEGIN
		-- make sure all CCS triggers are enabled, sum should be 0 if all properly enabled
		IF (@SumTriggersDisabled > 0)
		BEGIN
			-- CCS Functionality on the CommServer appears to have been re-enable.
			-- Re-enable all the CCS Triggers since some are disabled
			-- Note Before enabling / disabling triggers CS Applications should be STOPPED.
			-- There are issues if done under transactions that lead to long blocked sessions or deadlocks.
			--EXEC AppCCSTriggerCtrl 1
			PRINT 'AppCCSTriggerToWorkQueue: Warning CS CCS Operations Enabled but some CCS Triggers disabled!'
		END
	END
	ELSE
	BEGIN
		IF (@CntTriggersDisabled <> @SumTriggersDisabled)		-- if not equal some CCS triggers are enabled
		BEGIN
			PRINT 'AppCCSTriggerToWorkQueue: Warning CS CCS Operations Disabled but some CCS Triggers enabled!'
		END
		-- CCS Functionality on the CommServer appears to have been disabled.
		-- Disable all the CCS Triggers since some are enabled
		-- Note Before enabling / disabling triggers CS Applications should be STOPPED.
		--EXEC AppCCSTriggerCtrl 0
		-- Should existing queued CCS WorkQueue rows (workToken=19) be deleted at this point???
		-- delete all current captured trigger rows
		DECLARE @maxTRId INT = NULL
		SELECT
			@maxTRId = MAX(id)
		FROM APP_CCSTriggerRows WITH(NOLOCK)
		WHERE  modified <= @startTime
		SET @delRowCnt = 1
		WHILE (@delRowCnt > 0 AND @maxTRId IS NOT NULL AND @maxTRId > 0)
		BEGIN
			-- Batch deleting to keep implicit transaction short
			DELETE TOP (@delBatchCnt)
			FROM APP_CCSTriggerRows
			WHERE id <= @maxTRId
				AND modified <= @startTime
			SET @delRowCnt = @@ROWCOUNT
		END
		GOTO END_OF_PROC
	END
	SELECT @rowCnt = COUNT(*) FROM APP_CCSTriggerRows WITH (NOLOCK) WHERE modified <= @startTime
	IF (@rowCnt = 0)
	BEGIN
		-- nothing to do!
		GOTO END_OF_PROC
	END
	-- Setup batch deletion
	SELECT
		@delBatchCnt = TRY_CAST(value AS INT)
	FROM GXGlobalParam WITH(NOLOCK)
	WHERE name = N'CCSTriggerBatchDeleteCount'
		AND TRY_CAST(value AS INT) >= 100
		AND TRY_CAST(value AS INT) <= 1000
	-- Table to hold clientIds for all active CCS Enabled Clients
	IF OBJECT_ID('tempdb.dbo.#CcsClients') IS NOT NULL
		 DROP TABLE #CcsClients
	CREATE TABLE #CcsClients (clientId INT PRIMARY KEY)
	INSERT #CcsClients (clientId)
		SELECT
			c.id
		FROM
			APP_Client c WITH (NOLOCK)
			INNER JOIN APP_ClientProp cp WITH (NOLOCK) ON
				cp.componentNameId = c.id
				AND (c.status & (2|4)) = 0		-- installed
				AND cp.modified = 0
				AND cp.attrName = N'CCS Enabled'
				AND cp.attrVal = N'1'
		--WHERE
		--	c.id NOT IN (SELECT clientId FROM APP_Platform WHERE platformType = 1)
	SELECT @rowCnt = COUNT(*) FROM #CcsClients
	IF (@rowCnt = 0)
	BEGIN
		-- No CCS Enabled clients, nothing to do!
		-- Delete all rows before start time since they are no longer valid for processing
		SET @delRowCnt = 1
		WHILE (@delRowCnt > 0)
		BEGIN
			-- Batch deleting to keep implicit transaction short
			DELETE TOP (@delBatchCnt) FROM APP_CCSTriggerRows WHERE modified <= @startTime
			SET @delRowCnt = @@ROWCOUNT
		END
		GOTO END_OF_PROC
	END
	-- Delete Non-CCS Clients from APP_CCSApplicationDelAudit Table. Note keep Commserver Rows as well for Assocaition SubClient Policies.
	SET @delRowCnt = 1
	WHILE (@delRowCnt > 0)
	BEGIN
		-- Batch deleting to keep implicit transaction short
		DELETE TOP (@delBatchCnt) aa
		FROM APP_CCSApplicationDelAudit aa
			LEFT OUTER JOIN #CcsClients c ON
				c.clientId = aa.clientId
				AND aa.deleted <= @startTime
		WHERE
			c.clientId IS NULL
			AND NOT (
				aa.clientId = 2		-- CS Id
				AND aa.appTypeId = 1030
			)
		SET @delRowCnt = @@ROWCOUNT
	END
	-- Only keep 24 hours of CCS to Work Queue Auditing
	SET @delRowCnt = 1
	WHILE (@delRowCnt > 0)
	BEGIN
		-- Batch deleting to keep implicit transaction short
		DELETE TOP (@delBatchCnt)
		FROM APP_CCSWorkQueueAudit
		WHERE createTime < @pruneTime
		SET @delRowCnt = @@ROWCOUNT
	END
	-- Generate Include and Exclude filter clauses
	IF OBJECT_ID('tempdb.dbo.#CcsFilters') IS NOT NULL
		 DROP TABLE #CcsFilters
	CREATE TABLE #CcsFilters (
		tableType	INT,
		opType		INT,
		filters		NVARCHAR(MAX),
		 PRIMARY KEY(tableType, opType)
	)
	INSERT INTO #CcsFilters (tableType, opType, filters)
		SELECT
			m.id,
			1,		-- EXCLUDE / INCLUDE
			-- Note for deleting rows EXCLUDE(IN) and INCLUDE(NOT IN) - it is the opposite behavior for deleting vs selecting rows
			N' AND ccstbl.'
			+ c.value('@name', 'NVARCHAR(128)')
			+ CASE c.value('@opType', 'NVARCHAR(16)')
				WHEN N'INCLUDE' THEN N' NOT IN ( '
				ELSE N' IN ( '
			END
			+ (
				CASE ISNULL(c.value('@SQLCMD', 'INT'), 0)
					WHEN 0 THEN (
						CASE c.value('@dataType', 'VARCHAR(16)')
							WHEN 'NSTRING' THEN (
								SELECT
									(CASE WHEN q.rn > 1 THEN N', ' ELSE N'' END)
									+ N'N'''
									+ q.val
									+ N''''
								FROM (
										SELECT
											v.value('@value', 'NVARCHAR(1024)') val,
											ROW_NUMBER() OVER (ORDER BY v.value('@value', 'NVARCHAR(1024)')) rn
										FROM m.filters.nodes('/Filters/Column/Filter') f(v)
										WHERE
											v.value('../@opType', 'NVARCHAR(16)') IN ('INCLUDE', 'EXCLUDE')
									) q
								FOR XML PATH('')
							)
							WHEN 'STRING' THEN (
								SELECT
									(CASE WHEN q.rn > 1 THEN N', ' ELSE N'' END)
									+ N''''
									+ q.val
									+ N''''
								FROM (
										SELECT
											v.value('@value', 'NVARCHAR(1024)') val,
											ROW_NUMBER() OVER (ORDER BY v.value('@value', 'NVARCHAR(1024)')) rn
										FROM m.filters.nodes('/Filters/Column/Filter') f(v)
										WHERE
											v.value('../@opType', 'NVARCHAR(16)') IN ('INCLUDE', 'EXCLUDE')
									) q
								FOR XML PATH('')
							)
							ELSE (
								SELECT
									(CASE WHEN q.rn > 1 THEN N', ' ELSE N'' END)
									+ q.val
								FROM (
										SELECT
											v.value('@value', 'NVARCHAR(1024)') val,
											ROW_NUMBER() OVER (ORDER BY v.value('@value', 'NVARCHAR(1024)')) rn
										FROM m.filters.nodes('/Filters/Column/Filter') f(v)
										WHERE
											v.value('../@opType', 'NVARCHAR(16)') IN ('INCLUDE', 'EXCLUDE')
									) q
								FOR XML PATH('')
							)
						END
					)
					ELSE (
						SELECT
							(CASE WHEN q.rn > 1 THEN N' UNION ' ELSE N'' END)
							+ q.val
						FROM (
								SELECT
									v.value('@value', 'NVARCHAR(1024)') val,
									ROW_NUMBER() OVER (ORDER BY v.value('@value', 'NVARCHAR(1024)')) rn
								FROM m.filters.nodes('/Filters/Column/Filter') f(v)
								WHERE
									v.value('../@opType', 'NVARCHAR(16)') IN ('INCLUDE', 'EXCLUDE')
							) q
						FOR XML PATH('')
					)
				END
			)
			+ N' ) '
		FROM APP_CCSXMLMapping m WITH(NOLOCK)
			CROSS APPLY m.filters.nodes('/Filters/Column') n(c)
		WHERE
			m.filters.exist('/Filters') = 1
			AND  c.value('@opType', 'NVARCHAR(16)') IN ('INCLUDE', 'EXCLUDE')
		UNION ALL
		SELECT
			lm.id,
			2,	-- LIKE / NOT LIKE
			-- Note for deleting rows NOT LIKE(LIKE) and LIKE(NOT LIKE) - it is the opposite behavior for deleting vs selecting rows
			(
				' AND ( '
				+ (
					SELECT
						(CASE WHEN q.rn > 1 THEN (CASE q.opType WHEN 'NOT LIKE' THEN ' OR ' ELSE N' AND ' END) ELSE N'' END)
						+ q.cmd + ' '
					FROM (
							SELECT
								N' ccstbl.'
								+ c.value('../@name', 'NVARCHAR(128)')
								+ N' '
								+ CASE c.value('../@opType', 'NVARCHAR(16)')
									WHEN 'LIKE' THEN 'NOT LIKE'
									ELSE 'LIKE'
								END
								+ N' '
								+ N''''
								+ c.value('@value', 'NVARCHAR(1024)')
								+ N''' ' cmd,
								ROW_NUMBER() OVER (ORDER BY c.value('@value', 'NVARCHAR(1024)')) rn,
								c.value('../@opType', 'NVARCHAR(16)') opType
							FROM APP_CCSXMLMapping m WITH(NOLOCK)
								CROSS APPLY m.filters.nodes('/Filters/Column/Filter') n(c)
							WHERE
								m.id = lm.id
								AND m.filters.exist('/Filters') = 1
								AND c.value('../@opType', 'NVARCHAR(16)') IN ('LIKE', 'NOT LIKE')
						) q
					FOR XML PATH('')
				)
				+ ' ) '
			)
		FROM APP_CCSXMLMapping lm WITH(NOLOCK)
			CROSS APPLY lm.filters.nodes('/Filters/Column') n(c)
		WHERE
			lm.filters.exist('/Filters') = 1
			AND c.value('@opType', 'NVARCHAR(16)') IN ('LIKE', 'NOT LIKE')
	-- Delete Black Listed Items from the trigger table.
	DECLARE @nl NVARCHAR(4) = NCHAR(13) + NCHAR(10)
	DECLARE @addUnion TINYINT = 0
	DECLARE @rowsToDelete NVARCHAR(MAX) = N'INSERT INTO #deleteRows (id)' + @nl
	-- Primary Key Id
	SELECT
		@rowsToDelete += (CASE @addUnion WHEN 1 THEN (N'UNION ALL' + @nl) ELSE N'' END) +
					N'SELECT tr.id ' + @nl +
					N'FROM APP_CCSTriggerRows tr WITH(NOLOCK) ' +  @nl +
					N'	INNER JOIN ' + m.tableName + N' ccstbl WITH(NOLOCK) ON ' + @nl +
					N'		tr.tableType = ' + CAST(m.id AS NVARCHAR(12)) + @nl +
					N'		AND tr.rowId1 = ccstbl.' + m.primaryId + @nl +
					N'WHERE 1 = 1 ' + @nl +
					f.filters +  @nl,
		@addUnion = 1
	FROM #CcsFilters f
		INNER JOIN APP_CCSXMLMapping m WITH(NOLOCK) ON
			m.primaryId <> N''
			AND f.tableType = m.id
	-- Composite Primary Keys
	SELECT
		@rowsToDelete += (CASE @addUnion WHEN 1 THEN (N'UNION ALL' + @nl) ELSE N'' END) +
					N'SELECT tr.id deleteId ' + @nl +
					N'FROM APP_CCSTriggerRows tr WITH(NOLOCK) ' +  @nl +
					N'	INNER JOIN ' + m.tableName + N' ccstbl WITH(NOLOCK) ON ' + @nl +
					N'		tr.tableType = ' + CAST(m.id AS NVARCHAR(12)) + @nl +
					N'		AND tr.rowId1 = ccstbl.' + m.cpkId1Name + @nl +
					N'		AND tr.rowId2 = ccstbl.' + m.cpkId2Name + @nl +
					N'WHERE 1 = 1 ' + @nl +
					f.filters +  @nl,
		@addUnion = 1
	FROM #CcsFilters f
		INNER JOIN APP_CCSXMLMapping m WITH(NOLOCK) ON
			m.primaryId = N''
			AND m.cpkId1Name <> N''
			AND m.cpkId2Name <> N''
			AND f.tableType = m.id
	--===========================================================================================
	-- NOTE NOTE NOTE NOTE NOTE
	-- XML Composite Primary Keys - are hardcoded implementations!
	--===========================================================================================
	-- Convert APP_CCSTriggerRows::rowXmlKeys from NVARCHAR to XML data type
	IF OBJECT_ID('tempdb.dbo.#XmlTriggerRows') IS NOT NULL
		DROP TABLE #XmlTriggerRows
	CREATE TABLE #XmlTriggerRows (
		trId		INT,
		tableType	INT,
		xmlPKs		XML
	)
	INSERT INTO #XmlTriggerRows (trId, tableType, xmlPKs)
		SELECT
			r.id,
			r.tableType,
			CAST(r.rowXmlKeys AS XML)
		FROM APP_CCSTriggerRows r WITH(NOLOCK)
			INNER JOIN APP_CCSXMLMapping m WITH(NOLOCK) ON
				m.id = r.tableType
				AND CAST(m.filters AS NVARCHAR(MAX)) <> N''		-- only join for tables that have filtering defined.C
		WHERE
			r.rowXmlKeys <> N''
			AND r.modified <= @startTime		-- performance change for high CPU Usage for better index selection
	SET @rowCnt = @@ROWCOUNT
	IF (@rowCnt > 0)
	BEGIN
		-- Hardcode scripting - could not implement a script generator for rowXmlKeys
		IF EXISTS (SELECT 1 FROM #XmlTriggerRows r WHERE r.tableType = 24)
		BEGIN
			SELECT
				@rowsToDelete += (CASE @addUnion WHEN 1 THEN (N'UNION ALL' + @nl) ELSE N'' END) + N'
						SELECT
							tr.id deleteId
						FROM APP_CCSTriggerRows tr WITH(NOLOCK)
							INNER JOIN #XmlTriggerRows r ON
								r.trId = tr.id
							CROSS APPLY r.xmlPKs.nodes(''/Keys/tableKeys[@columnName = "typeOfGroup"]'') typeOfGroup(attr)
							CROSS APPLY r.xmlPKs.nodes(''/Keys/tableKeys[@columnName = "appGroupId"]'') appGroupId(attr)
							CROSS APPLY r.xmlPKs.nodes(''/Keys/tableKeys[@columnName = "appTypeId"]'') appTypeId(attr)
							INNER JOIN APP_AppTypeGroupAssoc ccstbl WITH(NOLOCK) ON
								ccstbl.typeOfGroup = typeOfGroup.attr.value(''@columnValue'', ''INT'')
								AND ccstbl.appGroupId = appGroupId.attr.value(''@columnValue'', ''INT'')
								AND ccstbl.appTypeId = appTypeId.attr.value(''@columnValue'', ''INT'')
						WHERE 1 = 1
						' + (SELECT f.filters FROM #CcsFilters f WHERE f.tableType = 24) + @nl,
				@addUnion = 1
		END
		ELSE
		BEGIN
			-- XML Key Filter that needs to be implemented
			PRINT 'AppCCSTriggerToWorkQueue: WARNING: Missing CCS XML Row Filter Implementation!'
		END
	END
	--PRINT @rowsToDelete
	-- Setup temp table and execute generated SQL statement
	-- Get APP_CCSTriggerRows IDs that meet Black List Filtering and than delete them
	IF OBJECT_ID('tempdb.dbo.#deleteRows') IS NOT NULL
		DROP TABLE #deleteRows
	CREATE TABLE #deleteRows (
		id		INT
	)
	EXEC(@rowsToDelete)
	SET @delRowCnt = 1
	WHILE (@delRowCnt > 0)
	BEGIN
		-- Batch deleting to keep implicit transaction short
		DELETE TOP (@delBatchCnt) tr
		FROM APP_CCSTriggerRows tr
			INNER JOIN #deleteRows dr ON
				dr.id = tr.id
		SET @delRowCnt = @@ROWCOUNT
	END
	-- Map all -1 client rows before starttime into actual client trigger rows and delete -1 rows
	INSERT INTO APP_CCSTriggerRows(clientId, tableType, opCode, modified, rowId1, rowId2, rowXmlKeys)
		SELECT
			c.clientId, n.tableType, n.opCode, n.modified, n.rowId1, n.rowId2, n.rowXmlKeys
		FROM
			APP_CCSTriggerRows AS n
			LEFT OUTER JOIN #CcsClients AS c ON
				n.clientId = @AllClients
				AND n.modified <= @startTime
		WHERE c.clientId IS NOT NULL
	SET @delRowCnt = 1
	WHILE (@delRowCnt > 0)
	BEGIN
		-- Batch deleting to keep implicit transaction short
		DELETE TOP (@delBatchCnt) FROM	APP_CCSTriggerRows WHERE clientId = @AllClients AND modified <= @startTime
		SET @delRowCnt = @@ROWCOUNT
	END
	-- Process CommServ "Associated Subclient Policies" row changes that need to be mapped for delivery to all CCS Enabled Clients
	DECLARE @ascpRC INT = 0
	EXEC  @ascpRC = AppCCSAssociatedSubClientPolicyRows @startTime, 0
	-- EdgeDrive no longer supported by CCSDb
	-- Delete client rows that do not have CCS enabled
	DELETE dtr
	FROM APP_CCSTriggerRows AS dtr,
		(SELECT
			tr.id	-- find all client rows that do not have CCS enabled
		FROM APP_CCSTriggerRows AS tr
			LEFT OUTER JOIN #CcsClients AS c
				ON tr.clientId = c.clientId
				AND tr.modified <= @startTime
		WHERE
			tr.clientId IS NOT NULL
			AND c.clientId IS NULL) AS str
	WHERE
		dtr.id = str.id
	--  Delete CCS Enabled Clients for clients that currently DO NOT have network connectivity to the CS
	DELETE FROM #CcsClients
	WHERE clientId IN
		(SELECT clientId FROM #CcsClients
		EXCEPT
		(SELECT
			c.clientId AS clientId
		FROM #CcsClients AS c
			INNER JOIN CCRClientToClient AS ctc WITH (NOLOCK) ON
				ctc.FromClientId = 2
				AND ctc.ToClientId = c.clientId
				AND ctc.lastOnlineTime > ctc.lastOfflineTime))
	-- Delete CCS Enabled Clients for clients that are currently having WorkQueue retry issues
	DELETE FROM #CcsClients
	WHERE clientId IN
		(SELECT
			wq.clientId
		FROM
			APP_WorkQueueRequest wq WITH(NOLOCK)
		WHERE
			wq.workToken = @WorkToken
			AND wq.retryCount > 0
		GROUP BY
			wq.clientId
		HAVING
			COUNT(wq.clientId) > 6)		-- total rows for client in WQ Table in retry mode
	--#### START: CCS MD5 Hash Check #################################################################################################################
	-- For each CCS Table Type in the Trigger table for clientId verify that the table data is changing (MD5 Hashes do not match) if match delete
	-- these trigger rows since the client's CCSDb does not need to be updated.
	IF OBJECT_ID('tempdb.dbo.#MD5HashTables') IS NOT NULL
		 DROP TABLE #MD5HashTables
	CREATE TABLE #MD5HashTables (
		clientId		INT,
		tableType		INT,
		PRIMARY KEY (clientId, tableType)
	)
	INSERT INTO #MD5HashTables (clientId, tableType)
		SELECT DISTINCT
			cr.clientId,
			cr.tableType
		FROM APP_CCSTriggerRows cr WITH (NOLOCK)
			INNER JOIN #CcsClients c ON
				cr.clientId = c.clientId
				AND cr.modified <= @startTime
	DECLARE @htCnt INT = @@ROWCOUNT
	IF (@htCnt > 0)
	BEGIN
		IF (@timers > 0)
		BEGIN
			SET @edt = SYSDATETIME()
			PRINT 'AppCCSTriggerToWorkQueue Cursor Start Tables[' + CAST(@htCnt AS VARCHAR(12)) + ']: ' + CAST(@edt AS VARCHAR(128)) + '  TimeMS: ' + CAST(DATEDIFF(ms, @sdt, @edt) AS VARCHAR(24))
		END
		DECLARE @htClientId		INT
		DECLARE @htTableType	INT
		DECLARE @htIsMatch		INT = 0
		DECLARE md5HTCursor CURSOR LOCAL FORWARD_ONLY READ_ONLY FOR
			SELECT DISTINCT
				t.clientId,
				t.tableType
			FROM #MD5HashTables t
		OPEN md5HTCursor
		FETCH NEXT FROM md5HTCursor
			INTO @htClientId, @htTableType
		WHILE @@FETCH_STATUS = 0
		BEGIN
			EXEC APPCCSMd5TableHashCompare @htClientId, @htTableType, @htIsMatch OUTPUT, @logLevel
			IF (@htIsMatch > 0)
			BEGIN
				-- No need to send this data to the CCS Laptop Client since it matches CCSDb MD5 Hash
				DELETE dtr
				FROM APP_CCSTriggerRows AS dtr
				WHERE
					dtr.clientId = @htClientId
					AND dtr.tableType = @htTableType
					AND dtr.modified <= @startTime			-- performance for index selection
				SET @htIsMatch = 0		-- reset
				-- Debug testing messages - remove for delivery
				PRINT 'AppCCSTriggerToWorkQueue Table MD5 Hash Match Deletion NODATACHANGE: ClientId[' + CAST(@htClientId AS VARCHAR(128)) + ']  TableType[' + CAST(@htTableType AS VARCHAR(12)) + ']'
			END
			FETCH NEXT FROM md5HTCursor
				INTO @htClientId, @htTableType
		END
		CLOSE md5HTCursor
		DEALLOCATE md5HTCursor
		IF (@timers > 0)
		BEGIN
			SET @edt = SYSDATETIME()
			PRINT 'AppCCSTriggerToWorkQueue Cursor End: ' + CAST(@edt AS VARCHAR(128)) + '  TimeMS: ' + CAST(DATEDIFF(ms, @sdt, @edt) AS VARCHAR(24))
		END
	END
	--#### END: CCS MD5 Hash Check ###################################################################################################################
	-- Consolidate CCS Table Row Updates to only what is needed to update the clients
	IF OBJECT_ID('tempdb.dbo.#TableUpdates') IS NOT NULL
		 DROP TABLE #TableUpdates
	CREATE TABLE #TableUpdates (
		clientId		INT,
		tableType		INT,
		rowNumber		INT,
		opCode			INT,
		modified		INT,
		rowId1			INT,
		rowId2			INT,
		rowXmlKeys		XML
	)
	CREATE UNIQUE INDEX TableUpdates_idx1 on #TableUpdates (clientId, tableType, rowNumber)
	INSERT INTO #TableUpdates(clientId, tableType, rowNumber, opCode, modified, rowId1, rowId2, rowXmlKeys)
		SELECT
			cr.clientId,
			cr.tableType,
			ROW_NUMBER() OVER (PARTITION BY cr.clientId, cr.tableType ORDER BY cr.opCode ASC, cr.modified ASC) AS rowNumber,
			cr.opCode,
			cr.modified,
			cr.rowId1,
			cr.rowId2,
			cr.rowXmlkeys
		FROM
			-- only need the latest inserted(0), updated(1), deleted(2) row to send all row data to the client, eliminate all other rows
			(SELECT
				r.clientId,
				r.tableType,
				r.opCode,
				r.modified,
				r.rowId1,
				r.rowId2,
				r.rowXmlKeys
			FROM
				(SELECT
					RANK() OVER (PARTITION BY d.clientId, d.tableType, d.rowId1, d.RowId2, d.rowXmlKeys ORDER BY d.opCode DESC, d.modified DESC) AS rk,
					d.clientId,
					d.tableType,
					d.opCode,
					d.modified,
					d.rowId1,
					d.rowId2,
					d.rowXmlKeys
				FROM
					(SELECT DISTINCT		-- eliminate duplicate rows with same modified timestamp
						cr.clientId,
						cr.tableType,
						cr.opCode,
						cr.modified,
						cr.rowId1,
						cr.rowId2,
						cr.rowXmlKeys
					FROM
						APP_CCSTriggerRows cr WITH (NOLOCK)
						INNER JOIN #CcsClients c ON
							cr.clientId = c.clientId
							AND cr.opCode IN (0,1,2)
							AND cr.modified <= @startTime) AS d) AS r
			WHERE
				r.rk = 1	-- take the top ranked row only
			) AS cr
	SELECT @rowCnt = COUNT(*) FROM #TableUpdates
	IF (@rowCnt = 0)
	BEGIN
		-- rows no longer valid for processing
		-- Delete all rows before start time and for processed clients
		SET @delRowCnt = 1
		WHILE (@delRowCnt > 0)
		BEGIN
			-- Batch deleting to keep implicit transaction short
			DELETE TOP (@delBatchCnt) FROM APP_CCSTriggerRows
			WHERE
				clientId IN (SELECT clientId FROM #CcsClients)
				AND modified <= @startTime
			SET @delRowCnt = @@ROWCOUNT
		END
		GOTO END_OF_PROC
	END
	-- Below query inccuring a high number of deadlocks when it was a sub-query table below so to help avoid
	-- deadlocks moved it upward to create it own Temp Table to be executed quicker.
	IF OBJECT_ID('tempdb.dbo.#WQItems') IS NOT NULL
		 DROP TABLE #WQItems
	CREATE TABLE #WQItems (
		clientId	INT,
		token		XML,
		flag		INT
	)
	-- #WQItems leaving a HEAP Table for now
	INSERT INTO #WQItems (clientId, token, flag)
		SELECT
			wq.clientId,
			CAST(wq.workTokenParams AS XML) token,
			wq.flag
		FROM
			APP_WorkQueueRequest wq	-- need good data so NOLOCK not used
			INNER JOIN #CcsClients c ON
				wq.clientId = c.clientId
				AND wq.workToken = @WorkToken
	-- Remove duplicate entries that are already in the Work Queue Pipeline
	IF OBJECT_ID('tempdb.dbo.#WorkRows') IS NOT NULL
		 DROP TABLE #WorkRows
	CREATE TABLE #WorkRows (
		clientId		INT,
		--retryCount		INT,
		flag			INT,
		--sequenceNumber	INT,
		tableType		INT,
		tableOpCode		INT,
		tableRowID		INT,
		tableKeys		VARCHAR(MAX)
	)
	CREATE INDEX WorkRows_idx1 on #WorkRows (clientId, tableType, tableOpCode)
	-- Retreive all 19 type workTokens and parse workTokenParams into usable data fields
	INSERT INTO #WorkRows (clientId, flag, tableType, tableOpCode, tableRowID, tableKeys) --(clientId, retryCount, flag, sequenceNumber, tableType, tableOpCode, tableRowID, tableKeys)
		SELECT
			d.clientId,
			--d.retryCount,
			d.flag,
			--attr.value('(./@sequenceNumber)[1]', 'INT') AS sequenceNumber,
			attr.value('(./@tableType)[1]', 'INT') AS tableType,
			attr.value('(./@tableOpCode)[1]', 'INT') AS tableOpCode,
			attr.value('(./@tableRowID)[1]', 'INT') AS tableRowID,
			CASE
				WHEN token.exist('/TMMsg_CCSTableRowUpdates/TMMsg_ClientConfigTableChangeInfo/tableKeys') = 1
					THEN (SELECT attr.query('./tableKeys') FOR XML PATH('Keys'))
				ELSE ''
			END  AS tableKeys
		FROM #WQItems AS d		-- remove subquery to try and avoid deadlock here while parsing XML for data
			CROSS APPLY d.token.nodes('/TMMsg_CCSTableRowUpdates/TMMsg_ClientConfigTableChangeInfo') t(attr)
	-- now delete new entries that are already in the Work Queue pipe that are not already started
	DELETE tu
	FROM #TableUpdates tu, #WorkRows wr, APP_CCSXMLMapping xm WITH (NOLOCK)
	WHERE
		tu.clientId = wr.clientId
		AND tu.tableType = wr.tableType
		AND xm.id = wr.tableType
		AND wr.flag = 0				-- not being processed
		--AND wr.retryCount = 0		-- may want to change to <= 6
		AND tu.opCode IN (0,1)		-- only delete where opCode is an insert or update operation, let delete operations go thru
		AND (	-- delete if there there is a matching entry between the 2 tables
				(tu.rowId1 IS NOT NULL AND tu.rowId1 = wr.tableRowID)	-- by primary key
				OR
				(tu.rowXmlKeys IS NOT NULL AND CAST(tu.rowXmlKeys AS VARCHAR(MAX)) <> '' AND CAST(tu.rowXmlKeys AS VARCHAR(MAX)) = wr.tableKeys)	-- by multiple keys
				OR
				(tu.rowId1 <> 0 AND tu.rowId2 <> 0 AND wr.tableKeys =		-- by 2 primary keys
							CAST((SELECT
-- NOTE: Must add tableType checks and column names here
--								CASE
--									WHEN tu.tableType = 3 THEN 'clientId'		-- APP_Platform Table key
--									WHEN tu.tableType = 23 THEN 'typeOfGroup'	-- APP_AppTypeGroup Table key
--									WHEN tu.tableType = 26 THEN 'clientGroupId'		-- APP_ClientGroupAssoc Table key
--									ELSE 'AppCCSTriggerWorkQueueSP_UnknownCPKRowId1Name'
--								END AS 'tableKeys/@columnName',
								CASE
									WHEN xm.cpkId1Name <> '' THEN xm.cpkId1Name
									ELSE 'AppCCSTriggerWorkQueueSP_EmptyCPKRowId1Name'		-- error
								END AS 'tableKeys/@columnName',
								1 AS 'tableKeys/@columnType',
								tu.rowId1 AS 'tableKeys/@columnValue',
								NULL,
--								CASE
--									WHEN tu.tableType = 3 THEN 'platformType'		-- APP_Platform Table key
--									WHEN tu.tableType = 23 THEN 'appTypeGroupId'	-- APP_AppTypeGroup Table key
--									WHEN tu.tableType = 26 THEN 'clientId'			-- APP_ClientGroupAssoc Table key
--									ELSE 'AppCCSTriggerWorkQueueSP_UnknownCPKRowId2Name'
--								END AS 'tableKeys/@columnName',
								CASE
									WHEN xm.cpkId2Name <> '' THEN xm.cpkId2Name
									ELSE 'AppCCSTriggerWorkQueueSP_EmptyCPKRowId2Name'		-- error
								END AS 'tableKeys/@columnName',
								1 AS 'tableKeys/@columnType',
								tu.rowId2 AS 'tableKeys/@columnValue',
								NULL
							FOR XML PATH('Keys')) AS VARCHAR(MAX))
				)
			)
	-- Create Work Queue Client Config Store Update work token strings
	IF OBJECT_ID('tempdb.dbo.#WorkTokens') IS NOT NULL
		 DROP TABLE #WorkTokens
	CREATE TABLE #WorkTokens (
		clientId		INT,
		tableType		INT,
		ordering		INT,
		token			XML
	)
	CREATE INDEX WorkTokens_idx1 on #WorkTokens (clientId, ordering, tableType) INCLUDE (token)
	-- Insert actual client rows
	-- But first we are going to consolidate all delete, insert and update rows for a given client into only one XML document and
	-- order it accordingly to how rows should be inserted for FK constraints relationships to be maintained, should NOT have
	-- to lookup any FK row not present in the CCSDb remotely.
	INSERT INTO #WorkTokens (clientId, tableType, ordering, token)
		-- Insert and Update opCodes
		SELECT
			mcr.clientId,
			0 tableType,
			0 ordering,
			(SELECT
				(SELECT
					ROW_NUMBER() OVER (ORDER BY xm.ordering ASC) AS '@sequenceNumber',
--					xm.ordering AS '@ordering',
					cr.tableType AS '@tableType',
					cr.opCode AS '@tableOpCode',
					CASE
						WHEN cr.rowId1 <> 0 AND cr.rowId2 = 0 THEN cr.rowId1
					END AS '@tableRowID',
					CASE
						WHEN cr.rowId1 <> 0 AND cr.rowId2 = 0 THEN NULL	-- using @tableRowID above
						WHEN cr.rowXmlKeys.exist('/Keys') = 0 THEN		-- "cr.rowId1 <> 0 AND cr.rowId2 <> 0" have to handle id1 and id2 can each be 0, so assume they are valid "if r.rowXmlKeys.exist('/Keys') = 0" is true
							(SELECT
								CASE
									WHEN xm.cpkId1Name <> '' THEN xm.cpkId1Name
									ELSE 'AppCCSTriggerWorkQueueSP_EmptyCPKRowId1Name_2'		-- error
								END AS 'tableKeys/@columnName',
								1 AS 'tableKeys/@columnType',
								cr.rowId1 AS 'tableKeys/@columnValue',
								NULL,
								CASE
									WHEN xm.cpkId2Name <> '' THEN xm.cpkId2Name
									ELSE 'AppCCSTriggerWorkQueueSP_EmptyCPKRowId2Name_2'		-- error
								END AS 'tableKeys/@columnName',
								1 AS 'tableKeys/@columnType',
								cr.rowId2 AS 'tableKeys/@columnValue',
								NULL
							FOR XML PATH(''), TYPE)
						WHEN cr.rowXmlKeys.exist('/Keys') = 1 THEN
							(SELECT
								cr.rowXmlKeys.query('/Keys/tableKeys')		-- only extract tableKeys nodes
							FOR XML PATH(''), TYPE)
					END
				FROM #TableUpdates cr
					INNER JOIN APP_CCSXMLMapping xm WITH (NOLOCK) ON
						--cr.opCode IN (0,1)
						cr.clientId = mcr.clientId
						AND xm.id = cr.tableType
				FOR XML PATH('TMMsg_ClientConfigTableChangeInfo'), TYPE)
			FOR XML PATH('TMMsg_CCSTableRowUpdates'), TYPE)
		FROM (
				SELECT DISTINCT
					tr.clientId
				FROM
					APP_CCSTriggerRows tr WITH (NOLOCK)
					INNER JOIN #CcsClients c ON
						tr.clientId = c.clientId
						AND tr.modified <= @startTime
						--AND tr.opCode IN (0,1)
			) AS mcr
	-- Determine clients that should not have any CCS WQ Rows
	IF OBJECT_ID('tempdb.dbo.#DeleteWQNotCCS') IS NOT NULL
		 DROP TABLE #DeleteWQNotCCS
	CREATE TABLE #DeleteWQNotCCS (
		clientId	INT PRIMARY KEY
	)
	INSERT INTO #DeleteWQNotCCS (clientId)
		SELECT	-- get clients with CCS disabled
			c.id clientId
		FROM APP_Client c WITH(NOLOCK)
			INNER JOIN APP_WorkQueueRequest wq WITH(NOLOCK) ON
				wq.clientId = c.id
				AND wq.workToken = @WorkToken		-- CCS Token
			INNER JOIN APP_ClientProp cp  WITH(NOLOCK) ON
				cp.componentNameId = c.id
				AND cp.attrName = 'CCS Enabled'
				AND cp.attrVal = '0'
				AND cp.modified = 0
		UNION
		SELECT	-- get clients with CCS enabled and uninstalled
			c.id clientId
		FROM APP_Client c WITH(NOLOCK)
			INNER JOIN APP_WorkQueueRequest wq WITH(NOLOCK) ON
				wq.clientId = c.id
				AND wq.workToken = @WorkToken		-- CCS Token
			INNER JOIN APP_ClientProp cp  WITH(NOLOCK) ON
				cp.componentNameId = c.id
				AND cp.attrName = 'CCS Enabled'
				AND cp.attrVal = '1'
				AND cp.modified = 0
				AND (c.status & 2) = 2		-- uninstalled
		UNION
		SELECT	-- get clients with CCS not set
			c.id clientId
		FROM
			APP_Client c WITH(NOLOCK)
			INNER JOIN APP_WorkQueueRequest wq WITH(NOLOCK) ON
				wq.clientId = c.id
				AND wq.workToken = @WorkToken		-- CCS Token
			LEFT OUTER JOIN APP_ClientProp cp  WITH(NOLOCK) ON
				cp.componentNameId = c.id
				AND cp.attrName = 'CCS Enabled'
				AND cp.modified = 0
		WHERE
			cp.id IS NULL		-- no row found
	DECLARE @deleteWQNotCCSCnt INT = @@ROWCOUNT
	--=========================================================================
	-- From here on actual database updates take place to APP_WorkQueueRequest
	--=========================================================================
	DECLARE @opSuccessful	TINYINT = 0
	DECLARE @tranCnt		INT = @@TRANCOUNT
	IF (@tranCnt > 0)
	BEGIN
		PRINT 'AppCCSTriggerToWorkQueue: Warning transaction started outside of SP, TransactionCount[' + CAST(@tranCnt AS VARCHAR(120)) + ']!'
	END
	BEGIN TRY
		BEGIN TRANSACTION Update_WorkQueueRequest
		-- Delete CCS WorkQueueRequest that are not enabled for CCS Operations any longer
		IF (@deleteWQNotCCSCnt > 0)
		BEGIN
			DELETE wq
			FROM APP_WorkQueueRequest wq		-- delete CCS workqueue rows for any of these clients that should not have CCS rows
				INNER JOIN #DeleteWQNotCCS c ON
					c.clientId = wq.clientId
					AND wq.workToken = @WorkToken		-- CCS Token
		END
		-- Insert APP_WorkQueueRequest rows
		INSERT INTO APP_WorkQueueRequest (clientId, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag, remoteClient)
			OUTPUT INSERTED.workQueueId, INSERTED.clientId, INSERTED.workTokenParams, INSERTED.createTime
				-- Audit Trail for CCSDb
				INTO APP_CCSWorkQueueAudit (workQueueId, clientId, ccsParams, createTime)
			SELECT
				wt.clientId,
				@WorkToken,
				CAST(wt.token AS NVARCHAR(MAX)),
				@startTime, 0, 0, 0, -1
			FROM
				APP_Client c WITH(NOLOCK)
				INNER JOIN #WorkTokens wt ON
					c.id = wt.clientId					-- make sure client still exist and was not deleted
					AND (c.status & 2) <> 2				-- has not been uninstalled
					AND CAST(wt.token AS NVARCHAR(MAX)) <> '<TMMsg_CCSTableRowUpdates/>'
				LEFT OUTER JOIN APP_WorkQueueRequest wqr ON
					wt.clientId = wqr.clientId
					AND wqr.workToken = @WorkToken
					AND wqr.flag = 0            -- work item has not started
					AND CAST(wt.token AS NVARCHAR(MAX)) = wqr.workTokenParams
			WHERE
				wqr.workQueueId IS NULL     -- only insert rows that do not already exist or failed all attempts
			ORDER BY
				wt.ordering ASC	-- influence workqueue to process table updates in order of data dependencies
		COMMIT TRANSACTION Update_WorkQueueRequest
		SET  @opSuccessful = 1
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @o_errorCode = 1
		SET @o_errorCodeStr = 'APP_WorkQueueRequest CCS Trigger Row update failed'
		ROLLBACK TRANSACTION Update_WorkQueueRequest
	END CATCH
	IF (@opSuccessful >= 1)
	BEGIN
		-- Moved from TRY CATCH Block and do if only a successful operation
		SET @delRowCnt = 1
		WHILE (@delRowCnt > 0)
		BEGIN
			-- Batch deleting to keep implicit transaction short
			-- Delete all rows before start time and for processed clients	- moved outside of transaction
			DELETE TOP (@delBatchCnt) FROM	APP_CCSTriggerRows
			WHERE
				clientId IN (SELECT clientId FROM #CcsClients)
				AND modified <= @startTime
			SET @delRowCnt = @@ROWCOUNT
		END
	END
END_OF_PROC:
	IF OBJECT_ID('tempdb.dbo.#WorkRows') IS NOT NULL
		 DROP TABLE #WorkRows
	IF OBJECT_ID('tempdb.dbo.#WorkTokens') IS NOT NULL
		 DROP TABLE #WorkTokens
	IF OBJECT_ID('tempdb.dbo.#TableUpdates') IS NOT NULL
		 DROP TABLE #TableUpdates
	IF OBJECT_ID('tempdb.dbo.#CcsClients') IS NOT NULL
		 DROP TABLE #CcsClients
	IF OBJECT_ID('tempdb.dbo.#MD5HashTables') IS NOT NULL
		 DROP TABLE #MD5HashTables
	IF OBJECT_ID('tempdb.dbo.#DeleteWQNotCCS') IS NOT NULL
		 DROP TABLE #DeleteWQNotCCS
	IF (@timers > 0)
	BEGIN
		SET @edt = SYSDATETIME()
		PRINT 'AppCCSTriggerToWorkQueue End: ' + CAST(@edt AS VARCHAR(128)) + '  TimeMS: ' + CAST(DATEDIFF(ms, @sdt, @edt) AS VARCHAR(24))
	END
	SELECT @o_errorCode, @o_errorCodeStr
GO

IF EXISTS (select * from GxQscripts where name = 'AppCCSTriggerToWorkQueue')
	delete from GxQscripts where name = 'AppCCSTriggerToWorkQueue'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCCSTriggerToWorkQueue')
	delete from GXDBVersions where aliasname = 'AppCCSTriggerToWorkQueue'
GO

insert into GXDBVersions values(2, 'AppCCSTriggerToWorkQueue',  '00010013000200200000', 'AppCCSTriggerToWorkQueue', '00010013000200200000')
GO

