

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCCSTriggerOfflineClientRowConsolidation.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCCSTriggerOfflineClientRowConsolidation.sp,v $ $Id: AppCCSTriggerOfflineClientRowConsolidation.sp,v 1.1.2.1 2019/10/17 17:32:22 abilbrey Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppCCSTriggerOfflineClientRowConsolidation')
BEGIN
	print '>>> Drop Stored Procedure: AppCCSTriggerOfflineClientRowConsolidation <<<'
	drop procedure AppCCSTriggerOfflineClientRowConsolidation
END
IF EXISTS (select * from GxQscripts where name='AppCCSTriggerOfflineClientRowConsolidation')
	delete from GxQscripts where name = 'AppCCSTriggerOfflineClientRowConsolidation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCCSTriggerOfflineClientRowConsolidation')
	delete from GXDBVersions where aliasname = 'AppCCSTriggerOfflineClientRowConsolidation'
GO
print '... Creating Procedure: AppCCSTriggerOfflineClientRowConsolidation'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCCSTriggerOfflineClientRowConsolidation
-- Input arguments
  @startTime INT,
  @noResultSet INT
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @o_rowConsolidated int = 0
  DECLARE @o_errorCode int = 0
  DECLARE @o_errorCodeStr nvarchar(1024) = ''
BEGIN
	SET NOCOUNT ON
	IF (@startTime = 0)
	BEGIN
		-- set to current time
		SET @startTime = dbo.GetUnixTime(GETUTCDATE()) - 2		-- move back 2 second so that transaction activity does not allow mid-second updates to slip thru filtering
	END
	-- test code - temporary stop processing of trigger rows
	IF EXISTS (SELECT 1 FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'CCSTriggerRowProccessingStop' AND value = '1')
	BEGIN
		GOTO END_OF_PROC
	END
	IF OBJECT_ID('TempDb..#OfflineClients') IS NOT NULL
		DROP TABLE #OfflineClients
	CREATE TABLE #OfflineClients (
		clientId		INT,
		tableType		INT,
		rowId1			INT,
		rowId2			INT,
		rowXmlKeys		NVARCHAR(MAX),
		rowCnt			INT,
		maxId			INT,
		maxModified		INT,
		daysOffline		INT
	)
	CREATE CLUSTERED INDEX OfflineClients_idx  ON #OfflineClients (daysOffline, clientId, TableType)
	-- Find all client rows that have been offline or no CCR row
	DECLARE @rowCnt INT = 0
	INSERT INTO #OfflineClients (clientId, tableType, rowId1, rowId2, rowXmlKeys, rowCnt, maxId, maxModified, daysOffline)
		SELECT
			r.clientId,
			r.tabletype,
			r.rowId1,
			r.rowId2,
			r.rowXmlKeys,
			COUNT(*) rowcnt,
			MAX(r.id) maxId,		-- the row id to keep and delete all other rows
			MAX(r.modified) maxModified,
			ISNULL(DATEDIFF(DAY, dbo.GetDateTime(ctc.lastOfflineTime), GETUTCDATE()), -1) daysOffline		-- -1 represents no row found in CCR Table
		FROM APP_CCSTriggerRows r WITH(NOLOCK)
			LEFT OUTER JOIN CCRClientToClient AS ctc WITH (NOLOCK) ON
				ctc.FromClientId = 2		--CSId
				AND ctc.ToClientId = r.clientId
				AND ctc.lastOnlineTime <= ctc.lastOfflineTime		-- want clients that have been marked offline
		WHERE
			r.modified <= @startTime
		GROUP BY
			r.clientId,
			r.tabletype,
			r.rowId1,
			r.rowId2,
			r.rowXmlKeys,
			ctc.lastOfflineTime
	SET @rowCnt = @@ROWCOUNT
	IF (@rowCnt = 0)
	BEGIN
		GOTO END_OF_PROC
	END
	BEGIN TRY
		BEGIN TRAN CCSOfflineConsolidationTrans
		DELETE r
		FROM APP_CCSTriggerRows r
			INNER JOIN #OfflineClients oc ON
				oc.clientId = r.clientId
				AND oc.tableType = r.tableType
				AND oc.rowId1 = r.rowId1
				AND oc.rowId2 = r.rowId2
				AND oc.rowXmlKeys = r.rowXmlKeys
		WHERE
			(	-- keep row(s) with maxId and / or maxModified, could be 1 row or 2 rows if serial id rolls over then modified will keep the latest row under startTime inserted as well
				oc.maxId <> r.id
				AND oc.maxModified <> r.modified
			)
			AND (
				oc.daysOffline > 5		-- only consolidate client rows when offline for more than 5 days (make tunable)
				OR oc.daysOffline = -1	-- No CCR Row found
			)
		SET @o_rowConsolidated = @@ROWCOUNT
		COMMIT TRANSACTION CCSOfflineConsolidationTrans
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @o_errorCode = 1
		SET @o_errorCodeStr = 'AppCCSTriggerOfflineClientRowConsolidation CCS Trigger Row consolidation failed'
		ROLLBACK TRANSACTION CCSOfflineConsolidationTrans
	END CATCH
END_OF_PROC:
	IF (@noResultSet = 0)
	BEGIN
		SELECT @o_rowConsolidated o_rowConsolidated, @o_errorCode o_errorCode, @o_errorCodeStr o_errorCodeStr
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppCCSTriggerOfflineClientRowConsolidation')
	delete from GxQscripts where name = 'AppCCSTriggerOfflineClientRowConsolidation'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCCSTriggerOfflineClientRowConsolidation')
	delete from GXDBVersions where aliasname = 'AppCCSTriggerOfflineClientRowConsolidation'
GO

insert into GXDBVersions values(2, 'AppCCSTriggerOfflineClientRowConsolidation',  '00010001000200010000', 'AppCCSTriggerOfflineClientRowConsolidation', '00010001000200010000')
GO

