

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCCSTriggerCtrl.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCCSTriggerCtrl.sp,v $ $Id: AppCCSTriggerCtrl.sp,v 1.5.12.2 2018/09/18 19:13:30 abilbrey Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppCCSTriggerCtrl <<<'

IF EXISTS (select * from sysobjects where name='AppCCSTriggerCtrl')
	drop procedure AppCCSTriggerCtrl
IF EXISTS (select * from GxQscripts where name='AppCCSTriggerCtrl')
	delete from GxQscripts where name = 'AppCCSTriggerCtrl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCCSTriggerCtrl')
	delete from GXDBVersions where aliasname = 'AppCCSTriggerCtrl'
GO
print '... Creating Procedure: AppCCSTriggerCtrl'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCCSTriggerCtrl
-- Input arguments
  @enable INT
AS
	SET NOCOUNT ON
	IF (@@TRANCOUNT > 0)
	BEGIN
		PRINT 'AppCCSTriggerCtrl: Cannot execute while under transaction.'
	END
	ELSE
	BEGIN
		DECLARE @rc INT = 0
		DECLARE @ctrl NVARCHAR(128) = N'DISABLE '
		SELECT @ctrl = N'ENABLE ' WHERE @enable > 0
		DECLARE @triggerStmt NVARCHAR(MAX) = ''
		-- generate enable / disable trigger commands
		SELECT
			@triggerStmt += @ctrl + N'TRIGGER ' + s.name + N'.' + t.name +  N' ON ' + s.name + N'.' + tbl.name + N'; ' + NCHAR(13) + NCHAR(10)
		FROM
			sys.triggers t
			INNER JOIN sys.objects o ON
				o.object_id = t.object_id
			INNER JOIN sys.schemas s ON
				s.schema_id = o.schema_id
			INNER JOIN sys.objects tbl ON
				tbl.object_id = o.parent_object_id
		WHERE
			t.name LIKE 'APP_CCS%TableChange'
		IF (@triggerStmt <> '')
		BEGIN
			--PRINT @triggerStmt
			EXEC @rc = sp_executesql @stmt = @triggerStmt
		END
	END
GO

IF EXISTS (select * from GxQscripts where name = 'AppCCSTriggerCtrl')
	delete from GxQscripts where name = 'AppCCSTriggerCtrl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCCSTriggerCtrl')
	delete from GXDBVersions where aliasname = 'AppCCSTriggerCtrl'
GO

insert into GXDBVersions values(2, 'AppCCSTriggerCtrl',  '00010005001200020000', 'AppCCSTriggerCtrl', '00010005001200020000')
GO

