

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCCSSetLoadState.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCCSSetLoadState.sp,v $ $Id: AppCCSSetLoadState.sp,v 1.1.2.1 2020/03/12 01:31:51 abilbrey Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppCCSSetLoadState')
BEGIN
	print '>>> Drop Stored Procedure: AppCCSSetLoadState <<<'
	drop procedure AppCCSSetLoadState
END
IF EXISTS (select * from GxQscripts where name='AppCCSSetLoadState')
	delete from GxQscripts where name = 'AppCCSSetLoadState'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCCSSetLoadState')
	delete from GXDBVersions where aliasname = 'AppCCSSetLoadState'
GO
print '... Creating Procedure: AppCCSSetLoadState'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCCSSetLoadState
-- Input arguments
-- individual clientId or 0 for all clients
  @inClientId INT
AS
BEGIN
	SET NOCOUNT ON
	DECLARE @wkToken49      INT = 49        -- WORK_TOKEN_CCS_DB_CHANGE_STATE
	DECLARE @ccsClients		INT = 0
	DECLARE @msg			NVARCHAR(MAX)
	IF OBJECT_ID('tempdb.dbo.#clientReload') IS NOT NULL
		DROP TABLE #clientReload
	CREATE TABLE #clientReload (
		clientId		INT PRIMARY KEY,
		ccsEnabled		TINYINT,
		asSet			TINYINT
	)
	IF (@inClientId = 0)
	BEGIN
		INSERT INTO #clientReload (clientId, ccsEnabled, asSet)
			SELECT
			   c.id clientId,
			   IIF((cp.attrVal = N'1'), 1, 0) ccsEnabled,
			   IIF((s.id IS NOT NULL), 1, 0) asSet
			FROM APP_Client c WITH(NOLOCK)
				INNER JOIN APP_ClientProp cp WITH(NOLOCK) ON
					cp.componentNameId = c.id
					AND cp.attrName = N'CCS Enabled'
					AND cp.modified = 0
					AND (c.status & 6) = 0			-- client not uninstalled / deleted
					AND (c.status & 4096) = 4096	-- client is laptop
				LEFT OUTER JOIN APP_AdvanceSettings s WITH(NOLOCK) ON
					s.entityId = cp.componentNameId
					AND s.entityType = 3        -- Client Type
					AND s.keyName = N'sCCSDbStatus'
		SET @ccsClients = @@ROWCOUNT
	END
	ELSE
	BEGIN
		-- All CCS Laptop Clients
		INSERT INTO #clientReload (clientId, ccsEnabled, asSet)
			SELECT
			   c.id clientId,
			   IIF((cp.attrVal = N'1'), 1, 0) ccsEnabled,
			   IIF((s.id IS NOT NULL), 1, 0) asSet
			FROM APP_Client c WITH(NOLOCK)
				INNER JOIN APP_ClientProp cp WITH(NOLOCK) ON
					cp.componentNameId = c.id
					AND cp.attrName = N'CCS Enabled'
					AND cp.modified = 0
					AND (c.status & 6) = 0			-- client not uninstalled / deleted
					AND (c.status & 4096) = 4096	-- client is laptop
				LEFT OUTER JOIN APP_AdvanceSettings s WITH(NOLOCK) ON
					s.entityId = cp.componentNameId
					AND s.entityType = 3        -- Client Type
					AND s.keyName = N'sCCSDbStatus'
			WHERE
				c.id = @inClientId
		SET @ccsClients = @@ROWCOUNT
	END
	IF (@ccsClients = 0)
	BEGIN
		-- Nothing to process
		RETURN
	END
	IF OBJECT_ID('tempdb.dbo.#asRows') IS NOT NULL
		DROP TABLE #asRows
	CREATE TABLE #asRows (
		id		INT PRIMARY KEY
	)
	BEGIN TRY
		BEGIN TRAN
		DECLARE @asCount INT = 0
		INSERT INTO APP_AdvanceSettings (entityId, keyName, type, relativePath, value, enabled, deleted, entityType, sourceId, sourceEntityType)
			OUTPUT INSERTED.id
				INTO #asRows(id)
			SELECT
				cr.clientId, N'sCCSDbStatus', N'STRING', N'iDataAgent', (CASE cr.ccsEnabled WHEN 0 THEN N'DISABLED' ELSE N'LOAD' END), 1, 0, 3 /* client */, 0, 0
			FROM #clientReload cr
			WHERE
				cr.asSet = 0
		SET @asCount = @@ROWCOUNT
		UPDATE s
			SET value = IIF((cr.ccsEnabled = 1), N'LOAD', N'DISABLED'),
				enabled = 1,
				deleted = 0
		OUTPUT INSERTED.id
				INTO #asRows(id)
		FROM APP_AdvanceSettings s
			INNER JOIN #clientReload cr ON
				cr.asSet = 1
				AND s.entityId = cr.clientId
				AND s.entityType = 3		-- client entity
				AND s.keyName = N'sCCSDbStatus'
		SET @asCount += @@ROWCOUNT
		-- Hide the above rows from GUI if currently visible
		DECLARE @aseCount INT = 0
		INSERT INTO APP_AdvanceSettingsEx (keyId, details, hidden)
			SELECT
				s.id, N'', 1
			FROM #asRows s
				LEFT OUTER JOIN APP_AdvanceSettingsEx e WITH(NOLOCK) ON
					e.keyId = s.id
			WHERE
				e.keyId IS NULL
		SET @aseCount = @@ROWCOUNT
		-- Cleanup the APP_CCSTableHashes since all the CCS Clients will be reloaded to start
		DELETE FROM APP_CCSTableHashes
		-- Remove any WQT49 rows currently in the table, since adding all new ones for all CCS Clients
		DELETE FROM APP_WorkQueueRequest
		WHERE workToken = @wkToken49
		-- Force all CCS Clients to reload
		DECLARE @currentTime    INT = DATEDIFF(second, '01/01/1970', GETUTCDATE())
		DECLARE @wqCount INT = 0
		INSERT INTO APP_WorkQueueRequest(clientId, remoteClient, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag)
			SELECT
				cr.clientId,
				-1,
				@wkToken49,
				IIF((cr.ccsEnabled = 1), N'LOAD', N'DISABLED'),
				@currentTime,
				0,
				0,
				0
			FROM #clientReload cr
		SET @wqCount = @@ROWCOUNT
		-- Check if counts match
		IF (@ccsClients <> @wqCount OR @ccsClients <> @asCount)
		BEGIN
			DECLARE @repXml XML = (
				SELECT
					@ccsClients '@ccsClientRowCount',
					@asCount '@advSetRowCount',
					@aseCount '@advSetExRowCount',
					@wqCount '@workQueueCCSClientReloadCount'
				FOR XML PATH('CCSErrorReport'), TYPE
			)
			SET @msg = 'CCS Client Count Mismatch! ' + CAST(@repXml AS NVARCHAR(MAX))
			;THROW 50001, @msg, 255;
		END
		COMMIT TRAN
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		ROLLBACK TRAN
		;THROW;
	END CATCH
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppCCSSetLoadState')
	delete from GxQscripts where name = 'AppCCSSetLoadState'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCCSSetLoadState')
	delete from GXDBVersions where aliasname = 'AppCCSSetLoadState'
GO

insert into GXDBVersions values(2, 'AppCCSSetLoadState',  '00010001000200010000', 'AppCCSSetLoadState', '00010001000200010000')
GO

