

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCCSLoadRowsWrapper.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCCSLoadRowsWrapper.sp,v $ $Id: AppCCSLoadRowsWrapper.sp,v 1.2.2.1 2018/03/22 01:38:11 jiechen Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppCCSLoadRowsWrapper <<<'

IF EXISTS (select * from sysobjects where name='AppCCSLoadRowsWrapper')
	drop procedure AppCCSLoadRowsWrapper
IF EXISTS (select * from GxQscripts where name='AppCCSLoadRowsWrapper')
	delete from GxQscripts where name = 'AppCCSLoadRowsWrapper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCCSLoadRowsWrapper')
	delete from GXDBVersions where aliasname = 'AppCCSLoadRowsWrapper'
GO
print '... Creating Procedure: AppCCSLoadRowsWrapper'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCCSLoadRowsWrapper
-- Input arguments
  @inXMLText XML
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @xmlText XML = NULL;
	SET NOCOUNT ON
	--- '<TBL_CCSDbRemoteWorkQueueLoadReq opType="EdgeDrive" clientId="21" clientName="MyClientName"/>'
	DECLARE @outXML		XML
	DECLARE @rc			INT = 0
	DECLARE @clientId	INT = NULL
	DECLARE @clientName	NVARCHAR(255) = NULL
	DECLARE @opType		VARCHAR(128) = NULL
	-- Get Arguments
	SELECT
		@opType = a.value('./@opType', 'VARCHAR(128)'),
		@clientId = a.value('./@clientId', 'INT'),
		@clientName = a.value('./@clientName', 'NVARCHAR(255)')
	FROM
		@inXMLText.nodes('/TBL_CCSDbRemoteWorkQueueLoadReq') n(a)
	-- Validate Arguments
	IF (@opType IS NULL OR @opType = '')
	BEGIN
		SET @outXML = '<TBL_CCSOperationStatus errorCode="97" errorMessage="Invalid TBL_CCSDbRemoteWorkQueueLoadReq::opType setting."/>'
		GOTO END_OF_PROC
	END
	IF ((@clientId IS NULL OR @clientId = 0) AND @clientName IS NOT NULL)
	BEGIN
		SELECT
			@clientId = c.id
		FROM
			APP_Client c WITH(NOLOCK)
		WHERE
			c.name = @clientName
	END
	IF (@clientId IS NULL OR @clientId = 0)
	BEGIN
		SET @outXML = '<TBL_CCSOperationStatus errorCode="98" errorMessage="Invalid TBL_CCSDbRemoteWorkQueueLoadReq inputted data."/>'
		GOTO END_OF_PROC
	END
	-- Perform requested operation
	DECLARE @spName	VARCHAR(64) = ''
	IF (@opType = 'EdgeDrive')
	BEGIN
		SET  @spName = 'AppCCSEdgeDriveRows'
		EXEC @rc = AppCCSEdgeDriveRows 0, @clientId
		GOTO CHK_PROC_RC
	END
	IF (@opType = 'AssocSCPolicy')
	BEGIN
		SET  @spName = 'AppCCSAssociatedSubClientPolicyRows'
		EXEC @rc = AppCCSAssociatedSubClientPolicyRows 0, @clientId
		GOTO CHK_PROC_RC
	END
	-- Error: unknown operation type
	SET @outXML = '<TBL_CCSOperationStatus errorCode="99" errorMessage="Unsupported TBL_CCSDbRemoteWorkQueueLoadReq::opType setting."/>'
	GOTO END_OF_PROC
CHK_PROC_RC:
	IF (@rc = 0)
	BEGIN
		SET @outXML = '<TBL_CCSOperationStatus errorCode="0" errorMessage="' + @spName + ' completed for clientId[' + CAST(@clientId AS NVARCHAR(12)) + ']."/>'
	END
	ELSE
	BEGIN
		SET @outXML = '<TBL_CCSOperationStatus errorCode="1" errorMessage="' + @spName + ' failed for clientId[' + CAST(@clientId AS NVARCHAR(12)) + ']."/>'
	END
END_OF_PROC:
	SELECT @outXML AS xmlText
GO

IF EXISTS (select * from GxQscripts where name = 'AppCCSLoadRowsWrapper')
	delete from GxQscripts where name = 'AppCCSLoadRowsWrapper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCCSLoadRowsWrapper')
	delete from GXDBVersions where aliasname = 'AppCCSLoadRowsWrapper'
GO

insert into GXDBVersions values(2, 'AppCCSLoadRowsWrapper',  '00010002000200010000', 'AppCCSLoadRowsWrapper', '00010002000200010000')
GO

