

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCCSEdgeDriveRows.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCCSEdgeDriveRows.sp,v $ $Id: AppCCSEdgeDriveRows.sp,v 1.3.2.2 2018/03/22 01:43:25 jiechen Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppCCSEdgeDriveRows <<<'

IF EXISTS (select * from sysobjects where name='AppCCSEdgeDriveRows')
	drop procedure AppCCSEdgeDriveRows
IF EXISTS (select * from GxQscripts where name='AppCCSEdgeDriveRows')
	delete from GxQscripts where name = 'AppCCSEdgeDriveRows'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCCSEdgeDriveRows')
	delete from GXDBVersions where aliasname = 'AppCCSEdgeDriveRows'
GO
print '... Creating Procedure: AppCCSEdgeDriveRows'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCCSEdgeDriveRows
-- Input arguments
  @startTime INT,
  @clientId INT		-- force load CCS Client with all EdgeDrive Table Rows if > 0. If 0 process all CCS Enabled clients.
AS
SET NOCOUNT ON
	DECLARE @returnCode		INT = 0		-- success
	IF (@startTime = 0)
	BEGIN
		-- set to current time
		SET @startTime = dbo.GetUnixTime(GetUTCDate())
	END
	-- Get CCS Enabled Client(s), if temp table already exist [created by calling SP] use it, else create it
	IF (@clientId > 0 OR @startTime = 0)
	BEGIN
		-- Alway create a new temp table when clientId is set
		-- Or when startTime is 0, calling SP will supply a valid startTime!
		IF OBJECT_ID('tempdb.dbo.#CcsClients') IS NOT NULL
			DROP TABLE #CcsClients
	END
	DECLARE @rcount INT = 0
	DECLARE	@createdCcsClients	INT = 0
	IF OBJECT_ID('tempdb.dbo.#CcsClients') IS NULL
	BEGIN
		CREATE TABLE #CcsClients (clientId INT PRIMARY KEY)
		INSERT #CcsClients (clientId)
			SELECT
				c.id
			FROM
				APP_Client c WITH (NOLOCK)
				INNER JOIN APP_ClientProp cp WITH (NOLOCK) ON
					cp.componentNameId = c.id
					AND (c.status & 2) <> 2		-- installed
					AND cp.modified = 0
					AND cp.attrName = 'CCS Enabled'
					AND cp.attrVal = '1'
			WHERE
				(@clientId = 0 OR c.id = @clientId)		-- @clientId = 0 means all CCS Enabled Clients configured
		SET @rcount = @@ROWCOUNT
		SET @createdCcsClients = 1		-- SP created it drop it at end
	END
	ELSE
	BEGIN
		SELECT @rcount = COUNT(clientId) FROM #CcsClients
	END
	IF (@rcount = 0)
	BEGIN
		-- nothing to process
		GOTO END_OF_PROC
	END
	-- Get All EdgeDrive Client Content Stores
	IF OBJECT_ID('tempdb.dbo.#edgeDriveClients') IS NOT NULL
		DROP TABLE #edgeDriveClients
	CREATE TABLE #edgeDriveClients (
		clientId		INT PRIMARY KEY
	)
	INSERT INTO #edgeDriveClients (clientId)
		SELECT
			c.id clientId
		FROM
			APP_Client c WITH(NOLOCK)
		WHERE
			(c.status & 268435456) = 268435456		-- CV_STATUS_EDGE_DRIVE
	IF (@@ROWCOUNT = 0)
	BEGIN
		-- nothing to process
		GOTO END_OF_PROC
	END
	-- Get All CCS Clients with EdgeDrive Apps
	IF OBJECT_ID('tempdb.dbo.#edgeDriveApps') IS NOT NULL
		DROP TABLE #edgeDriveApps
	CREATE TABLE #edgeDriveApps (
		ccsClientId		INT,
		edAppId			INT,
		PRIMARY KEY(ccsClientId, edAppId)
	)
	INSERT INTO #edgeDriveApps(ccsClientId, edAppId)
		SELECT
			c.clientId ccsClientId,
			a.id edAppId
		FROM #CcsClients c
			INNER JOIN App_SyncCloudConfig scc WITH(NOLOCK) ON
				scc.clientId = c.clientId
			INNER JOIN APP_Application a  WITH(NOLOCK) ON
				a.id = scc.subclientId
				AND (a.subclientStatus & 131072) = 131072		-- CV_STATUS_EDGEDRIVE_SUB
	BEGIN TRY
		-- not allowed in insert-exec operations - rollback
		--BEGIN TRANSACTION Update_EdgeDriveRows
		IF (@clientId = 0)
		BEGIN
			-- Process all CCS Enabled Clients and map trapped trigger rows to clients
			INSERT INTO APP_CCSTriggerRows
				SELECT		-- CS APP_Client rows to forward to associated clients for Associated SubClient Polices
					ccs.clientId,
					ctr.tableType,
					ctr.opCode,
					ctr.modified,
					ctr.rowId1,		-- APP_Client Id
					ctr.rowId2,
					ctr.rowXmlKeys
				FROM
					APP_CCSTriggerRows ctr WITH(NOLOCK)
					INNER JOIN #edgeDriveClients c ON
						ctr.clientId = c.clientId
						AND ctr.tableType = 1		--APP_Client Table Type
						AND ctr.modified <= @startTime
					RIGHT OUTER JOIN #CcsClients ccs ON
						c.clientId = ctr.rowId1
				WHERE
					ctr.tableType IS NOT NULL
				UNION
				SELECT		-- CS APP_ClientProp rows to forward to associated clients for Associated SubClient Polices
					ccs.clientId,
					ctr.tableType,
					ctr.opCode,
					ctr.modified,
					ctr.rowId1,		-- APP_ClientProp Id
					ctr.rowId2,
					ctr.rowXmlKeys
				FROM
					APP_CCSTriggerRows ctr WITH(NOLOCK)
					INNER JOIN #edgeDriveClients c ON
						ctr.clientId = c.clientId
						AND ctr.tableType = 2		--APP_ClientProp Table Type
						AND ctr.modified <= @startTime
					INNER JOIN APP_ClientProp cp WITH(NOLOCK) ON
						cp.componentNameId = c.clientId
					RIGHT OUTER JOIN #CcsClients ccs ON
						cp.id = ctr.rowId1
				WHERE
					ctr.tableType IS NOT NULL
				UNION
				SELECT		-- CS APP_Application rows to forward to associated clients for Associated SubClient Polices
					ccs.ccsClientId clientId,
					ctr.tableType,
					ctr.opCode,
					ctr.modified,
					ctr.rowId1,		-- APP_Application Id
					ctr.rowId2,
					ctr.rowXmlKeys
				FROM
					APP_CCSTriggerRows ctr WITH(NOLOCK)
					INNER JOIN #edgeDriveClients c ON
						ctr.clientId = c.clientId
						AND ctr.tableType = 4		--APP_Application Table Type
						AND ctr.modified <= @startTime
					INNER JOIN APP_Application a WITH(NOLOCK) ON
						a.clientId = c.clientId
					INNER JOIN #edgeDriveApps ccs ON
						ccs.edAppId = a.id
				WHERE
					ctr.tableType IS NOT NULL
				UNION
				SELECT		-- CS APP_BackupSetName rows to forward to associated clients for Associated SubClient Polices
					ccs.ccsClientId clientId,
					ctr.tableType,
					ctr.opCode,
					ctr.modified,
					ctr.rowId1,		-- APP_BackupSetName Id
					ctr.rowId2,
					ctr.rowXmlKeys
				FROM
					APP_CCSTriggerRows ctr WITH(NOLOCK)
					INNER JOIN #edgeDriveClients c ON
						ctr.clientId = c.clientId
						AND ctr.tableType = 11		--APP_BackupSetName Table Type
						AND ctr.modified <= @startTime
					INNER JOIN APP_Application a WITH(NOLOCK) ON
						a.clientId = c.clientId
					INNER JOIN #edgeDriveApps ccs ON
						ccs.edAppId = a.id
					INNER JOIN APP_BackupSetName bs WITH(NOLOCK) ON
						bs.id = ctr.rowId1
						AND (bs.status & 65536) = 65536		-- CV_STATUS_EDGE_POLICY_BSET
				WHERE
					ctr.tableType IS NOT NULL
				UNION
				SELECT		-- CS APP_BackupSetProp rows to forward to associated clients for Associated SubClient Polices
					ccs.ccsClientId clientId,
					ctr.tableType,
					ctr.opCode,
					ctr.modified,
					ctr.rowId1,		-- APP_BackupSetProp Id
					ctr.rowId2,
					ctr.rowXmlKeys
				FROM
					APP_CCSTriggerRows ctr WITH(NOLOCK)
					INNER JOIN #edgeDriveClients c ON
						ctr.clientId = c.clientId
						AND ctr.tableType = 12		--APP_BackupSetProp Table Type
						AND ctr.modified <= @startTime
					INNER JOIN APP_Application a WITH(NOLOCK) ON
						a.clientId = c.clientId
					INNER JOIN #edgeDriveApps ccs ON
						ccs.edAppId = a.id
					INNER JOIN APP_BackupSetProp bsp WITH(NOLOCK) ON
						bsp.id = ctr.rowId1
						AND bsp.componentNameId = a.backupSet
				WHERE
					ctr.tableType IS NOT NULL
				UNION
				SELECT		-- CS APP_SubClientProp rows to forward to associated clients for Associated SubClient Polices
					ccs.ccsClientId clientId,
					ctr.tableType,
					ctr.opCode,
					ctr.modified,
					ctr.rowId1,		-- APP_SubClientProp Id
					ctr.rowId2,
					ctr.rowXmlKeys
				FROM
					APP_CCSTriggerRows ctr WITH(NOLOCK)
					INNER JOIN #edgeDriveClients c ON
						ctr.clientId = c.clientId
						AND ctr.tableType = 5		--APP_SubClientProp Table Type
						AND ctr.modified <= @startTime
					INNER JOIN APP_Application a WITH(NOLOCK) ON
						a.clientId = c.clientId
					INNER JOIN #edgeDriveApps ccs ON
						ccs.edAppId = a.id
					INNER JOIN APP_SubClientProp scp WITH(NOLOCK) ON
						scp.id = ctr.rowId1
				WHERE
					ctr.tableType IS NOT NULL
				UNION
				SELECT		-- CS APP_ScFilterFile rows to forward to associated clients for Associated SubClient Polices
					ccs.ccsClientId clientId,
					ctr.tableType,
					ctr.opCode,
					ctr.modified,
					ctr.rowId1,		-- APP_ScFilterFile Id
					ctr.rowId2,
					ctr.rowXmlKeys
				FROM
					APP_CCSTriggerRows ctr WITH(NOLOCK)
					INNER JOIN #edgeDriveClients c ON
						ctr.clientId = c.clientId
						AND ctr.tableType = 17		--APP_ScFilterFile Table Type
						AND ctr.modified <= @startTime
					INNER JOIN APP_Application a WITH(NOLOCK) ON
						a.clientId = c.clientId
					INNER JOIN #edgeDriveApps ccs ON
						ccs.edAppId = a.id
					INNER JOIN APP_ScFilterFile sff WITH(NOLOCK) ON
						sff.id = ctr.rowId1
				WHERE
					ctr.tableType IS NOT NULL
		END
		ELSE
		BEGIN
			-- Force load all EdgeDrive Table Rows to the given CCS Enabled ClientId
			DECLARE @opCode			INT = 1	-- update
			INSERT INTO APP_CCSTriggerRows
				SELECT	-- all content store dummy clients to push to all CCS Enabled clients
					@clientId clientId,
					1 tableType,		-- APP_Client table type
					@opCode opCode,
					@startTime modified,
					c.clientId rowId1,
					0 rowId2,
					'' rowXmlKeys
				FROM #edgeDriveClients c
				UNION	-- all content store client properties to push to all CCS Enabled clients
				SELECT
					@clientId clientId,
					2 tableType,		-- APP_ClientProp table type
					@opCode opCode,
					@startTime modified,
					cp.id rowId1,
					0 rowId2,
					'' rowXmlKeys
				FROM #edgeDriveClients c
					INNER JOIN APP_ClientProp cp  WITH(NOLOCK) ON
						cp.componentNameId = c.clientId
				UNION
				SELECT
					@clientId clientId,
					4 tableType,		-- APP_Application table type
					@opCode opCode,
					@startTime modified,
					a.id rowId1,
					0 rowId2,
					'' rowXmlKeys
				FROM #edgeDriveClients c
					INNER JOIN APP_Application a WITH(NOLOCK) ON
						a.clientId = c.clientId
					INNER JOIN #edgeDriveApps ccs ON
						ccs.edAppId = a.id
				UNION
				SELECT
					@clientId clientId,
					11 tableType,		-- APP_BackupSetName table type
					@opCode opCode,
					@startTime modified,
					bs.id rowId1,
					0 rowId2,
					'' rowXmlKeys
				FROM #edgeDriveClients c
					INNER JOIN APP_Application a WITH(NOLOCK) ON
						a.clientId = c.clientId
					INNER JOIN #edgeDriveApps ccs ON
						ccs.edAppId = a.id
					INNER JOIN APP_BackupSetName bs WITH(NOLOCK) ON
						bs.id = a.backupSet
				UNION
				SELECT
					@clientId clientId,
					12 tableType,		-- APP_BackupSetProp table type
					@opCode opCode,
					@startTime modified,
					bsp.id rowId1,
					0 rowId2,
					'' rowXmlKeys
				FROM #edgeDriveClients c
					INNER JOIN APP_Application a WITH(NOLOCK) ON
						a.clientId = c.clientId
					INNER JOIN #edgeDriveApps ccs ON
						ccs.edAppId = a.id
					INNER JOIN APP_BackupSetProp bsp WITH(NOLOCK) ON
						bsp.componentNameId = a.backupSet
				UNION
				SELECT
					@clientId clientId,
					5 tableType,		-- APP_SubClientProp table type
					@opCode opCode,
					@startTime modified,
					scp.id rowId1,
					0 rowId2,
					'' rowXmlKeys
				FROM #edgeDriveClients c
					INNER JOIN APP_Application a WITH(NOLOCK) ON
						a.clientId = c.clientId
					INNER JOIN #edgeDriveApps ccs ON
						ccs.edAppId = a.id
					INNER JOIN APP_SubClientProp scp WITH(NOLOCK) ON
						scp.componentNameId = a.id
				UNION
				SELECT
					@clientId clientId,
					17 tableType,		-- APP_ScFilterFile table type
					@opCode opCode,
					@startTime modified,
					sff.id rowId1,
					0 rowId2,
					'' rowXmlKeys
				FROM #edgeDriveClients c
					INNER JOIN APP_Application a WITH(NOLOCK) ON
						a.clientId = c.clientId
					INNER JOIN #edgeDriveApps ccs ON
						ccs.edAppId = a.id
					INNER JOIN APP_ScFilterFile sff WITH(NOLOCK) ON
						sff.componentNameId = a.id
		END
		-- not allowed in insert-exec operations - rollback
		--COMMIT TRANSACTION Update_EdgeDriveRows
		SET @returnCode = 0
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		-- not allowed in insert-exec operations - rollback
		--ROLLBACK TRANSACTION Update_EdgeDriveRows
		SET @returnCode = 1
	END CATCH
END_OF_PROC:
	IF OBJECT_ID('tempdb.dbo.#edgeDriveApps') IS NOT NULL
		DROP TABLE #edgeDriveApps
	IF OBJECT_ID('tempdb.dbo.#edgeDriveClients') IS NOT NULL
		DROP TABLE #edgeDriveClients
	IF (@createdCcsClients = 1 AND OBJECT_ID('tempdb.dbo.#CcsClients') IS NOT NULL)
		DROP TABLE #CcsClients
	RETURN @returnCode
GO

IF EXISTS (select * from GxQscripts where name = 'AppCCSEdgeDriveRows')
	delete from GxQscripts where name = 'AppCCSEdgeDriveRows'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCCSEdgeDriveRows')
	delete from GXDBVersions where aliasname = 'AppCCSEdgeDriveRows'
GO

insert into GXDBVersions values(2, 'AppCCSEdgeDriveRows',  '00010003000200020000', 'AppCCSEdgeDriveRows', '00010003000200020000')
GO

