

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCCSClientControl.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCCSClientControl.sp,v $ $Id: AppCCSClientControl.sp,v 1.1.2.1.36.1 2021/01/12 23:53:17 abilbrey Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppCCSClientControl')
BEGIN
	print '>>> Drop Stored Procedure: AppCCSClientControl <<<'
	drop procedure AppCCSClientControl
END
IF EXISTS (select * from GxQscripts where name='AppCCSClientControl')
	delete from GxQscripts where name = 'AppCCSClientControl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCCSClientControl')
	delete from GXDBVersions where aliasname = 'AppCCSClientControl'
GO
print '... Creating Procedure: AppCCSClientControl'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppCCSClientControl
-- Input arguments
  @clientId INT,
-- 1 enabled or 0 disabled - CCS for client
  @isEnabled INT,
-- 0 No Change default, 1 LOAD, or 2 DISABLED.  If CCS NOT configured then defaults to LOAD and WQ Request sent
  @ccsStatus INT,
-- 1 yes or 0 no - Change CCSDb status on client if CCS Status actually changes
  @sendWQRequest INT = 0
AS
  DECLARE @outputXml XML = NULL;
BEGIN
	SET NOCOUNT ON
	-- Get CS Global CCS Setting
	DECLARE @isCSCCSEnabled	INT = 0
	SELECT
		@isCSCCSEnabled = CAST(p.value AS INT)
	FROM GXGlobalParam p WITH(NOLOCK)
	WHERE
		name = N'CommServCCSEnabled'
	IF (@isCSCCSEnabled = 0)
	BEGIN
		SELECT
			1 [@errorCode],
			N'CCS not enabled on Commserver.' [@errorMessage]
		FOR XML PATH('genericResp'), TYPE
		RETURN
	END
	-- Is Client a valid for CCS Operations
	DECLARE @ccsValid TINYINT = 0
	DECLARE @ccsCfg INT = NULL
	SELECT
		@ccsValid = 1,
		@ccsCfg = TRY_CAST(c.ccsEnabled AS INT)
	FROM ClientsWithValidCCSCfgsView c
	WHERE
		c.clientId = @clientId
		AND c.GESP12Version >= 14		-- V11 SP14+ required for CCS Software support
	IF (@ccsValid = 0)
	BEGIN
		SELECT
			2 [@errorCode],
			N'CCS operations not valid for clientId [' + CAST(@clientId AS NVARCHAR(12)) + '].' [@errorMessage]
		FOR XML PATH('genericResp'), TYPE
		RETURN
	END
	-- Validate inputs
	IF (@isEnabled NOT IN (0,1) OR @ccsStatus NOT IN (0,1,2) OR @sendWQRequest NOT IN (0,1) OR (@isEnabled = 1 AND @ccsStatus = 2) OR (@isEnabled = 0 AND @ccsStatus = 1))
	BEGIN
		SELECT
			3 [@errorCode],
			N'Inputed arguments contains errors.' [@errorMessage]
		FOR XML PATH('genericResp'), TYPE
		RETURN
	END
	DECLARE @now		INT = dbo.getunixtime(GETUTCDATE())
	DECLARE @asId		INT
	DECLARE @rcnt		INT
	DECLARE @dbStatus	NVARCHAR(20)
	DECLARE @transCnt	INT
	DECLARE @outTbl TABLE (
		id		INT
	)
	-- Database update work begins here
	BEGIN TRY
		SET @transCnt  = @@TRANCOUNT
		IF (@transCnt = 0)
		BEGIN
			BEGIN TRANSACTION
		END
		IF (@ccsCfg IS NULL)
		BEGIN
			-- Need to configure CCS Operations initially
			INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
				VALUES(@clientId, N'CCS Enabled', 2, CAST(@isEnabled AS NVARCHAR(12)), @now, 0, 0)
			INSERT INTO APP_AdvanceSettings (entityId, keyName, type, relativePath, value, enabled, deleted, entityType, sourceId, sourceEntityType)
				VALUES (@clientId, N'sCCSDbStatus', N'STRING', N'iDataAgent', N'LOAD', 1, 0, 3, 0, 0)
			SET @asId  = SCOPE_IDENTITY()
			INSERT INTO APP_AdvanceSettingsEx (keyId, details, hidden)
				VALUES (@asId, N'', 1)
			-- WORK_TOKEN_CCS_DB_CHANGE_STATE
			INSERT INTO APP_WorkQueueRequest (clientId, remoteClient, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag)
				VALUES (@clientId, -1, 49, N'LOAD', @now, 0, 0, 0)
			GOTO COMMIT_WORK
		END
		ELSE
		BEGIN
			IF (@ccsCfg <> @isEnabled)
			BEGIN
				-- Changing CCS Enabled
				UPDATE APP_ClientProp
					SET attrVal = CAST(@isEnabled AS NVARCHAR(12))
				WHERE
					componentNameId = @clientId
					AND modified = 0
					AND attrName = N'CCS Enabled'
					AND attrVal <> CAST(@isEnabled AS NVARCHAR(12))
			END
			-- Check for CCSDb status change
			IF (@ccsStatus = 0)
			BEGIN
				-- nothing to do
				GOTO COMMIT_WORK
			END
			SET @dbStatus = (
				CASE @ccsStatus
					WHEN 1 THEN N'LOAD'
					ELSE N'DISABLED'
				END
			)
			-- Update CCSDb Status if changed
			UPDATE APP_AdvanceSettings
				SET [value] = @dbStatus,
					[enabled] = 1,
					[deleted] = 0
			WHERE
				entityType = 3
				AND entityId = @clientId
				AND keyName = N'sCCSDbStatus'
				AND relativePath = N'iDataAgent'
				AND CAST(value AS NVARCHAR(128)) <> @dbStatus
			SET @rcnt = @@ROWCOUNT
			IF (@sendWQRequest = 1 AND @rcnt > 0)
			BEGIN
				-- Send client a request to change CCSDb Status
				-- WORK_TOKEN_CCS_DB_CHANGE_STATE
				INSERT INTO APP_WorkQueueRequest (clientId, remoteClient, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag)
					VALUES (@clientId, -1, 49, @dbStatus, @now, 0, 0, 0)
			END
			GOTO COMMIT_WORK
		END
COMMIT_WORK:
		IF (@transCnt = 0)
		BEGIN
			COMMIT TRANSACTION
		END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		IF (@transCnt = 0)
		BEGIN
			ROLLBACK TRANSACTION
		END
		-- Re-throw the exception
		;THROW;
	END CATCH
	SELECT
		0 [@errorCode],
		N'Success' [@errorMessage]
	FOR XML PATH('genericResp'), TYPE
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppCCSClientControl')
	delete from GxQscripts where name = 'AppCCSClientControl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCCSClientControl')
	delete from GXDBVersions where aliasname = 'AppCCSClientControl'
GO

insert into GXDBVersions values(2, 'AppCCSClientControl',  'v1.1.2.1.36.1', 'AppCCSClientControl', 'v1.1.2.1.36.1')
GO

