

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCCSAssociatedSubClientPolicyRows.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCCSAssociatedSubClientPolicyRows.sp,v $ $Id: AppCCSAssociatedSubClientPolicyRows.sp,v 1.3.2.9.36.1 2021/03/08 18:19:11 abilbrey Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppCCSAssociatedSubClientPolicyRows')
BEGIN
	print '>>> Drop Stored Procedure: AppCCSAssociatedSubClientPolicyRows <<<'
	drop procedure AppCCSAssociatedSubClientPolicyRows
END
IF EXISTS (select * from GxQscripts where name='AppCCSAssociatedSubClientPolicyRows')
	delete from GxQscripts where name = 'AppCCSAssociatedSubClientPolicyRows'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCCSAssociatedSubClientPolicyRows')
	delete from GXDBVersions where aliasname = 'AppCCSAssociatedSubClientPolicyRows'
GO
print '... Creating Procedure: AppCCSAssociatedSubClientPolicyRows'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppCCSAssociatedSubClientPolicyRows
-- Input arguments
  @startTime INT,
  @clientId INT		-- force load CCS Client with all ASCP Table Rows if > 0. If 0 process all CCS Enabled clients.
AS
SET NOCOUNT ON
	DECLARE @returnCode		INT = 0		-- success
	IF (@startTime = 0)
	BEGIN
		-- set to current time
		SET @startTime = dbo.GetUnixTime(GetUTCDate())
	END
	-- Get CCS Enabled Client(s), if temp table already exist [created by calling SP] use it, else create it
	IF (@clientId > 0 OR @startTime = 0)
	BEGIN
		-- Alway create a new temp table when clientId is set
		-- Or when startTime is 0, calling SP will supply a valid startTime!
		IF OBJECT_ID('tempdb.dbo.#CcsClients') IS NOT NULL
			DROP TABLE #CcsClients
	END
	DECLARE @rcount INT = 0
	DECLARE	@createdCcsClients	INT = 0
	IF OBJECT_ID('tempdb.dbo.#CcsClients') IS NULL
	BEGIN
		CREATE TABLE #CcsClients (clientId INT PRIMARY KEY)
		INSERT #CcsClients (clientId)
			SELECT
				c.id
			FROM
				APP_Client c WITH (NOLOCK)
				INNER JOIN APP_ClientProp cp WITH (NOLOCK) ON
					cp.componentNameId = c.id
					AND (c.status & (2|4)) = 0		-- not uninstalled or deleted
					AND cp.modified = 0
					AND cp.attrName = N'CCS Enabled'
					AND cp.attrVal = N'1'
			WHERE
				(@clientId = 0 OR c.id = @clientId)		-- @clientId = 0 means all CCS Enabled Clients configured
		SET @rcount = @@ROWCOUNT
		SET @createdCcsClients = 1		-- SP created it drop it at end
	END
	ELSE
	BEGIN
		SELECT @rcount = COUNT(clientId) FROM #CcsClients
	END
	IF (@rcount = 0)
	BEGIN
		-- nothing to process
		GOTO END_OF_PROC
	END
	--- Get All Associated SubClient Policy AppIds
	IF OBJECT_ID('tempdb.dbo.#ASCPs') IS NOT NULL
		DROP TABLE #ASCPs
	CREATE TABLE #ASCPs (
		clientId		INT,
		appTypeId		INT,
		instance		INT,
		backupSet		INT,
		ascpId			INT,
		PRIMARY KEY (clientId, ascpId)
	)
	INSERT INTO #ASCPs
		SELECT
			a.clientId,
			a.appTypeId,
			a.instance,
			a.backupset,
			a.id ascpId
		FROM APP_Application a WITH(NOLOCK)
		WHERE
			a.appTypeId = 1030
			AND a.clientId = 2		-- CS Id
	SET @rcount = @@ROWCOUNT
	IF (@rcount = 0)
	BEGIN
		-- nothing to process since there are NO ASCPs defined
		GOTO END_OF_PROC
	END
	-- Get All CCS Clients / ASCPs mapping that currently exist when the ASCP is created and mapped in one sitting
	-- and captured by the trigger table.
	IF OBJECT_ID('tempdb.dbo.#ASCPsMapped') IS NOT NULL
		DROP TABLE #ASCPsMapped
	CREATE TABLE #ASCPsMapped (
		clientId		INT,
		ascpId			INT,
		instance		INT,
		backupSet		INT,
		appTypeId		INT,
		PRIMARY KEY (clientId, ascpId)
	)
	INSERT INTO #ASCPsMapped(clientId, ascpId, instance, backupset, appTypeId)
		SELECT DISTINCT
			c.clientId,
			a.ascpId,
			a.instance,
			a.backupset,
			a.appTypeId
		FROM APP_SubClientProp scp WITH(NOLOCK)
			INNER JOIN APP_Application sca WITH(NOLOCK) ON
				sca.id = scp.componentNameId
				AND scp.attrName = N'Associated subclient Policy'
				AND scp.cs_attrName = CHECKSUM(N'Associated subclient Policy')	-- Updated APP_SubClientProp cs_attrName index was the only way to get better performance
				AND scp.modified = 0
			INNER JOIN #CcsClients c ON
				c.clientId = sca.clientId
			INNER JOIN #ASCPs a ON
				scp.attrVal = CAST(a.ascpId AS NVARCHAR(12))
	SET @rcount = @@ROWCOUNT
	IF (@rcount = 0)
	BEGIN
		-- nothing to process since there are NO ASCPs mapped
		GOTO END_OF_PROC
	END
	-- Now get all data rows mapping to their ASCPs
	IF OBJECT_ID('tempdb.dbo.#ASCPData') IS NOT NULL
		DROP TABLE #ASCPData
	CREATE TABLE #ASCPData (
		clientId		INT,
		tableType		INT,
		tableId			INT,
		ascpId			INT,
		PRIMARY KEY (tableType, tableId, ascpId, clientId)
	)
	-- Create Filters table for better performance for inserting data into ASCPData table
	IF OBJECT_ID('TempDb..#Filters') IS NOT NULL
		DROP TABLE #Filters
	CREATE TABLE #Filters (
		tableType		INT,
		attrName		NVARCHAR(1024)
	)
	CREATE CLUSTERED INDEX Filter_idx ON #Filters (tableType)
	INSERT INTO #Filters (tableType, attrName)
		SELECT
			id,
			f.value('@value', 'NVARCHAR(128)') filter
		FROM APP_CCSXMLMapping WITH(NOLOCK)
			CROSS APPLY filters.nodes('/Filters/Column/Filter') n(f)
		WHERE
			id = 12
			AND f.value('../@name', 'NVARCHAR(128)') = 'attrName'
			AND f.value('../@opType', 'NVARCHAR(128)') = 'EXCLUDE'
		UNION ALL
		SELECT
			id,
			f.value('@value', 'NVARCHAR(128)') filter
		FROM APP_CCSXMLMapping WITH(NOLOCK)
			CROSS APPLY filters.nodes('/Filters/Column/Filter') n(f)
		WHERE
			id = 5
			AND f.value('../@name', 'NVARCHAR(128)') = 'attrName'
			AND f.value('../@opType', 'NVARCHAR(128)') = 'EXCLUDE'
	INSERT INTO #ASCPData
		SELECT
			ascp.clientId,
			8 tableType,	-- APP_iDAType
			t.type tableId,
			ascp.ascpId
		FROM #ASCPs ascp
			INNER JOIN APP_Application a WITH(NOLOCK) ON
				ascp.ascpId = a.id
			INNER JOIN APP_iDAType t WITH(NOLOCK) ON
				t.type = a.appTypeId
		UNION ALL
		SELECT
			ascp.clientId,
			6 tableType,	-- APP_InstanceName
			i.id tableId,
			ascp.ascpId
		FROM #ASCPs ascp
			INNER JOIN APP_InstanceName i WITH(NOLOCK) ON
				i.id = ascp.instance
		UNION ALL
		SELECT
			ascp.clientId,
			11 tableType,	-- APP_BackupSetName
			bs.id tableId,
			ascp.ascpId
		FROM #ASCPs ascp
			INNER JOIN APP_BackupSetName bs WITH(NOLOCK) ON
				bs.id = ascp.backupset
		UNION ALL
		SELECT
			ascp.clientId,
			4 tableType,	-- APP_Application
			ascp.ascpId tableId,
			ascp.ascpId
		FROM #ASCPs ascp
		UNION ALL
		SELECT
			ascp.clientId,
			14 tableType,	-- APP_InstanceProp
			ip.id tableId,
			ascp.ascpId
		FROM #ASCPs ascp
			INNER JOIN APP_InstanceProp  ip WITH(NOLOCK) ON
				ip.componentNameId = ascp.instance
		UNION ALL
		SELECT
			ascp.clientId,
			12 tableType,	-- APP_BackupSetProp
			bsp.id tableId,
			ascp.ascpId
		FROM #ASCPs ascp
			INNER JOIN APP_BackupSetProp bsp WITH(NOLOCK) ON
				bsp.componentNameId = ascp.backupset
			LEFT OUTER JOIN #Filters f ON
				f.tableType = 12
				AND f.attrName = bsp.attrName
		WHERE
			f.tableType IS NULL
		UNION ALL
		SELECT
			ascp.clientId,
			5 tableType,	-- APP_SubClientProp
			scp.id tableId,
			ascp.ascpId
		FROM #ASCPs ascp
			INNER JOIN APP_SubClientProp  scp WITH(NOLOCK) ON
				scp.componentNameId = ascp.ascpId
			LEFT OUTER JOIN #Filters f ON
				f.tableType = 5
				AND f.attrName = scp.attrName
			WHERE
				f.tableType IS NULL
		UNION ALL
		SELECT
			ascp.clientId,
			16 tableType,	-- APP_InstFilterFile
			ff.id tableId,
			ascp.ascpId
		FROM #ASCPs ascp
			INNER JOIN APP_InstFilterFile ff WITH(NOLOCK) ON
				ff.componentNameId = ascp.instance
		UNION ALL
		SELECT
			ascp.clientId,
			15 tableType,	-- APP_BackupSetFilterFile
			ff.componentNameId tableId,
			ascp.ascpId
		FROM #ASCPs ascp
			INNER JOIN APP_BackupSetFilterFile ff WITH(NOLOCK) ON
				ff.componentNameId = ascp.backupset
		UNION ALL
		SELECT
			ascp.clientId,
			17 tableType,	-- APP_ScFilterFile
			ff.id tableId,
			ascp.ascpId
		FROM #ASCPs ascp
			INNER JOIN APP_ScFilterFile  ff WITH(NOLOCK) ON
				ff.componentNameId = ascp.ascpId
	--#### START: CCS MD5 Hash Check #################################################################################################################
	-- @ASCPHashNeedsUpdating contains a list of ASCPIds that require their MD5 Hashes to be updated at the end of this SP due to changes
	DECLARE @ASCPHashNeedsUpdating TABLE (
		ascpId		INT PRIMARY KEY
	)
	IF OBJECT_ID('tempdb.dbo.#MD5HashTables') IS NOT NULL
		 DROP TABLE #MD5HashTables
	CREATE TABLE #MD5HashTables (
		appId			INT,
		tableType		INT,
		PRIMARY KEY (appId, tableType)
	)
	-- Get distinct rows by AppId and TableType that exist in the trigger table to verify the MD5 Hashes on those tables
	INSERT INTO #MD5HashTables (appId, tableType)
		SELECT DISTINCT
			d.ascpId,
			d.tableType
		FROM APP_CCSTriggerRows tr WITH(NOLOCK)
			INNER JOIN #ASCPData d ON
				d.tableType = tr.tableType
				AND d.tableId = tr.rowId1
				AND d.clientId = tr.clientId
				AND tr.modified <= @startTime
			INNER JOIN #ASCPsMapped m ON
				m.ascpId = d.ascpId
	DECLARE @htCnt INT = @@ROWCOUNT
	IF (@htCnt > 0)
	BEGIN
		DECLARE @htAppId		INT
		DECLARE @htTableType	INT
		DECLARE @htIsMatch		INT = 0
		DECLARE md5HTASCPCursor CURSOR LOCAL FORWARD_ONLY READ_ONLY FOR
			SELECT DISTINCT
				t.appId,
				t.tableType
			FROM #MD5HashTables t
		OPEN md5HTASCPCursor
		FETCH NEXT FROM md5HTASCPCursor
			INTO @htAppId, @htTableType
		WHILE @@FETCH_STATUS = 0
		BEGIN
			EXEC APPCCSMd5ASCPTableHashCompare @htAppId, @htTableType, @startTime, @htIsMatch OUTPUT, 0
			IF (@htIsMatch > 0)
			BEGIN
				-- No need to send this data to the CCS Laptop Client since it matches CS ASCP MD5 Hash
				DELETE dtr
				FROM APP_CCSTriggerRows AS dtr
					INNER JOIN #ASCPData d ON
						d.tableType = dtr.tableType
						AND d.tableId = dtr.rowId1
						AND d.clientId = dtr.clientId
						AND dtr.modified <= @startTime
					INNER JOIN #ASCPsMapped m ON
						m.ascpId = d.ascpId
						AND d.ascpId = @htAppId
				WHERE
					dtr.clientId = 2		-- Always CSId for ASCP
					AND dtr.tableType = @htTableType
				SET @htIsMatch = 0		-- reset
				-- Debug testing messages - remove for delivery
				PRINT 'AppCCSAssociatedSubClientPolicyRows Table MD5 Hash Match Deletion NODATACHANGE: AscpId[' + CAST(@htAppId AS VARCHAR(128)) + ']  TableType[' + CAST(@htTableType AS VARCHAR(12)) + ']'
			END
			ELSE
			BEGIN
				IF NOT EXISTS (SELECT ascpId FROM @ASCPHashNeedsUpdating WHERE ascpId = @htAppId)
				BEGIN
					-- ASCP table has been updated and local MD5 Hashes are out-of-date now
					INSERT INTO @ASCPHashNeedsUpdating (ascpId) VALUES (@htAppId)
				END
			END
			FETCH NEXT FROM md5HTASCPCursor
				INTO @htAppId, @htTableType
		END
		CLOSE md5HTASCPCursor
		DEALLOCATE md5HTASCPCursor
	END
	--#### END: CCS MD5 Hash Check ###################################################################################################################
	BEGIN TRY
		-- not allowed in insert-exec operations - rollback
		--BEGIN TRANSACTION Update_ASCPRows
		IF (@clientId = 0)
		BEGIN
			-- Identify ASCP data rows in the trigger table and map their assigned CCS Clients for updating the CCSDb.
			INSERT INTO APP_CCSTriggerRows(clientId, tableType, opCode, modified, rowId1, rowId2, rowXmlKeys)
				SELECT --DISTINCT
					m.clientId,
					tr.tableType,
					tr.opCode,		-- update or insert (deletion will not be able to map since data is gone in the CSDb)
					@startTime,
					d.tableId rowId1,
					0 rowId2,
					'' rowXmlKeys
				FROM APP_CCSTriggerRows tr
					INNER JOIN #ASCPData d ON
						d.tableType = tr.tableType
						AND d.tableId = tr.rowId1
						AND d.clientId = tr.clientId
						AND tr.modified <= @startTime
					INNER JOIN #ASCPsMapped m ON
						m.ascpId = d.ascpId
					LEFT OUTER JOIN APP_CCSTriggerRows c WITH(NOLOCK) ON	-- if NOT NULL then data row already captured in table and no need to insert
						c.clientId = m.clientId
						AND c.tableType = d.tableType
						AND c.opCode = tr.opCode
						AND c.rowId1 = d.tableId
				WHERE
					c.id IS NULL
		END
		ELSE
		BEGIN
			-- Load ASCP Rows for the given CCS Enabled ClientId
			INSERT INTO APP_CCSTriggerRows(clientId, tableType, opCode, modified, rowId1, rowId2, rowXmlKeys)
				SELECT --DISTINCT
					m.clientId,
					tr.tableType,
					tr.opCode,		-- update or insert (deletion will not be able to map since data is gone in the CSDb)
					@startTime,
					d.tableId rowId1,
					0 rowId2,
					'' rowXmlKeys
				FROM APP_CCSTriggerRows tr
					INNER JOIN #ASCPData d ON
						d.tableType = tr.tableType
						AND d.tableId = tr.rowId1
						AND d.clientId = tr.clientId
						AND tr.modified <= @startTime
					INNER JOIN #ASCPsMapped m ON
						m.ascpId = d.ascpId
						AND m.clientId = @clientId
					LEFT OUTER JOIN APP_CCSTriggerRows c WITH(NOLOCK) ON	-- if NOT NULL then data row already captured in table and no need to insert
						c.clientId = m.clientId
						AND c.tableType = d.tableType
						AND c.opCode = tr.opCode
						AND c.rowId1 = d.tableId
				WHERE
					c.id IS NULL
		END
		-- not allowed in insert-exec operations - rollback
		--COMMIT TRANSACTION Update_ASCPRows
		SET @returnCode = 0
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		-- not allowed in insert-exec operations - rollback
		--ROLLBACK TRANSACTION Update_ASCPRows
		SET @returnCode = 1
		GOTO END_OF_PROC
	END CATCH
	BEGIN TRY
		-- CCS Client ASCP row being created / updated on a client later after ASCP created on the CS.
		-- Insert all ASCP data rows into the trigger table
		-- so that the client is properly in sync with these changes
		IF OBJECT_ID('tempdb.dbo.#ASCPsMappedLater') IS NOT NULL
			DROP TABLE #ASCPsMappedLater
		CREATE TABLE #ASCPsMappedLater (
			clientId		INT,
			ascpId			INT,
			instance		INT,
			backupSet		INT,
			PRIMARY KEY (clientId, ascpId)
		)
		INSERT INTO #ASCPsMappedLater(clientId, ascpId, instance, backupset)
			SELECT DISTINCT
				c.clientId,
				a.id,
				a.instance,
				a.backupset
			FROM #CcsClients c
				INNER JOIN APP_CCSTriggerRows r WITH(NOLOCK) ON
					r.clientId = c.clientId
				INNER JOIN APP_SubClientProp scp WITH(NOLOCK) ON
					r.tableType = 5		-- APP_SubClientProp
					AND scp.id = r.rowId1
					AND scp.attrName = N'Associated subclient Policy'
					AND scp.cs_attrName = CHECKSUM( N'Associated subclient Policy')
				INNER JOIN APP_Application a WITH(NOLOCK) ON
					scp.attrVal = CAST(a.id AS NVARCHAR(12))
					AND a.appTypeId = 1030
					AND a.clientId = 2		-- CS Id
			WHERE
				r.opCode IN (0, 1)		-- insert / update [deletion cannot be done here]
				AND (
					@clientId = 0
					OR r.clientId = @clientId
				)
		SET @rcount = @@ROWCOUNT
		IF (@rcount = 0)
		BEGIN
			-- nothing to process since there are NO ASCPs defined
			GOTO END_OF_BLOCK2
		END
		-- Capture all ASCP rows so that they can be filtered later for rows that
		-- do not need to be inserted since they are already captured in the APP_CCSTriggerRows Table.
		IF OBJECT_ID('TempDb..#TempCCSTriggerRows') IS NOT NULL
			DROP TABLE #TempCCSTriggerRows
		CREATE TABLE #TempCCSTriggerRows (
			clientId		INT,
			tableType		INT,
			opCode			INT,
			modified		INT,
			rowId1			INT,
			rowId2			INT,
			rowXmlKeys		NVARCHAR(MAX)
		)
		CREATE CLUSTERED INDEX TempCCSTriggerRows_idx1 ON #TempCCSTriggerRows (clientId, tableType, opCode, rowId1)
		DECLARE @ascpTempCnt INT = 0
		IF (@clientId = 0)
		BEGIN
			INSERT INTO #TempCCSTriggerRows (clientId, tableType, opCode, modified, rowId1, rowId2, rowXmlKeys)
				SELECT
					ascp.clientId,
					8 tableType,	-- APP_iDAType
					1 opCode,		-- update
					@startTime,
					t.type rowId1,
					0 rowId2,
					'' rowXmlKeys
				FROM #ASCPsMappedLater ascp
					INNER JOIN APP_Application a WITH(NOLOCK) ON
						ascp.ascpId = a.id
					INNER JOIN APP_iDAType t WITH(NOLOCK) ON
						t.type = a.appTypeId
				UNION
				SELECT
					ascp.clientId,
					6 tableType,	-- APP_InstanceName
					1 opCode,		-- update
					@startTime,
					i.id rowId1,
					0 rowId2,
					'' rowXmlKeys
				FROM #ASCPsMappedLater ascp
					INNER JOIN APP_InstanceName i WITH(NOLOCK) ON
						i.id = ascp.instance
				UNION
				SELECT
					ascp.clientId,
					11 tableType,	-- APP_BackupSetName
					1 opCode,		-- update
					@startTime,
					bs.id rowId1,
					0 rowId2,
					'' rowXmlKeys
				FROM #ASCPsMappedLater ascp
					INNER JOIN APP_BackupSetName bs WITH(NOLOCK) ON
						bs.id = ascp.backupset
				UNION
				SELECT
					ascp.clientId,
					4 tableType,	-- APP_Application
					1 opCode,		-- update
					@startTime,
					ascp.ascpId rowId1,
					0 rowId2,
					'' rowXmlKeys
				FROM #ASCPsMappedLater ascp
				UNION
				SELECT
					ascp.clientId,
					14 tableType,	-- APP_InstanceProp
					1 opCode,		-- update
					@startTime,
					ip.id rowId1,
					0 rowId2,
					'' rowXmlKeys
				FROM #ASCPsMappedLater ascp
					INNER JOIN APP_InstanceProp  ip WITH(NOLOCK) ON
						ip.componentNameId = ascp.instance
				UNION
				SELECT
					ascp.clientId,
					12 tableType,	-- APP_BackupSetProp
					1 opCode,		-- update
					@startTime,
					bsp.id rowId1,
					0 rowId2,
					'' rowXmlKeys
				FROM #ASCPsMappedLater ascp
					INNER JOIN APP_BackupSetProp bsp WITH(NOLOCK) ON
						bsp.componentNameId = ascp.backupset
					LEFT OUTER JOIN #Filters f ON
						f.tableType = 12
						AND f.attrName = bsp.attrName
				WHERE
					f.tableType IS NULL
				UNION
				SELECT
					ascp.clientId,
					5 tableType,	-- APP_SubClientProp
					1 opCode,		-- update
					@startTime,
					scp.id rowId1,
					0 rowId2,
					'' rowXmlKeys
				FROM #ASCPsMappedLater ascp
					INNER JOIN APP_SubClientProp  scp WITH(NOLOCK) ON
						scp.componentNameId = ascp.ascpId
					LEFT OUTER JOIN #Filters f ON
						f.tableType = 5
						AND f.attrName = scp.attrName
				WHERE
					f.tableType IS NULL
				UNION
				SELECT
					ascp.clientId,
					16 tableType,	-- APP_InstFilterFile
					1 opCode,		-- update
					@startTime,
					ff.id rowId1,
					0 rowId2,
					'' rowXmlKeys
				FROM #ASCPsMappedLater ascp
					INNER JOIN APP_InstFilterFile ff WITH(NOLOCK) ON
						ff.componentNameId = ascp.instance
				UNION
				SELECT
					ascp.clientId,
					15 tableType,	-- APP_BackupSetFilterFile
					1 opCode,		-- update
					@startTime,
					ff.componentNameId rowId1,
					0 rowId2,
					'' rowXmlKeys
				FROM #ASCPsMappedLater ascp
					INNER JOIN APP_BackupSetFilterFile ff WITH(NOLOCK) ON
						ff.componentNameId = ascp.backupset
				UNION
				SELECT
					ascp.clientId,
					17 tableType,	-- APP_ScFilterFile
					1 opCode,		-- update
					@startTime,
					ff.id rowId1,
					0 rowId2,
					'' rowXmlKeys
				FROM #ASCPsMappedLater ascp
					INNER JOIN APP_ScFilterFile  ff WITH(NOLOCK) ON
						ff.componentNameId = ascp.ascpId
			SET @ascpTempCnt = @@ROWCOUNT
		END
		ELSE
		BEGIN
			INSERT INTO #TempCCSTriggerRows (clientId, tableType, opCode, modified, rowId1, rowId2, rowXmlKeys)
				SELECT
					ascp.clientId,
					8 tableType,	-- APP_iDAType
					1 opCode,		-- update
					@startTime,
					t.type rowId1,
					0 rowId2,
					'' rowXmlKeys
				FROM #ASCPsMappedLater ascp
					INNER JOIN APP_Application a WITH(NOLOCK) ON
						ascp.ascpId = a.id
					INNER JOIN APP_iDAType t WITH(NOLOCK) ON
						t.type = a.appTypeId
				WHERE
					ascp.clientId = @clientId
				UNION
				SELECT
					ascp.clientId,
					6 tableType,	-- APP_InstanceName
					1 opCode,		-- update
					@startTime,
					i.id rowId1,
					0 rowId2,
					'' rowXmlKeys
				FROM #ASCPsMappedLater ascp
					INNER JOIN APP_InstanceName i WITH(NOLOCK) ON
						i.id = ascp.instance
				WHERE
					ascp.clientId = @clientId
				UNION
				SELECT
					ascp.clientId,
					11 tableType,	-- APP_BackupSetName
					1 opCode,		-- update
					@startTime,
					bs.id rowId1,
					0 rowId2,
					'' rowXmlKeys
				FROM #ASCPsMappedLater ascp
					INNER JOIN APP_BackupSetName bs WITH(NOLOCK) ON
						bs.id = ascp.backupset
				WHERE
					ascp.clientId = @clientId
				UNION
				SELECT
					ascp.clientId,
					4 tableType,	-- APP_Application
					1 opCode,		-- update
					@startTime,
					ascp.ascpId rowId1,
					0 rowId2,
					'' rowXmlKeys
				FROM #ASCPsMappedLater ascp
				WHERE
					ascp.clientId = @clientId
				UNION
				SELECT
					ascp.clientId,
					14 tableType,	-- APP_InstanceProp
					1 opCode,		-- update
					@startTime,
					ip.id rowId1,
					0 rowId2,
					'' rowXmlKeys
				FROM #ASCPsMappedLater ascp
					INNER JOIN APP_InstanceProp  ip WITH(NOLOCK) ON
						ip.componentNameId = ascp.instance
				WHERE
					ascp.clientId = @clientId
				UNION
				SELECT
					ascp.clientId,
					12 tableType,	-- APP_BackupSetProp
					1 opCode,		-- update
					@startTime,
					bsp.id rowId1,
					0 rowId2,
					'' rowXmlKeys
				FROM #ASCPsMappedLater ascp
					INNER JOIN APP_BackupSetProp bsp WITH(NOLOCK) ON
						bsp.componentNameId = ascp.backupset
					LEFT OUTER JOIN #Filters f ON
						f.tableType = 12
						AND f.attrName = bsp.attrName
				WHERE
					f.tableType IS NULL
					AND ascp.clientId = @clientId
				UNION
				SELECT
					ascp.clientId,
					5 tableType,	-- APP_SubClientProp
					1 opCode,		-- update
					@startTime,
					scp.id rowId1,
					0 rowId2,
					'' rowXmlKeys
				FROM #ASCPsMappedLater ascp
					INNER JOIN APP_SubClientProp  scp WITH(NOLOCK) ON
						scp.componentNameId = ascp.ascpId
					LEFT OUTER JOIN #Filters f ON
						f.tableType = 5
						AND f.attrName = scp.attrName
				WHERE
					f.tableType IS NULL
					AND ascp.clientId = @clientId
				UNION
				SELECT
					ascp.clientId,
					16 tableType,	-- APP_InstFilterFile
					1 opCode,		-- update
					@startTime,
					ff.id rowId1,
					0 rowId2,
					'' rowXmlKeys
				FROM #ASCPsMappedLater ascp
					INNER JOIN APP_InstFilterFile ff WITH(NOLOCK) ON
						ff.componentNameId = ascp.instance
				WHERE
					ascp.clientId = @clientId
				UNION
				SELECT
					ascp.clientId,
					15 tableType,	-- APP_BackupSetFilterFile
					1 opCode,		-- update
					@startTime,
					ff.componentNameId rowId1,
					0 rowId2,
					'' rowXmlKeys
				FROM #ASCPsMappedLater ascp
					INNER JOIN APP_BackupSetFilterFile ff WITH(NOLOCK) ON
						ff.componentNameId = ascp.backupset
				WHERE
					ascp.clientId = @clientId
				UNION
				SELECT
					ascp.clientId,
					17 tableType,	-- APP_ScFilterFile
					1 opCode,		-- update
					@startTime,
					ff.id rowId1,
					0 rowId2,
					'' rowXmlKeys
				FROM #ASCPsMappedLater ascp
					INNER JOIN APP_ScFilterFile  ff WITH(NOLOCK) ON
						ff.componentNameId = ascp.ascpId
				WHERE
					ascp.clientId = @clientId
			SET @ascpTempCnt = @@ROWCOUNT
		END
		-- Filter out rows already captured
		IF (@ascpTempCnt > 0)
		BEGIN
			INSERT INTO APP_CCSTriggerRows  (clientId, tableType, opCode, modified, rowId1, rowId2, rowXmlKeys)
				SELECT
					t.clientId,
					t.tableType,
					t.opCode,
					t.modified,
					t.rowId1,
					t.rowId2,
					t.rowXmlKeys
				FROM #TempCCSTriggerRows t
					LEFT OUTER JOIN APP_CCSTriggerRows c WITH(NOLOCK) ON
						c.clientId = t.clientId
						AND c.tableType = t.tableType
						AND c.opCode = t.opCode
						AND c.rowId1 = t.rowId1
				WHERE
					c.id IS NULL		-- insert row since not captured yet
		END
		-- done with temp table
		DROP TABLE #TempCCSTriggerRows
END_OF_BLOCK2:
		SET @returnCode = 0
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @returnCode = 1
		GOTO END_OF_PROC
	END CATCH
-- Need a specialize TableType for ASCP Deletion Cleanup
--	BEGIN TRY
--		-- ASCP being deleted.
--		-- Insert delete rows into the trigger table so that all clients
--		-- are updated for the deletion of the ASCP and its properties
--		IF OBJECT_ID('tempdb.dbo.#delASCPs') IS NOT NULL
--			DROP TABLE #delASCPs
--
--		CREATE TABLE #delASCPs (
--			clientId		INT,
--			ascpId			INT
--			PRIMARY KEY (clientId, ascpId)
--		)
--
--		INSERT INTO #delASCPs(clientId, ascpId)
--			SELECT
--				scp.componentNameId,
--				r.rowId1
--			FROM APP_CCSTriggerRows r WITH(NOLOCK)
--				INNER JOIN APP_SubClientProp scp WITH(NOLOCK) ON
--					r.tableType = 4
--					AND scp.attrName = N'Associated subclient Policy'
--					AND scp.attrVal = CAST(r.rowId1 AS NVARCHAR(12))		-- if found 1030 ASCP
--			WHERE
--				r.opCode = 2		-- deleted
--
--END_OF_BLOCK3:
--		SET @returnCode = 0
--	END TRY
--	BEGIN CATCH
--
--		$ $ (CATCH_HANDLING_MACRO)
--
--		SET @returnCode = 1
--
--		GOTO END_OF_PROC
--	END CATCH
END_OF_PROC:
	-- Does any ASCP MD5 Hashes need to be updated>
	IF EXISTS (SELECT TOP 1 ascpId FROM @ASCPHashNeedsUpdating)
	BEGIN
		DECLARE @ec INT
		DECLARE @em	NVARCHAR(1024)
		DECLARE ASCPUpdateMD5Cursor CURSOR LOCAL FORWARD_ONLY READ_ONLY FOR
			SELECT
				t.ascpId
			FROM @ASCPHashNeedsUpdating t
		OPEN ASCPUpdateMD5Cursor
		FETCH NEXT FROM ASCPUpdateMD5Cursor
			INTO @htAppId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			EXEC APPCCSMd5ASCPTableHash @ec OUTPUT, @em OUTPUT, @startTime, @htAppId, 1, 0
			IF (@ec > 0)
			BEGIN
				PRINT 'AppCCSAssociatedSubClientPolicyRows: Warning APPCCSMd5ASCPTableHash did not update MD5 Hashes for ASCPID[' + CAST(@htAppId AS VARCHAR(12)) + ']'
			END
			FETCH NEXT FROM ASCPUpdateMD5Cursor
				INTO @htAppId
		END
		CLOSE ASCPUpdateMD5Cursor
		DEALLOCATE ASCPUpdateMD5Cursor
	END
	IF OBJECT_ID('tempdb.dbo.#ASCPs') IS NOT NULL
		DROP TABLE #ASCPs
	IF OBJECT_ID('tempdb.dbo.#ASCPsMapped') IS NOT NULL
		DROP TABLE #ASCPsMapped
	IF OBJECT_ID('tempdb.dbo.#ASCPData') IS NOT NULL
		DROP TABLE #ASCPData
	IF OBJECT_ID('tempdb.dbo.#ASCPsMappedLater') IS NOT NULL
		DROP TABLE #ASCPsMappedLater
	IF OBJECT_ID('tempdb.dbo.#MD5HashTables') IS NOT NULL
		 DROP TABLE #MD5HashTables
	IF (@createdCcsClients = 1 AND OBJECT_ID('tempdb.dbo.#CcsClients') IS NOT NULL)
		DROP TABLE #CcsClients
	RETURN @returnCode
GO

IF EXISTS (select * from GxQscripts where name = 'AppCCSAssociatedSubClientPolicyRows')
	delete from GxQscripts where name = 'AppCCSAssociatedSubClientPolicyRows'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCCSAssociatedSubClientPolicyRows')
	delete from GXDBVersions where aliasname = 'AppCCSAssociatedSubClientPolicyRows'
GO

insert into GXDBVersions values(2, 'AppCCSAssociatedSubClientPolicyRows',  'v1.3.2.9.36.1', 'AppCCSAssociatedSubClientPolicyRows', 'v1.3.2.9.36.1')
GO

