

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCCPoperations.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCCPoperations.sp,v $ $Id: AppCCPoperations.sp,v 1.34.60.2 2018/03/27 08:16:14 jiechen Exp $";
--	+===================================================================+
--	| APPCCPoperations - PRIMARY ENTRY POINT FOR ALL CCP OPS			|
--	+===================================================================+
-- IdNAmeList needs to be moved out to some common location,  but for now OK to leave here
DECLARE @typeId as int = ISNULL((select TYPE_Id('dbo.IdNameList')), 0)
IF @typeId = 0
	CREATE TYPE dbo.IdNameList AS TABLE
	(
		id		integer,
		name	varchar(1024)
	)
GO
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppCCPoperations <<<'

IF EXISTS (select * from sysobjects where name='AppCCPoperations')
	drop procedure AppCCPoperations
IF EXISTS (select * from GxQscripts where name='AppCCPoperations')
	delete from GxQscripts where name = 'AppCCPoperations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCCPoperations')
	delete from GXDBVersions where aliasname = 'AppCCPoperations'
GO
print '... Creating Procedure: AppCCPoperations'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCCPoperations
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
-----------------------------------------------------------
  @ownerID int,
  @locale int,
  @xmlString nvarchar(MAX)
-----------------------------------------------------------
AS
SET NOCOUNT ON
DECLARE	@function        AS varchar(80)                = 'APPCCPoperations'
DECLARE @brAlertTrace	 AS varchar(256)               = (select value from gxglobalParam Where name = 'bralertTrace')
DECLARE	@releaseId       AS int	                       = (select Max(id) from simAllGalaxyRel)
DECLARE	@cv_STATUS_CCP   AS int                        = 0x10000						--'CV_STATUS_CCP'
DECLARE @nowTime		 AS integer						= dbo.GetUnixTime (GetUTCdate())
DECLARE	@clientId		int								-- USED IN CURSORS BELOW
DECLARE @state			int
DECLARE	@clientName	nvarchar(255)
DECLARE	@errorCode	AS integer = 0						-- BE OPTIMISTIC!
DECLARE @errorString AS varchar(2048) = ''
DECLARE @appTypeId		as int = 0
--DECLARE @ccpAppTypeId	int
DECLARE @appTypeName	nvarchar(255)
--
if @brAlertTrace <> 0
	exec br_ntTrace '.. APPCCPoperations', 0, 0, 0, 0, @xmlString
--
----------------------------------------------------------
---	HERE IS WHERE WE WILL EXTRACT THE XML TO:		   ---
----------------------------------------------------------
DECLARE @iDoc     		 int
DECLARE	@operation		 int
DECLARE @ccpId			 int
DECLARE @ccpStatus		 int
DECLARE	@ccpName		 nvarchar(255)
DECLARE	@ccpDescription  nvarchar(255)
DECLARE @cloneId		int
DECLARE @cloneName		nvarchar(255)
----------------------------------------------------------
DECLARE @ClientList table
	(
		[clientId]    integer NOT NuLL,
[clientName]  nvarchar(255) NOT NuLL,
		[state]		  integer NOT NuLL
	)
--
DECLARE @AppTypeList table
	(
		[appTypeId]    integer NOT NuLL,
[appTypeName]  nvarchar(255) NOT NuLL,
		[state]		  integer NOT NuLL
	)
-----------------------------------------------
--- SOME CONVENIENCE VARIABLES				---
-----------------------------------------------
DECLARE	@clientAddedCount	 AS integer = 0
DECLARE	@clientDeletedCount	 AS integer = 0
DECLARE	@appTypeAddedCount	 AS integer = 0
DECLARE	@appTypeDeletedCount AS integer = 0
DECLARE @clientCcpId int					-- current CCPId of client being operated on
BEGIN TRY
-----------------------------------------------
--- EXTRACT FROM THE XML					---
-----------------------------------------------
	exec sp_xml_preparedocument @iDoc OUTPUT, @xmlString
	set @operation		=  ISNULL((select * from OPENXML(@iDoc, 'EVGui_AppCCPoperationsReq', 0)
							WITH (operation int '@operation')), 0)
	set @ccpName		=  ISNULL((select * from OPENXML(@iDoc, 'EVGui_AppCCPoperationsReq/ccpName', 0)
							WITH (clientName nvarchar(255) '@clientName')), '')
	set @ccpId			=  ISNULL((select * from OPENXML(@iDoc, 'EVGui_AppCCPoperationsReq/ccpName', 0)
							WITH (clientId int '@clientId')), 0)
	set @ccpDescription	=  ISNULL((select * from OPENXML(@iDoc, 'EVGui_AppCCPoperationsReq', 0)
WITH (description nvarchar(255) '@description')), @ccpDescription)
	set @cloneName		=  ISNULL((select * from OPENXML(@iDoc, 'EVGui_AppCCPoperationsReq/cloneName', 0)
							WITH (clientName nvarchar(255) '@clientName')), '')
	set @cloneId		=  ISNULL((select * from OPENXML(@iDoc, 'EVGui_AppCCPoperationsReq/cloneName', 0)
							WITH (clientId int '@clientId')), 0)
	IF	@ccpId = 0
		SET @ccpId 	=  ISNULL((Select id from App_client WHERE name = @ccpName), 0)
	IF	@cloneId = 0
		SET @cloneId 	=  ISNULL((Select id from App_client WHERE name = @cloneName), 0)
	set @ccpStatus 		=  ISNULL((Select status from App_client where id = @ccpId), 0)
	IF @ccpId <> 0 AND (@ccpStatus & @cv_STATUS_CCP) = 0
	BEGIN
		SET @errorCode = 1
		IF EXISTS (SELECT * FROM APP_Client WHERE id = @ccpId)
			SET @errorString='A client with the name ['+@ccpName +'] already exists and is not a CCP'
		ELSE
		  BEGIN
			SET @errorString='No client or CCP ith the name ['+@ccpName +'] exists.'
			GOTO APPCCP_EXIT
		  END
	END
--
--
--
	------------------------------------------------
	--- FETCH LIST OF CLIENTS ALREADY IN THE CCP ---
	------------------------------------------------
	INSERT INTO @ClientList (clientId, clientName, state)
SELECT id, name, 0										--'OPERATION_NONE'
		FROM App_Client
		WHERE ccpId = @ccpId
		  AND (status & @cv_STATUS_CCP ) = 0
		  -- (Skip CCP definition itself!)
--
	------------------------------------------
	--- FETCH LIST OF CLIENTS TO BE ADDED ----
	------------------------------------------
	INSERT INTO  @ClientList (clientId, clientName, state)
SELECT clientId, clientName, 1								-- 'OPERATION_ADD'
      FROM OPENXML(@iDoc, 'EVGui_AppCCPoperationsReq/clientsAdded', 0)
        WITH (clientId  int, clientName nvarchar(255))
WHERE clientId not in (Select clientId from @ClientList where state = 0)	-- Don't want the ones that were added previously!
    SET @clientAddedCount = @@rowCount
--
	---------------------------------------------
	--- FETCH LIST OF CLIENTS TO BE DELETED -----
	---------------------------------------------
	INSERT INTO  @ClientList (clientId, clientName, state)
SELECT clientId, clientName, 2							--'OPERATION_DELETE'
      FROM OPENXML(@iDoc, 'EVGui_AppCCPoperationsReq/clientsDeleted', 0)
        WITH (clientId  int, clientName nvarchar(255))
    SET @clientDeletedCount = @@rowCount
--
--
	--==========================================================================================---
	--- VERIFY THAT THERE ARE NO JOBS RUNNING FOR ANY CLIENT THAT COULD BE AFFECTED BY THIS CCP ---
	--- THIS "COULD" BE SMARTER AND CHECK FOR AppTypes TOO, BUT C++ CODE DOESN'T DO THIS!		---
	--==========================================================================================---
	IF EXISTS (SELECT * FROM JMBkpJobInfo WHERE applicationID in (SELECT id from APP_Application where clientId in (Select clientId from @ClientList)))
	BEGIN
		SET @errorString = 'There are jobs running for the current clients or clients to be added or deleted.'
		SET @errorCode = 0x0A0014											--From AppMgr\Errors.h: 'CV_ERROR_JOBS_RUNNING'
		GOTo APPCCP_EXIT
	END
	------------------------------------------------------------------------------
	--	FETCH LIST OF EXISTING APPLICATIONS IN CCP 								--
	--	~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~								--
	--  NOTE THAT WE WILL NOT NCLUDE APPS TO BE ADDED THAT ARE ALREADY 			--
	--	.. ASSOC. WITH THIS CCP, ONLY NEW ONES AND THOSE ABOUT TO BE DELETED	--
	--  .. WILL NEED SPECIAL PROCESSING FOR 'CV_APPTYPE_CCP_ALL_IDATAAGENTS'	--
	------------------------------------------------------------------------------
	INSERT INTO @AppTypeList (appTypeId, appTypeName, state)
SELECT DISTINCT appTypeId, (select name from APP_IDATYPE where type=appTypeId), 0			--'OPERATION_NONE'
		FROM  APP_IdaName
		WHERE clientId = @ccpId
	-----------------------------------------------
	--- FETCH LIST OF APPLICATIONS TO BE ADDED ----
	-----------------------------------------------
	INSERT INTO  @AppTypeList (appTypeId, appTypeName, state)
SELECT appTypeId, name, 1									--'OPERATION_ADD'
      FROM OPENXML(@iDoc, 'EVGui_AppCCPoperationsReq/appTypesAdded', 0)
        WITH (appTypeId  int, name nvarchar(255))
    WHERE appTypeId not in (Select appTypeId from @AppTypeList where state = 0)  -- Don't want the ones that were added previously!
    SET @appTypeAddedCount = @@rowCount
	-------------------------------------------------
	--- FETCH LIST OF APPLICATIONS TO BE DELETED ----
	-------------------------------------------------
	INSERT INTO  @AppTypeList (appTypeId, appTypeName, state)
SELECT appTypeId, name, 2								--'OPERATION_DELETE
      FROM OPENXML(@iDoc, 'EVGui_AppCCPoperationsReq/appTypesDeleted', 0)
        WITH (appTypeId  int, name nvarchar(255))
    SET @appTypeDeletedCount = @@rowCount
/*
	select step='debug 01', operation=@operation, ccpName=convert(varchar(20),@ccpName), ccpDescription=convert(varchar(20),@ccpDescription),
		 clientAddedCount=@clientAddedCount, clientDeletedCount=@clientDeletedCount,
		 appTypeAddedCount=@appTypeAddedCount, appTypeDeletedCount=@appTypeDeletedCount
*/
	EXEC sp_xml_removedocument @idoc
--=====================================================================
--======================   OPERATION 'ADD'    =========================
--=====================================================================
IF	@operation = 1
	BEGIN
	--------------------------------------------------------------
	--	CREATE THE ENTRY IN THE CLIENT TABLE FOR THE NEW CCP	--
	--  .. Note, no clients or appTypes are associated 			--
	--  .. during "ADD" Operation								--
	--------------------------------------------------------------
	--
		IF @ccpId <> 0
		BEGIN
			SET @errorCode = 1
			SET @errorString='A CCP or client with the name ['+@ccpName +'] already exists.'
			GOTO APPCCP_EXIT
		END
		INSERT App_Client(name, simOperatingSystemId, net_hostname, client_password, refTime, modified, offlineEntity,
						  offlineTimeStamp, csHostName, clientDescription, jobResultDir, clientSkewTime, cvdPort,
						  evmgrcPort, status, releaseId, spaceCheckFlags, origCCId, GUID)
			  Select @ccpName, simOperatingSystemId, 'NO_NETHOSTNAME for '+@ccpName, client_password, @nowTime, 0, offlineEntity,
					offlineTimeStamp, 'NO HOSTNAME',  @ccpDescription, 'NO DIR', clientSkewTime, 0,
					0, @cv_STATUS_CCP, @releaseId, 0, 2 ,newid()
				FROM App_Client
				WHERE id=2				  -- (USE CS Client as a prototype)
--
		SET @ccpId = @@identity
		UPDATE App_Client SET ccpId = @ccpId WHERE id=@ccpId
		SET @errorCode = 0
		GOTO APPCCP_EXIT
	END
--=====================================================================
--======================   OPERATION 'UPDATE'   =======================
--=====================================================================
--	TODO  DO WE HAVE TO UPDATE DESCRIPTION, ETC ,, HERE TOO?  ---
IF	@operation = 3
BEGIN
	DECLARE @ActiveApps  dbo.IdNameList				-- This is the list of applications that will be part of the CCP if successful
--
	IF @ccpId = 0
	BEGIN
		SET @errorCode = 1
		SET @errorString='No CCP with the name ['+@ccpName +'] exists.'
		GOTO APPCCP_EXIT
	END
--
	INSERT @ActiveApps(id, Name)					-- Need this IF one of he application types is 'CV_APPTYPE_CCP_ALL_IDATAAGENTS'
		SELECT DISTINCT appTypeId, appTypeName		-- .. to pass down to called stored procs so they know which appTypes to 'skip'
			FROM @appTypeList
WHERE state <> 2			-- 'OPERATION_DELETE'
	--
	------------------------------------------------------
	--- ADD/DELETE THE APPTYPES TO/FROM THE CCP FIRST  ---
	------------------------------------------------------
	DECLARE	appTypeCursor CURSOR
	FOR
	SELECT DISTINCT appTypeId, appTypeName, state
		FROM @AppTypeList
WHERE state <> 0    -- 'OPERATION_NONE'
--
	OPEN appTypeCursor
	FETCH NEXT from appTypeCursor INTO @appTypeId, @appTypeName, @state
	WHILE @@FETCH_STATUS = 0
	BEGIN
--
IF @state = 1			--'OPERATION_ADD'
			EXEC AppCCP_iDa_Template @ccpId, @AppTypeId, @errorCode output, @errorString output
--
ELSE IF @state = 2		--'OPERATION_DELETE'
			EXEC AppCCPdecouple @ccpId, 0, @appTypeId, @ActiveApps, @errorCode output, @errorString output
--
		IF @errorCode <> 0
				GoTo APPCCP_EXIT
--
		FETCH NEXT from appTypeCursor INTO @appTypeId, @appTypeName, @state
	END
	CLOSE		appTypeCursor
	DEALLOCATE	appTypeCursor
-------------------------------
--	NOW ADD/DELETE CLIENTS:	---
-------------------------------
	DECLARE	clientCursor CURSOR
	FOR
	SELECT DISTINCT clientId, clientName, state
		FROM @ClientList
--  TODO:  NEED A "NEW" TEMP APPTYPE TABLE TO STORE CLIENT SPECIFIC APPTYPES, JUST IN CASE ONE OF THE
--	APPTYPES SENT FROM THE GUI IS THE "ALL APPTYPES" PSEUDO APPTYPE!!!!!
	OPEN clientCursor
	FETCH NEXT FROM clientCursor INTO @clientId, @clientName, @state
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @clientCcpId = ISNULL((select ccpId from App_Client where id = @clientId), 0)
IF @clientCcpId <> 0 AND @clientCcpId <> @ccpId  AND @state <> 2   -- 'OPERATION_DELETE
		BEGIN
			SET @errorCode = 1
			SET @errorString='Attempt to add client ['+@clientName +'] to Policy [' + @ccpName + '].  Client already part of Policy ['
                			+ ISNULL((select name from app_client where id = @clientccpId), 'Unknown') + '].'
			GOTO APPCCP_EXIT
		END
--
If @state = 0 AND @clientCcpId = 0		--'OPERATION_NONE'
SET @state = 1						-- "Should never happen, but just in case, force 'OPERATION_ADD'
--
--		--------------------------
--		ADD A CLIENT TO THE CCP	--
--		--------------------------
if @state = 1										--'OPERATION_ADD'
		  BEGIN
			IF @clientCcpId = @ccpId									-- ALREADY ADDED, IGNORE REQUEST
				GOTO UPDATE_CLIENT_APPS
--
			-------------------------------------------------------------------------------------------------------
			-- MAKE ThIS CLIENT PART OF THE CCP.  AGE OFF ANY CCP PROPERTIES CURRENTLY DEFINED FOR THE CLIENT	---
			-- AND ADD  ANY PROPERTIES DEFINED FOR THE CCP AT THE CLIENT LEVEL									---
			-------------------------------------------------------------------------------------------------------
--			SELECT DEBUG='phase 3, adding client', @clientId, clientName=convert(char(20), @clientName)
			UPDATE App_Client SET ccpId = @ccpId, ccpTime = @nowTime
				WHERE id = @clientId  														-- NOW PART OF CCP
--
			UPDATE App_ClientProp set modified = @nowTime 								    -- AGE OFF OLD PROPS
				Where componentNameId = @clientId
				  AND   modified = 0
				  AND	attrName In
						(Select attrName from APP_CCP_PROP
							WHERE componentLevel = 10	 --'(APP_CCP_CLIENT_LEVEL)'
							AND AppTypeId = 0
						)
			INSERT App_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)	-- ADD  CCP PROPS
				SELECT @clientId, attrName, attrType, attrVal, @nowTime, 0, @ccpId
				  FROM APP_ClientProp
					WHERE componentNameId = @ccpId AND modified = 0
--
UPDATE_CLIENT_APPS:
--			--------------------------------------------------------------------------------------------------
--			NOW THAT WE HAVE ADDED THE CLIENT, WE NOW NEED TO "ASSOCIATE" ANY IDA'S THAT MATCH THE APPs 	--
--			IN THE CPP TO THE CCP.  WE NEED TO CONSIDER:													--
--			  1. EXISTING APPS IN THE CCP FOR CLIENTS JUST ADDED												--
--			  2. NEWLY ADDED APPS FOR OLD AND NEW CLIENTS. 													--
--			  3. AS A LAST TWIST, IF ONE OF THE IDAs IS THE	"ALL IDA" PSEUDO IDA. WE NEED TO "DISCOVER" ALL	--
--               THE IDAs on THE CLIENT !NOT! EXPLICITLY LISTED	IN THE CCP APP LIST AND ASSOCIATE THEM TOO!	--													--
--			--------------------------------------------------------------------------------------------------
			DECLARE @clientAppState  integer
--
			DECLARE	appTypeCursor CURSOR
				FOR
				SELECT DISTINCT appTypeId, appTypeName, state
					FROM @AppTypeList
--					WHERE state <> OPERATION_NONE    -- WE NEED TO SEE PREVIOUSLY ADDED APPTYPES IN CASE THIS CLIENT WAS ADDED AFTERWARDS
			--
				OPEN appTypeCursor
				FETCH NEXT from appTypeCursor INTO @appTypeId, @appTypeName, @clientAppState
				WHILE @@FETCH_STATUS = 0
				BEGIN
			--
IF @clientAppState = 0 AND @state = 1			--IF APPTYPE IS OLD, BUT CLIENT JUST ADDED, TREAT AS IF APPTYPE IS NEW
SET  @clientAppSTATE=1
IF @clientAppState= 1			--'OPERATION_ADD'
IF   @appTypeId = 33
							exec AppCCP_iDa_WinFS_Push @ccpId, @clientId, @appTypeId, @errorCode output, @errorString output
ELSE IF @appTypeId= 1137
							exec AppCCP_iDa_WinFS_Push @ccpId, @clientId, @appTypeId, @errorCode output, @errorString output
						ELSE
						  BEGIN
							  SET @errorCode = 1
							  SET @errorString = 'Invalid appType .......'
						  END
						-- DO SOMETHING
			--
ELSE IF @clientAppState = 2		--'OPERATION_DELETE'
						exec AppCCP_iDa_WinFS_Push @ccpId, @clientId, @appTypeId, @errorCode output, @errorString output   -- UNCOUPLE IDA FROM CCP (NOT THE CURRENT CODE TO THE LEFT!)
			--
					IF @errorCode <> 0
							GoTo APPCCP_EXIT
			--
					FETCH NEXT from appTypeCursor INTO @appTypeId, @appTypeName, @clientAppState
				END
				CLOSE		appTypeCursor
				DEALLOCATE	appTypeCursor
--
				If @errorCode <> 0
				goto APPCCP_EXIT
		    END
		ELSE
		---------------------------------------------------
		---  UPDATE: REMOVECLIENT (WITH APPS) FROM CCP	---
		---------------------------------------------------
		  BEGIN
			exec AppCCPdecouple @ccpId, @clientId, 0, @ActiveApps, @errorCode output, @errorString output
			IF @errorCode <> 0
				GoTo APPCCP_EXIT
		  END
 --		TODOTODO   Have to do the same thing as ABOVE for ADD/DELETE APPLICATIONS!
		FETCH NEXT FROM clientCursor INTO @clientId, @clientName, @state
	END
	CLOSE		clientCursor
	DEALLOCATE	clientCursor
	SET @errorCode = 0
	GOTO APPCCP_EXIT
END
--=====================================================================
--======================   OPERATION 'DELETE'   =======================
--=====================================================================
IF	@operation = 2
BEGIN
	-- Do Some Validation First:			---
	IF @ccpId = 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'No CCP with the name ['+@ccpName + '] exists.'
		GOTO APPCCP_EXIT
	END
	-------------------------------------------
	--  GOT HERE, SO OKAY TO Delete CCP!	---
	-------------------------------------------
	exec AppCCPdelete @ccpId, @errorCode output, @errorString output
	GOTO APPCCP_EXIT
END
--=====================================================================
--======================   OPERATION 'CLONE'    =======================
--=====================================================================
IF	@operation = 115
BEGIN
	-- Do Some Validation First:			---
	IF @cloneId = 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'No CCP or Client with name ['+@ccpName + '] exists.'
		GOTO APPCCP_EXIT
	END
	IF @ccpId <> 0
	BEGIN
		SET @errorCode = 1
		SET @errorString = 'A CCP with the name ['+@ccpName + '] already exists.'
		GOTO APPCCP_EXIT
	END
	-------------------------------------------
	--  GOT HERE, SO OKAY TO CLONE THE CCP!	---
	-------------------------------------------
	exec AppCCPclone @cloneId, @ccpName, @errorCode output, @errorString output
	GOTO APPCCP_EXIT
END
--=====================================================================
--=====================   UNKNOWN OPERATION    ========================
--=====================================================================
SET		@errorCode = -1
SET		@errorString ='Unknown Operation['+convert(varchar(10), @operation) + '].'
GOTO APPCCP_EXIT
END TRY
--=====================================================================
--==============  COME HERE IF THERE WAS A PROBLEM!     ===============
--=====================================================================
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode	 = 1
	SET @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
APPCCP_EXIT:
--
-----------------------------------------------------------
---  CLEAN UP ANY CURSORS LEFT OPEN						---
-----------------------------------------------------------
--
IF ( CURSOR_STATUS('global', 'appTypeCursor') >= 0 	OR CURSOR_STATUS('local', 'appTypeCursor') >= 0 )
BEGIN
	CLOSE		appTypeCursor
	DEALLOCATE	appTypeCursor
END
IF ( CURSOR_STATUS('global', 'clientCursor') >= 0 	OR CURSOR_STATUS('local', 'clientCursor') >= 0 )
BEGIN
	CLOSE		clientCursor
	DEALLOCATE	clientCursor
END
--------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
SELECT  1                    as TAG,
        NULL                 as Parent,
    @errorCode               as [CVGui_GenericResp!1!errorCode],
    @errorString             as [CVGui_GenericResp!1!errorMessage]
FOR XML EXPLICIT
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppCCPoperations')
	delete from GxQscripts where name = 'AppCCPoperations'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCCPoperations')
	delete from GXDBVersions where aliasname = 'AppCCPoperations'
GO

insert into GXDBVersions values(2, 'AppCCPoperations',  '00010034006000020000', 'AppCCPoperations', '00010034006000020000')
GO

