

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCCPdelete.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCCPdelete.sp,v $ $Id: AppCCPdelete.sp,v 1.10.60.2 2018/03/27 08:09:18 jiechen Exp $";
----------------------------------------------------------------------------------------------------
--
--	AppCCPdelete	- procedure to delete a CCP and dissassociate (Decouple) any associated clients
--
----------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppCCPdelete <<<'

IF EXISTS (select * from sysobjects where name='AppCCPdelete')
	drop procedure AppCCPdelete
IF EXISTS (select * from GxQscripts where name='AppCCPdelete')
	delete from GxQscripts where name = 'AppCCPdelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCCPdelete')
	delete from GXDBVersions where aliasname = 'AppCCPdelete'
GO
print '... Creating Procedure: AppCCPdelete'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCCPdelete
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
----------------------------------------------------------
  @i_ccpId integer,
  @errCode integer			OUTPUT,
  @errString varchar(1024)	OUTPUT
AS
SET NOCOUNT ON
IF object_id('tempdb.dbo.#applicationList') is not null
		DROP TABLE #applicationList
	CREATE TABLE #applicationList
	(
		[id]    		integer NOT NuLL,
		[clientId]  	integer NOT NuLL,
		[appTypeId]		integer NOT NuLL,
		[instance]		integer NOT NuLL,
		[backupSet]		integer NOT NuLL,
		[iDaId]			integer NOT NuLL,		-- NOT SURE IF THIS IS NEEDED OR NOT!
		[ccPId]			integer NOT NuLL
	)
-----------------------------------------------------------
-- CONVENIENCE DEFS  --
DECLARE @nowTime		AS integer = dbo.GetUnixTime (GetUTCdate())
DECLARE	@cv_STATUS_CCP	AS integer = 0x10000						--'CV_STATUS_CCP'
SET		@errCode	=0			-- 'DB_OK'
SET		@errString	='Succeeded.'
-----------------------------------------------------------
-- LOCAL DEFS
DECLARE @ccp_idaNameId		int
DECLARE	@ccp_instanceId		int
DECLARE	@ccp_backupsetId	int
DECLARE @ccp_subClientId	int
DECLARE @myStatus int
DECLARE	@ccpName			nvarchar(255)
-----------------------------------------------------------
BEGIN TRY
	SET @myStatus = ISNULL((select status from app_client where id = @i_ccpId),0)
	IF  (@myStatus & @cv_STATUS_CCP) = 0
	BEGIN
		SET @ccpName=ISNULL((select name from app_client where id = @i_ccpId), 'Unknown('+convert(varchar(5), @i_ccpId)+')')
		SET @errCode = 1
		SET @errString = '['+@ccpName + '] is not a Client Configuration Policy.'
	END
---  	APP_APPLICATION TABLE WILL BE "DIPPED" INTO A LOT.  CREATE A TEMP TABLE TO DO
---		ALL THE SUBQUERIES WITH.
    INSERT #applicationList
	  SELECT id, clientId, appTypeId, instance, backupSet, 0, ccpId
		FROM APP_APPLICATION
		   WHERE clientId = @i_ccpId
	UPDATE #applicationList								-- Do we really need this?
		SET idaId = ISNULL((select id from APP_IdaName
							where APP_IdaName.clientId = #applicationList.clientId
							  and APP_IdaName.appTypeId = #applicationList.appTypeId),0)
	------------------------
	UPDATE APP_SCFILTERFILE		SET ccpId = 0 				WHERE ccpID in (SELECT id from #applicationList) --Decouple Associated Objects
	UPDATE APP_SUBCLIENTPROP	SET ccpId = 0 				WHERE ccpID in (SELECT id from #applicationList)
	UPDATE APP_APPLICATION		SET ccpId = 0, ccpTime = 0 	WHERE ccpID in (SELECT id from #applicationList)
	Delete APP_SCFILTERFILE									WHERE componentNameId in (SELECT Id from #applicationList)		 --Delete CCP Content
	Delete APP_SUBCLIENTPROP								WHERE componentNameId in (SELECT Id from #applicationList)
	Delete APP_APPLICATION									WHERE id              in (SELECT Id from #applicationList)
	-----------------------
	UPDATE APP_BACKUPSETPROP	SET ccpId = 0				WHERE ccpID			 	in (Select Distinct backupset From #applicationList)
	UPDATE APP_BACKUPSETNAME	SET ccpId = 0, ccpTime = 0	WHERE ccpID 			in (Select Distinct backupset From #applicationList)
	Delete APP_BACKUPSETPROP								WHERE componentNameId	in (Select Distinct backupset From #applicationList)
	Delete APP_BACKUPSETNAME								WHERE ID    			in (Select Distinct backupset From #applicationList)
	------------------------
	--	InstanceProp, not checking against id=1 here because there should be no properties EVER against the "default" instance
	UPDATE APP_INSTANCEPROP		SET ccpId = 0				WHERE ccpID				in (Select Distinct instance From #applicationList)
	UPDATE APP_INSTANCENAME		SET ccpId = 0, ccpTime = 0	WHERE ccpID 			in (Select Distinct instance From #applicationList)
	Delete APP_INSTANCEPROP									WHERE componentNameId 	in (Select Distinct instance From #applicationList)
	Delete APP_INSTANCENAME									WHERE Id			 	in (Select Distinct backupset From #applicationList) AND id <> 1
	------------------------
	UPDATE APP_IDAPROP			SET ccpId = 0				WHERE ccpID 			in (Select Distinct iDaId From #applicationList)
	UPDATE APP_IDANAME			SET ccpId = 0, ccpTime = 0	WHERE ccpID 			in (Select Distinct iDaId From #applicationList)
	Delete APP_IDAPROP										WHERE componentNameId	in (Select Distinct iDaId From #applicationList)
	Delete APP_IDANAME										WHERE id				in (Select Distinct iDaId From #applicationList)
	------------------------
	UPDATE APP_CLIENTPROP		SET ccpId = 0				WHERE ccpID 			in (Select Distinct clientId From #applicationList)
	UPDATE APP_CLIENT			SET ccpId = 0, ccpTime=0	WHERE ccpID 			in (Select Distinct clientId From #applicationList)
	Delete APP_CLIENTPROP									WHERE componentNameId	in (Select Distinct clientId From #applicationList)
	Delete APP_CLIENT										WHERE id				in (Select Distinct clientId From #applicationList)
	------------------------
	-- ??
	Delete App_BackupsetName								WHERE ccpId = @i_ccpId AND (status & @cv_STATUS_CCP) <> 0
	Delete App_IdaName										WHERE ccpId = @i_ccpId AND (status & @cv_STATUS_CCP) <> 0
	Delete APP_ClientProp									WHERE componentNameId in (select id from APP_Client WHERE ccpId = @i_ccpId AND (status & @cv_STATUS_CCP) <> 0)
	Delete App_Client										WHERE ccpId = @i_ccpId AND (status & @cv_STATUS_CCP) <> 0
	GOTO CCP_EXIT
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
BEGIN
    set @errCode = ERROR_NUMBER()
    set @errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END
END CATCH
CCP_EXIT:
IF object_id('tempdb.dbo.#applicationList') is not null
		DROP TABLE #applicationList
GO
/*
select * from app_client where ccpId <> 0
declare @ccpId int
declare @errorCode int
declare @errorString varchar(2048)
set     @ccpId	=93
exec AppCCPdelete @ccpId, @errorCode output, @errorString output
select errorcode=@errorCode, errorString=@errorString
Go
*/

IF EXISTS (select * from GxQscripts where name = 'AppCCPdelete')
	delete from GxQscripts where name = 'AppCCPdelete'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCCPdelete')
	delete from GXDBVersions where aliasname = 'AppCCPdelete'
GO

insert into GXDBVersions values(2, 'AppCCPdelete',  '00010010006000020000', 'AppCCPdelete', '00010010006000020000')
GO

