

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCCPdefinitionReq.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCCPdefinitionReq.sp,v $ $Id: AppCCPdefinitionReq.sp,v 1.4.60.2 2018/03/27 08:17:40 jiechen Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppCCPdefinitionReq -
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppCCPdefinitionReq <<<'

IF EXISTS (select * from sysobjects where name='AppCCPdefinitionReq')
	drop procedure AppCCPdefinitionReq
IF EXISTS (select * from GxQscripts where name='AppCCPdefinitionReq')
	delete from GxQscripts where name = 'AppCCPdefinitionReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCCPdefinitionReq')
	delete from GXDBVersions where aliasname = 'AppCCPdefinitionReq'
GO
print '... Creating Procedure: AppCCPdefinitionReq'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCCPdefinitionReq
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
-----------------------------------------------------------
  @ownerID int,
  @ccpId int,
  @ccpName nvarchar(1024)
AS
SET NOCOUNT ON
DECLARE @errorCode 		AS integer = 0
DECLARE @errorString 	AS varchar(2048) = ''
DECLARE @function  		AS varchar(80)= 'AppCCPdefinitionReq'
DECLARE @cv_STATUS_CCP  AS integer= convert(int,0x10000)		-- 'CV_STATUS_CCP'
DECLARE @status			AS integer = 0
DECLARE @description	AS varchar(2048) = ''
BEGIN TRY
	-----------------------------------
	--	SOME BASIC CHECKING FIRST	---
	-----------------------------------
	If @ccpId = 0
		SET @ccpId = IsNuLL((select id from App_Client Where name = @ccpName And (Status &@cv_STATUS_CCP) <> 0), 0)
	IF @ccpId = 0
	BEGIN
		Set @errorString = 'Invalid CCPName[' + @CCPName + '], CCPId[' + CONVERT(Varchar(10), @ccpId) + '] specified'
		SET @errorCode = 1
		GOTO APPCCP_EXIT
	END
	-----------------------------------
	-- RETURN REQUESTED DATA 		---
	-----------------------------------
	SELECT @status=status, @description=clientDescription FROM APP_Client WHERE id=@ccpId
	SELECT	1	    	AS TAG,
		NuLL	    	AS Parent,
		NuLL        	AS [EVGui_AppCCPGetCCPdefinionResp!1],
		@status			AS [EVGui_AppCCPGetCCPdefinionResp!1!doNotPushStatus],
		@description	AS [EVGui_AppCCPGetCCPdefinionResp!1!description],
		NuLL			AS [clientList!2!clientId],
		NuLL			AS [clientList!2!clientName],
		NuLL			AS [appTypeList!3!appTypeId],
		NuLL			AS [appTypeList!3!name]
	UNION ALL
	SELECT 2,1 , NuLL,
			NuLL,NuLL,
			id,   name,
			NuLL, NuLL
	FROM app_client where [ccpId] = @ccpId AND id <> @ccpId
	UNION ALL
	SELECT 3,1, NuLL,
		NuLL, NuLL,
		NuLL, NuLL,
		appTypeId, name=(select name from APP_iDAType where type =appTypeId)
		FROM app_idaName
		WHERE clientId=@ccpId
	FOR XML EXPLICIT
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
--	=====================================================================
--	==============  COME HERE IF THERE WAS A PROBLEM!     ===============
--	=====================================================================
	SET @errorCode	 = 1
	SET @errorString = 'Problems Executing [' + @function +'] Error Message [' + ERROR_MESSAGE() + '].'
END CATCH
-- IF, NO ERROR, XML ABOVE IS RETURNED, OTHERWISE RETURN A "GENERIC RESPONSE" MESSAGE --
APPCCP_EXIT:
	IF @errorCode <> 0
	BEGIN
		SELECT  1                    AS TAG,
				NuLL                 AS Parent,
				@errorCode               AS [CVGui_GenericResp!1!errorCode],
				@errorString             AS [CVGui_GenericResp!1!errorMessage]
		FOR XML EXPLICIT
	END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppCCPdefinitionReq')
	delete from GxQscripts where name = 'AppCCPdefinitionReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCCPdefinitionReq')
	delete from GXDBVersions where aliasname = 'AppCCPdefinitionReq'
GO

insert into GXDBVersions values(2, 'AppCCPdefinitionReq',  '00010004006000020000', 'AppCCPdefinitionReq', '00010004006000020000')
GO

