

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCCPdecouple.sp] ---------- 

-- DROP PROC AppCCPdecouple
-- GO
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCCPdecouple.sp,v $ $Id: AppCCPdecouple.sp,v 1.6.60.2 2018/03/27 08:17:24 jiechen Exp $";
--
--   AppCCPdecouple -  "Unassociates" a client from a CCP
--
DECLARE @typeId as int = ISNULL((select TYPE_Id('dbo.IdNameList')), 0)
SELECT typeId=@typeId
IF @typeId = 0
CREATE TYPE dbo.IdNameList AS TABLE
(
	id		integer,
	name	varchar(1024)
)
GO
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppCCPdecouple <<<'

IF EXISTS (select * from sysobjects where name='AppCCPdecouple')
	drop procedure AppCCPdecouple
IF EXISTS (select * from GxQscripts where name='AppCCPdecouple')
	delete from GxQscripts where name = 'AppCCPdecouple'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCCPdecouple')
	delete from GXDBVersions where aliasname = 'AppCCPdecouple'
GO
print '... Creating Procedure: AppCCPdecouple'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCCPdecouple
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
-----------------------------------------------------------
  @i_ccpId integer,
  @i_clientId integer,
  @i_appTypeId integer,
  @i_idaList dbo.IdNameList  READONLY,
  @errCode integer			OUTPUT,
  @errString varchar(1024)	OUTPUT
-----------------------------------------------------------
AS
SET NOCOUNT ON
DECLARE	@function        AS varchar(80)                	= 'AppCCPdecouple'
DECLARE	@cv_STATUS_CCP   AS int                        	= 0x10000						--'CV_STATUS_CCP'
DECLARE @nowTime		 AS integer						= dbo.GetUnixTime (GetUTCdate())
DECLARE @clientStatus	 AS integer					 	= ISNULL((Select status FROM app_client WHERE id = @i_clientId), 0)
DECLARE @cName			varchar(1024)
DECLARE @idaNameId		 AS integer						= ISNULL((Select id from App_idaName where clientId = @i_ccpId AND appTypeId = @i_appTypeId), 0)
DECLARE	@clientList		AS dbo.idNameList
DECLARE @appTypeList	AS dbo.idNameList
BEGIN TRY
--SELECT Debug='step 1', i_ccpId=@i_ccpId, i_clientId=@i_clientId, i_appTypeId=@i_appTypeId, * from @i_idaList
-------------------------------------------------------------------------------
---	MOST CHECKING SHOULD HAVE BEEN DONE IN THE CALLING PROCEDURE, BUT ADD	---
---	SOME HERE, JUST IN CASE													---
-------------------------------------------------------------------------------
	IF @i_ccpId = 0
	BEGIN
		SET @errCode = 1
		SET @cName = ISNULL((Select name from app_client where id = @i_ccpId), 'Unknown ccp['+CONVERT(VARCHAR(6), @i_ccpId)+']')
		SET @errString='No CCP with the name ['+@cName +'] exists.'
		GOTO APPCCP_EXIT
	END
	IF (@clientStatus & @cv_STATUS_CCP) <> 0
	BEGIN
		SET @cName = ISNULL((Select name from app_client where id = @i_clientId), 'Unknown client['+CONVERT(VARCHAR(6), @i_clientId)+']')
		SET @errCode = 1
		SET @errString='Client with the name ['+@cName +'] is a CCP, and cannot be decoupled.'
		GOTO APPCCP_EXIT
	END
DECLARE @applicationList table
	(
		[id]    		integer NOT NuLL,
		[client_id]  	integer NOT NuLL,
		[appType_Id]	integer NOT NuLL,
		[instance]		integer NOT NuLL,
		[backupSet]		integer NOT NuLL,
		[iDaId]			integer NOT NuLL,		-- NOT SURE IF THIS IS NEEDED OR NOT!
		[ccPId]			integer NOT NuLL
	)
	INSERT @clientList
		SELECT id, name FROM app_client WHERE ccpId = @i_ccpId AND id <> @i_ccpId AND (@i_clientId = 0 OR id = @i_clientId)
	INSERT @appTypeList
		SELECT DISTINCT appTypeId, '' FROM app_idaName where clientId IN (Select id from @clientList) AND (@i_apptypeId = 0 OR appTypeId = @i_appTypeId)
	INSERT @applicationList
		  SELECT id, clientId, appTypeId, instance, backupSet, 0, ccpId
		  FROM App_Application
		  WHERE clientId in (Select id from @clientList)
		    AND appTypeId in (Select id from @appTypeList)
			AND (subclientstatus & @cv_STATUS_CCP) = 0
/*
		  WHERE ccpId = @i_ccpId
			AND (@i_clientId = 0   OR clientId = @i_clientId )
			AND (@i_appTypeId = 0  OR appTypeId = @i_appTypeId)
			AND (subclientstatus & @cv_STATUS_CCP) = 0
*/
		UPDATE @applicationList
			SET idaId = ISNULL((select id from APP_IdaName
				where APP_IdaName.clientId = client_id
				  and APP_IdaName.appTypeId = appType_Id),0)
		-------------------------------------------------------------------
		-- THIS CODE WILL CLEAN UP ALL THE ASSOCIATED CLIENT OR CLIENTS ---
		-------------------------------------------------------------------
		UPDATE  App_Application 	SET ccpID=0, ccpTime=0	WHERE id				in (Select id from @applicationList)
		UPDATE  App_SCfilterFile 	SET ccpId=0 			WHERE componentNameId	in (Select  id from @applicationList)
		UPDATE  App_SubClientProp	SET ccpId=0 			WHERE componentNameId	in (Select  id from @applicationList)
		UPDATE  App_BackupsetName	SET ccpID=0, ccpTime=0	WHERE id				in (Select distinct backupset from @applicationList)
		UPDATE  App_BackupsetProp	SET ccpId=0 			WHERE componentNameId	in (Select distinct backupset from @applicationList)
		UPDATE  App_InstanceName	SET ccpID=0, ccpTime=0	WHERE id				in (Select distinct instance from @applicationList) and id <> 1
		UPDATE  App_InstanceProp	SET ccpId=0 			WHERE componentNameId	in (Select distinct instance from @applicationList) and id <> 1
		UPDATE  APP_IdaName			SET ccpID=0, ccpTime=0	WHERE id				in (Select distinct idaId from @applicationList)
		UPDATE  App_IdaProp			SET ccpId=0 			WHERE componentNameId	in (Select distinct idaId from @applicationList)
		UPDATE  App_Client			SET ccpID=0, ccpTime=0	WHERE id				= @i_clientId
		UPDATE  App_ClientProp		SET ccpId=0 			WHERE componentNameId	= @i_clientId
		-----------------------------------------------------------------------
		-- IF ClientId = 0, THAT MEANS WE ARE DELETING THE IDA COMPLETELY	---
		-- FROM THE CCP, SO CLEAN UP THE CCP ENTRIES TOO					---
		-----------------------------------------------------------------------
		if @i_clientId = 0
		BEGIN
			DeLETE @applicationList
			INSERT @applicationList
			  SELECT id, clientId, appTypeId, instance, backupSet, 0, ccpId
			  FROM App_Application
			  WHERE ccpId = @i_ccpId
				AND (@i_clientId = 0   OR clientId = @i_clientId )
				AND (@i_appTypeId = 0  OR appTypeId = @i_appTypeId)
				AND (subclientstatus & @cv_STATUS_CCP) <> 0
			UPDATE @applicationList
				SET idaId = ISNULL((select id from APP_IdaName
					where APP_IdaName.clientId = client_id
					  and APP_IdaName.appTypeId = appType_id),0)
			DeLETE APP_SubClientProp		WHERE componentNameId	in (Select id from @applicationList)
			DeLETE APP_ScFilterFile			WHERE componentNameId	in (Select id from @applicationList)
			DeLETE APP_Application			WHERE id				in (Select id from @applicationList)
			DeLETE APP_BackupSetProp		WHERE componentNameId	in (Select Distinct backupset from @applicationList)
			DeLETE APP_BackupSetName		WHERE id				in (Select Distinct backupset from @applicationList)
			DeLETE APP_InstanceProp			WHERE componentNameId	in (Select Distinct instance FROM @applicationList where instance <> 1)
			DeLETE APP_InstanceName			WHERE id				in (Select Distinct instance FROM @applicationList where instance <> 1)
			DeLETE APP_IDAProp				WHERE componentNameId	in (Select Distinct idaId from @applicationList)
			DeLETE APP_IDAName				WHERE id				in (Select Distinct idaId from @applicationList)
--			SAFETY NET: JUST IN CASE AGENT WASN'T COMPLETELY FORMED UNDER THE CCP, THE NEXT (2)
--			LINES WILL MAKE SURE THAT IT IS CLEANED UP PROPERLY!
			DeLETE APP_IDAProp				WHERE componentNameid = @idaNameId
			DeLETE APP_IDAName				WHERE id = @idaNameId
		END
	SET @errCode = 0
	GOTO APPCCP_EXIT
END TRY
--=====================================================================
--==============  COME HERE IF THERE WAS A PROBLEM!     ===============
--=====================================================================
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errCode	 = 1
	SET @errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
APPCCP_EXIT:
return @errCode
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppCCPdecouple')
	delete from GxQscripts where name = 'AppCCPdecouple'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCCPdecouple')
	delete from GXDBVersions where aliasname = 'AppCCPdecouple'
GO

insert into GXDBVersions values(2, 'AppCCPdecouple',  '00010006006000020000', 'AppCCPdecouple', '00010006006000020000')
GO

