

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCCPclone.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCCPclone.sp,v $ $Id: AppCCPclone.sp,v 1.7.60.2 2018/03/27 08:16:10 jiechen Exp $";
--	+-----------------------------------------------------------------------------------------------------------+
--	| Notes:																									|
--	| 		1  Sources for "clones", depending on whether we are cloning down to the subClient level or not		|
--	| 		   1st source is the app_application table of course, the other is the app_idaName table. Note that	|
--	| 		   unless you have app_application table entries, there is no way to tie backsets or instances to 	|
--	| 		   iDa's																							|
--	|		2. When deleting properties from proplist before cloning, we are making the assumption that the 	|
--	|		   property is specifically defined for that level and that for all appTypes, there are no props.	|
--	|		   at a given level that are "CCP'able for some IDAs and not for others.  If this ever were the		|
--	|		   case, the "DELETE #propList rule would have to be more complicated at the iDa level & below.		|
--	+-----------------------------------------------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppCCPclone <<<'

IF EXISTS (select * from sysobjects where name='AppCCPclone')
	drop procedure AppCCPclone
IF EXISTS (select * from GxQscripts where name='AppCCPclone')
	delete from GxQscripts where name = 'AppCCPclone'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCCPclone')
	delete from GXDBVersions where aliasname = 'AppCCPclone'
GO
print '... Creating Procedure: AppCCPclone'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCCPclone
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
----------------------------------------------------------
  @i_cloneId integer,
  @i_ccpName varchar(1024),
  @errCode integer			OUTPUT,
  @errString varchar(1024)	OUTPUT
AS
SET NOCOUNT ON
-----------------------------------------------------------
-- CONVENIENCE DEFS  --
DECLARE @nowTime		AS integer = dbo.GetUnixTime (GetUTCdate())
DECLARE	@cv_STATUS_CCP	AS integer = CONVERT(int, 0x10000)						--'CV_STATUS_CCP'
SET		@errCode	= 0			-- 'DB_OK'
SET		@errString	=''				-- GUI Expects empty string on success, even if errCode == 0
-----------------------------------------------------------
-- LOCAL DEFS
-- Following (5) used when looping through cursor:
DECLARE @ccp_clientId		int
DECLARE @ccp_idaNameId		int
DECLARE	@ccp_instanceId		int
DECLARE	@ccp_backupsetId	int
DECLARE @ccp_subClientId	int
-----------------------------------------------------------
BEGIN TRY
IF object_id('tempdb.dbo.#applicationList') is not null
		DROP TABLE #applicationList
	CREATE TABLE #applicationList
	(
		[id]    		integer NOT NuLL,
		[clientId]  	integer NOT NuLL,
		[appTypeId]		integer NOT NuLL,
		[instance]		integer NOT NuLL,
		[backupSet]		integer NOT NuLL,
		[iDaId]			integer NOT NuLL,
		[newIDaId]		integer NOT NuLL,
		[newInstance]	integer NOT NuLL,
		[newBackupSet]	integer NOT NuLL,
		[NewSubClient]	integer NOT NuLL
	)
--	ALL "PROPS" TABLES HAVE SIMILAR ARCHITECTURE, SO WE CAN USE ONE TEMP TABLE
--	SCHEMA TO ADDRESS THEM ALL
	IF object_id('tempdb.dbo.#PropList') IS NOT Null DROP TABLE #PropList
	CREATE TABLE #PropList
   (
       id				integer,
       componentNameId  integer,
       attrName			nvarchar(1024),    --CV_MAX_PROPERTYNAME_LEN_
       attrType         integer,
       attrVal			nvarchar(MAX) NOT NuLl,
       created			integer,
       modified         integer,
       ccpId            integer
	)
--	--------------------------------------------
--  CLONE CLIENT AND ASSOCIATED PROPERTIES	----
--	--------------------------------------------
	INSERT App_Client(name, simOperatingSystemId, net_hostname, client_password, refTime, modified, offlineEntity,
	                  offlineTimeStamp, csHostName, clientDescription, jobResultDir, clientSkewTime, cvdPort,
	                  evmgrcPort, status, releaseId, spaceCheckFlags, origCCId, GUID)
	SELECT @i_ccpName, simOperatingSystemId, 'NO_NETHOSTNAME for '+@i_ccpName, client_password, @nowTime, 0, offlineEntity,
				offlineTimeStamp, 'NO HOSTNAME',  clientDescription, 'NO DIR', clientSkewTime, 0,
				0, @cv_STATUS_CCP, releaseId, 0, 2, newid()
	FROM App_Client
		WHERE id = @i_cloneId
	SET @ccp_clientId = @@IDENTITY			-- This is our new CCP!
	UPDATE APP_Client
	SET ccpId = @ccp_clientId, ccpTime=@nowTime
		WHERE id = @ccp_clientId
	DELETE #PropList	-- Always start with an empty list
	INSERT #PropList(componentNameId,attrName,attrType,attrVal,created,modified,ccpId)
		SELECT @ccp_clientId, attrName, attrType, attrVal, @nowTime, 0, @ccp_clientId
		FROM APP_ClientProp
			WHERE componentNameId = @i_cloneId AND modified = 0
	DELETE #PropList
WHERE attrName not in (Select attrName from APP_CCP_prop WHERE componentLevel = 10)			-- AppMgrDefines.h: 'APP_CCP_CLIENT_LEVEL'
	INSERT APP_ClientProp (componentNameId,attrName,attrType,attrVal,created,modified,ccpId)
		SELECT componentNameId,attrName,attrType,attrVal,created,modified,ccpId
		FROM #PropList
--	+-------------------------------------------+
--	| CREATE THE LIST OF OBJECTS TO BE CLONED:	|
--	+-------------------------------------------+
	INSERT #applicationList
		SELECT id, clientId, appTypeId, instance, backupset, 0,    0,0,0,0
			FROM app_application
			WHERE clientId = @i_cloneId
	INSERT #applicationList
		SELECT 0, clientId, appTypeId, 0,0,0,  0,0,0,0
		FROM APP_IDANAME
		WHERE clientId = @i_cloneId
		  AND appTypeId NOT IN (select distinct appTypeId from #applicationList)
	UPDATE #applicationList
       SET idaId = ISNULL((select id from APP_IdaName
                           where APP_IdaName.clientId = #applicationList.clientId
                             and APP_IdaName.appTypeId = #applicationList.appTypeId),0)
	UPDATE #applicationList							-- InstanceId == 1 is a placeholder, make sure it is preserved!
		Set newInstance = instance
		WHERE instance = 1
--	+===============================================+
--	| NOW LOOP FOR ALL THE ENTRIES IN THE TABLE:	|
--	+===============================================+
	DECLARE @xId int, @xClientId int, @xAppTypeId int, @xInstance int, @xBackupset int, @xIdaId int;
	DECLARE	cloneCursor CURSOR  FOR
		SELECT distinct id, clientId, appTypeId, instance, backupset, idaId	From #applicationList
		OPEN cloneCursor
		FETCH NEXT from cloneCursor INTO @xId, @xClientId, @xAppTypeId, @xInstance, @xBackupSet, @xIdaId
		WHILE @@FETCH_STATUS = 0
		BEGIN
--			SELECT step='Looping', xid=@xId, appTypeId=@xappTypeId, xInstance=@xInstance, BackupSet = @xBackupSet, xIdaId=@xIdaId
--			-------------------------------------------------
--			--- SEE IF WE (STILL) NEED TO CLONE THE IDA:  ---
--			-------------------------------------------------
			IF EXISTS (Select * from #applicationList WHERE appTypeId = @xappTypeId AND newIDaId = 0)
			BEGIN
--				SELECT 'Processing appType [' + Convert(varchar(10), @xappTypeId) + '], ida[' + CONVERT(varchar(10), @xIdaId) + ']'
				INSERT APP_IdAName(clientId, appTypeId, status, refTime, modified, ccpId, ccpTime)
					VALUES (@ccp_clientId, @xappTypeId, @cv_STATUS_CCP, @nowTime, 0, @ccp_clientId, @nowTime)
				SET @ccp_idaNameId = @@IDENTITY
				UPDATE #applicationList
					SET newIdaId = @CCP_idaNameId
						WHERE appTypeId = @xappTypeId
				DELETE #PropList	-- CLEAN UP FROM PREV. USE
				INSERT #PropList(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
					SELECT @ccp_IdaNameId, attrName, attrType, attrVal, @nowTime, 0, @ccp_clientId
					FROM APP_IDAPROP
						WHERE componentNameId = @xIdaId
						  AND modified = 0
				DELETE #PropList 	-- DON'T CLONE PROPERTIES THAT ARE NOT CCP PROPERTIES
WHERE attrName not in (Select attrName from APP_CCP_prop WHERE componentLevel = 20)			-- AppMgrDefines.h: 'APP_CCP_IDA_LEVEL'
				INSERT APP_IDAPROP(componentNameId,attrName,attrType,attrVal,created,modified,ccpId)
					SELECT componentNameId, attrName, attrType, attrVal, created, modified, ccpId
					FROM #PropList
			END
			ELSE
				SET @ccp_idaNameId = ISNULL((select distinct newIdaId from #applicationList
												where clientId = @ccp_clientId
												  and appTypeId = @xappTypeId),
												  0)
--			------------------------------------------------------
--			--- SEE IF WE (STILL) NEED TO CLONE THE INSTANCE:  ---
--			------------------------------------------------------
			IF @xInstance <> 0 AND EXISTS (Select * from #applicationList Where appTypeId = @xAppTypeId AND instance=@xInstance AND newInstance = 0)
			BEGIN
--				SELECT 'Processing appType [' + Convert(varchar(10), @xappTypeId) + '], instance[' + CONVERT(varchar(10), @xInstance) + ']'
				INSERT APP_InstanceName(name,refTime,modified,status,ccpId,ccpTime, origCCId, GUID)
					SELECT name, @nowTime, 0, @cv_STATUS_CCP, @ccp_clientId, @nowTime, 2, newid()
					FROM APP_InstanceName
						WHERE id = @xInstance
				SET @ccp_instanceId = @@IDENTITY
				UPDATE #applicationList
					SET newInstance = @ccp_instanceId
					WHERE instance = @xInstance
				DELETE #PropList	-- CLEAN UP FROM PREV. USE
				INSERT #PropList(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
					SELECT @ccp_instanceId, attrName, attrType, attrVal, @nowTime, 0, @ccp_clientId
					FROM APP_InstanceProp
						WHERE componentNameId = @xInstance
						  AND modified = 0
				DELETE #PropList 	-- DON'T CLONE PROPERTIES THAT ARE NOT CCP PROPERTIES
WHERE attrName not in (Select attrName from APP_CCP_prop WHERE componentLevel = 30)			-- AppMgrDefines.h: 'APP_CCP_INSTANCE_LEVEL'
				INSERT APP_InstanceProp(componentNameId,attrName,attrType,attrVal,created,modified,ccpId)
						SELECT componentNameId, attrName, attrType, attrVal, created, modified, ccpId
						FROM #PropList
			END
			ELSE
				SET @ccp_instanceId = ISNULL((Select distinct newInstance From #applicationList
												Where clientId  = @xClientId
												  And appTypeId = @xappTypeId
												  And instance	= @xinstance),
												  0)
--			-------------------------------------------------------
--			--- SEE IF WE (STILL) NEED TO CLONE THE BACKUPSET:  ---
--			-------------------------------------------------------
			IF @xBackupset <> 0 AND EXISTS (Select * from #applicationList
												Where appTypeId = @xAppTypeId
												  AND instance	= @xInstance
												  AND backupSet = @xBackupset
												  AND newBackupSet = 0)
			BEGIN
--				SELECT 'Processing appType [' + Convert(varchar(10), @xappTypeId)
--								+ '], instance[' + CONVERT(varchar(10), @xInstance)
--								+ '], backupset['+ CONVERT(varchar(10), @xBackupset) + ']'
				INSERT APP_BackupsetName(name,refTime,modified,status,ccpId,ccpTime)
					SELECT name, @nowTime, 0, @cv_STATUS_CCP, @ccp_clientId, @nowTime
						FROM APP_BackupsetName
							WHERE id = @xBackupSet
				SET @ccp_backupsetId = @@IDENTITY
				UPDATE #applicationList
					SET newBackupset = @ccp_backupsetId
						WHERE backupset = @xBackupSet
				DELETE #PropList				-- CLEAN UP FROM PREV. USE
				INSERT #PropList(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
				SELECT @ccp_backupsetId, attrName, attrType, attrVal, @nowTime, 0, @ccp_clientId
					FROM APP_BackupsetProp
						WHERE componentNameId = @xBackupSet
						  AND modified = 0
				DELETE #PropList 	-- DON'T CLONE PROPERTIES THAT ARE NOT CCP PROPERTIES
WHERE attrName not in (Select attrName from APP_CCP_prop WHERE componentLevel = 40)			-- AppMgrDefines.h: 'APP_CCP_BKUPSET_LEVEL'
				INSERT APP_BackupsetProp(componentNameId,attrName,attrType,attrVal,created,modified,ccpId)
					SELECT componentNameId, attrName, attrType, attrVal, created, modified, ccpId
						FROM #PropList
			END
			ELSE
				SET @ccp_backupSetId = ISNULL((Select distinct newBackupset From #applicationList
												Where clientId  = @xClientId
												  And appTypeId = @xappTypeId
												  And instance	= @xinstance
												  And backupset = @xBackupset),
												  0)
--			----------------------------------------------
--			--- SEE IF THERE IS A SUBCLIENT TO CLONE:  ---
--			----------------------------------------------
			IF @xId <> 0
			BEGIN
				INSERT APP_Application (clientId, appTypeId, instance, backupSet, appNumber, dataArchGrpID, logArchGrpID,
											refTime, modified, subclientName, subclientStatus, ccpId, ccpTime, origCCId, GUID)
						SELECT @ccp_clientId, @xAppTypeId, @ccp_instanceId, @ccp_backupsetId, appNumber, dataArchGrpID, logArchGrpID,
											@nowTime, 0, subClientName, subClientStatus | @cv_STATUS_CCP, @ccp_clientId, @nowTime, 2, newid()
						FROM APP_Application
							Where id = @xId
				SET @ccp_subClientId = @@IDENTITY
				DELETE #PropList	-- CLEAN UP FROM PREV. USE
				INSERT #PropList(componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
				SELECT @ccp_subClientId, attrName, attrType, attrVal, @nowTime, 0, @ccp_clientId
					FROM APP_SubClientProp
						WHERE componentNameId = @xid
						  AND modified = 0
 				DELETE #PropList 	-- DON'T CLONE PROPERTIES THAT ARE NOT CCP PROPERTIES
WHERE attrName not in (Select attrName from APP_CCP_prop WHERE componentLevel = 50)			-- AppMgrDefines.h: 'APP_CCP_SUBCLIENT_LEVEL'
				INSERT APP_SubClientProp(componentNameId,attrName,attrType,attrVal,created,modified,ccpId)
					SELECT componentNameId, attrName, attrType, attrVal, created, modified, ccpId
						FROM #PropList
				INSERT APP_SCFILTERFILE(componentNameId, type, fileName, created, modified, ccpId)
					SELECT   @ccp_subClientId, type, fileName, created, modified, @ccp_clientId
						FROM APP_SCfilterFile
							WHERE  componentNameId = @xId
							  AND  modified =0
			END
NEXT_ROW:
			FETCH NEXT from cloneCursor INTO @xId, @xClientId, @xAppTypeId, @xInstance, @xBackupSet, @xIdaId
		END
--- GOT HERE, MUST BE SUCCESS!  ---
	Set @errCode = 0
	Set @errString = ''
	GOTO CCP_EXIT
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
BEGIN
    set @errCode = ERROR_NUMBER()
    set @errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END
END CATCH
CCP_EXIT:
IF object_id('tempdb.dbo.#applicationList') is not null
		DROP TABLE #applicationList
IF object_id('tempdb.dbo.#PropList') is not null
		DROP TABLE #PropList
IF ( CURSOR_STATUS('global', 'cloneCursor') >= 0 	OR CURSOR_STATUS('local', 'cloneCursor') >= 0 )
BEGIN
	CLOSE		cloneCursor
	DEALLOCATE	cloneCursor
END
GO
/*
BEGIN TRAN
DECLARE @ccpId int
DECLARE @ccpName as varchar(256) = 'CCP FROM OSCAR (STUK)'
select id, name, status, ccpId, ccpTime from app_client where ccpId <> 0
DECLARE @errCode int, @errString varchar(1024)
exec AppCCPclone 3, @ccpName, @errCode output, @errString output
select errC=@errCode, errS=@errString
set @ccpId = ISNULL((Select ID from APP_Client where name = @ccpName), 0)
select id, name, status, ccpId, ccpTime from app_client where ccpid = @ccpId
select id, name, status, ccpId, ccpTime from app_instanceName where ccpid = @ccpId
select id, name, status, ccpId, ccpTime from app_backupsetname where ccpid = @ccpId
select id, subclientname, clientId, appTypeId, instance, backupset, subClientstatus, ccpId, ccpTime
    from app_application where ccpid = @ccpId
    order by appTypeId, backupset, id
rollback tran
*/

IF EXISTS (select * from GxQscripts where name = 'AppCCPclone')
	delete from GxQscripts where name = 'AppCCPclone'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCCPclone')
	delete from GXDBVersions where aliasname = 'AppCCPclone'
GO

insert into GXDBVersions values(2, 'AppCCPclone',  '00010007006000020000', 'AppCCPclone', '00010007006000020000')
GO

