

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCCP_iDa_Template.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCCP_iDa_Template.sp,v $ $Id: AppCCP_iDa_Template.sp,v 1.6.60.2 2018/03/27 08:16:46 jiechen Exp $";
----------------------------------------------------------------------
-- EDIT HISTORY														--
-- DATE			DESCRIPTION											--
-- -----------	---------------------------------------------		--
-- 06-May-2009	Initial Edit										--
----------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppCCP_iDa_Template <<<'

IF EXISTS (select * from sysobjects where name='AppCCP_iDa_Template')
	drop procedure AppCCP_iDa_Template
IF EXISTS (select * from GxQscripts where name='AppCCP_iDa_Template')
	delete from GxQscripts where name = 'AppCCP_iDa_Template'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCCP_iDa_Template')
	delete from GXDBVersions where aliasname = 'AppCCP_iDa_Template'
GO
print '... Creating Procedure: AppCCP_iDa_Template'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCCP_iDa_Template
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
-----------------------------------------------------------
  @i_ccpId integer,
  @i_appTypeId integer,
  @errCode integer			OUTPUT,
  @errString varchar(1024)	OUTPUT
AS
SET NOCOUNT ON
-----------------------------------------------------------
-- CONVENIENCE DEFS  --
DECLARE @nowTime            AS integer	= dbo.GetUnixTime (GetUTCdate())
DECLARE	@cv_STATUS_CCP      AS integer	= 0x10000						--'CV_STATUS_CCP'
DECLARE	@cv_STATUS_DEFAULT  AS integer  = 0x00008					--'CV_STATUS_DEFAULT'
SET		@errCode	=0			-- 'DB_OK'
SET		@errString	='Succeeded.'
-----------------------------------------------------------
-- LOCAL DEFS
DECLARE @ccp_idaNameId		int
DECLARE	@ccp_backupsetId	int
DECLARE @ccp_subClientId	int
-- Following should never evaluate to 0, as this is checked by calling procedure, but ...
DECLARE	@ccpAppTypeId 		AS integer =  ISNULL((Select ccpType FROM app_idaType WHERE type = @i_appTypeId), 0)
DECLARE @ccp_instanceId		AS integer = 1
-----------------------------------------------------------
BEGIN TRY
	SET @errString = 'Called with ccpId[' + Convert(varchar(5), @i_ccpId)
			+ '], appType[' + CONVERT(varchar(5), @i_appTypeId)
			+'], (baseType=' +CONVERT(varchar(5), @ccpAppTypeId)
			+').'
	If @ccpAppTypeId = 0				-- ABSOLULTELY SHOULD NEVER HAVE TO DO THIS, BUT JIC!
	BEGIN
		Set @errCode = 1
		SET @errString = @errString +'  Error, no common appType can be determined.'
		GOTO CCP_EXIT
	END
-----------------------------------------------------------------------------
-- 'OPERATION_ADD:'														-----
-- Need to create IdaName ENTRY, BACKUPSET ENTRY, APPLICATION TABLE ENTRY	-
-- IF !IsNew, FOR EACH (EXISTING) ASSOCIATED CLIENT:						-
--	 o Add CCP Id to all APP Objects										-
--	 o Age CCP properties and content for those objects						-
-----------------------------------------------------------------------------
--
	------------------------------------------------------------------------------------
	-- IDA LEVEL:  REQUIRED FOR ALL APPTYPES										----
	------------------------------------------------------------------------------------
	INSERT APP_IDAName (clientId, appTypeId, status, refTime, modified, ccpId, ccpTime)
		VALUES (@i_ccpId, @ccpAppTypeId, @cv_STATUS_DEFAULT+@cv_STATUS_CCP, @nowTime, 0, @i_ccpId, @nowTime)
	SET @ccp_idaNameId = @@Identity
	------------------------------------------------------------------------------------
	-- INSTANCE LEVEL: FOR RIGHT NOW, EVERYONE EXCEPT FILESYSTEM					----
	------------------------------------------------------------------------------------
IF @ccpAppTypeId <> 33
	BEGIN
		INSERT App_InstanceName(name, refTime, modified, status, ccpId, ccpTime, origCCId, GUID)
			VALUES ('defaultInstance', @nowTime, 0, @cv_STATUS_DEFAULT+@cv_STATUS_CCP, @i_ccpId, @nowTime, 2, newid())
		SET @ccp_instanceId = @@Identity
	END
	------------------------------------------------------------------------------------
	--	BACKUPSET LEVEL: FOR RIGHT NOW, REQUIRED FOR ALL APPTYPES					----
	------------------------------------------------------------------------------------
	INSERT APP_BACKUPSETNAME(name, refTime, modified, status, ccpId, ccpTime)
		VALUES ('defaultBackupSet', @nowTime, 0, @cv_STATUS_DEFAULT+@cv_STATUS_CCP, @i_ccpId, @nowTime)
	SET @ccp_backupsetId = @@identity
	------------------------------------------------------------------------------------
	--	SUBCLIENT LEVEL: FOR RIGHT NOW, REQUIRED FOR ALL APPTYPES, BUT 				----
	--					 NOT ALL GET CONTENT!										----
	------------------------------------------------------------------------------------
	INSERT APP_APPLICATION (clientId, appTypeId, instance, backupSet, appNumber, dataArchGrpId, logArchGrpId,
							 reftime, modified, subClientName, subclientStatus, ccpId, ccpTime, origCCId, GUID)
		VALUES (@i_ccpId, @ccpAppTypeId, @ccp_instanceId, @ccp_backupsetId, 0, 1, 1,
					@nowtime, 0, 'default', @cv_STATUS_DEFAULT+@cv_STATUS_CCP, @i_ccpId, @nowTime, 2, newid())
	SET @ccp_subclientId = @@Identity
IF @ccpAppTypeId = 33		--'CV_CCPTYPE_FILESYSTEM'
	BEGIN
		INSERT APP_SCFILTERFILE(componentNameId, Type, filename, created, modified, ccpId)
			VALUES(@ccp_subClientId, 1, '\', @nowTime, 0, @i_ccpId)
	END
	GOTO CCP_EXIT
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
BEGIN
    set @errCode = ERROR_NUMBER()
    set @errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END
END CATCH
CCP_EXIT:
GO

IF EXISTS (select * from GxQscripts where name = 'AppCCP_iDa_Template')
	delete from GxQscripts where name = 'AppCCP_iDa_Template'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCCP_iDa_Template')
	delete from GXDBVersions where aliasname = 'AppCCP_iDa_Template'
GO

insert into GXDBVersions values(2, 'AppCCP_iDa_Template',  '00010006006000020000', 'AppCCP_iDa_Template', '00010006006000020000')
GO

