

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCCP_iDa_Push.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCCP_iDa_Push.sp,v $ $Id: AppCCP_iDa_Push.sp,v 1.4.60.2 2018/03/27 08:14:13 jiechen Exp $";
--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=---
-- EDIT HISTORY																		--
-- DATE			DESCRIPTION															--
-- -----------	---------------------------------------------						--
-- 13-May-2009	Initial Edit														--
-- 20-Jul-2009	Hiatus edit.  Project pushed out to 9.0.  See work todo list below	--
--																					--
--=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=---
-- Work remaining:
-- Shortly before project put on hold, additional requirement to support below iDa level for ALL iDa's not just FS
-- Changes started here to do that.  Essentially concept is that there will be only one instance, backupset & subclient defined
-- in the CCP for these iDa's, and that the properties stored at each of these levels will get pushed out to all the objects in
-- the associated clients at the corresponding levels, regardless of how many at each level there are.   No real progress in this
-- procedure was made, save for a placekeeper statement at the instance level.  Note that F.S. "push" should still be OK.  Note that
-- when completed, this SP should be called instead of "AppCCP_iDa_WinFS_Push" in AppCCPoperations.
-------------------------------------------------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppCCP_iDa_Push <<<'

IF EXISTS (select * from sysobjects where name='AppCCP_iDa_Push')
	drop procedure AppCCP_iDa_Push
IF EXISTS (select * from GxQscripts where name='AppCCP_iDa_Push')
	delete from GxQscripts where name = 'AppCCP_iDa_Push'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCCP_iDa_Push')
	delete from GXDBVersions where aliasname = 'AppCCP_iDa_Push'
GO
print '... Creating Procedure: AppCCP_iDa_Push'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCCP_iDa_Push
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
-----------------------------------------------------------
  @iCcpId integer,
  @iClientId integer,
  @iappTypeId integer,
  @errCode integer			OUTPUT,
  @errString varchar(1024)	OUTPUT
AS
SET NOCOUNT ON
-----------------------------------------------------------
-- CONVENIENCE DEFS                                     ---
-----------------------------------------------------------
DECLARE @nowTime				AS integer		= dbo.GetUnixTime (GetUTCdate())
DECLARE	@cv_STATUS_CCP			AS integer		= 0x10000		--'CV_STATUS_CCP'
DECLARE	@cv_STATUS_DEFAULT		AS integer		= 0x00008		--'CV_STATUS_DEFAULT'
DECLARE	@tempId					AS integer		= 0
DECLARE @isNew					AS int			= 0
--- Following is for messages ---
DECLARE @ccpName				varchar(512)
DECLARE @clientName				varchar(512)
DECLARE @appTypeName			varchar(512)
SET		@errCode	                            = 1			-- Be pessimistic, Assume some failure
-----------------------------------------------------------
-- LOCAL DEFS                                           ---
-----------------------------------------------------------
DECLARE	@status				integer
DECLARE @thisIda			integer
DECLARE @ccp_idaNameId		integer
DECLARE @ccpAppTypeId 	AS	integer = dbo.GetCCPappType(@iappTypeId)		-- "Common" apptype to use for a lot of things.
DECLARE @ccp_instanceId	AS	integer = ISNULL((select instance FROM App_application WHERE clientId = @iCcpId and appTypeId = @ccpAppTypeId), 1)
-----------------------------------------------------------
BEGIN TRY
	SET @ccpName     = '['+ISNULL((Select name from app_client  where id   = @iCcpId),    'Unknown')+'('+CONVERT(VarChar(10),@iCcpId)     + ')]'
	SET @clientName  = '['+ISNULL((Select name from app_client  where id   = @iClientId), 'Unknown')+'('+CONVERT(VarChar(10),@iClientId)  + ')]'
	SET @appTypeName = '['+ISNULL((Select name from app_idaType where type = @iappTypeId),'Unknown')+'('+CONVERT(VarChar(10),@iappTypeId) + ')]'
	SET @errString = 'Called with ccpId[' + Convert(varchar(5), @iCcpId) + '], @clientId[' + convert(varchar(5), @iClientId) + '].'
-------------------------------------------------------------------------------------------------------------------
---	DO SOME BASIC CHECKING FIRST.  EVEN THOUGH THIS IS "SUPPOSED" TO BE A CLOSED SYSTEM, WE DON'T WANT TO TRY	---
---	PUSHING BAD DATA!																							---
-------------------------------------------------------------------------------------------------------------------
	-- VALIDATE CCP: Does the ccpId  belong to a valid CCP, is the appType configured for the CCP ?
	---------------------------------------------------------------------------------------------
	SET @status = (SELECT status FROM APP_CLIENT WHERE id=@iCcpId)
	IF  @status is NuLL
	BEGIN
		SET	@errString	=	'No Client or CCP exists with id[' + CONVERT(varchar(5), @iCcpId) + '].'
		GOTO CCP_ALL_DONE
	END
	IF (@status & @cv_STATUS_CCP) = 0
	BEGIN
		SET @errString	=	@ccpName+ ' is not a CCP!.'
		GOTO CCP_ALL_DONE
	END
	SET @ccp_idaNameId = (SELECT id from APP_IDANAME where clientId = @iccpId AND dbo.GetCCPappType(appTypeId) = @ccpAppTypeId)
	IF  @ccp_idaNameId is NuLL
	BEGIN
		SET	@errString	=	'AppType' +@appTypeName + ' is not a member of this CCP!.'
		GOTO CCP_ALL_DONE
	END
	-- VALIDATE THE CLIENT  -----------------------------------------
	SET @tempId = (SELECT ccpID FROM APP_Client WHERE id = @iClientId)
	IF  @status is NuLL
	BEGIN
		SET	@errString	=	'No Client exists with id[' + CONVERT(varchar(5), @iClientId) + '].'
		GOTO CCP_ALL_DONE
	END
	IF @tempId <> @iCcpId
	  BEGIN
		SET	@errString	=	'Client with id[' + CONVERT(varchar(5), @iClientId) + '] does not belong to CCP[' + CONVERT(VARCHAR(5), @iCcPId) + '].'
		GOTO CCP_ALL_DONE
	  END
	-- Validate iDa: Does this client have an iDa of this type (must!) ?
	---------------------------------------------------------------------
	SET @thisIda = ISNULL((Select id FROM APP_IDANAME WHERE clientId = @iclientId AND appTypeId = @iAppTypeId), 0)
	IF	@thisIda = 0
	BEGIN
		SET	@errString	=	'Client ' +@clientName + ' does not have an iDa of type ' + @appTypeName
		GOTO CCP_ALL_DONE
	END
	SET @tempId = (SELECT ccpID from APP_IDANAME WHERE id = @thisIda)
	IF @tempId  <> 0
	BEGIN
		IF @tempId = @ccp_idaNameId
			SET @errString	=	'Apptype ' + @appTypeName + 'of Client ' + @clientName + ' is already associated with CCP ' + @CcpName + '.'
		ELSE
			SET @errString	=	'Apptype ' + @appTypeName + 'of Client ' + @clientName + ' is already associated with another CCP.'
		GOTO CCP_ALL_DONE
	END
------------------------------------------------------------------------------------------------
--	MOST PROPERTY TABLES ARE PRETTY MUCH THE SAME, SO USE ONE TEMP GENERIC TABLE FOR THEM ALL --
------------------------------------------------------------------------------------------------
	IF object_id('tempdb.dbo.#PropList') IS NOT Null DROP TABLE #PropList
	CREATE TABLE #PropList
   (
       id				integer,
       componentNameId  integer,
       attrName			nvarchar(1024),    --CV_MAX_PROPERTYNAME_LEN_
       attrType         integer,
       attrVal			nvarchar(MAX) NOT NuLl,
       created			integer,
       modified         integer,
       ccpId            integer
	)
--	===========================================================
--	===========        DO THE WORK!   =========================
--	===========================================================
---	FOR FS IDA:
---		Client			- already done?
---		idaName			- Do Here
---		instance		- Always = 1 (No Instance Props)
---		Backupsets		- Can have multiples - if name is same, overwrite, if name is different, add (leave no-match alone)
---		subClients		- Can Have multiples
	--==========================================---
	-- IDA LEVEL: DO THIS FOR ALL APPTYPES		---
	--==========================================---
	UPDATE APP_IDANAME
		SET ccpId = @ccp_idaNameId, ccpTime = 0
		WHERE id = @thisIda
	SET @isNew = 1
	-- AGE OFF OLD PROPS --
	UPDATE APP_IDAPROP
		SET Modified = @nowTime
		WHERE	componentNameId = @thisIda
		  AND   modified = 0
		  AND	attrName In
					(Select attrName from APP_CCP_PROP
WHERE componentLevel = 20						-- APP_CCP_IDA_LEVEL
						  AND (AppTypeId = 0 OR appTypeId = @iAppTypeId)
					)
	-- ADD NEW PROPS --
	INSERT APP_IDAPROP (componentNameId,attrName,attrType,attrVal,created,modified,ccpId)
		SELECT @thisIda,attrName,attrType,attrVal,@nowTime,0,@iCcpId
		   FROM APP_IDAPROP
				WHERE componentNameId = @ccp_idaNameId
				  AND modified = 0
	--==========================================================================---
	-- INSTANCE LEVEL: 1. BY RULE, WE WILL DEFINE ONLY ONCE INSTANCE PER IDA	---
	--					  IN THE CCP THAT WE WILL PUSH TO ALL INSTANCES IN THE	---
	--					  ASSOCIATED CLIENT                                     ---
	--				   2. FILESYSTEM DOESN'T HAVE INSTANCE LEVEL PROPS			---
	--==========================================================================---
IF @ccpAppTypeId <> 33
	BEGIN
		UPDATE APP_INSTANCENAME
			SET ccpId = @ccp_instanceId, ccpTime = 0
			WHERE id in (Select instance FROM App_Application Where clientId=@iclientId and dbo.getCCPappType(appTypeId) = @ccpAppTypeId)
			--- MORE TO DO !!!!
	END
	------------------------------
	-- BACKUP SETS (LOOP)	   ---
	------------------------------
	DECLARE @ccpBackupSetId  	integer
	DECLARE @ccpBackupSetStatus	integer
	DECLARE @ccpBackupSetName	varchar(512)
	DECLARE @ccpSubClientId		integer
	DECLARE @ccpSubClientName	varchar(512)
	DECLARE @statusMask 		AS integer = 8+16			--Default & Indexing
	DECLARE @backupSetId    integer
	DECLARE @subClientId		integer
	UPDATE App_BackupsetName                            --"ASSUME" CCP already has it's own Default & Indexing BackupSet
		SET status = status & (~@statusMask)
		WHERE id in (
					select distinct backupSet
					  from App_Application
					  where clientId= @iClientId AND appTypeId=@iappTypeId
					)
	DECLARE	backupSetCursor CURSOR
		FOR
		select distinct backupSet
				from App_Application
				where clientId= @iCcpId AND appTypeId=@iappTypeId
		OPEN backupSetCursor
		FETCH NEXT from backupSetCursor INTO @ccpBackupSetId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SELECT @ccpBackupSetName = Name, @ccpBackupSetStatus = status From app_backupSetName Where id = @ccpBackupSetId
			SET @backupsetId = ISNULL((SELECT id FROM APP_BACKUPSETNAME
							WHERE name = @ccpBackupSetName
							  AND id in (select distinct backupSet
										 from App_Application
											where clientId= @iClientId
										AND appTypeId=@iappTypeId)), 0)
			IF @backupSetId <> 0
			  BEGIN
				-- AGE OFF EXISTING SUBCLIENTS, CONTENTS & PROPERTIES, SET BACKUPSETNAME PROPS
				UPDATE App_Application SET SubClientStatus = 4 WHERE backupSet = @backupSetId
				UPDATE App_ScfilterFile  set Modified = @nowTime WHERE componentNameId in (Select id from App_Application Where backupSet = @backupSetId)
				UPDATE App_SubClientProp Set Modified = @nowTime WHERE componentNameId in (Select id from App_Application Where backupSet = @backupSetId)
				UPDATE APP_BackupSetProp Set Modified = @nowTime WHERE componentNameId = @backupSetId
				UPDATE APP_BackupSetName SET Status = @ccpBackupSetStatus & ~@cv_STATUS_CCP, ccpId = @ccpBackupSetId, ccpTime = @nowTime
						WHERE id = @backupSetId
			  END
			ELSE
			  BEGIN
				INSERT APP_BackupSetName (name,refTime,modified,status,ccpId,ccpTime)
					SELECT name, refTime, modified, (status & ~@cv_STATUS_CCP), @ccpBackupSetId, @nowtime
					FROM APP_BackupSetName
					WHERE id = @ccpBackupSetId
				SET @backupSetId = @@Identity
			  END
			-- NOW COPY BACKUPSET LEVEL PROPS (IF ANY) TO THE "CHILD" BACKUPSET --
			INSERT APP_BACKUPSETPROP(componentNameId,attrName,attrType,attrVal,created,modified,ccpId)
			  SELECT @backupSetId, attrName, attrType, attrVal, created, 0, @ccpBackupSetId
				FROM APP_BackupSetProp
				  WHERE componentNameId = @ccpBackupSetId AND modified = 0
			-- NOW LOOP FOR ALL THE SUBCLIENTS
			DECLARE	subClientCursor CURSOR
			FOR
			select distinct id, subClientName
				from App_Application
				where backupSet = @ccpBackupSetId
			OPEN subClientCursor
			FETCH NEXT from subClientCursor INTO @ccpSubClientId, @ccpsubClientName
			WHILE @@FETCH_STATUS = 0
			  BEGIN
				-- CREATE THE NEW SUBCLIENT.  IF THERE IS A NAME CONFLICT, RENAME CONFLICTING NAME PER CONVENTION
				SET @subClientId = ISNULL((Select id from App_Application WHERE backupSet = @backupSetId AND subClientName = @ccpsubClientName), 0)
				IF @subClientId <> 0
					UPDATE App_Application Set subClientName = subClientName + '_'+CONVERT(VARCHAR(10), @nowTime) WHERE id = @subClientId
				INSERT App_Application (clientId,appTypeId,instance,backupSet,appNumber,dataArchGrpID,logArchGrpID,
												refTime,modified,subclientName,subclientStatus,ccpId,ccpTime, origCCId, GUID)
					SELECT @iClientId,appTypeId,instance,@backupSetId,appNumber,dataArchGrpID,logArchGrpID,@nowTime,modified,subclientName,
						subclientStatus & ~@cv_STATUS_CCP,@ccpSubClientId,@nowTime, 2, newid()
					FROM App_Application
					  WHERE id = @ccpSubclientId
					SET @subClientId = @@Identity
				-- ADD THE SUBCLIENT PROPERTIES
				INSERT App_SubClientProp (componentNameId,attrName,attrType,attrVal,created,modified,ccpId)
					SELECT @subClientId, attrName, attrType, attrVal, @nowTime, modified, @ccpSubClientId
					FROM App_SubClientProp
					  WHERE componentNameId = @ccpSubClientId AND Modified = 0
				-- FINALLY, ADD THE CONTENT
				INSERT App_ScfilterFile (componentNameId,type,fileName,created,modified,ccpId)
				  SELECT @subClientId, type, fileName, @nowtime, 0, @ccpSubClientId
				    FROM App_ScfilterFile
					  WHERE componentNameId = @ccpSubClientId AND Modified = 0
				FETCH NEXT from subClientCursor INTO @ccpSubClientId, @ccpsubClientName
			  END
			CLOSE		subClientCursor
			DEALLOCATE	subClientCursor
			-----------------------------------------------------------------------
			--	ALL DONE WITH THIS BACKUPSET, SEE IF THERE ARE ANY NORE!		---
			-----------------------------------------------------------------------
			FETCH NEXT from backupSetCursor INTO @ccpBackupSetId
		END
		CLOSE		backupSetCursor
		DEALLOCATE	backupSetCursor
	----------------------
	-- GOT HERE, MUST	--
	-- HAVE SUCCEEDED!	--
	----------------------
	SET @errCode = 0
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    set @errCode = ERROR_NUMBER()
    set @errString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
CCP_ALL_DONE:
----------------------------------------------------------------
--- CLEAN UP ANY TEMP TABLES OR OPEN CURSORS, JUST IN CASE  ----
----------------------------------------------------------------
IF object_id('tempdb.dbo.#PropList') IS NOT Null
	DROP TABLE #PropList
IF ( CURSOR_STATUS('global', 'backupSetCursor') >= 0 	OR CURSOR_STATUS('local', 'backupSetCursor') >= 0 )
BEGIN
	CLOSE		backupSetCursor
	DEALLOCATE	backupSetCursor
END
IF ( CURSOR_STATUS('global', 'subClientCursor') >= 0 	OR CURSOR_STATUS('local', 'subClientCursor') >= 0 )
BEGIN
	CLOSE		subClientCursor
	DEALLOCATE	subClientCursor
END
GO
/*
DECLARE @eCode	int
Declare @eString varchar(2048)
exec AppCCP_iDa_Push 12, 2, 33, @eCode output, @eString output
select eCode=@eCode, eString=@eString
*/

IF EXISTS (select * from GxQscripts where name = 'AppCCP_iDa_Push')
	delete from GxQscripts where name = 'AppCCP_iDa_Push'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCCP_iDa_Push')
	delete from GXDBVersions where aliasname = 'AppCCP_iDa_Push'
GO

insert into GXDBVersions values(2, 'AppCCP_iDa_Push',  '00010004006000020000', 'AppCCP_iDa_Push', '00010004006000020000')
GO

