

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppCCPListReq.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppCCPListReq.sp,v $ $Id: AppCCPListReq.sp,v 1.3.60.2 2018/03/27 08:04:33 jiechen Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppCCPListReq -
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppCCPListReq <<<'

IF EXISTS (select * from sysobjects where name='AppCCPListReq')
	drop procedure AppCCPListReq
IF EXISTS (select * from GxQscripts where name='AppCCPListReq')
	delete from GxQscripts where name = 'AppCCPListReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCCPListReq')
	delete from GXDBVersions where aliasname = 'AppCCPListReq'
GO
print '... Creating Procedure: AppCCPListReq'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppCCPListReq
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
-----------------------------------------------------------
  @ownerID int
AS
SET NOCOUNT ON
DECLARE @errorCode 		as integer = 0
DECLARE @errorString 	as varchar(2048) = ''
DECLARE @function  		as varchar(80)= 'AppCCPListReq'
DECLARE @CCP_MASK		 as integer= convert(int,0x10000)+ convert(int, 0x20000)+CONVERT(int,0x40000)	 -- 'CV_STATUS_CCP|CV_STATUS_CCP_HOLD|CV_STATUS_CCP_CHILD'
BEGIN TRY
	SELECT	1	    as TAG,
		NuLL	    as Parent,
		NuLL        as [EVGui_AppCCPListResp!1],
		NuLL		as [ccpList!2!id!hide],
		NuLL		as [ccpList!2!status],
		NuLL		as [client!3!clientId],
		NuLL		as [client!3!clientName]
	UNION ALL
	SELECT 2,1 , NuLL,
			ID, CASE
				  When ccpId = id THEN status
ELSE	status | convert(int, 0x40000)
				END,
			Id, NuLL
	FROM app_client where ccpId <> 0
	UNION ALL
	SELECT 3,2, NuLL,
		ID, NuLL,
		Id, Name
	FROM app_client where ccpId <> 0
	ORDER BY [ccpList!2!id!hide], [client!3!clientId]
	FOR XML EXPLICIT
END TRY
--=====================================================================
--==============  COME HERE IF THERE WAS A PROBLEM!     ===============
--=====================================================================
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode	 = 1
	SET @errorString = 'Problems Executing [' + @function +'] Error Message [' + ERROR_MESSAGE() + '].'
SELECT  1                    as TAG,
        null                 as Parent,
    @errorCode               as [CVGui_GenericResp!1!errorCode],
    @errorString             as [CVGui_GenericResp!1!errorMessage]
FOR XML EXPLICIT
END CATCH
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppCCPListReq')
	delete from GxQscripts where name = 'AppCCPListReq'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppCCPListReq')
	delete from GXDBVersions where aliasname = 'AppCCPListReq'
GO

insert into GXDBVersions values(2, 'AppCCPListReq',  '00010003006000020000', 'AppCCPListReq', '00010003006000020000')
GO

