

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppBuildYearMonthNumberOfWeek.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppBuildYearMonthNumberOfWeek')
BEGIN
	print '>>> Drop Stored Procedure: AppBuildYearMonthNumberOfWeek <<<'
	drop procedure AppBuildYearMonthNumberOfWeek
END
IF EXISTS (select * from GxQscripts where name='AppBuildYearMonthNumberOfWeek')
	delete from GxQscripts where name = 'AppBuildYearMonthNumberOfWeek'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppBuildYearMonthNumberOfWeek')
	delete from GXDBVersions where aliasname = 'AppBuildYearMonthNumberOfWeek'
GO
print '... Creating Procedure: AppBuildYearMonthNumberOfWeek'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppBuildYearMonthNumberOfWeek
AS
BEGIN
    SET NOCOUNT ON
	DECLARE @MyDate DATETIME = GETUTCDATE()
	DECLARE @Yr SMALLINT = DATEPART(YEAR, @MyDate)
	DECLARE @MaxYr SMALLINT = @Yr + 2
	WHILE (@Yr <= @MaxYr)
	BEGIN
		IF NOT EXISTS(SELECT 1 FROM APP_YearMonthNumberOfWeeks WHERE yearNo = @Yr)
		BEGIN
			INSERT INTO APP_YearMonthNumberOfWeeks (yearNo, monthNo, numberOfWeeks)
				SELECT
					d.yearNo,
					d.monthNo,
					d.numberOfWeeks
				FROM dbo.GetYearMonthNumberOfWeeks(@Yr) d
		END
	SET @Yr += 1
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppBuildYearMonthNumberOfWeek')
	delete from GxQscripts where name = 'AppBuildYearMonthNumberOfWeek'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppBuildYearMonthNumberOfWeek')
	delete from GXDBVersions where aliasname = 'AppBuildYearMonthNumberOfWeek'
GO

insert into GXDBVersions values(2, 'AppBuildYearMonthNumberOfWeek',  '00010001000200010000', 'AppBuildYearMonthNumberOfWeek', '00010001000200010000')
GO

