

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppBuildTimeZoneDates.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppBuildTimeZoneDates <<<'

IF EXISTS (select * from sysobjects where name='AppBuildTimeZoneDates')
	drop procedure AppBuildTimeZoneDates
IF EXISTS (select * from GxQscripts where name='AppBuildTimeZoneDates')
	delete from GxQscripts where name = 'AppBuildTimeZoneDates'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppBuildTimeZoneDates')
	delete from GXDBVersions where aliasname = 'AppBuildTimeZoneDates'
GO
print '... Creating Procedure: AppBuildTimeZoneDates'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppBuildTimeZoneDates
-- Input arguments
  @PlusNumYears int,
  @MinusNumYears int
AS
  DECLARE @Count int = 0
BEGIN
	SET NOCOUNT ON
	DECLARE @CurrentUTCTime dateTime
	DECLARE @CurrentYear integer
	DECLARE @StartYear integer
	DECLARE @EndYear integer
	DECLARE @DSTDate	datetime
	DECLARE @STDDate	datetime
	DECLARE @DayFound	integer
	DECLARE @DayOfWeek	integer
	DECLARE @WeekCount	integer
	DECLARE @TimeZoneID		integer
	DECLARE @TimeZoneName		nvarchar(128)
	DECLARE @TimeZoneStdName	varchar(128)
	DECLARE @DSTFlag		integer
	DECLARE @Bias			integer
	DECLARE @STDBias		integer
	DECLARE @STDMonth		integer
	DECLARE @STDDayOfWeek		integer
	DECLARE @STDDay			integer
	DECLARE @STDSeconds		integer
	DECLARE @DSTBias		integer
	DECLARE @DSTMonth		integer
	DECLARE @DSTDayOfWeek		integer
	DECLARE @DSTDay			integer
	DECLARE @DSTSeconds		integer
	SET @currentUTCTime = GetUTCDate()
	SET @CurrentYear = datepart(yy, @CurrentUTCtime)
	Set @StartYear = @CurrentYear - @MinusNumYears
	Set @EndYear = @CurrentYear + @PlusNumYears
	-- Set @StartYear = @CurrentYear
	-- Set @EndYear = @CurrentYear
	-- Select @CurrentUTCTime, @CurrentYear, @StartYear, @EndYear
	Delete SchedTimeZoneDates
	Set @CurrentYear = @StartYear
	WHILE (@CurrentYear <= @EndYear)
	BEGIN
		-- DECLARE CURSORS
		DECLARE TimeZoneCursor CURSOR
		FOR
		SELECT TimeZoneID, TimeZoneName, TimeZoneStdName, DSTFlag, Bias,
			STDBias, STDMonth, STDDayOfWeek, STDDay, STDSeconds,
			DSTBias, DSTMonth, DSTDayOfWeek, DSTDay, DSTSeconds
			FROM SchedTimeZone
		-- WHERE TimeZoneID = 26
		-- Open
		OPEN TimeZoneCursor
		-- Fetch
		FETCH NEXT FROM TimeZoneCursor
		INTO @TimeZoneID, @TimeZoneName, @TimeZoneStdName, @DSTFlag, @Bias,
			@STDBias, @STDMonth, @STDDayOfWeek, @STDDay, @STDSeconds,
			@DSTBias, @DSTMonth, @DSTDayOfWeek, @DSTDay, @DSTSeconds
		WHILE @@FETCH_STATUS = 0
		BEGIN
			IF (@DSTFlag = 0)
			BEGIN
				-- No DayLight Savings Time for this TimeZone
				INSERT INTO SchedTimeZoneDates
				VALUES (@TimeZoneID, @CurrentYear, @TimeZoneName, @TimeZoneStdName,
					@DSTFlag, @Bias, @StdBias, dbo.GetDateTime(0),
					@DSTBias, dbo.GetDateTime(0))
			END
			ELSE
			BEGIN
				-- Calculate the Date for DST & STD time changes...
				SET @DSTDate = '01/01/' + CAST(@CurrentYear AS varchar(10))
				SET @STDDate = '01/01/' + CAST(@CurrentYear AS varchar(10))
				-- Jump to the Month when the switch happens
				SET @DSTDate = DateAdd(month, @DSTMonth - 1, @DSTDate)
				SET @STDDate = DateAdd(month, @STDMonth - 1, @STDDate)
				-- SELECT @DSTDate, @STDDate
				-- SELECT DSTFlag = @DSTFlag, DSTMonth = @DSTMonth, DSTDay = @DSTDay, DSTSeconds = @DSTSeconds
				-- DSTDay-th occurence of DSTDayOfWeek in DSTMonth @ DSTSeconds, time changes to DST
				-- IF DSTDay = 5, then the switch happens in the LAST Week of the month
				-- (could be fourth OR fifth week of the month)
				IF (@DSTDay = 5)
				BEGIN
					-- To get to the Last week of the current month...
					-- Jump to the next Month & keep subtracting 1 day
					-- at a time looking for DSTDayOfWeek.
					-- When you get hit a match with DSTDayOfWeek, thats
					-- the day, when the switch happens @ DSTSeconds from midnight.
					-- SELECT @DSTDate
					SET @DSTDate = DateAdd(month, 1, @DSTDate)
					SET @DSTDate = DateAdd(day, -1, @DSTDate)
					SET @DayFound = 0
					WHILE (@DayFound = 0)
					BEGIN
						SET @DayOfWeek = DatePart(WEEKDAY, @DSTDate) - 1
						IF (@DayOfWeek = @DSTDayOfWeek)
						BEGIN
							SET @DayFound = 1
						END
						ELSE
						BEGIN
							SET @DSTDate = DateAdd(day, -1, @DSTDate)
						END
					END
				END
				ELSE
				BEGIN
					-- For all other DSTDay (1, 2, 3, 4)
					-- walk through each day of the month until you hit the DSTDay-th occurence
					-- of DSTDayOfWeek
					-- SELECT @DSTDate
					SET @WeekCount = 1
					SET @DayFound = 0
					WHILE (@DayFound = 0)
					BEGIN
						SET @DayOfWeek = DatePart(WEEKDAY, @DSTDate) - 1
						-- PRINT '@DayOfWeek = ' + CAST(@DayOfWeek AS varchar(3)) + ' @DSTDayOfWeek = ' + CAST(@DSTDayOfWeek AS varchar(3)) +  ' @WeekCount = ' + CAST(@WeekCount AS varchar(3)) + ' @DSTDay = ' + CAST(@DSTDay AS varchar(3))
						IF (@DayOfWeek = @DSTDayOfWeek AND @DSTDay = @WeekCount)
						BEGIN
							SET @DayFound = 1
						END
						ELSE
						BEGIN
							SET @DSTDate = DateAdd(day, 1, @DSTDate)
							SET @WeekCount = ((DatePart(day, @DSTDate) - 1) / 7) + 1
						END
					END
				END
				-- Add DSTSeconds to DSTDate to get the time of Swtich
				SET @DSTDate = DateAdd(second, @DSTSeconds, @DSTDate)
				-- SELECT DSTFlag = @DSTFlag, STDMonth = @STDMonth, STDDay = @STDDay, STDSeconds = @STDSeconds
				-- STDDay-th occurence of STDDayOfWeek in STDMonth @ STDSeconds, time changes to STD
				-- IF STDDay = 5, then the switch happens in the LAST Week of the month
				-- (could be fourth OR fifth week of the month)
				IF (@STDDay = 5)
				BEGIN
					-- To get to the Last week of the current month...
					-- Jump to the next Month & keep subtracting 1 day
					-- at a time looking for STDDayOfWeek.
					-- When you get hit a match with STDDayOfWeek, thats
					-- the day, when the switch happens @ STDSeconds from midnight.
					-- SELECT @STDDate
					SET @STDDate = DateAdd(month, 1, @STDDate)
					SET @STDDate = DateAdd(day, -1, @STDDate)
					SET @DayFound = 0
					WHILE (@DayFound = 0)
					BEGIN
						SET @DayOfWeek = DatePart(WEEKDAY, @STDDate) - 1
						IF (@DayOfWeek = @STDDayOfWeek)
						BEGIN
							SET @DayFound = 1
						END
						ELSE
						BEGIN
							SET @STDDate = DateAdd(day, -1, @STDDate)
						END
					END
				END
				ELSE
				BEGIN
					-- For all other STDDay (1, 2, 3, 4)
					-- walk through each day of the month until you hit the STDDay-th occurence
					-- of STDDayOfWeek
					-- SELECT @STDDate
					SET @WeekCount = 1
					SET @DayFound = 0
					WHILE (@DayFound = 0)
					BEGIN
						SET @DayOfWeek = DatePart(WEEKDAY, @STDDate) - 1
						-- PRINT '@DayOfWeek = ' + CAST(@DayOfWeek AS varchar(3)) + ' @STDDayOfWeek = ' + CAST(@STDDayOfWeek AS varchar(3)) +  ' @WeekCount = ' + CAST(@WeekCount AS varchar(3)) + ' @STDDay = ' + CAST(@STDDay AS varchar(3))
						IF (@DayOfWeek = @STDDayOfWeek AND @STDDay = @WeekCount)
						BEGIN
							SET @DayFound = 1
						END
						ELSE
						BEGIN
							SET @STDDate = DateAdd(day, 1, @STDDate)
							SET @WeekCount = ((DatePart(day, @STDDate) - 1) / 7) + 1
						END
					END
				END
				-- Add STDSeconds to STDDate to get the time of Swtich
				SET @STDDate = DateAdd(second, @STDSeconds, @STDDate)
				-- Insert into SchedTimeZoneDates table...
				INSERT INTO SchedTimeZoneDates
				VALUES (@TimeZoneID, @CurrentYear, @TimeZoneName, @TimeZoneStdName,
					@DSTFlag, @Bias, @StdBias, @STDDate,
					@DSTBias, @DSTDate)
			END
			FETCH NEXT FROM TimeZoneCursor
			INTO @TimeZoneID, @TimeZoneName, @TimeZoneStdName, @DSTFlag, @Bias,
				@STDBias, @STDMonth, @STDDayOfWeek, @STDDay, @STDSeconds,
				@DSTBias, @DSTMonth, @DSTDayOfWeek, @DSTDay, @DSTSeconds
		END
		-- Close & Deallocate Cursors
		CLOSE TimeZoneCursor
		DEALLOCATE TimeZoneCursor
		SET @CurrentYear = @CurrentYear + 1
	END
	SELECT COUNT(*)
	FROM	SchedTimeZoneDates
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppBuildTimeZoneDates')
	delete from GxQscripts where name = 'AppBuildTimeZoneDates'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppBuildTimeZoneDates')
	delete from GXDBVersions where aliasname = 'AppBuildTimeZoneDates'
GO

insert into GXDBVersions values(2, 'AppBuildTimeZoneDates',  '00010001000200020000', 'AppBuildTimeZoneDates', '00010001000200020000')
GO

