

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppBuildIdxArchiveFile.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppBuildIdxArchiveFile.sp,v $ $Id: AppBuildIdxArchiveFile.sp,v 1.1.2.1 2020/12/15 00:14:04 sjanakiraman Exp $";
--
--  +========================================================================+
--  |   Procedure:  AppBuildIdxArchiveFile()
--  |
--  | Description:  Inserts archiveFile information into IdxArchFile table with input statistics.
--	|
--  |       Input:  XML with list of archiveFileId and its visible count
--	|
--  |      Output:  ErrorCode and ErrorMessage if any during insertion
--  |
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppBuildIdxArchiveFile')
BEGIN
	print '>>> Drop Stored Procedure: AppBuildIdxArchiveFile <<<'
	drop procedure AppBuildIdxArchiveFile
END
IF EXISTS (select * from GxQscripts where name='AppBuildIdxArchiveFile')
	delete from GxQscripts where name = 'AppBuildIdxArchiveFile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppBuildIdxArchiveFile')
	delete from GXDBVersions where aliasname = 'AppBuildIdxArchiveFile'
GO
print '... Creating Procedure: AppBuildIdxArchiveFile'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppBuildIdxArchiveFile
  @i_inputArchFileInfo XML
AS
--'<Indexing_ArchFileIdxInfo>
--  <archFileInfo afileId="1" validItems="100"  maskedItems="0" />
--  <archFileInfo afileId="2" validItems="0"  maskedItems="100" />
--  <archFileInfo afileId="3" validItems="100"  maskedItems="100" />
--  <archFileInfo afileId="4" validItems="400"  maskedItems="300" />
--  <archFileInfo afileId="5" validItems="10"  maskedItems="10" />
--  <archFileInfo afileId="6" validItems="11"  maskedItems="22" />
--  <archFileInfo afileId="652" validItems="11"  maskedItems="22" />
--  <archFileInfo afileId="653" validItems="11"  maskedItems="0" />
--  </Indexing_ArchFileIdxInfo>'
  DECLARE @o_errorCode INT = 0
  DECLARE @o_errorMsg NVARCHAR(MAX)=''
  BEGIN TRY
  BEGIN TRAN
   DECLARE @i_firstCall INT
   DECLARE @i_subclientId INT
   /*
   enum IdxArchiveFileFlag
	{
		NO_PRESENCE = 0,
		PRESENT_IN_INDEX = 1,  --1 << 0 only present in index .
		PRESENT_IN_CSDB = 2    --1 << 1 only present in csdb
	}*/
   DECLARE @presentInCSDB INT = 2
   DECLARE @presentInIndex INT = 1
   SELECT
   @i_firstCall = info.value('@firstCall', 'INT') ,
   @i_subclientId = info.value('@subclientId', 'INT')
   FROM @i_inputArchFileInfo.nodes('Indexing_IdxArchiveFileInfoList') input(info)
   DECLARE  @currentTime INT = dbo.GetUnixTime(GETUTCDATE())
   --insert from archFile only on 1st call for this subclient
   IF ( @i_firstCall = 1)
   BEGIN
    -- on first call, reset flag to 0, assuming not present in both.
    -- below merge logic from csdb archFile and Index will update the presence correctly.
	UPDATE IdxArchiveFile
	SET Flag = 0
	WHERE SubclientId = @i_subclientId
	MERGE INTO IdxArchiveFile as Trg
	USING (
			SELECT A.id, A.appId, C.number
			FROM archFile A WITH(NOLOCK)
			JOIN APP_Commcell C WITH(NOLOCK)ON A.commcellId = C.id
			WHERE appId = @i_subclientId AND fileType=1
		) as Src
	ON ( Trg.ArchiveFileId = Src.id AND Trg.SubclientId = Src.appId AND Trg.CommcellNo = Src.number)
	WHEN MATCHED
	THEN
		Update SET Trg.Flag =  @presentInCSDB, -- set it to 2, so that if present in index, it will be updated to 3 later, if not present in index, it will remain 2 and selected for pruning.
		Trg.CollectionTime = @currentTime
	WHEN NOT MATCHED
	THEN
		INSERT (ArchiveFileId, CommcellNo, SubclientId, MaxArchiveOffset,TotalNumberOfItems,NumberOfValidItems,	NumberOfMaskedItems,VerificationCount,Flag,	Status,	CollectionTime ,ProcessedTime)
		VALUES(Src.id, Src.number, Src.appId, 0, 0, 0, 0, 0, @presentInCSDB, 0, @currentTime, 0)
	;
	END
  MERGE INTO IdxArchiveFile as Trg
  USING (
	SELECT
	info.value('@afileId', 'INT') as ArchiveFileId,
	@i_subclientId as SubclientId,
	ISNULL(info.value('@validItemsCount', 'INT'),0) as NumberOfValidItems,
	ISNULL(info.value('@maskedItemsCount', 'INT'),0) as NumberOfMaskedItems,
	ISNULL(info.value('@totalItemsCount', 'INT'),0) as TotalNumberOfItems,
	ISNULL(info.value('@maxAfileOffset', 'INT'),0) as MaxArchiveOffset,
	ISNULL(info.value('@commcellNo', 'INT'),0) as CommcellNo
	FROM @i_inputArchFileInfo.nodes('Indexing_IdxArchiveFileInfoList/archiveFileInfo') input(info)
	) as Src
  ON (Trg.ArchiveFileId = Src.ArchiveFileId AND Trg.SubclientId = Src.SubclientId AND Trg.CommcellNo = Src.CommcellNo)
  WHEN MATCHED
  THEN
	UPDATE SET Trg.NumberOfValidItems = Src.NumberOfValidItems,
	Trg.NumberOfMaskedItems = Src.NumberOfMaskedItems,
	Trg.TotalNumberOfItems = Src.TotalNumberOfItems,
	Trg.MaxArchiveOffset = Src.MaxArchiveOffset,
	Trg.CollectionTime = @currentTime,
	Trg.Flag = Trg.Flag | @presentInIndex
  WHEN NOT MATCHED
  THEN
	INSERT(ArchiveFileId, CommcellNo, SubclientId, MaxArchiveOffset,TotalNumberOfItems,NumberOfValidItems,	NumberOfMaskedItems,VerificationCount,Flag,	Status,	CollectionTime ,ProcessedTime)
	VALUES(Src.ArchiveFileId, Src.CommcellNo, @i_subclientId, Src.MaxArchiveOffset, Src.TotalNumberOfItems, Src.NumberOfValidItems, Src.NumberOfMaskedItems, 0, @presentInIndex, 0, @currentTime,0 )
	--dont reset the flag. The flag will be reset only when firstcall is true and we update the table from archFile
	--because this can be batch update, it may remove index flag if we add not matched condition to update the flag
   ;
	COMMIT TRAN
 END TRY
 BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	EXECUTE dbo.GetError @o_errorMsg OUTPUT, @o_errorCode OUTPUT
	IF XACT_STATE() <> 0
	BEGIN
		ROLLBACK TRANSACTION;
	END
	;THROW
 END CATCH;
   DECLARE @o_csdbOnlyCount BIGINT = 0
   DECLARE @o_IndexOnlyCount BIGINT = 0
   DECLARE @o_csdbAndIndexCount BIGINT =0
   SELECT
    @o_csdbOnlyCount +=IIF((flag = @presentInCSDB), 1,0),
    @o_IndexOnlyCount +=IIF((flag = @presentInIndex), 1,0),
    @o_csdbAndIndexCount +=IIF((flag = @presentInIndex | @presentInCSDB), 1,0)
    FROM IdxArchiveFile WITH(NOLOCK)
    WHERE  subclientId = @i_subclientId
   SELECT
   @o_csdbOnlyCount as 'o_csdbOnlyCount',
   @o_IndexOnlyCount as 'o_IndexOnlyCount' ,
   @o_csdbAndIndexCount as 'o_csdbAndIndexCount' ,
   @o_errorCode 'o_errorCode',
   @o_errorMsg 'o_errorMsg'
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppBuildIdxArchiveFile')
	delete from GxQscripts where name = 'AppBuildIdxArchiveFile'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppBuildIdxArchiveFile')
	delete from GXDBVersions where aliasname = 'AppBuildIdxArchiveFile'
GO

insert into GXDBVersions values(2, 'AppBuildIdxArchiveFile',  '00010001000200010000', 'AppBuildIdxArchiveFile', '00010001000200010000')
GO

