

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppBrowseSharePointOldRelease.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppBrowseSharePointOldRelease.sp,v $ $Id: AppBrowseSharePointOldRelease.sp,v 1.9.60.2 2018/03/22 01:31:45 jiechen Exp $";
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppBrowseSharePointOldRelease <<<'

IF EXISTS (select * from sysobjects where name='AppBrowseSharePointOldRelease')
	drop procedure AppBrowseSharePointOldRelease
IF EXISTS (select * from GxQscripts where name='AppBrowseSharePointOldRelease')
	delete from GxQscripts where name = 'AppBrowseSharePointOldRelease'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppBrowseSharePointOldRelease')
	delete from GXDBVersions where aliasname = 'AppBrowseSharePointOldRelease'
GO
print '... Creating Procedure: AppBrowseSharePointOldRelease'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppBrowseSharePointOldRelease
  @inRequest XML
AS
  DECLARE @errorCode INT	= 0
  DECLARE @errorString VARCHAR(MAX) = 'Success'
  DECLARE @strXML NVARCHAR(MAX) = '<databrowse_BrowseResponse/>'
--:DECLARE xmlResult	XML = '<databrowse_BrowseResponse/>'
DECLARE @subclientId INT = 0
DECLARE @backupSetId INT = 0
DECLARE @clientId INT = 0
DECLARE @sessionId NVARCHAR(MAX) = ''
DECLARE @xmlResult	XML = '<databrowse_BrowseResponse/>'
DECLARE @finalContents TABLE (	subClientId INT,
								content NVARCHAR(MAX),
								objectType INT)
BEGIN TRY
	--Identify Input parameters
	IF 1 = (@inRequest.exist('(//./entity/@subclientId)[1]'))
	BEGIN
		SET @subclientId = @inRequest.value('(//./entity/@subclientId)[1]','INT')
	END
	IF 1 = (@inRequest.exist('(//./entity/@backupsetId)[1]'))
	BEGIN
		SET @backupSetId = @inRequest.value('(//./entity/@backupsetId)[1]','INT')
	END
	IF 1 = (@inRequest.exist('(//./entity/@clientId)[1]'))
	BEGIN
		SET @clientId = @inRequest.value('(//./entity/@clientId)[1]','INT')
	END
	IF 1 = (@inRequest.exist('(//./session/@sessionId)[1]'))
	BEGIN
		SET @sessionId = @inRequest.value('(//./session/@sessionId)[1]','NVARCHAR(MAX)')
	END
	IF @subclientId > 0
		BEGIN
			DECLARE ContentCur	CURSOR FOR SELECT componentNameId, attrname, attrVal
			  FROM APP_SubClientProp
			  WHERE componentNameId = @subclientId
					AND attrType = 115
					AND modified = 0
		END
	ELSE IF @backupSetId > 0
		BEGIN
			DECLARE ContentCur	CURSOR FOR SELECT componentNameId, attrname, attrVal
			  FROM APP_SubClientProp
			  WHERE componentNameId IN(SELECT id FROM APP_Application WITH (NOLOCK)
WHERE (subclientStatus & 0x0800) = 0x0800
AND (subclientStatus & 0x00002) = 0
AND (subclientStatus & 0x00004) = 0
AND (subclientStatus & 0x00020) = 0
AND appTypeId = 78
												AND clientId = @clientId
												AND backupSet = @backupSetId)
					AND attrType = 115
					AND modified = 0
		END
	ELSE
		BEGIN
			SET @errorCode = 1
			SET @errorString = 'Input XML do not have subclientid and backupsetid'
			GOTO SKIP
		END
	DECLARE @cSubClientId INT = 0
	DECLARE @attrVal NVARCHAR(MAX)
	DECLARE @attrName NVARCHAR(MAX)
	DECLARE @content NVARCHAR(MAX)
	--Iteriate through all contents
	OPEN ContentCur
	FETCH NEXT FROM ContentCur INTO @cSubClientId, @attrName, @attrVal
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SELECT @content = CASE WHEN Id = 1 THEN Data ELSE @content END
				FROM SplitString(@attrVal,' ')
			SET @content = REPLACE(@content, '+1', ' ') + '\' + REPLACE(@attrName, 0x13, '|#13!')
			IF CHARINDEX('|#13!', @content) > 0
				SET @content =  '|' + @content
			INSERT INTO @finalContents(subClientId, content, objectType) VALUES (@cSubClientId, @content, 1000)
			FETCH NEXT FROM ContentCur INTO @cSubClientId, @attrName, @attrVal
		END--END ContentCur fetch loop
	CLOSE ContentCur
	DEALLOCATE ContentCur
SKIP:
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
   set @errorCode = ERROR_NUMBER()
   set @errorString = 'Problems executing [' +ERROR_PROCEDURE() +'], Line['
					+ CONVERT(nvarchar(10),ERROR_LINE()) + '] :' +ERROR_MESSAGE()
END	  CATCH
	DECLARE @browseResult XML
	SET	@browseResult =
							(SELECT
									(SELECT
										finalContentsTBL.content AS '@path',
										(SELECT
											(SELECT
													finalContentsSP.subClientId AS '@applicationId',
													'SUBCLIENT_ENTITY' AS '@_type_'
												FROM @finalContents AS finalContentsSP
												WHERE finalContentsSP.content = finalContentsMain.content
												FOR XML PATH('subclient'),TYPE)
										FOR XML PATH('advancedData'),TYPE)
									FROM @finalContents AS finalContentsTBL
									WHERE finalContentsTBL.content = finalContentsMain.content
									FOR XML PATH('dataResultSet'),TYPE)
								FROM @finalContents AS finalContentsMain
							FOR XML PATH(''), ROOT('browseResult'))
SET	@xmlResult =
					(SELECT 'Data' AS '@respType',
							'1' AS '@workerId',
							(SELECT
									@sessionId AS '@sessionId'
									FOR XML PATH('session'),TYPE),
							@browseResult
					FOR XML PATH('databrowse_BrowseResponse'))
SET @strXML = cast(@xmlResult as NVARCHAR(MAX))
	select @errorCode, @errorString, @strXML
GO

IF EXISTS (select * from GxQscripts where name = 'AppBrowseSharePointOldRelease')
	delete from GxQscripts where name = 'AppBrowseSharePointOldRelease'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppBrowseSharePointOldRelease')
	delete from GXDBVersions where aliasname = 'AppBrowseSharePointOldRelease'
GO

insert into GXDBVersions values(2, 'AppBrowseSharePointOldRelease',  '00010009006000020000', 'AppBrowseSharePointOldRelease', '00010009006000020000')
GO

