

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppAutoDeleteMonitoringPolicy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--	Author: Saurabh Yadav
--	Date:   01/10/2017
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppAutoDeleteMonitoringPolicy <<<'

IF EXISTS (select * from sysobjects where name='AppAutoDeleteMonitoringPolicy')
	drop procedure AppAutoDeleteMonitoringPolicy
IF EXISTS (select * from GxQscripts where name='AppAutoDeleteMonitoringPolicy')
	delete from GxQscripts where name = 'AppAutoDeleteMonitoringPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAutoDeleteMonitoringPolicy')
	delete from GXDBVersions where aliasname = 'AppAutoDeleteMonitoringPolicy'
GO
print '... Creating Procedure: AppAutoDeleteMonitoringPolicy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppAutoDeleteMonitoringPolicy
  @dummy INT
AS
  DECLARE @errorCode INT;
  DECLARE @errorMessage NVARCHAR(MAX);
BEGIN
	SET NOCOUNT ON
	DECLARE @deleteMonPol TABLE (id INT)
	DECLARE @returnCode TABLE (errorCode INT, errorMessage NVARCHAR(MAX))
	INSERT @deleteMonPol
	SELECT A.monitorPolicyId
	FROM APP_MonitoringPolicy A WITH (NOLOCK),  APP_MonitoringPolicyProp AP WITH (NOLOCK)
	WHERE AP.attrName = 'Policy Expiry Time'
		AND CONVERT(INT, AP.attrVal) > 0
		AND CONVERT(INT, AP.attrVal) < dbo.GetUnixTime(GETUTCDATE())
		AND AP.monitorPolicyId = A.monitorPolicyId
		AND status <> 3
	IF EXISTS (SELECT 1 FROM @deleteMonPol )
	BEGIN
		DECLARE deleteMonPolCursor CURSOR  FOR
		SELECT id
		FROM @deleteMonPol
		DECLARE @monitoringPolicyId INT
		OPEN deleteMonPolCursor
		FETCH NEXT FROM deleteMonPolCursor INTO @monitoringPolicyId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			UPDATE APP_MonitoringPolicy
			SET status = 3
			WHERE monitorPolicyId = @monitoringPolicyId
			DECLARE @ApplicableAssocForMonitoringPolicy TABLE (clientId INT, isPackageInstalled INT, clientMangledHostName NVARCHAR(1024), randomGUID NVARCHAR(1024))
			DELETE @ApplicableAssocForMonitoringPolicy
			INSERT @ApplicableAssocForMonitoringPolicy
			EXEC LMGetApplicableAssocForMonitoringPolicy @monitoringPolicyId, 0, 1
			DELETE P
			FROM @ApplicableAssocForMonitoringPolicy P, APP_Client AC WITH (NOLOCK)
			WHERE P.clientId = AC.Id
AND (AC.status & 0x00002) = 0x00002
			DELETE @ApplicableAssocForMonitoringPolicy
			WHERE isPackageInstalled = 0
			IF EXISTS (SELECT 1 FROM @ApplicableAssocForMonitoringPolicy WHERE clientId > 0)
			BEGIN
				DECLARE @deleteReq  NVARCHAR(MAX) = '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><TMMsg_MonitoringPolicyChangeReq monitoringPolicyId="' + CONVERT(NVARCHAR(MAX),@monitoringPolicyId) + '" operationType="2"/>'
				DECLARE clientIdCursor  CURSOR FOR
				SELECT clientId
				FROM @ApplicableAssocForMonitoringPolicy
				OPEN clientIdCursor
				DECLARE @clientId INT
				FETCH NEXT FROM clientIdCursor INTO @clientId
				WHILE @@FETCH_STATUS = 0
				BEGIN
					INSERT @returnCode
					EXEC AppWorkQueueSubmitRequest 8/*WORK_TOKEN_LOGMONITORING*/, 0, 0, @clientId, 0, @deleteReq
					FETCH NEXT FROM clientIdCursor INTO @clientId
				END
				DECLARE @cloudId INT = 0
				DECLARE @cloudClientId INT = 0
				SET @cloudId = ISNULL ((SELECT CONVERT(INT, AP.attrVal)
										FROM APP_MonitoringPolicyProp AP WITH (NOLOCK)
										WHERE AP.attrName = 'Cloud Id'
										AND AP.monitorPolicyId = @monitoringPolicyId
										AND CONVERT(INT, AP.attrVal) > 0 ), 0 )
				IF (@cloudId > 0 )
				BEGIN
					SET @cloudClientId = ISNULL((SELECT clientId
										    	FROM DM2SearchServerCoreInfo WITH (NOLOCK)
												WHERE cloudId = @cloudId), 0)
					IF(@cloudClientId > 0)
					BEGIN
						DECLARE @cleanDataReq NVARCHAR(MAX) = '<?xml version="1.0" encoding="UTF-8" standalone="no" ?><TMMsg_MonitoringPolicyChangeReq monitoringPolicyId="' + CONVERT(NVARCHAR(MAX),@monitoringPolicyId) + '" operationType="7"/>'
						INSERT @returnCode
						EXEC AppWorkQueueSubmitRequest 8/*WORK_TOKEN_LOGMONITORING*/, 0, 0, @cloudClientId, 0, @cleanDataReq
					END
				END
				CLOSE clientIdCursor
				DEALLOCATE clientIdCursor
			END
			FETCH NEXT FROM deleteMonPolCursor INTO @monitoringPolicyId
		END
		CLOSE 	deleteMonPolCursor
		DEALLOCATE deleteMonPolCursor
	END
	SELECT 0, ' '
	SET NOCOUNT OFF
END

IF EXISTS (select * from GxQscripts where name = 'AppAutoDeleteMonitoringPolicy')
	delete from GxQscripts where name = 'AppAutoDeleteMonitoringPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAutoDeleteMonitoringPolicy')
	delete from GXDBVersions where aliasname = 'AppAutoDeleteMonitoringPolicy'
GO

insert into GXDBVersions values(2, 'AppAutoDeleteMonitoringPolicy',  '00000000000000000000', 'AppAutoDeleteMonitoringPolicy', '00000000000000000000')
GO

