

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppAssociateNewBackupsetToSCP.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  AppAssociateNewBackupsetToSCP
--  |
--  | Description:  SP for associating a newly created backupset to subclient
--  |				policy if backupset is part of some client group which is
--  |				associated to subclient policy
--  |
--  |       Input:  backupsetId
--  |      Output:  xxx
--  |      Return:  xxx
--  |
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppAssociateNewBackupsetToSCP <<<'

IF EXISTS (select * from sysobjects where name='AppAssociateNewBackupsetToSCP')
	drop procedure AppAssociateNewBackupsetToSCP
IF EXISTS (select * from GxQscripts where name='AppAssociateNewBackupsetToSCP')
	delete from GxQscripts where name = 'AppAssociateNewBackupsetToSCP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAssociateNewBackupsetToSCP')
	delete from GXDBVersions where aliasname = 'AppAssociateNewBackupsetToSCP'
GO
print '... Creating Procedure: AppAssociateNewBackupsetToSCP'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppAssociateNewBackupsetToSCP
  @backupsetId INT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @assocScpId INT = ISNULL((SELECT CAST(attrVal AS INT) FROM APP_BackupSetProp WHERE componentNameId = @backupsetId AND attrName = N'Associated subclient Policy' AND modified = 0), 0)
DECLARE @backupsetName NVARCHAR(256) = (SELECT name FROM APP_BackupSetName WHERE id = @backupsetId)
DECLARE @hasUserDefinedSubclients INT = ISNULL((SELECT TOP (1) 1 from App_Application SubClient
										LEFT JOIN App_SubclientProp Prop
										ON Prop.componentNameId = SubClient.id AND  attrName = N'System State Subclient'  AND Prop.modified=0
										WHERE subclientstatus=0 AND SubClient.backupSet = @backupsetId AND ((attrName=N'System State Subclient' AND attrval<>1) OR attrname is NUll)
), 0)
IF (@assocScpId = 0) AND (@backupsetName <> N'Indexing BackupSet') AND (@hasUserDefinedSubclients = 0)
BEGIN
	DECLARE @clientGroupId INT = 0
	DECLARE @scpId INT = 0
	SELECT TOP 1 @clientGroupId = ISNULL(CGAssoc.clientGroupId, 0), @scpId = ISNULL(SCPAssoc.scpId, 0)
		FROM APP_Application App
		INNER JOIN APP_ClientGroupAssoc CGAssoc
			ON App.backupSet = @backupsetId
			AND App.clientId = CGAssoc.clientId
		INNER JOIN App_ClientGroup CG
		    ON CG.id = CGAssoc.clientGroupId
		INNER JOIN APP_SubclientPolicyAssoc SCPAssoc
ON SCPAssoc.entityType = 28
			AND SCPAssoc.entityId = CGAssoc.clientGroupId
		INNER JOIN APP_Client client
			ON CGAssoc.clientId = client.id
AND (client.status & 0x10000000) =  0		--Exclude edge drive clients
		INNER JOIN APP_BackupSetProp SCPProp
			ON SCPProp.componentNameId = SCPAssoc.scpId
			AND SCPProp.attrName = N'Associated subclient Policy Ida Type'
		INNER JOIN APP_AppTypeGroup AG
			ON AG.groupName = CASE	WHEN CAST(SCPProp.attrVal AS INT) = 2 THEN 'APPGRP_WindowsFileSystemIDA'
									WHEN CAST(SCPProp.attrVal AS INT) = 3 THEN 'APPGRP_UnixFileSystem'
									ELSE '' END
		INNER JOIN APP_AppTypeGroupAssoc AGAssoc
			ON AG.appTypeGroupId = AGAssoc.appGroupId
			AND App.appTypeId = AGAssoc.appTypeId
		ORDER BY CG.name
	IF (@clientGroupId <> 0) AND (@scpId <> 0)
	BEGIN
		DECLARE @currentTime INT = dbo.GetUnixTime(GetUTCDate())
		DECLARE @returnValueTbl TABLE (rc INT)
		-- Call sp for association
		-- As SP returns row count insert it into return table
		INSERT INTO @returnValueTbl
		EXEC AppAssocSubClientPolicy @backupsetId, @scpId, @currentTime
		-- Insert scp association level as 2 (i.e. Client Group Level)
		INSERT INTO APP_BackupSetProp (componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@backupsetId, N'Subclient Policy Association Level', 7, 2, @currentTime, 0)
		-- Insert client group id for inherited association from client group level
		INSERT INTO APP_BackupSetProp (componentNameId, attrName, attrType, attrVal, created, modified)
			VALUES (@backupsetId, N'Client Group For SCP Association', 7, @clientGroupId, @currentTime, 0)
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'AppAssociateNewBackupsetToSCP')
	delete from GxQscripts where name = 'AppAssociateNewBackupsetToSCP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAssociateNewBackupsetToSCP')
	delete from GXDBVersions where aliasname = 'AppAssociateNewBackupsetToSCP'
GO

insert into GXDBVersions values(2, 'AppAssociateNewBackupsetToSCP',  '00000000000000000000', 'AppAssociateNewBackupsetToSCP', '00000000000000000000')
GO

