

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppAssocWBP.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--		July 08, 2009: Converted to SP for performance/debugging  -SKatz
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppAssocWBP.sp,v $ $Id: AppAssocWBP.sp,v 1.6.276.2 2018/03/22 01:50:00 jiechen Exp $";
-- 	+---------------------------------------------------------------------------+
--	| 						Cursor: "AppAssocWBP"								|
--	|																			|
--  |Creates a WBA (Workstation Backup Agent) Repset and copies backupset		|
--	|properties + pairs and pair props from the WBP (Workstation Backup Policy)	|
--	|to the new Repset.  Once done, there is no association	retained between	|
--	|the Policy and the new Repset/Pairs.										|
-- 	+---------------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppAssocWBP <<<'

IF EXISTS (select * from sysobjects where name='AppAssocWBP')
	drop procedure AppAssocWBP
IF EXISTS (select * from GxQscripts where name='AppAssocWBP')
	delete from GxQscripts where name = 'AppAssocWBP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAssocWBP')
	delete from GXDBVersions where aliasname = 'AppAssocWBP'
GO
print '... Creating Procedure: AppAssocWBP'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppAssocWBP
  @wbpId integer,
  @newClientId integer,
  @newApptypeId integer,
  @newRepsetName nvarchar(128),
  @isClientOSUNIX integer
AS
  DECLARE @newRepsetId integer
  DECLARE @destClientId integer
   set nocount on
DECLARE @nowTime	integer
SET		@nowTime	= dbo.GetUnixTime (GetUTCdate())
DECLARE @WBA_INSTANCE					int
SET		@WBA_INSTANCE					= 1
DECLARE @REPSET_STATUS					int
SET		@REPSET_STATUS					= 0
--   declare @destClientId	integer
 --  declare @newClientId		integer
--   declare @newApptypeId	integer
--   declare @wbpId			integer
--   declare @newRepsetName	nvarchar(128)
--   declare @isClientOSUNIX	integer
   declare @appId integer
   declare @appClientId integer
   declare @appAppTypeId integer
   declare @appinstanceId integer
   declare @appbackupsetId integer
   declare @appappNumberId integer
   declare @appdArchId integer
   declare @applArchId integer
   declare @apprefTime integer
   declare @appmodifiedTime integer
   declare @appscStatus integer
   declare @compress integer
   declare @nwAgents integer
   declare @newSCId  integer
   declare @NWWriteSpeed  integer
   declare @appscName nvarchar(128)
   declare @newBackupsetId integer
   declare @rc integer
   declare @slash	nvarchar(8)
   declare @policyCommonBaseFolder nvarchar(1024)
   declare @newCommonBaseFolder nvarchar(1024)
   declare @newClientName	nvarchar(128)
   	DECLARE @clientSourcePath			NVARCHAR(1024)
	DECLARE @destinationPath			NVARCHAR(1024)
	DECLARE @matchPath					NVARCHAR(1024)
	DECLARE @repsetDestPath				NVARCHAR(1024)
   BEGIN
		-- Will gui check that repset name does not already exist for that client, or must we??
		-- Create new Repset (do not create any subclients yet).
		Insert App_BackupsetName(name,refTime,modified,status)
				VALUES(@newRepsetName, @nowTime, @nowTime, @REPSET_STATUS)
		-- Get ID of the Repset just created
		SET @newBackupSetId = (SELECT TOP 1 buname.id from app_backupsetName as buname
				WHERE buname.name = @newRepsetName
				AND buname.refTime = @nowTime
				AND buname.modified = @nowTime
				AND status = @REPSET_STATUS)
		-- Set same repset props as in policy except Common Base folder
		INSERT APP_BACKUPSETPROP(componentNameId,attrName,attrType,attrVal,created,modified)
		Select @newBackupSetId, attrName, AttrType, AttrVal, created, modified
			FROM APP_BACKUPSETPROP
			WHERE componentNameId = @wbpId AND attrName <> 'FLR CommonBase Folder Name'
		-- 7/10/08 Common Base folder = Common Base folder from policy + source client name + repsetname
		Set @newClientName = (select name from APP_CLIENT where id = @newClientId)
		Set @policyCommonBaseFolder = (select attrval FROM APP_BACKUPSETPROP
			WHERE componentNameId = @wbpId AND attrName = 'FLR CommonBase Folder Name')
		--Check if client is UNIX and determine the type of slash (\) or (/) MR:21862
		if(@isClientOSUNIX=0)
			SET @slash = '\'
		else
			SET @slash = '/'
		-- If slash(\) exist at the end don't append slash(\)
		if((RIGHT(@policyCommonBaseFolder,1) = '\') OR (RIGHT(@policyCommonBaseFolder,1) = '/'))
			SET @newCommonBaseFolder = @policyCommonBaseFolder +  @newClientName + @slash + @newRepsetName
		else
			SET @newCommonBaseFolder = @policyCommonBaseFolder + @slash + @newClientName + @slash + @newRepsetName
	--	select @newCommonBaseFolder, @policyCommonBaseFolder, @newClientName,  @newRepsetName
		INSERT APP_BACKUPSETPROP (componentNameId,attrName,attrType,attrVal,created,modified)
			SELECT @newBackupSetId, attrName, AttrType, @newCommonBaseFolder, created, modified
			FROM APP_BACKUPSETPROP
			WHERE componentNameId = @wbpId AND attrName = 'FLR CommonBase Folder Name'
		--return destClient for the repset policy
		Set @destClientId = (select attrval FROM APP_BACKUPSETPROP
			WHERE componentNameId = @wbpId AND attrName = 'FLR Destination HostId')
		-- Get all the subclients in the DB for the Policy
		DECLARE	GetSubclientsCursor CURSOR FOR
		SELECT id, clientId,appTypeId,instance,backupSet,appNumber,dataArchGrpID,logArchGrpID,refTime,modified,subclientName,subclientStatus
			FROM APP_Application where backupset = @wbpId AND subclientStatus & 4 <> 4
		OPEN GetSubclientsCursor
		FETCH GetSubclientsCursor INTO @appId, @appClientId, @appAppTypeId ,@appinstanceId, @appbackupsetId, @appappNumberId, @appdArchId,
									@applArchId, @apprefTime,   @appmodifiedTime, @appscName, @appscStatus
		WHILE	@@FETCH_STATUS = 0
		BEGIN
			set @newSCId = 0
			-- Create a subclient under newBackupsetId for each one in the policy
			BEGIN
			  INSERT into APP_Application (clientId,appTypeId,instance,backupSet,appNumber,dataArchGrpID,logArchGrpID,refTime,modified,subclientName,subclientStatus, origCCId, GUID)
			  values(@newClientId, @newApptypeId ,@WBA_INSTANCE, @newBackupsetId, @appappNumberId, @appdArchId,
									@applArchId, @nowtime,   @nowtime, @appscName, @appscStatus, 2, newid())
			  SELECT @newSCId = id  from APP_Application where backupset = @newBackupsetId and subclientName = @appscName
			END
			-- scReplicationPair
			BEGIN
			  INSERT into APP_scReplicationPair(pairId,propType,created,modified,intVal,stringVal)
			  SELECT @newSCId, propType, created, modified, intVal, stringVal
			  from APP_scReplicationPair
			  where pairId = @appId AND modified = 0 AND proptype<>10002
			END
			--Copy the WBP's subclient content into the new subclient
 			INSERT into APP_ScFilterFile (componentNameId,type,fileName,created,modified)
 				SELECT distinct @newSCId, type, filename, @nowtime, 0
 				FROM APP_ScFilterFile
 				WHERE componentnameId = @appId AND modified = 0
 			--Copy the WBP's subclient properties into the associated subclient
 			INSERT into APP_SubClientProp (componentNameId,attrName,attrType,attrVal,created,modified)
 				SELECT distinct @newSCId, attrName, attrType, attrVal, @nowtime, 0
 				FROM APP_SubClientProp
 				WHERE componentnameId = @appId AND modified = 0
			IF @appscStatus&40 <> 40
			BEGIN
				SET @clientSourcePath = (SELECT stringVal FROM APP_scReplicationPair WHERE pairId = @appId AND modified=0 AND proptype=10001)
				if(@isClientOSUNIX=0)
	                              SET @matchPath = '%\' + @clientSourcePath + '%'
        	                else
                	              SET @matchPath = '%' + @clientSourcePath + '%'
				SET @repsetdestPath = (SELECT stringVal FROM APP_scReplicationPair WHERE pairId = @appId AND modified=0 AND proptype=10002)
				SET @destinationPath = LEFT (@repsetdestPath, PATINDEX(REPLACE(@matchPath, ':', ''), @repsetdestPath ) - 1)
				SET @destinationPath = @destinationPath + @slash + @newClientName + @slash + @newRepsetName + @slash + REPLACE(@clientSourcePath, ':', '')
				INSERT INTO APP_scReplicationPair (pairId,propType,created,modified,intVal,stringVal)
				SELECT @newSCId, 10002, @nowTime, 0, 0, @destinationPath
			END
			--Insert the sw comp and NW agent in archpipeconfig table
			Insert into archpipeconfig SELECT distinct @newSCId, compressWhere, numNWAgents, NWWriteSpeed from archpipeconfig where appNumber = @appId
			IF (@@ROWCOUNT <> 0)
			BEGIN
				insert into archpipeconfig values( @newSCId, @compress, @nwAgents, @NWWriteSpeed)
			END
			FETCH GetSubclientsCursor INTO @appId, @appClientId, @appAppTypeId ,@appinstanceId, @appbackupsetId, @appappNumberId, @appdArchId,
									@applArchId, @apprefTime,   @appmodifiedTime, @appscName, @appscStatus
		END
		CLOSE GetSubclientsCursor
		DEALLOCATE GetSubclientsCursor
	END
   select @newBackupsetId, @destClientId
   set nocount off
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'AppAssocWBP')
	delete from GxQscripts where name = 'AppAssocWBP'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAssocWBP')
	delete from GXDBVersions where aliasname = 'AppAssocWBP'
GO

insert into GXDBVersions values(2, 'AppAssocWBP',  '00010006027600020000', 'AppAssocWBP', '00010006027600020000')
GO

