

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppAssocWBAPolicy.sp] ---------- 

-- Modified fpr (CCP)
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppAssocWBAPolicy.sp,v $ $Id: AppAssocWBAPolicy.sp,v 1.24.60.2 2018/03/22 01:35:23 jiechen Exp $";
-- 	+---------------------------------------------------------------------------+
--	| 						Cursor: "AppAssocWBP"								|
--	|																			|
--  |Creates a WBA (Workstation Backup Agent) Repset and copies backupset		|
--	|properties + pairs and pair props from the WBP (Workstation Backup Policy)	|
--	|to the new Repset.  Once done, there is no association	retained between	|
--	|the Policy and the new Repset/Pairs.										|
-- 	+---------------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppAssocWBAPolicy <<<'

IF EXISTS (select * from sysobjects where name='AppAssocWBAPolicy')
	drop procedure AppAssocWBAPolicy
IF EXISTS (select * from GxQscripts where name='AppAssocWBAPolicy')
	delete from GxQscripts where name = 'AppAssocWBAPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAssocWBAPolicy')
	delete from GXDBVersions where aliasname = 'AppAssocWBAPolicy'
GO
print '... Creating Procedure: AppAssocWBAPolicy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppAssocWBAPolicy
  @i_xmlText XML,
  @i_userId INT,
  @i_localeId INT
AS
BEGIN
SET NOCOUNT ON
	DECLARE @nowTime			INT
	DECLARE @WBA_INSTANCE		INT
	DECLARE @REPSET_STATUS		INT
	DECLARE	@policyId			INT
	DECLARE	@clientId			INT
	DECLARE	@newApptypeId		INT
	DECLARE	@newRepsetName		NVARCHAR(128)
	DECLARE @appId				INT
	DECLARE @appClientId		INT
	DECLARE @appAppTypeId		INT
	DECLARE @appinstanceId		INT
	DECLARE @appbackupsetId		INT
	DECLARE @appappNumberId		INT
	DECLARE @appdArchId			INT
	DECLARE @applArchId			INT
	DECLARE @apprefTime			INT
	DECLARE @appmodifiedTime	INT
	DECLARE @appscStatus		INT
	DECLARE @compress			INT
	DECLARE @nwAgents			INT
	DECLARE @newSCId			INT
	DECLARE @NWWriteSpeed		INT
	DECLARE @appscName			NVARCHAR(128)
	DECLARE @newBackupsetId		INT
	DECLARE @rc					INT
	DECLARE @slash				NVARCHAR(8)
	DECLARE @isUpdate			INT
	DECLARE @pos				INT
	DECLARE @clientTbl			TABLE(clientId INT)
	DECLARE @clientGroupTbl		TABLE(groupId INT)
	DECLARE @errorCode			INT
	DECLARE @errorString		NVARCHAR(1024)
	DECLARE @attrName			NVARCHAR(1024)
	DECLARE @attrType			INT
	DECLARE @attrVal			NVARCHAR(1024)
	DECLARE @propType			INT
	DECLARE @intVal				INT
	DECLARE @oldIntVal			INT
	DECLARE @stringVal			NVARCHAR(1024)
	DECLARE @oldStringVal		NVARCHAR(1024)
	DECLARE @policyCommonBaseFolder		NVARCHAR(1024)
	DECLARE @newCommonBaseFolder		NVARCHAR(1024)
	DECLARE @clientSourcePath			NVARCHAR(1024)
	DECLARE @destinationPath			NVARCHAR(1024)
	DECLARE @newClientName				NVARCHAR(128)
	DECLARE @matchPath					NVARCHAR(1024)
	DECLARE @repsetDestPath				NVARCHAR(1024)
	DECLARE @jobId				INT		= 0
BEGIN TRY
BEGIN TRAN
	SET @WBA_INSTANCE = 1
	SET @REPSET_STATUS = 0
	SET @errorCode = 0
	SET @errorString = ''
SET @newApptypeId = 107
	SET @slash = '\'
	SET @nowTime = dbo.GetUnixTime (GetUTCdate())
	SET @policyId = ISNULL(( SELECT ref.value('@repsetPolicyId', 'INT')
						FROM @i_xmlText.nodes('EVGui_SyncWorkstationWithRepset') R ( ref ) ), 0)
	SET @newRepsetName = ISNULL(( SELECT ref.value('@repsetName', 'NVARCHAR(128)')
						FROM @i_xmlText.nodes('EVGui_SyncWorkstationWithRepset') R ( ref ) ), 'RepSet')
	INSERT INTO @clientTbl
	SELECT ref.value('@val', 'INT')
	FROM  @i_xmlText.nodes ('EVGui_SyncWorkstationWithRepset/clientId') R(ref)
	INSERT INTO @clientGroupTbl
	SELECT ref.value('@val', 'INT')
	FROM  @i_xmlText.nodes ('EVGui_SyncWorkstationWithRepset/clientGroupIds') R(ref)
	INSERT INTO @clientTbl
	SELECT clientId
	FROM APP_ClientGroupAssoc WHERE clientGroupId IN (
		SELECT groupId FROM @clientGroupTbl)
	DECLARE	GetClientsCursor CURSOR FOR
	SELECT DISTINCT clientId FROM @clientTbl
	OPEN GetClientsCursor
	FETCH GetClientsCursor INTO @clientId
	WHILE	@@FETCH_STATUS = 0
	BEGIN
		SET @intVal = 0
		SET @oldIntVal = 0
		SET @stringVal =''
		SET @oldStringVal = ''
		--CHECK FOR CLIENT HAVING WBA INSTALLED
IF (NOT EXISTS(SELECT * FROM APP_IdaName WHERE clientId=@clientId AND appTypeId IN (107)))
			GOTO CLIENT_CONT
		--SET @isUpdate = (SELECT COUNT(*) FROM APP_Application WHERE subclientStatus&40<>40 AND appTypeId IN (CV_APPTYPE_WORKSTATION_BACKUP) AND clientId=@clientId)
SET @isUpdate = (SELECT COUNT(DISTINCT backupset) FROM APP_Application WHERE appTypeId IN (107) AND clientId=@clientId)
		SET @newClientName = (SELECT name FROM APP_Client WHERE id = @clientId)
		-- Common Base folder = Common Base folder from policy + source client name + repsetname
		SET @policyCommonBaseFolder = (SELECT attrval FROM APP_BackupSetProp
			WHERE componentNameId = @policyId AND attrName = 'FLR CommonBase Folder Name')
		-- If slash(\) exist at the end don't append slash(\)
		IF ((RIGHT(@policyCommonBaseFolder,1) = '\') OR (RIGHT(@policyCommonBaseFolder,1) = '/'))
			SET @newCommonBaseFolder = @policyCommonBaseFolder +  @newClientName + @slash + @newRepsetName
		ELSE
			SET @newCommonBaseFolder = @policyCommonBaseFolder + @slash + @newClientName + @slash + @newRepsetName
		IF @isUpdate < 2
		BEGIN
			-- CREATE NEW REPSET (do not create any subclients yet).
			INSERT App_BackupsetName (name,reftime,modified,status)
				VALUES(@newRepsetName, @nowTime, @nowTime, @REPSET_STATUS)
			-- GET ID OF REPSET JUST CREATED
			SET @newBackupSetId = @@IDENTITY
			-- SET SAME REPSET PROPERTIES AS IN POLICY EXCEPT Common Base folder
			INSERT APP_BackupSetProp
			SELECT @newBackupSetId, attrName, AttrType, AttrVal, @nowTime, modified, ccpId
				FROM APP_BackupSetProp
				WHERE componentNameId = @policyId AND attrName <> 'FLR CommonBase Folder Name' AND modified = 0
			INSERT APP_BackupSetProp
			SELECT @newBackupSetId, attrName, AttrType, @newCommonBaseFolder, created, modified, ccpId
				FROM APP_BackupSetProp
				WHERE componentNameId = @policyId AND attrName = 'FLR CommonBase Folder Name' AND modified = 0
		END
		ELSE
		BEGIN
			-- GET ID OF EXISTING REPSET
			SET @newBackupSetId = (SELECT TOP(1) backupSet FROM APP_Application
WHERE backupSet NOT IN (SELECT id FROM App_BackupsetName WHERE status&8=8 OR status&16=16) AND appTypeId IN (107) AND clientId = @clientId)
			--CHECK FOR RUNNING JOB BEFORE TRYING AN UPDATE
IF (EXISTS(SELECT * FROM JMBkpJobInfo WHERE applicationId IN (SELECT id FROM APP_Application WHERE clientId=@clientId AND appTypeId IN (107))))
			BEGIN
				SET @errorCode = -1
SET @errorString = dbo.fn_EvFormatEventMsgText(0,@i_localeId, (994 | (CAST(POWER(2, 24) AS BIGINT) * 35)), 0,2) + N' '+ dbo.fn_EvFormatEventMsgText(0, @i_localeId, (202 | (CAST(POWER(2, 24) AS BIGINT) * 85)), 0,2) + @newClientName
				RAISERROR (@errorString,
				   11, -- Severity,
				   1 -- State,
				   )
			END
			UPDATE App_BackupsetName SET name=@newRepsetName WHERE id = @newBackupSetId
			-- REMOVE THOSE PROPERTIES THAT ARE GOING TO CHANGE
			--UPDATE APP_BackupSetProp SET modified=@nowTime
			--DELETE APP_BackupSetProp
			--WHERE componentNameId=@newBackupSetId AND attrName IN
			--(SELECT attrName FROM APP_BackupSetProp WHERE componentNameId = @policyId)
			DECLARE GetBackupSetPropCursor CURSOR FOR
			SELECT attrName, attrType, attrVal FROM APP_BackupSetProp WHERE componentNameId = @policyId AND modified=0
			OPEN GetBackupSetPropCursor
			FETCH GetBackupSetPropCursor INTO @attrName, @attrType, @stringVal
			WHILE @@FETCH_STATUS = 0
			BEGIN
				SELECT @oldStringVal = attrVal FROM APP_BackupSetProp
						WHERE attrName=@attrName AND componentNameId=@newBackupSetId AND attrType=@attrType AND modified=0
				IF @attrName = 'FLR CommonBase Folder Name'
					SET @stringVal = @newCommonBaseFolder
				IF @oldStringVal <> @stringVal OR @oldStringVal IS null
				BEGIN
					-- IF EXISTS DELETE PREVIOUS PROPERTY
					IF @oldStringVal <> '' OR @stringVal IS NOT null
						--DELETE APP_BackupSetProp
						UPDATE APP_BackupSetProp SET modified=@nowTime
							WHERE componentNameId=@newBackupSetId AND attrName=@attrName AND attrType=@attrType AND modified=0
					IF @attrName = 'FLR CommonBase Folder Name'
						SET @stringVal = @newCommonBaseFolder
					INSERT APP_BackupSetProp
					SELECT @newBackupSetId, @attrName, @attrType, @stringVal, @nowTime, 0, 0
				END
				FETCH GetBackupSetPropCursor INTO @attrName, @attrType, @stringVal
			END
			CLOSE GetBackupSetPropCursor
			DEALLOCATE GetBackupSetPropCursor
		END
		--return destClient for the repset policy
		--SET @destClientId = (SELECT attrval FROM APP_BackupSetProp
		--	WHERE componentNameId = @policyId AND attrName = 'FLR Destination HostId')
		--CLEAN UP JOBMANAGER TABLES  (DEFECT 52019)
		DELETE FROM JMJobStats
			WHERE jobId IN
				(SELECT jobiD from JMCdrJobs WHERE [pairId] in (SELECT id
			                     FROM APP_Application
			                    WHERE appTypeId IN (107) AND clientId=@clientId AND (subClientStatus&40) <>40) AND commcellId = 2)
		DELETE  JMCdrJobs
			WHERE [pairId] in (SELECT id
			                     FROM APP_Application
			                    WHERE appTypeId IN (107) AND clientId=@clientId AND (subClientStatus&40) <>40)
		--MARK EXISTING PROPERTY AS MODIFIED
	    UPDATE APP_ScReplicationPair SET modified = @nowTime WHERE pairId IN (SELECT id	FROM APP_Application WHERE appTypeId IN (107) AND clientId=@clientId AND subClientStatus&40<>40) AND modified = 0
		--MARK ANY EXISTING SUBCLIENTS AS DELETED
UPDATE APP_Application SET subClientStatus=subClientStatus|4 WHERE appTypeId IN (107) AND clientId=@clientId AND subClientStatus&40<>40
		-- Get all the subclients in the DB for the Policy
		DECLARE GetSubclientsCursor CURSOR FOR
			SELECT id, clientId, appTypeId, instance, backupSet, appNumber, dataArchGrpID,
					logArchGrpID, refTime, modified, subclientName, subclientStatus
		FROM APP_Application
			WHERE backupset = @policyId AND appTypeId = 1090
		OPEN GetSubclientsCursor
		FETCH GetSubclientsCursor INTO @appId, @appClientId, @appAppTypeId ,@appinstanceId, @appbackupsetId, @appappNumberId, @appdArchId,
					@applArchId, @apprefTime, @appmodifiedTime, @appscName, @appscStatus
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SET @intVal = 0
			SET @oldIntVal = 0
			SET @stringVal =''
			SET @oldStringVal = ''
			SET @newSCId = 0
			SET @isUpdate = (SELECT COUNT(*) FROM APP_Application WHERE clientId=@clientId AND subclientName=@appscName AND backupset=@newBackupsetId)
			IF @isUpdate = 0
			BEGIN
				-- CREATE A SUBCLIENT UNDER newBackupsetId FOR EACH ONE IN THE POLICY
				INSERT INTO APP_Application (clientId,appTypeId,instance,backupSet,appNumber,dataArchGrpID,logArchGrpID,refTime,modified,subclientName,subclientStatus,ccpId,ccpTime, origCCId, GUID)
				VALUES(@clientId, @newApptypeId ,@WBA_INSTANCE, @newBackupsetId, @appappNumberId, @appdArchId,
							@applArchId, @nowtime, @nowtime, @appscName, @appscStatus, 0, 0, 2, newid())
			END
			ELSE
			BEGIN
				UPDATE APP_Application SET subClientStatus=@appscStatus WHERE backupset=@newBackupsetId AND subclientName=@appscName
				UPDATE APP_ScReplicationPair SET modified = 0 WHERE pairId IN (SELECT id FROM APP_Application WHERE backupset=@newBackupsetId AND subclientStatus=@appscStatus AND subclientName=@appscName) AND modified = @nowTime
			END
			SELECT @newSCId = id FROM APP_Application WHERE backupset=@newBackupsetId AND subclientStatus=@appscStatus AND subclientName=@appscName
			IF @appscStatus&40 <> 40 AND @appscStatus & 4 <> 4
			BEGIN
				SET @clientSourcePath = (SELECT stringVal FROM APP_scReplicationPair WHERE pairId = @appId AND modified=0 AND proptype=10001)
				SET @matchPath = '%\' + @clientSourcePath + '%'
				SET @repsetdestPath = (SELECT stringVal FROM APP_scReplicationPair WHERE pairId = @appId AND modified=0 AND proptype=10002)
				SET @destinationPath = LEFT (@repsetdestPath, PATINDEX(REPLACE(@matchPath, ':', ''), @repsetdestPath ) - 1)
				SET @destinationPath = @destinationPath + @slash + @newClientName + @slash + @newRepsetName + @slash + REPLACE(@clientSourcePath, ':', '')
				--INSERT INTO APP_scReplicationPair
				--SELECT @newSCId, 10002, @nowTime, 0, 0, @destinationPath
			END
			DECLARE GetReplicationPairCursor CURSOR FOR
			SELECT propType, intVal, stringVal FROM APP_scReplicationPair WHERE pairId = @appId AND modified = 0
			OPEN GetReplicationPairCursor
			FETCH GetReplicationPairCursor INTO @propType, @intVal, @stringVal
			WHILE @@FETCH_STATUS = 0
			BEGIN
				SET @oldStringVal = (SELECT stringVal FROM APP_scReplicationPair
						WHERE pairId=@newSCId AND propType=@propType AND modified=0)
				SET @oldIntVal = (SELECT intVal FROM APP_scReplicationPair
						WHERE pairId=@newSCId AND propType=@propType AND modified=0)
				IF @propType = 10002
					SET @stringVal = @destinationPath
				IF @oldStringVal <> @stringVal OR @oldIntVal <> @intVal OR @isUpdate = 0 OR
					(@oldStringVal IS null AND @oldIntVal IS null)
				BEGIN
					-- IF EXISTS DELETE PREVIOUS PROPERTY
					IF @oldStringVal <> '' OR @oldIntVal <> 0 OR
					 (@oldStringVal IS NOT null AND @oldIntVal IS NOT null)
					BEGIN
						--REMOVE PREVIOUS MODIFIED
						DELETE APP_scReplicationPair
							WHERE pairId=@newSCId AND propType=@propType AND modified<>0
						UPDATE APP_scReplicationPair SET modified=@nowTime
							WHERE pairId=@newSCId AND propType=@propType
					END
					IF @propType = 10002
						SET @stringVal = @destinationPath
					INSERT APP_scReplicationPair
					SELECT @newSCId, @propType, @nowTime, 0, @intVal, @stringVal
				END
				FETCH GetReplicationPairCursor INTO @propType, @intVal, @stringVal
			END
			CLOSE GetReplicationPairCursor
			DEALLOCATE GetReplicationPairCursor
			-- scReplicationPair
			--IF @isUpdate > 0
			--BEGIN
			--	UPDATE APP_scReplicationPair SET modified=@nowTime
			--	WHERE pairId = @newSCId AND modified=0
			--	--DELETE APP_scReplicationPair WHERE pairId = @newSCId
			--END
			--INSERT INTO APP_scReplicationPair
			--SELECT @newSCId, propType, @nowTime, modified, intVal, stringVal
			--FROM APP_scReplicationPair
			--WHERE pairId = @appId AND modified=0 AND proptype<>10002
			IF @isUpdate > 0
			BEGIN
				UPDATE APP_ScFilterFile SET modified=@nowTime
				WHERE componentnameId = @newSCId AND modified = 0
			END
			INSERT INTO APP_ScFilterFile (componentNameId, type, fileName, created, modified)
				SELECT DISTINCT @newSCId, type, filename, @nowtime, 0
				FROM APP_ScFilterFile
				WHERE componentnameId = @appId AND modified = 0 AND
					filename NOT IN (SELECT filename FROM APP_ScFilterFile WHERE componentnameId = @newSCId AND modified = 0)
			DECLARE GetSubClientPropCursor CURSOR FOR
			SELECT attrName, attrType, attrVal FROM APP_SubClientProp WHERE componentnameId = @appId AND modified = 0
			OPEN GetSubClientPropCursor
			FETCH GetSubClientPropCursor INTO @attrName, @attrType, @attrVal
			WHILE @@FETCH_STATUS = 0
			BEGIN
				SET @oldStringVal = (SELECT attrVal FROM APP_SubClientProp
						WHERE componentnameId=@newSCId AND @attrName=attrName AND attrType=@attrType AND modified=0)
				IF @oldStringVal<>@attrVal OR @oldStringVal IS null
				BEGIN
					IF @oldStringVal <> '' OR @oldStringVal IS NOT null
						UPDATE APP_SubClientProp SET modified=@nowTime
						WHERE componentnameId=@newSCId AND @attrName=attrName AND attrType=@attrType AND modified=0
					--Copy the WBP's subclient properties into the associated subclient
					INSERT INTO APP_SubClientProp
						SELECT @newSCId, @attrName, @attrType, @attrVal, @nowtime, 0, 0
				END
				FETCH GetSubClientPropCursor INTO @attrName, @attrType, @attrVal
			END
			CLOSE GetSubClientPropCursor
			DEALLOCATE GetSubClientPropCursor
			IF @isUpdate > 0
			BEGIN
				DELETE archpipeconfig WHERE appNumber=@newSCId
			END
			--Insert the sw comp and NW agent in archpipeconfig table
			INSERT INTO archpipeconfig SELECT DISTINCT @newSCId, compressWhere, numNWAgents, NWWriteSpeed FROM archpipeconfig
			WHERE appNumber = @appId
			IF (@@ROWCOUNT <> 0 AND @isUpdate = 0)
			BEGIN
				INSERT INTO archpipeconfig VALUES( @newSCId, @compress, @nwAgents, @NWWriteSpeed)
			END
SUBCLIENT_CONT:
			FETCH GetSubclientsCursor INTO @appId, @appClientId, @appAppTypeId ,@appinstanceId, @appbackupsetId, @appappNumberId, @appdArchId,
									@applArchId, @apprefTime, @appmodifiedTime, @appscName, @appscStatus
		END
		CLOSE GetSubclientsCursor
		DEALLOCATE GetSubclientsCursor
CLIENT_CONT:
		FETCH GetClientsCursor INTO @clientId
	END
	CLOSE GetClientsCursor
	DEALLOCATE GetClientsCursor
	COMMIT TRAN
END TRY
---------------------------------------------
-- CHECK FOR ERRORS ----
---------------------------------------------
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	-- Call procedure to print error information.
	-- Call procedure to get error information.
	DECLARE @errStr NVARCHAR(1024)
	EXECUTE dbo.GetError @errStr OUTPUT , @errorCode OUTPUT
	--Close cursor
	IF ( CURSOR_STATUS('global', 'GetBackupSetPropCursor') >= 0  /* cursor is open */
		OR CURSOR_STATUS('local', 'GetBackupSetPropCursor') >= 0 )
		CLOSE GetBackupSetPropCursor
	IF ( CURSOR_STATUS('global', 'GetReplicationPairCursor') >= 0  /* cursor is open */
		OR CURSOR_STATUS('local', 'GetReplicationPairCursor') >= 0 )
		CLOSE GetReplicationPairCursor
	IF ( CURSOR_STATUS('global', 'GetSubClientPropCursor') >= 0  /* cursor is open */
		OR CURSOR_STATUS('local', 'GetSubClientPropCursor') >= 0 )
		CLOSE GetSubClientPropCursor
	IF ( CURSOR_STATUS('global', 'GetSubclientsCursor') >= 0  /* cursor is open */
		OR CURSOR_STATUS('local', 'GetSubclientsCursor') >= 0 )
		CLOSE GetSubclientsCursor
	IF ( CURSOR_STATUS('global', 'GetClientsCursor') >= 0  /* cursor is open */
		OR CURSOR_STATUS('local', 'GetClientsCursor') >= 0 )
		CLOSE GetClientsCursor
	IF ( CURSOR_STATUS('global','GetBackupSetPropCursor') = -1  /* cursor is closed */
		OR CURSOR_STATUS('local','GetBackupSetPropCursor') = -1 )
		DEALLOCATE GetBackupSetPropCursor
	IF ( CURSOR_STATUS('global','GetReplicationPairCursor') = -1  /* cursor is closed */
		OR CURSOR_STATUS('local','GetReplicationPairCursor') = -1 )
		DEALLOCATE GetReplicationPairCursor
	IF ( CURSOR_STATUS('global','GetSubClientPropCursor') = -1  /* cursor is closed */
		OR CURSOR_STATUS('local','GetSubClientPropCursor') = -1 )
		DEALLOCATE GetSubClientPropCursor
	IF ( CURSOR_STATUS('global','GetSubclientsCursor') = -1  /* cursor is closed */
		OR CURSOR_STATUS('local','GetSubclientsCursor') = -1 )
		DEALLOCATE GetSubclientsCursor
	IF ( CURSOR_STATUS('global','GetClientsCursor') = -1  /* cursor is closed */
		OR CURSOR_STATUS('local','GetClientsCursor') = -1 )
		DEALLOCATE GetClientsCursor
	-- Rollback any active or uncommittable transactions before
	-- inserting information in the ErrorLog
	IF XACT_STATE() <> 0
	BEGIN
		ROLLBACK TRANSACTION;
	END
END CATCH;
EXIT_PROC:
	SELECT	1					as TAG,
		NULL					as Parent,
		@errorCode				as [CVGui_GenericResp!1!errorCode],
		@errorString			as [CVGui_GenericResp!1!errorMessage]
	FOR XML EXPLICIT
END
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'AppAssocWBAPolicy')
	delete from GxQscripts where name = 'AppAssocWBAPolicy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAssocWBAPolicy')
	delete from GXDBVersions where aliasname = 'AppAssocWBAPolicy'
GO

insert into GXDBVersions values(2, 'AppAssocWBAPolicy',  '00010024006000020000', 'AppAssocWBAPolicy', '00010024006000020000')
GO

