

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppAssocSubClientPolicyToSubclient.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppAssocSubClientPolicyToSubclient.sp,v $ $Id: AppAssocSubClientPolicyToSubclient.sp,v 1.1.2.4 2020/08/12 06:57:07 alakra Exp $";
-- 	+-----------------------------------------------------------------------------------+
--	| 					Procedure: "AppAssocSubClientPolicyToSubclient"					|
--	|																					|
--  |Associate the default subclient of Subclient Policy to the provided subclient Id	|
-- 	+-----------------------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AppAssocSubClientPolicyToSubclient')
BEGIN
	print '>>> Drop Stored Procedure: AppAssocSubClientPolicyToSubclient <<<'
	drop procedure AppAssocSubClientPolicyToSubclient
END
IF EXISTS (select * from GxQscripts where name='AppAssocSubClientPolicyToSubclient')
	delete from GxQscripts where name = 'AppAssocSubClientPolicyToSubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAssocSubClientPolicyToSubclient')
	delete from GXDBVersions where aliasname = 'AppAssocSubClientPolicyToSubclient'
GO
print '... Creating Procedure: AppAssocSubClientPolicyToSubclient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppAssocSubClientPolicyToSubclient
  @i_id INTEGER,
  @scpId INTEGER,
  @timeStamp INTEGER
AS
  DECLARE @errorCode INTEGER
  DECLARE @errorString NVARCHAR(MAX)
 SET NOCOUNT ON
 BEGIN TRY
	SET @errorCode = 0
	SET @errorString = N''
   declare @appId			integer
   declare @appClientId		integer
   declare @appAppTypeId	integer
   declare @appinstanceId	integer
   declare @appbackupsetId	integer
   declare @appappNumberId	integer
   declare @appdArchId		integer
   declare @applArchId		integer
   declare @apprefTime		integer
   declare @appmodifiedTime	integer
   declare @appscStatus		integer
   declare @compress		integer
   declare @nwAgents		integer
   declare @NWWriteSpeed	integer
   declare @appscName		nvarchar(128)
   declare @useSubclientPolicyRetention integer
   DECLARE @subclientOfSCPId INTEGER
   BEGIN
IF OBJECT_ID('tempdb.dbo.#DecoupledRetentionProperties') IS NOT null
DROP TABLE #DecoupledRetentionProperties
CREATE TABLE #DecoupledRetentionProperties
(
	attrName nvarchar(510)
)
INSERT #DecoupledRetentionProperties(attrName)
VALUES(N'Archived expiration days'),
		(N'Is Turbo Subclient'),
		(N'Is Archive Retention Mode Enabled'),
		(N'Is Backup Retention Mode Enabled'),
		(N'Days to keep items past their expiration'),
		(N'Keep older Synth Full Versions'),
		(N'Keep items past their expiration'),
		(N'Number of Days of Synth Full Versions'),
		(N'Number of Synth Full Versions'),
		(N'User deleted stubs expiration days'),
		(N'Retain daily version period'),
		(N'Retain weekly version period'),
		(N'Retain monthly version period')
IF OBJECT_ID('tempdb.dbo.#decoupledArchivalRules') IS NOT NULL
	DROP TABLE #decoupledArchivalRules
CREATE TABLE #decoupledArchivalRules
(
	attrName VARCHAR(MAX),
	cs_attrName INT
)
INSERT INTO #decoupledArchivalRules
VALUES	('Num of Days Old',							CHECKSUM(N'Num of Days Old')),
('Num of Days Old Modified',					CHECKSUM(N'Num of Days Old Modified')),
('Minimum File Size',							CHECKSUM(N'Minimum File Size')),
('Num of Days Old Created',					CHECKSUM(N'Num of Days Old Created')),
('Maximum File Size',							CHECKSUM(N'Maximum File Size')),
('DiskCleanup File Types',				CHECKSUM(N'DiskCleanup File Types')),
('Low Percent Disk Space Free',			CHECKSUM(N'Low Percent Disk Space Free')),
('Percent Disk Space Free',				CHECKSUM(N'Percent Disk Space Free')),
('Data Migrator Rule Flag',				CHECKSUM(N'Data Migrator Rule Flag')),
('Enable Redundancy For Data Backedup',	CHECKSUM(N'Enable Redundancy For Data Backedup')),
('Stub pruning Options',				CHECKSUM(N'Stub pruning Options')),
('Stub Retention Time',				CHECKSUM(N'Stub Retention Time'))
		IF OBJECT_ID('tempdb.dbo.#decoupledLocalcontent') IS NOT NULL
			DROP TABLE #decoupledLocalcontent
		CREATE TABLE #decoupledLocalcontent
		(
			attrName VARCHAR(MAX)
		)
		INSERT INTO #decoupledLocalcontent
			VALUES	('System State'),
					('use cs setting for global filters'),
					('use global filters')
	   IF object_id('tempdb.dbo.#bkpSetInfo') IS NOT NULL
			DROP TABLE #bkpSetInfo
	   CREATE TABLE #bkpSetInfo(backupsetId INT, newClientId INT, newAppTypeId INT,newInstanceId INT,newSCId INT,clientReleaseId INT,dataArchGrpID INT,isSCInserted  INT)
SELECT  @subclientOfSCPId = id FROM APP_Application WHERE backupset=@scpId AND subclientStatus&0x00008=0x00008 AND appTypeId=1030
	   IF(@i_id<>0)
	   BEGIN
			INSERT INTO #bkpSetInfo(backupsetId, newClientId , newAppTypeId ,newInstanceId ,newSCId, dataArchGrpID, isSCInserted)
			SELECT backupset, clientId, appTypeId, instance, id, dataArchGrpID, 0 FROM APP_Application where id=@i_id
	   END
		--Set Enable Archive on agents of associated backupset
		DECLARE @ESPEnabled INT = ISNULL((SELECT TOP 1 1 FROM APP_Application subclient
											INNER JOIN APP_SubClientProp prop
												ON subclient.id = prop.componentNameId
											INNER JOIN APP_SubClientProp ESP
												ON subclient.id = ESP.componentNameId
										WHERE subclient.id = @subclientOfSCPId
											AND prop.attrName = N'Subclient Policy Has Retention' AND prop.attrVal = '1' AND prop.modified = 0
											AND ESP.attrName = N'Is Turbo Subclient' AND ESP.attrVal = N'1' AND ESP.modified = 0)
									, 0)
		--Subclient policy has Retention tab with Extend storage policy property. If this property is enabled then set Enable Archive on FS agent of associated backupset.
		IF @ESPEnabled = 1
		BEGIN
			IF OBJECT_ID('tempdb.dbo.#ESPAgents') IS NOT NULL
			DROP TABLE #ESPAgents
			CREATE TABLE #ESPAgents (agentId INT PRIMARY KEY )
			INSERT #ESPAgents
			SELECT DISTINCT agent.id
			FROM APP_Application subclient
			INNER JOIN APP_IDAName agent ON agent.clientId = subclient.clientId AND agent.appTypeId = subclient.appTypeId
			INNER JOIN APP_AppTypeGroupAssoc appType ON appType.appTypeId = subclient.appTypeId AND appType.appGroupId IN(22,34) AND appType.typeOfGroup = 0 --22:WinFS and 34:UnixFS
			INNER JOIN APP_ClientProp client ON client.componentNameId = subclient.clientId
			WHERE client.attrName = N'IndexingV2' AND client.attrVal = N'1' AND client.modified = 0
				AND subclient.id=@i_id
			UPDATE T
			SET T.modified = @timeStamp
			FROM APP_IDAProp T
			INNER JOIN #ESPAgents as Src ON T.componentNameId = Src.agentId
			WHERE T.attrName = N'Enable Archive' AND T.attrVal = N'0' AND T.modified = 0
			MERGE APP_IDAProp as Dest
			USING #ESPAgents as Src
			ON Dest.componentNameId = Src.agentId AND Dest.attrName = N'Enable Archive' AND Dest.attrVal = N'1' AND Dest.modified = 0
			WHEN NOT MATCHED THEN
				INSERT (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
				VALUES(Src.agentId, N'Enable Archive', 2, N'1', @timeStamp, 0, 0);
		END
		UPDATE BkpSet SET BkpSet.clientReleaseId = ISNULL(releaseId,0)
		FROM #bkpSetInfo BkpSet
		INNER JOIN App_Client WITH (nolock) ON id = newClientId
		DECLARE	GetSubclientsCursor CURSOR FOR
		SELECT id,clientId,appTypeId,instance,backupSet,appNumber,dataArchGrpID,logArchGrpID,refTime,modified,subclientName,subclientStatus
			FROM APP_Application where id = @subclientOfSCPId
		OPEN GetSubclientsCursor
		FETCH GetSubclientsCursor INTO @appId, @appClientId, @appAppTypeId ,@appinstanceId, @appbackupsetId, @appappNumberId, @appdArchId,
									@applArchId, @apprefTime,   @appmodifiedTime, @appscName, @appscStatus
		WHILE	@@FETCH_STATUS = 0
		BEGIN
			-- We only refer to default subclient of subclient policy. So this is always true -- Arvind
			--if it is default subclient, update will take place.
			IF ((@appscStatus & 8) = 8)
			BEGIN
			  --MR 146895: Do not change last backuptime
			  --If there is change in the dataarchiveID or logarchiveId, then we need to change the last backup time and set the reason for clearinig the backup time
			  --MR: 163985: Now bring back the code, it is enabled on key bEnablePopUpMessageDuringStoragePolicyChange
				IF EXISTS(SELECT 1 FROM APP_AdvanceSettings WHERE keyName = 'bEnablePopUpMessageDuringStoragePolicyChange' AND relativePath = 'CommServDB.Console' AND type = 'BOOLEAN' AND cast([value] as nvarchar(32)) = N'true' AND enabled = 1 AND deleted = 0 AND entityType = 3 AND entityId = 2)
				BEGIN
					UPDATE scp SET attrVal = N'0'
					FROM APP_SubClientProp scp
					INNER JOIN #bkpSetInfo BkpSet ON BkpSet.newSCId = scp.componentNameId AND scp.attrName IN('sys:last full','sys:last incr')  AND scp.modified=0
					WHERE BkpSet.dataArchGrpID <> @appdArchId
					MERGE APP_SubClientProp as Target
					USING
					(
						SELECT bkpset.newSCid AS componentNameId, N'Reason last backup time cleared' as attrName
						FROM #bkpSetInfo bkpset
						WHERE bkpset.dataArchGrpID <> @appdArchId
					)AS SOURCE
					ON(Target.componentNameId = Source.componentNameId AND Target.attrName = Source.attrName AND Target.modified=0)
					WHEN MATCHED THEN
						UPDATE SET Target.attrval = N'9'
					WHEN NOT MATCHED BY TARGET THEN
						INSERT(componentNameId,attrName,attrType,attrVal,created,modified)
						VALUES(Source.componentNameId,Source.attrName,7,9,@timeStamp,0);
				END
			   UPDATE App  set App.dataArchGrpID = @appdArchId,  App.logArchGrpID = @applArchId
				FROM  APP_Application App
			   INNER JOIN #bkpsetinfo bkpset ON App.id = bkpset.newSCId
			END
			DECLARE @usingLocalContent INT = 0
SELECT @usingLocalContent = attrVal FROM APP_SubClientProp WHERE componentNameId = @i_id AND modified = 0 AND attrName = 'Use Local Content' AND cs_attrname=CHECKSUM(N'Use Local Content')
			IF (@usingLocalContent = 0)
			BEGIN
				--AGE OFF THE ALREADY DEFINED CONTENT AND FILTER OF THE SC
				UPDATE FF SET FF.modified = @timeStamp
				FROM APP_ScFilterFile FF
				INNER JOIN #bkpSetInfo bkpset ON bkpset.newSCId = FF.componentNameId AND FF.modified = 0
				UPDATE APP_SubclientProp
					SET attrval='1'
				FROM APP_SubclientProp SCP
					INNER JOIN #bkpSetInfo bkpset
						ON bkpset.newSCId = SCP.componentNameId
						AND SCP.modified = 0
				WHERE attrName='use SCP filters' AND cs_attrName=CHECKSUM(N'use SCP filters')
			END
			ELSE
			BEGIN
				-- If Local content is deriving instead of plan content, then filter should not be honored from SCP
				UPDATE APP_SubclientProp
					SET attrval='0'
				FROM APP_SubclientProp SCP
					INNER JOIN #bkpSetInfo bkpset
						ON bkpset.newSCId = SCP.componentNameId
						AND SCP.modified = 0
				WHERE attrName='use SCP filters' AND cs_attrName=CHECKSUM(N'use SCP filters')
				--Insert use SCP filter property when not present.
				-- this is needed for default subclient as this property is missing from subclient prop
				INSERT INTO APP_SubClientProp (componentNameId,attrName,attrType,attrVal,created,modified)
				SELECT newSCId, N'use SCP filters' , 2 , '0', @timeStamp , 0
					FROM #bkpSetInfo bkpset
					LEFT OUTER JOIN APP_SubclientProp ASCP
						ON ASCP.componentNameId=bkpset.newSCId AND ASCP.attrName='use SCP filters' AND ASCP.cs_attrName=CHECKSUM(N'use SCP filters') AND ASCP.modified=0
				WHERE ASCP.id IS NULL
			END
			DECLARE @useLocalArchiveRules INT = 0
			SELECT @useLocalArchiveRules = CAST(attrVal AS INT)
			FROM APP_SubclientProp
			WHERE
				componentNameId = @i_id
AND attrName = 'Use Local Archival Rules'
AND cs_attrname=CHECKSUM(N'Use Local Archival Rules')
				AND modified = 0
			IF @useLocalArchiveRules IS NULL
				SET @useLocalArchiveRules = 0
			IF @useLocalArchiveRules = 0
			BEGIN
				-- Update the existing archival rules. We are going to use the plan's archival rules.
				UPDATE APP_SubclientProp
				SET modified = @timeStamp
				FROM APP_SubclientProp SCP
					INNER JOIN #bkpSetInfo bkpset
						ON bkpset.newSCId = SCP.componentNameId
						AND SCP.modified = 0
					INNER JOIN #decoupledArchivalRules ArcRules
						ON SCP.attrName = ArcRules.attrName
			END
			-- Else, we are going to use local archival rules. If there are some rules already configured, leave it as it is.
			SET @useSubclientPolicyRetention = ISNULL((SELECT attrVal FROM APP_SubclientProp WITH (NOLOCK) WHERE componentNameId = @appId AND attrName = N'Subclient Policy Has Retention' AND modified = 0), 0)
			IF @useSubclientPolicyRetention > 0
			BEGIN
				--AGE OFF THE ALREADY DEFINED OVERLAPPED PROPERTIES
				UPDATE SCP SET SCP.modified = @timeStamp
				FROM APP_SubClientProp SCP
				INNER JOIN #bkpSetInfo bkpset ON bkpset.newSCId = SCP.componentNameId AND SCP.modified = 0
				INNER JOIN APP_SubClientProp Prop2 ON Prop2.componentnameId = @appId AND Prop2.attrName = SCP.attrName AND Prop2.modified = 0
				LEFT OUTER JOIN #decoupledArchivalRules ArcRules ON ArcRules.attrName = SCP.attrName			-- Ignore archiving rules tab here, it is already handled.
				LEFT OUTER JOIN #decoupledLocalcontent LocalRules ON LocalRules.attrName = SCP.attrName
				WHERE
					ArcRules.attrName IS NULL
					AND SCP.attrName <> N'Turbo Mode Enable Stubbing'											-- Should not age this property. This is the only one to tell that subclient is one-pass and is being leverage at lot of code.
					AND LocalRules.attrName IS NULL
				--AGE OFF "DEFAULT" PROPERTIES OF SCP THAT MAY NOT HAVE BEEN SET YET
				UPDATE SCP SET SCP.modified = @timeStamp
				FROM APP_SubClientProp SCP
				INNER JOIN #bkpSetInfo bkpset ON bkpset.newSCId = SCP.componentNameId AND SCP.modified = 0
				INNER JOIN APP_CCP_prop CCP ON CCP.attrName=SCP.attrName AND CCP.componentLevel = 50
				LEFT OUTER JOIN #decoupledArchivalRules ArcRules ON ArcRules.attrName = SCP.attrName			-- Ignore archiving rules tab here, it is already handled.
				LEFT OUTER JOIN #decoupledLocalcontent LocalRules ON LocalRules.attrName = SCP.attrName
				WHERE
					ArcRules.attrName IS NULL
					AND SCP.attrName <> N'Turbo Mode Enable Stubbing'											-- Should not age this property. This is the only one to tell that subclient is one-pass and is being leverage at lot of code.
					AND LocalRules.attrName IS NULL
			END
			ELSE
			BEGIN
				--AGE OFF THE ALREADY DEFINED OVERLAPPED PROPERTIES
				UPDATE SCP SET SCP.modified = @timeStamp
				FROM APP_SubClientProp SCP
				INNER JOIN #bkpSetInfo bkpset ON bkpset.newSCId = SCP.componentNameId AND SCP.modified = 0
				INNER JOIN APP_SubClientProp Prop2 ON Prop2.componentnameId = @appId AND Prop2.attrName = SCP.attrName AND Prop2.modified = 0
				LEFT JOIN #DecoupledRetentionProperties RET ON Prop2.attrName = RET.attrName
				LEFT OUTER JOIN #decoupledArchivalRules ArcRules ON ArcRules.attrName = SCP.attrName			-- Ignore archiving rules tab here, it is already handled.
				LEFT OUTER JOIN #decoupledLocalcontent LocalRules ON LocalRules.attrName = SCP.attrName
				WHERE
					RET.attrName IS NULL
					AND ArcRules.attrName IS NULL
					AND SCP.attrName <> N'Turbo Mode Enable Stubbing'											-- Should not age this property. This is the only one to tell that subclient is one-pass and is being leverage at lot of code.
					AND LocalRules.attrName IS NULL
				--AGE OFF "DEFAULT" PROPERTIES OF SCP THAT MAY NOT HAVE BEEN SET YET
				UPDATE SCP SET SCP.modified = @timeStamp
				FROM APP_SubClientProp SCP
				INNER JOIN #bkpSetInfo bkpset ON bkpset.newSCId = SCP.componentNameId AND SCP.modified = 0
				INNER JOIN APP_CCP_prop CCP ON CCP.attrName=SCP.attrName AND componentLevel = 50
				LEFT JOIN #DecoupledRetentionProperties RET ON CCP.attrName = RET.attrName
				LEFT OUTER JOIN #decoupledArchivalRules ArcRules ON ArcRules.attrName = SCP.attrName			-- Ignore archiving rules tab here, it is already handled.
				LEFT OUTER JOIN #decoupledLocalcontent LocalRules ON LocalRules.attrName = SCP.attrName
				WHERE
					RET.attrName IS NULL
					AND ArcRules.attrName IS NULL
					AND SCP.attrName <> N'Turbo Mode Enable Stubbing'											-- Should not age this property. This is the only one to tell that subclient is one-pass and is being leverage at lot of code.
					AND LocalRules.attrName IS NULL
			END
			DELETE APC
			FROM archpipeconfig APC
			INNER JOIN #bkpSetInfo bkpset on appNumber = newSCId
			-- Age of older subclient policy value
			UPDATE FF SET FF.modified = @timeStamp
				FROM APP_SubClientProp FF
				INNER JOIN #bkpSetInfo bkpset ON bkpset.newSCId = FF.componentNameId AND FF.modified = 0 AND FF.attrname=N'Associated subclient Policy' AND FF.cs_attrname=CHECKSUM(N'Associated subclient Policy')
			--Insert the association id
			INSERT INTO APP_SubClientProp (componentNameId,attrName,attrType,attrVal,created,modified)
			SELECT newSCId, N'Associated subclient Policy' , 10 , @appId, @timeStamp , 0 FROM #bkpSetInfo
			--Insert the sw comp and NW agent in archpipeconfig table
			Select @compress = compressWhere, @nwAgents = numNWAgents, @NWWriteSpeed = NWWriteSpeed  from archpipeconfig where appNumber = @appId
			IF (@@ROWCOUNT <> 0)
			BEGIN
				INSERT INTO archpipeconfig
				SELECT newSCId, @compress, @nwAgents, @NWWriteSpeed FROM #bkpSetInfo
			END
			FETCH GetSubclientsCursor INTO @appId, @appClientId, @appAppTypeId ,@appinstanceId, @appbackupsetId, @appappNumberId, @appdArchId,
									@applArchId, @apprefTime,   @appmodifiedTime, @appscName, @appscStatus
		END
		CLOSE GetSubclientsCursor
		DEALLOCATE GetSubclientsCursor
		DROP TABLE #bkpSetInfo
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode    = ERROR_NUMBER()
	SET @errorString  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
	-- That implies no error else we will get exception
   SELECT @errorCode, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'AppAssocSubClientPolicyToSubclient')
	delete from GxQscripts where name = 'AppAssocSubClientPolicyToSubclient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAssocSubClientPolicyToSubclient')
	delete from GXDBVersions where aliasname = 'AppAssocSubClientPolicyToSubclient'
GO

insert into GXDBVersions values(2, 'AppAssocSubClientPolicyToSubclient',  '00010001000200040000', 'AppAssocSubClientPolicyToSubclient', '00010001000200040000')
GO

