

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppApplyFWConfig80.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AppApplyFWConfig80.sp,v $ $Id: AppApplyFWConfig80.sp,v 1.4.60.1 2017/02/10 20:59:45 sjohnson Exp $";
--
--  +========================================================================+
--  |   Procedure:  AppApplyFWConfig80()
--  |
--  | Description:  xx
--  |
--  |       Input:  xx
--  |
--  |      Output:  Applies firewall config for 80 clients
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Bhavyan Mehta   Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AppApplyFWConfig80 <<<'

IF EXISTS (select * from sysobjects where name='AppApplyFWConfig80')
	drop procedure AppApplyFWConfig80
IF EXISTS (select * from GxQscripts where name='AppApplyFWConfig80')
	delete from GxQscripts where name = 'AppApplyFWConfig80'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppApplyFWConfig80')
	delete from GXDBVersions where aliasname = 'AppApplyFWConfig80'
GO
print '... Creating Procedure: AppApplyFWConfig80'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AppApplyFWConfig80
  @i_clientId integer,
  @i_xml XML
AS
  DECLARE @o_errorCode integer
SET NOCOUNT ON
BEGIN
	DECLARE @PortRangeTbl TABLE ( id int identity(1,1) PRIMARY KEY , startPort int, endPort int )
	DECLARE @OnDemandListTbl TABLE ( clientId int )
	DECLARE @PassiveListTbl  TABLE ( clientId int )
	DECLARE @PersistentListTbl TABLE ( clientId int )
	SET	@o_errorCode = 0
BEGIN TRY
BEGIN TRAN
	INSERT INTO @PortRangeTbl
		SELECT ref.value('@startPort', 'int'), ref.value('@endPort', 'int')
		FROM  @i_xml.nodes ('EVGui_ApplyFWConfig80Req/portRange') R(ref)
	INSERT INTO @OnDemandListTbl
		SELECT ref.value('@val', 'int')
		FROM  @i_xml.nodes ('EVGui_ApplyFWConfig80Req/onDemandList') R(ref)
	INSERT INTO @PassiveListTbl
		SELECT ref.value('@val', 'int')
		FROM  @i_xml.nodes ('EVGui_ApplyFWConfig80Req/passiveList') R(ref)
	INSERT INTO @PersistentListTbl
		SELECT ref.value('@val', 'int')
		FROM  @i_xml.nodes ('EVGui_ApplyFWConfig80Req/persistentList') R(ref)
	--Handle Passive List
	DELETE APP_Firewall
	WHERE clientId IN ( SELECT clientId FROM @PassiveListTbl )
	INSERT INTO APP_Firewall
	SELECT clientId,0,@i_clientId,0,1 --FW_CLOSED
	FROM @PassiveListTbl
	-- Handle Ondemand List
	INSERT INTO APP_Firewall
	SELECT OD.clientId,0,@i_clientId,0,0 --FW_RESTRICTED
	FROM @OnDemandListTbl OD
	WHERE NOT EXISTS ( SELECT FW.clientId
					   FROM APP_Firewall FW
					   WHERE FW.clientId = OD.clientId
					  )
	-- Handle Persistent List
	DELETE APP_Firewall
	WHERE clientId = @i_clientId
	INSERT INTO APP_Firewall
	SELECT @i_clientId,0,clientId,0,1 --FW_CLOSED
	FROM @PersistentListTbl
	-- Handle PortRange List
	DECLARE @portRangeListCount INT = (SELECT COUNT(*) FROM @PortRangeTbl)
	IF (@portRangeListCount <> 0)
	BEGIN
		DECLARE @gatewayTunnelPort INT = ( SELECT startPort FROM @PortRangeTbl WHERE id = 1 )
		DECLARE @firstEndPort INT = ( SELECT endPort FROM @PortRangeTbl WHERE id = 1 )
		IF ( (@gatewayTunnelPort + 1 ) <= @firstEndPort )
		BEGIN
			UPDATE @PortRangeTbl
			SET startPort = startPort + 1
			WHERE id = 1
		END
		ELSE
		BEGIN
			DELETE @PortRangeTbl
			WHERE id = 1
		END
		DELETE APP_FWPortRange
		WHERE clientid = @i_clientId
		INSERT INTO APP_FWPortRange
		SELECT 	@i_clientId, 0, startPort,endPort
		FROM @PortRangeTbl
		IF EXISTS (SELECT clientid FROM APP_FirewallOptions WHERE clientId = @i_clientId)
		BEGIN
			UPDATE APP_FirewallOptions
			SET tunnelconnectionPort = @gatewayTunnelPort
			WHERE clientId = @i_clientId
		END
		ELSE
		BEGIN
			INSERT INTO APP_FirewallOptions
           (clientId
           ,clientGroupId
           ,isDMZ
           ,tunnelconnectionPort
           ,keepAliveSeconds
           ,tunnelInitSeconds
           ,foreceSSL
           ,lockDown
           ,bindOpenPortsOnly)
     VALUES
           (@i_clientId
           ,0
           ,0
           ,@gatewayTunnelPort
           ,300
           ,1
           ,0
           ,0
           ,0)
		END
	END
COMMIT TRAN
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_errorCode = 1
	ROLLBACK TRAN
END CATCH
SELECT @o_errorCode
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'AppApplyFWConfig80')
	delete from GxQscripts where name = 'AppApplyFWConfig80'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppApplyFWConfig80')
	delete from GXDBVersions where aliasname = 'AppApplyFWConfig80'
GO

insert into GXDBVersions values(2, 'AppApplyFWConfig80',  '00010004006000010000', 'AppApplyFWConfig80', '00010004006000010000')
GO

