

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AppAnalyticsServersWithPermission.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AppAnalyticsServersWithPermission')
BEGIN
	print '>>> Drop Stored Procedure: AppAnalyticsServersWithPermission <<<'
	drop procedure AppAnalyticsServersWithPermission
END
IF EXISTS (select * from GxQscripts where name='AppAnalyticsServersWithPermission')
	delete from GxQscripts where name = 'AppAnalyticsServersWithPermission'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAnalyticsServersWithPermission')
	delete from GXDBVersions where aliasname = 'AppAnalyticsServersWithPermission'
GO
print '... Creating Procedure: AppAnalyticsServersWithPermission'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AppAnalyticsServersWithPermission
  @i_userId INT =0,
  @i_permissionId INT =31,
  @i_cloudId INT =0,
  @i_cloudType INT =0,
  @i_roleIds VARCHAR(256) ='',
  @i_roleOp VARCHAR(64) ='OR'
AS
  DECLARE @o_xmlStr XML
--get all index servers
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
CREATE TABLE #getIndexServers
(
	serverURL NVARCHAR(512),
    clientId INT,
    clientName NVARCHAR(256),
    cloudId INT,
    hostName NVARCHAR(256),
    basePort INT,
    engineName  NVARCHAR(256),
    serverType INT,
    indexServerClientId INT,
    internalCloudName NVARCHAR(256)
)
EXEC DM2GetIndexServers '', 0 /*i_indexServerClientId*/, @i_cloudId /*i_cloudId*/, 0 /*i_nodeClientId*/, 1 /*i_status*/, 0 /*i_shouldSelectOutput*/
-- cloudtype filter -Standalone, cloud or both
IF @i_cloudType >0
	DELETE #getIndexServers WHERE serverType != @i_cloudType
--Roles Filter
IF @i_roleIds != ''
BEGIN
	IF @i_roleOp = 'OR'
	BEGIN
		DELETE T
		FROM #getIndexServers T
		WHERE T.CloudId NOT IN
		(
			SELECT T.CloudId
			FROM #getIndexServers T
			JOIN DM2CloudCoreRole R ON T.cloudId = R.cloudId
			JOIN dbo.SplitIDs(@i_roleIds) P ON P._ID =R.roleId
		)
	END
	ELSE IF @i_roleOp = 'AND'
	BEGIN
		DELETE T
		FROM #getIndexServers T
		WHERE clientId NOT IN (
			SELECT S.clientId
			FROM #getIndexServers S
			JOIN DM2CloudCoreRole R ON T.cloudId = R.cloudId
			WHERE R.roleId IN (SELECT _ID FROM dbo.SplitIDs(@i_roleIds))
			GROUP BY S.clientId
			HAVING COUNT(*)=(SELECT COUNT(_ID) FROM DBO.SplitIDs(@i_roleIds))
		)
	END
END
--permission filter
IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_InputTable') IS NOT NULL DROP TABLE #getPermissionsOnEntities_InputTable
CREATE TABLE #getPermissionsOnEntities_InputTable
(
    entityId1 INT,
    entityId2 INT DEFAULT 0,
    entityId3 INT DEFAULT 0,
    entityId4 INT DEFAULT 0,
    entityId5 INT DEFAULT 0
)
IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_OutputTable') IS NOT NULL DROP TABLE #getPermissionsOnEntities_OutputTable
CREATE TABLE #getPermissionsOnEntities_OutputTable
(
    entityId1 INT,
    entityId2 INT,
    entityId3 INT,
    entityId4 INT,
    entityId5 INT,
    permissionsString VARCHAR(512),
    isChildRow BIT DEFAULT 0
)
--all index servers found
INSERT into #getPermissionsOnEntities_InputTable (entityId1)
SELECT indexServerClientId
FROM #getIndexServers
--get permissions for each index server clients
EXEC sec_getPermissionsOnEntities @i_userId, 3/*CLIENT_ENTITY*/
--eligible index servers
IF OBJECT_ID('tempdb.dbo.#indexServerClients') IS NOT NULL     DROP TABLE #indexServerClients
CREATE TABLE #indexServerClients
(
	clientId 	INT,
	clientName 	NVARCHAR(256),
	hostName  	NVARCHAR(256),
	cloudType	INT,
	cloudId		INT,
	osId		INT
)
INSERT INTO #indexServerClients
SELECT DISTINCT E.indexServerClientId, C.name, C.net_hostname, E.serverType, E.cloudId, C.simOperatingSystemid
FROM #getIndexServers E
JOIN #getPermissionsOnEntities_OutputTable ON entityId1 = E.indexServerClientId
JOIN APP_Client C (NOLOCK) ON C.id = E.indexServerClientId
    WHERE SUBSTRING(permissionsString, @i_permissionId-1, 1) != N'1'
SET @o_xmlStr = ISNULL((SELECT
                            (
                            SELECT
                            T.cloudType AS '@clusterType',
							T.cloudId AS '@cloudId',
							(SELECT os.Type AS '@Type',
									os.SubType AS '@SubType',
									os.id AS '@osId'
							FOR XML PATH ('osInfo'), TYPE),
                            (
                            SELECT
                                T.clientId AS '@clientId',
                                T.clientName AS '@clientName'
                                FOR XML PATH('clients'), TYPE
                                )
                                FROM #indexServerClients T
								JOIN simOperatingSystem OS ON OS.id = T.osId
                                FOR XML PATH('indexServers'), TYPE
                     ) FOR XML PATH('App_IndexServerListResp')
                     ),'<App_IndexServerListResp/>')
--OUTPUT
SELECT @o_xmlStr
IF OBJECT_ID('tempdb.dbo.#indexServerClients') IS NOT NULL     DROP TABLE #indexServerClients
IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_OutputTable') IS NOT NULL DROP TABLE #getPermissionsOnEntities_OutputTable
IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_InputTable') IS NOT NULL DROP TABLE #getPermissionsOnEntities_InputTable
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
GO

IF EXISTS (select * from GxQscripts where name = 'AppAnalyticsServersWithPermission')
	delete from GxQscripts where name = 'AppAnalyticsServersWithPermission'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AppAnalyticsServersWithPermission')
	delete from GXDBVersions where aliasname = 'AppAnalyticsServersWithPermission'
GO

insert into GXDBVersions values(2, 'AppAnalyticsServersWithPermission',  '00000000000000000000', 'AppAnalyticsServersWithPermission', '00000000000000000000')
GO

